/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jp.gr.java_conf.abagames.bulletml.Action;
import jp.gr.java_conf.abagames.bulletml.ActionRef;
import jp.gr.java_conf.abagames.bulletml.Bullet;
import jp.gr.java_conf.abagames.bulletml.BulletRef;
import jp.gr.java_conf.abagames.bulletml.Expression;
import jp.gr.java_conf.abagames.bulletml.Fire;
import jp.gr.java_conf.abagames.bulletml.FireRef;
import jp.gr.java_conf.abagames.bulletml.IActionChoice;
import jp.gr.java_conf.abagames.bulletml.IActionElmChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletElmChoice;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BulletmlUtil {
    private ErrorHandler errorHandler;
    private Hashtable expressions = new Hashtable();
    private char[] expChr;
    private float rank = 0.5f;
    private Hashtable bullets = new Hashtable();
    private Hashtable actions = new Hashtable();
    private Hashtable fires = new Hashtable();

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public int getIntValue(String v, float[] prms) {
        return (int)this.evalExpression(v, prms);
    }

    public float getFloatValue(String v, float[] prms) {
        return this.evalExpression(v, prms);
    }

    public void setRank(float rk) {
        this.rank = rk;
    }

    public float getRank() {
        return this.rank;
    }

    private void evalFloatValue(Expression ep, int stIdx, int lgt, float sign) {
        if (this.expChr[stIdx] == '$') {
            String label = new String(this.expChr, stIdx + 1, lgt - 1);
            if (label.equals("rand")) {
                ep.push(0.0f, -1);
            } else if (label.equals("rank")) {
                ep.push(0.0f, -2);
            } else {
                int idx;
                try {
                    idx = new Integer(label) - 1;
                }
                catch (NumberFormatException e) {
                    ep.push(0.0f, 0);
                    return;
                }
                ep.push(0.0f, 11 + idx);
            }
        } else {
            try {
                ep.push(new Float(new String(this.expChr, stIdx, lgt)).floatValue() * sign, 0);
            }
            catch (NumberFormatException e) {
                ep.push(0.0f, 0);
            }
        }
    }

    private void evalExpPart(Expression ep, int stIdx, int edIdx) {
        int[] op = new int[]{-1, -1};
        while (this.expChr[stIdx] == '(' && this.expChr[edIdx - 1] == ')') {
            ++stIdx;
            --edIdx;
        }
        int i = edIdx - 1;
        while (i >= stIdx) {
            char c = this.expChr[i];
            if (c == ')') {
                while (this.expChr[--i] != '(') {
                }
            } else if (op[0] < 0 && (c == '*' || c == '/' || c == '%')) {
                op[0] = i;
            } else if (c == '+' || c == '-') {
                op[1] = i;
                break;
            }
            --i;
        }
        if (op[1] < 0) {
            if (op[0] < 0) {
                this.evalFloatValue(ep, stIdx, edIdx - stIdx, 1.0f);
            } else {
                switch (this.expChr[op[0]]) {
                    case '*': {
                        this.evalExpPart(ep, stIdx, op[0]);
                        this.evalExpPart(ep, op[0] + 1, edIdx);
                        ep.setOperator(3);
                        break;
                    }
                    case '/': {
                        this.evalExpPart(ep, stIdx, op[0]);
                        this.evalExpPart(ep, op[0] + 1, edIdx);
                        ep.setOperator(4);
                        break;
                    }
                    case '%': {
                        this.evalExpPart(ep, stIdx, op[0]);
                        this.evalExpPart(ep, op[0] + 1, edIdx);
                        ep.setOperator(5);
                    }
                }
            }
        } else if (op[1] == stIdx) {
            switch (this.expChr[op[1]]) {
                case '-': {
                    this.evalFloatValue(ep, stIdx + 1, edIdx - stIdx - 1, -1.0f);
                    break;
                }
                case '+': {
                    this.evalFloatValue(ep, stIdx + 1, edIdx - stIdx - 1, 1.0f);
                }
            }
        } else {
            switch (this.expChr[op[1]]) {
                case '+': {
                    this.evalExpPart(ep, stIdx, op[1]);
                    this.evalExpPart(ep, op[1] + 1, edIdx);
                    ep.setOperator(1);
                    break;
                }
                case '-': {
                    this.evalExpPart(ep, stIdx, op[1]);
                    this.evalExpPart(ep, op[1] + 1, edIdx);
                    ep.setOperator(2);
                }
            }
        }
    }

    public float evalExpression(String exp, float[] p) {
        Expression ep = (Expression)this.expressions.get(exp);
        if (ep == null) {
            this.expChr = new char[exp.length()];
            int ecIdx = 0;
            boolean skip = false;
            StringBuffer buf = new StringBuffer(exp);
            int depth = 0;
            boolean balance = true;
            int i = 0;
            while (i < buf.length()) {
                char ch = buf.charAt(i);
                switch (ch) {
                    case '\n': 
                    case ' ': {
                        skip = true;
                        break;
                    }
                    case ')': {
                        if (--depth >= 0) break;
                        balance = false;
                        break;
                    }
                    case '(': {
                        ++depth;
                    }
                }
                if (skip) {
                    skip = false;
                } else {
                    this.expChr[ecIdx] = ch;
                    ++ecIdx;
                }
                ++i;
            }
            if (depth != 0 || !balance) {
                return 0.0f;
            }
            ep = new Expression(this);
            this.evalExpPart(ep, 0, ecIdx);
            this.expressions.put(exp, ep);
        }
        return ep.calc(p);
    }

    public void clear() {
        this.bullets.clear();
        this.actions.clear();
        this.fires.clear();
        this.expressions.clear();
    }

    public void addBullet(Bullet blt) {
        this.bullets.put(blt.getLabel(), blt);
    }

    public void addAction(Action act) {
        this.actions.put(act.getLabel(), act);
    }

    public void addFire(Fire fre) {
        this.fires.put(fre.getLabel(), fre);
    }

    public final Bullet getBulletElm(IBulletElmChoice bec) {
        if (bec instanceof BulletRef) {
            String label = ((BulletRef)bec).getLabel();
            Bullet blt = (Bullet)this.bullets.get(label);
            if (blt == null) {
                if (this.errorHandler == null) {
                    System.out.println("unknown bullet label: " + label);
                } else {
                    try {
                        this.errorHandler.fatalError(new SAXParseException("unknown bullet label: " + label, null));
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                }
            }
            return blt;
        }
        if (bec instanceof Bullet) {
            return (Bullet)bec;
        }
        return null;
    }

    public final float[] getBulletParams(IBulletElmChoice bec, float[] prms) {
        if (bec instanceof BulletRef) {
            BulletRef br = (BulletRef)bec;
            float[] prm = new float[br.getParamCount()];
            int i = prm.length - 1;
            while (i >= 0) {
                prm[i] = this.getFloatValue(br.getParam(i).getContent(), prms);
                --i;
            }
            return prm;
        }
        return null;
    }

    public final Action getActionElm(IActionElmChoice aec) {
        if (aec instanceof ActionRef) {
            String label = ((ActionRef)aec).getLabel();
            Action act = (Action)this.actions.get(label);
            if (act == null) {
                if (this.errorHandler == null) {
                    System.out.println("unknown action label: " + label);
                } else {
                    try {
                        this.errorHandler.fatalError(new SAXParseException("unknown action label: " + label, null));
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                }
            }
            return act;
        }
        if (aec instanceof Action) {
            return (Action)aec;
        }
        return null;
    }

    public final float[] getActionParams(IActionElmChoice aec, float[] prms) {
        if (aec instanceof ActionRef) {
            ActionRef ar = (ActionRef)aec;
            float[] prm = new float[ar.getParamCount()];
            int i = prm.length - 1;
            while (i >= 0) {
                prm[i] = this.getFloatValue(ar.getParam(i), prms);
                --i;
            }
            return prm;
        }
        return null;
    }

    public final Fire getFireElm(IActionChoice fec) {
        if (fec instanceof FireRef) {
            String label = ((FireRef)fec).getLabel();
            Fire fire = (Fire)this.fires.get(label);
            if (fire == null) {
                if (this.errorHandler == null) {
                    System.out.println("unknown fire label: " + label);
                } else {
                    try {
                        this.errorHandler.fatalError(new SAXParseException("unknown fire label: " + label, null));
                    }
                    catch (SAXException sAXException) {
                        // empty catch block
                    }
                }
            }
            return fire;
        }
        if (fec instanceof Fire) {
            return (Fire)fec;
        }
        return null;
    }

    public final float[] getFireParams(IActionChoice fec, float[] prms) {
        if (fec instanceof FireRef) {
            FireRef fr = (FireRef)fec;
            float[] prm = new float[fr.getParamCount()];
            int i = prm.length - 1;
            while (i >= 0) {
                prm[i] = this.getFloatValue(fr.getParam(i).getContent(), prms);
                --i;
            }
            return prm;
        }
        return null;
    }

    public final IActionElmChoice[] getActionStartsWith(String label) {
        Vector<Action> actVct = new Vector<Action>();
        Enumeration keys = this.actions.keys();
        while (keys.hasMoreElements()) {
            String lbl = (String)keys.nextElement();
            if (!lbl.startsWith(label)) continue;
            actVct.addElement((Action)this.actions.get(lbl));
        }
        Object[] iac = new IActionElmChoice[actVct.size()];
        actVct.copyInto(iac);
        return iac;
    }
}

