/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import jp.gr.java_conf.abagames.bulletml.ActionImpl;
import jp.gr.java_conf.abagames.bulletml.BulletImpl;
import jp.gr.java_conf.abagames.bulletml.BulletmlUtil;
import jp.gr.java_conf.abagames.bulletml.IActionElmChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletmlScreen;
import org.xml.sax.ErrorHandler;

public class BulletmlManager {
    public int screenWidth;
    public int screenHeight;
    private IBulletmlScreen screen;
    private final int BULLET_MAX = 512;
    private BulletImpl[] bullet = new BulletImpl[512];
    private int bltIdx = 0;
    private final int ACTION_MAX = 2048;
    private ActionImpl[] action = new ActionImpl[2048];
    private int actIdx = 0;
    public int shipX;
    public int shipY;
    public int shipPx;
    public int shipPy;
    private String fileName;
    public int cnt;
    public BulletmlUtil bulletmlUtil = new BulletmlUtil();
    private int bulletNum;
    private final int CLS_WIDTH = 100;
    private IActionElmChoice[] topActions;
    private BulletImpl topBullet;

    public void setErrorHandler(ErrorHandler handler) {
        this.bulletmlUtil.setErrorHandler(handler);
    }

    public void reinit() {
        this.bulletmlUtil.clear();
        int i = 0;
        while (i < this.bullet.length) {
            this.bullet[i].vanish();
            ++i;
        }
        i = 0;
        while (i < this.action.length) {
            this.action[i].vanish();
            ++i;
        }
        this.cnt = 0;
    }

    public void init() {
        int i = 0;
        while (i < this.bullet.length) {
            this.bullet[i] = new BulletImpl(this);
            ++i;
        }
        i = 0;
        while (i < this.action.length) {
            this.action[i] = new ActionImpl(this);
            ++i;
        }
        this.reinit();
    }

    public void setScreen(IBulletmlScreen screen) {
        this.screen = screen;
        this.screenWidth = screen.getWidth() << 8;
        this.screenHeight = screen.getHeight() << 8;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setShipPos(int x, int y, int px, int py) {
        this.shipX = x;
        this.shipY = y;
        this.shipPx = px;
        this.shipPy = py;
    }

    public BulletImpl getBulletImplInstance() {
        int i = 511;
        while (i >= 0) {
            ++this.bltIdx;
            this.bltIdx &= 0x1FF;
            if (this.bullet[this.bltIdx].x == Integer.MIN_VALUE) {
                return this.bullet[this.bltIdx];
            }
            --i;
        }
        return null;
    }

    public ActionImpl getActionImplInstance() {
        int i = 2047;
        while (i >= 0) {
            ++this.actIdx;
            this.actIdx &= 0x7FF;
            if (this.action[this.actIdx].pc == Integer.MIN_VALUE) {
                return this.action[this.actIdx];
            }
            --i;
        }
        return null;
    }

    public void moveBullets() {
        int a2y;
        int a1y;
        int a2x;
        int a1x;
        if (this.shipX < this.shipPx) {
            a1x = this.shipX - 100;
            a2x = this.shipPx + 100;
        } else {
            a1x = this.shipPx - 100;
            a2x = this.shipX + 100;
        }
        if (this.shipY < this.shipPy) {
            a1y = this.shipY - 100;
            a2y = this.shipPy + 100;
        } else {
            a1y = this.shipPy - 100;
            a2y = this.shipY + 100;
        }
        this.bulletNum = 0;
        int i = 511;
        while (i >= 0) {
            if (this.bullet[i].x != Integer.MIN_VALUE) {
                int b2y;
                int b1y;
                BulletImpl bl = this.bullet[i];
                bl.move();
                if (bl.py < bl.y) {
                    b1y = bl.py - 100;
                    b2y = bl.y + 100;
                } else {
                    b1y = bl.y - 100;
                    b2y = bl.py + 100;
                }
                if (a2y >= b1y && b2y >= a1y) {
                    int b2x;
                    int b1x;
                    if (bl.px < bl.x) {
                        b1x = bl.px - 100;
                        b2x = bl.x + 100;
                    } else {
                        b1x = bl.x - 100;
                        b2x = bl.px + 100;
                    }
                    if (a2x >= b1x && b2x >= a1x) {
                        long a = this.shipY - this.shipPy;
                        long b = this.shipPx - this.shipX;
                        long c = this.shipPx * this.shipY - this.shipPy * this.shipX;
                        long d = bl.py - bl.y;
                        long e = bl.x - bl.px;
                        long f = bl.x * bl.py - bl.y * bl.px;
                        long dnm = b * d - a * e;
                        if (dnm != 0L) {
                            long x = (b * f - c * e) / dnm;
                            long y = (c * d - a * f) / dnm;
                            if ((long)a1x <= x && x <= (long)a2x && (long)a1y <= y && y <= (long)a2y && (long)b1x <= x && x <= (long)b2x && (long)b1y <= y && y <= (long)b2y) {
                                this.screen.hitShip();
                            }
                        }
                    }
                }
                ++this.bulletNum;
            }
            --i;
        }
        ++this.cnt;
    }

    public void drawBullets() {
        int i = 511;
        while (i >= 0) {
            if (this.bullet[i].x != Integer.MIN_VALUE) {
                this.bullet[i].draw();
            }
            --i;
        }
    }

    public final void drawBullet(int x, int y, int px, int py, int sx, int sy, int cl, int cnt) {
        this.screen.drawBullet(x, y, px, py, sx, sy, cl, cnt);
    }

    public void setTopActions(IActionElmChoice[] actions) {
        this.topActions = actions;
    }

    public BulletImpl addTopBullet(int x, int y, int d) {
        if (this.topBullet != null && this.topBullet.x != Integer.MIN_VALUE) {
            this.topBullet.vanishForced();
        }
        this.topBullet = this.getBulletImplInstance();
        if (this.topBullet != null) {
            this.topBullet.set(this.topActions, x, y, d, 0);
        }
        return this.topBullet;
    }

    public void setRank(float rank) {
        this.bulletmlUtil.setRank(rank);
    }

    public boolean isFinished() {
        return this.topBullet == null || this.topBullet.x == Integer.MIN_VALUE || this.topBullet.isAllActionFinished();
    }

    public int getBulletsNum() {
        return this.bulletNum;
    }
}

