/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.abagames.bulletml.Action;
import jp.gr.java_conf.abagames.bulletml.Bullet;
import jp.gr.java_conf.abagames.bulletml.Fire;
import jp.gr.java_conf.abagames.bulletml.IBulletmlChoice;
import jp.gr.java_conf.abagames.bulletml.RStack;
import jp.gr.java_conf.abagames.bulletml.UJAXP;
import jp.gr.java_conf.abagames.bulletml.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Bulletml
implements Serializable {
    private String xmlns_;
    private String type_;
    private List content_ = new ArrayList();

    public Bulletml() {
    }

    public Bulletml(RStack stack) {
        this.setup(stack);
    }

    public Bulletml(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Bulletml(Element element) {
        this.setup(element);
    }

    public Bulletml(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Bulletml(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Bulletml(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Bulletml(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Bulletml(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Bulletml(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.xmlns_ = URelaxer.getAttributePropertyAsString(element, "xmlns");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.content_.clear();
        while (true) {
            if (Action.isMatch(stack)) {
                this.addContent(new Action(stack));
                continue;
            }
            if (Bullet.isMatch(stack)) {
                this.addContent(new Bullet(stack));
                continue;
            }
            if (!Fire.isMatch(stack)) break;
            this.addContent(new Fire(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("bulletml");
        if (this.xmlns_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmlns", this.xmlns_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getXmlns() {
        return this.xmlns_;
    }

    public final void setXmlns(String xmlns) {
        this.xmlns_ = xmlns;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final IBulletmlChoice[] getContent() {
        IBulletmlChoice[] array = new IBulletmlChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IBulletmlChoice[] content) {
        this.content_.clear();
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
    }

    public final void setContent(IBulletmlChoice content) {
        this.content_.clear();
        this.addContent(content);
    }

    public final void addContent(IBulletmlChoice content) {
        this.content_.add(content);
    }

    public final void addContent(IBulletmlChoice[] content) {
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
    }

    public final int getContentCount() {
        return this.content_.size();
    }

    public final IBulletmlChoice getContent(int index) {
        return (IBulletmlChoice)this.content_.get(index);
    }

    public final void setContent(int index, IBulletmlChoice content) {
        this.content_.set(index, content);
    }

    public final void addContent(int index, IBulletmlChoice content) {
        this.content_.add(index, content);
    }

    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    public final void removeContent(IBulletmlChoice content) {
        this.content_.remove(content);
    }

    public final void clearContent() {
        this.content_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IBulletmlChoice value;
        buffer.append("<bulletml");
        if (this.xmlns_ != null) {
            buffer.append(" xmlns=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmlns())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.append(">");
        size = this.content_.size();
        i = 0;
        while (i < size) {
            value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</bulletml>");
    }

    public void makeTextElement(PrintWriter buffer) {
        IBulletmlChoice value;
        buffer.print("<bulletml");
        if (this.xmlns_ != null) {
            buffer.print(" xmlns=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getXmlns())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.print(">");
        size = this.content_.size();
        i = 0;
        while (i < size) {
            value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</bulletml>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getXmlnsAsString() {
        return URelaxer.getString(this.getXmlns());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public void setXmlnsByString(String string) {
        this.setXmlns(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "bulletml")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (true) {
            if (Action.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Bullet.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!Fire.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Bulletml.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Bulletml.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

