/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import jp.gr.java_conf.abagames.bulletml.ActionImpl;
import jp.gr.java_conf.abagames.bulletml.Bullet;
import jp.gr.java_conf.abagames.bulletml.BulletmlManager;
import jp.gr.java_conf.abagames.bulletml.Direction;
import jp.gr.java_conf.abagames.bulletml.IActionElmChoice;
import jp.gr.java_conf.abagames.bulletml.Speed;
import jp.gr.java_conf.abagames.util.DegUtil;
import jp.gr.java_conf.abagames.util.SCTable;

public class BulletImpl {
    public static final int NOT_EXIST = Integer.MIN_VALUE;
    private final int ACTION_MAX = 8;
    private ActionImpl[] action = new ActionImpl[8];
    private int acIdx;
    public int x;
    public int y;
    public int px;
    public int py;
    public int sx;
    public int sy;
    public Direction drcElm;
    public Speed spdElm;
    public float direction;
    public float speed;
    public float mx;
    public float my;
    public int clr;
    private int cnt;
    private BulletmlManager manager;
    private float[] prms;
    private int tmx;
    private int tmy;
    public BulletImpl parent;
    private final int SPEED_MAG = 2;
    private final int ACCEL_MAG = 2;

    public BulletImpl(BulletmlManager bm) {
        this.manager = bm;
        this.x = Integer.MIN_VALUE;
    }

    public void changeAction(ActionImpl bfr, ActionImpl aft) {
        int i = 0;
        while (i < this.acIdx) {
            if (this.action[i].equals(bfr)) {
                this.action[i] = aft;
                return;
            }
            ++i;
        }
    }

    public void set(IActionElmChoice[] aec, int x, int y, int d, int clr) {
        this.px = this.sx = x;
        this.x = this.sx;
        this.py = this.sy = y;
        this.y = this.sy;
        this.my = 0.0f;
        this.mx = 0.0f;
        this.tmy = 0;
        this.tmx = 0;
        this.clr = clr;
        this.cnt = 0;
        this.acIdx = 0;
        int i = 0;
        while (i < aec.length) {
            this.action[this.acIdx] = this.manager.getActionImplInstance();
            if (this.action[this.acIdx] == null) break;
            this.action[this.acIdx].set(this.manager.bulletmlUtil.getActionElm(aec[i]), this);
            float[] actPrms = this.manager.bulletmlUtil.getActionParams(aec[i], this.prms);
            if (actPrms == null) {
                this.action[this.acIdx].setParams(this.prms);
            } else {
                this.action[this.acIdx].setParams(actPrms);
            }
            ++this.acIdx;
            if (this.acIdx >= 8) break;
            ++i;
        }
        this.direction = d;
        this.speed = 0.0f;
        this.parent = null;
    }

    public void set(Bullet bullet, int x, int y, int ci, BulletImpl bImpl) {
        this.drcElm = bullet.getDirection();
        this.spdElm = bullet.getSpeed();
        IActionElmChoice[] aec = bullet.getActionElm();
        this.set(aec, x, y, 0, ci);
        this.parent = bImpl;
    }

    public void setParams(float[] prms) {
        this.prms = prms;
    }

    public float getAimDeg() {
        return (float)DegUtil.getDeg(this.manager.shipX - this.x, this.manager.shipY - this.y) * 360.0f / 1024.0f;
    }

    public void vanish() {
        this.vanishForced();
    }

    public void vanishForced() {
        int i = 0;
        while (i < this.acIdx) {
            this.action[i].vanish();
            ++i;
        }
        this.x = Integer.MIN_VALUE;
    }

    public boolean isAllActionFinished() {
        int i = 0;
        while (i < this.acIdx) {
            if (this.action[i].pc != Integer.MIN_VALUE) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void move() {
        int i = 0;
        while (i < this.acIdx) {
            this.action[i].move();
            ++i;
        }
        ++this.cnt;
        int d = (int)(this.direction * 1024.0f / 360.0f);
        int mvx = (int)(this.speed * (float)SCTable.sintbl[d &= 0x3FF]) * 2 + (int)(this.mx * 256.0f * 2.0f);
        int mvy = (int)(-this.speed * (float)SCTable.costbl[d]) * 2 + (int)(this.my * 256.0f * 2.0f);
        int pmvx = mvx;
        int pmvy = mvy;
        this.x += mvx;
        this.tmx = mvx;
        this.y += mvy;
        this.tmy = mvy;
        if (pmvx == 0 && pmvy == 0) {
            pmvx = SCTable.sintbl[d] << 0;
            pmvy = -SCTable.costbl[d] << 0;
        }
        if (this.cnt < 4) {
            this.px = this.x - pmvx;
            this.py = this.y - pmvy;
        } else if (this.cnt < 8) {
            this.px = this.x - (pmvx << 1);
            this.py = this.y - (pmvy << 1);
        } else {
            this.px = this.x - (pmvx << 2);
            this.py = this.y - (pmvy << 2);
        }
        if (this.px < 0 || this.px >= this.manager.screenWidth || this.py < 0 || this.py >= this.manager.screenHeight) {
            this.vanish();
        }
    }

    public final void draw() {
        this.manager.drawBullet(this.x, this.y, this.px, this.py, this.sx, this.sy, this.clr, this.cnt);
    }
}

