/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.abagames.bulletml.Action;
import jp.gr.java_conf.abagames.bulletml.ActionRef;
import jp.gr.java_conf.abagames.bulletml.Direction;
import jp.gr.java_conf.abagames.bulletml.IActionElmChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletElmChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletmlChoice;
import jp.gr.java_conf.abagames.bulletml.RStack;
import jp.gr.java_conf.abagames.bulletml.Speed;
import jp.gr.java_conf.abagames.bulletml.UJAXP;
import jp.gr.java_conf.abagames.bulletml.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Bullet
implements Serializable,
IBulletElmChoice,
IBulletmlChoice {
    private String label_;
    private Direction direction_;
    private Speed speed_;
    private List actionElm_ = new ArrayList();

    public Bullet() {
    }

    public Bullet(RStack stack) {
        this.setup(stack);
    }

    public Bullet(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Bullet(Element element) {
        this.setup(element);
    }

    public Bullet(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Bullet(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Bullet(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Bullet(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Bullet(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Bullet(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.label_ = URelaxer.getAttributePropertyAsString(element, "label");
        if (Direction.isMatch(stack)) {
            this.setDirection(new Direction(stack));
        }
        if (Speed.isMatch(stack)) {
            this.setSpeed(new Speed(stack));
        }
        this.actionElm_.clear();
        while (true) {
            if (Action.isMatch(stack)) {
                this.addActionElm(new Action(stack));
                continue;
            }
            if (!ActionRef.isMatch(stack)) break;
            this.addActionElm(new ActionRef(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("bullet");
        if (this.label_ != null) {
            URelaxer.setAttributePropertyByString(element, "label", this.label_);
        }
        if (this.direction_ != null) {
            this.direction_.makeElement(element);
        }
        if (this.speed_ != null) {
            this.speed_.makeElement(element);
        }
        int size = this.actionElm_.size();
        int i = 0;
        while (i < size) {
            IActionElmChoice value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getLabel() {
        return this.label_;
    }

    public final void setLabel(String label) {
        this.label_ = label;
    }

    public final Direction getDirection() {
        return this.direction_;
    }

    public final void setDirection(Direction direction) {
        this.direction_ = direction;
    }

    public final Speed getSpeed() {
        return this.speed_;
    }

    public final void setSpeed(Speed speed) {
        this.speed_ = speed;
    }

    public final IActionElmChoice[] getActionElm() {
        IActionElmChoice[] array = new IActionElmChoice[this.actionElm_.size()];
        return this.actionElm_.toArray(array);
    }

    public final void setActionElm(IActionElmChoice[] actionElm) {
        this.actionElm_.clear();
        int i = 0;
        while (i < actionElm.length) {
            this.addActionElm(actionElm[i]);
            ++i;
        }
    }

    public final void setActionElm(IActionElmChoice actionElm) {
        this.actionElm_.clear();
        this.addActionElm(actionElm);
    }

    public final void addActionElm(IActionElmChoice actionElm) {
        this.actionElm_.add(actionElm);
    }

    public final void addActionElm(IActionElmChoice[] actionElm) {
        int i = 0;
        while (i < actionElm.length) {
            this.addActionElm(actionElm[i]);
            ++i;
        }
    }

    public final int getActionElmCount() {
        return this.actionElm_.size();
    }

    public final IActionElmChoice getActionElm(int index) {
        return (IActionElmChoice)this.actionElm_.get(index);
    }

    public final void setActionElm(int index, IActionElmChoice actionElm) {
        this.actionElm_.set(index, actionElm);
    }

    public final void addActionElm(int index, IActionElmChoice actionElm) {
        this.actionElm_.add(index, actionElm);
    }

    public final void removeActionElm(int index) {
        this.actionElm_.remove(index);
    }

    public final void removeActionElm(IActionElmChoice actionElm) {
        this.actionElm_.remove(actionElm);
    }

    public final void clearActionElm() {
        this.actionElm_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IActionElmChoice value;
        buffer.append("<bullet");
        if (this.label_ != null) {
            buffer.append(" label=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLabel())));
            buffer.append("\"");
        }
        int size = this.actionElm_.size();
        int i = 0;
        while (i < size) {
            value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.append(">");
        if (this.direction_ != null) {
            this.direction_.makeTextElement(buffer);
        }
        if (this.speed_ != null) {
            this.speed_.makeTextElement(buffer);
        }
        size = this.actionElm_.size();
        i = 0;
        while (i < size) {
            value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</bullet>");
    }

    public void makeTextElement(PrintWriter buffer) {
        IActionElmChoice value;
        buffer.print("<bullet");
        if (this.label_ != null) {
            buffer.print(" label=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLabel())));
            buffer.print("\"");
        }
        int size = this.actionElm_.size();
        int i = 0;
        while (i < size) {
            value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.print(">");
        if (this.direction_ != null) {
            this.direction_.makeTextElement(buffer);
        }
        if (this.speed_ != null) {
            this.speed_.makeTextElement(buffer);
        }
        size = this.actionElm_.size();
        i = 0;
        while (i < size) {
            value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</bullet>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getLabelAsString() {
        return URelaxer.getString(this.getLabel());
    }

    public void setLabelByString(String string) {
        this.setLabel(string);
    }

    public void setDirectionByString(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setDirection(new Direction(string));
    }

    public void setSpeedByString(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setSpeed(new Speed(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "bullet")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Direction.isMatchHungry(target);
        Speed.isMatchHungry(target);
        while (true) {
            if (Action.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!ActionRef.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Bullet.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Bullet.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

