/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import jp.gr.java_conf.abagames.bulletml.Accel;
import jp.gr.java_conf.abagames.bulletml.Action;
import jp.gr.java_conf.abagames.bulletml.ActionRef;
import jp.gr.java_conf.abagames.bulletml.BulletImpl;
import jp.gr.java_conf.abagames.bulletml.BulletmlManager;
import jp.gr.java_conf.abagames.bulletml.ChangeDirection;
import jp.gr.java_conf.abagames.bulletml.ChangeSpeed;
import jp.gr.java_conf.abagames.bulletml.Direction;
import jp.gr.java_conf.abagames.bulletml.Fire;
import jp.gr.java_conf.abagames.bulletml.FireRef;
import jp.gr.java_conf.abagames.bulletml.Horizontal;
import jp.gr.java_conf.abagames.bulletml.IActionChoice;
import jp.gr.java_conf.abagames.bulletml.IActionElmChoice;
import jp.gr.java_conf.abagames.bulletml.Repeat;
import jp.gr.java_conf.abagames.bulletml.Speed;
import jp.gr.java_conf.abagames.bulletml.Vanish;
import jp.gr.java_conf.abagames.bulletml.Vertical;
import jp.gr.java_conf.abagames.bulletml.Wait;

public class ActionImpl {
    public static final int NOT_EXIST = Integer.MIN_VALUE;
    public IActionChoice[] action;
    private int repeat;
    public int pc;
    private int waitCnt;
    private float aimSpeed;
    private float mvSpeed;
    private int mvspCnt;
    private float aimDrc;
    private float mvDrc;
    private boolean isAim;
    private int mvdrCnt;
    private float prvFireDrc;
    private float prvFireSpeed;
    private int acclCnt;
    private float aimMx;
    private float aimMy;
    private float mvMx;
    private float mvMy;
    private ActionImpl parent;
    private BulletImpl bullet;
    private BulletmlManager manager;
    private float[] prms;
    private final String ABSOLUTE_KEYWORD = "absolute";
    private final String RELATIVE_KEYWORD = "relative";
    private final String SEQUENCE_KEYWORD = "sequence";
    private final String AIM_KEYWORD = "aim";

    public ActionImpl(BulletmlManager bm) {
        this.manager = bm;
        this.pc = Integer.MIN_VALUE;
    }

    public void rewind() {
        this.repeat = 1;
        this.pc = -1;
        this.acclCnt = 0;
        this.mvdrCnt = 0;
        this.mvspCnt = 0;
        this.waitCnt = 0;
        this.aimMy = 0.0f;
        this.aimMx = 0.0f;
        this.mvMy = 0.0f;
        this.mvMx = 0.0f;
        this.prvFireDrc = 0.0f;
        this.prvFireSpeed = 1.0f;
        this.parent = null;
        this.prms = null;
    }

    public void set(Action action, BulletImpl bullet) {
        this.action = action.getContent();
        this.bullet = bullet;
        this.rewind();
    }

    public void setParams(float[] prms) {
        this.prms = prms;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public void setParent(ActionImpl parent) {
        this.parent = parent;
    }

    public void setMoveStatus(int mvdrCnt, float mvDrc, boolean isAim, int mvspCnt, float mvSpeed, int acclCnt, float mvMx, float mvMy) {
        this.mvdrCnt = mvdrCnt;
        this.mvDrc = mvDrc;
        this.isAim = isAim;
        this.mvspCnt = mvspCnt;
        this.mvSpeed = mvSpeed;
        this.acclCnt = acclCnt;
        this.mvMx = mvMx;
        this.mvMy = mvMy;
    }

    public void setPrvFireStatus(float pfd, float pfs) {
        this.prvFireDrc = pfd;
        this.prvFireSpeed = pfs;
    }

    public void vanish() {
        if (this.parent != null) {
            this.parent.vanish();
        }
        this.pc = Integer.MIN_VALUE;
    }

    public final void move() {
        block50: {
            if (this.mvspCnt > 0) {
                --this.mvspCnt;
                this.bullet.speed += this.mvSpeed;
            }
            if (this.mvdrCnt > 0) {
                --this.mvdrCnt;
                this.bullet.direction += this.mvDrc;
            }
            if (this.acclCnt > 0) {
                --this.acclCnt;
                this.bullet.mx += this.mvMx;
                this.bullet.my += this.mvMy;
            }
            if (this.pc == Integer.MIN_VALUE) {
                return;
            }
            if (this.waitCnt > 0) {
                --this.waitCnt;
                return;
            }
            while (true) {
                String type;
                ActionImpl newAction;
                IActionChoice ac;
                ++this.pc;
                if (this.pc >= this.action.length) {
                    --this.repeat;
                    if (this.repeat <= 0) {
                        this.pc = Integer.MIN_VALUE;
                        if (this.parent == null) break block50;
                        this.parent.setMoveStatus(this.mvdrCnt, this.mvDrc, this.isAim, this.mvspCnt, this.mvSpeed, this.acclCnt, this.mvMx, this.mvMy);
                        this.parent.setPrvFireStatus(this.prvFireDrc, this.prvFireSpeed);
                        this.bullet.changeAction(this, this.parent);
                        break block50;
                    }
                    this.pc = 0;
                }
                if ((ac = this.action[this.pc]) instanceof Repeat) {
                    newAction = this.manager.getActionImplInstance();
                    if (newAction == null) continue;
                    Repeat rp = (Repeat)ac;
                    int rpNum = this.manager.bulletmlUtil.getIntValue(rp.getTimes(), this.prms);
                    if (rpNum <= 0) {
                        return;
                    }
                    newAction.set(this.manager.bulletmlUtil.getActionElm(rp.getActionElm()), this.bullet);
                    float[] actPrms = this.manager.bulletmlUtil.getActionParams(rp.getActionElm(), this.prms);
                    if (actPrms == null) {
                        newAction.setParams(this.prms);
                    } else {
                        newAction.setParams(actPrms);
                    }
                    newAction.setRepeat(rpNum);
                    newAction.setParent(this);
                    newAction.setMoveStatus(this.mvdrCnt, this.mvDrc, this.isAim, this.mvspCnt, this.mvSpeed, this.acclCnt, this.mvMx, this.mvMy);
                    newAction.setPrvFireStatus(this.prvFireDrc, this.prvFireSpeed);
                    this.bullet.changeAction(this, newAction);
                    newAction.move();
                    break block50;
                }
                if (ac instanceof Action || ac instanceof ActionRef) {
                    newAction = this.manager.getActionImplInstance();
                    if (newAction == null) continue;
                    IActionElmChoice aec = (IActionElmChoice)((Object)ac);
                    newAction.set(this.manager.bulletmlUtil.getActionElm(aec), this.bullet);
                    float[] actPrms = this.manager.bulletmlUtil.getActionParams(aec, this.prms);
                    if (actPrms == null) {
                        newAction.setParams(this.prms);
                    } else {
                        newAction.setParams(actPrms);
                    }
                    newAction.setRepeat(1);
                    newAction.setParent(this);
                    newAction.setMoveStatus(this.mvdrCnt, this.mvDrc, this.isAim, this.mvspCnt, this.mvSpeed, this.acclCnt, this.mvMx, this.mvMy);
                    newAction.setPrvFireStatus(this.prvFireDrc, this.prvFireSpeed);
                    this.bullet.changeAction(this, newAction);
                    newAction.move();
                    break block50;
                }
                if (ac instanceof Fire || ac instanceof FireRef) {
                    float drc;
                    IActionChoice fec = ac;
                    Fire fire = this.manager.bulletmlUtil.getFireElm(fec);
                    float[] firePrms = this.manager.bulletmlUtil.getFireParams(fec, this.prms);
                    BulletImpl bi = this.manager.getBulletImplInstance();
                    if (bi == null) continue;
                    if (firePrms == null) {
                        bi.setParams(this.manager.bulletmlUtil.getBulletParams(fire.getBulletElm(), this.prms));
                    } else {
                        bi.setParams(firePrms);
                    }
                    bi.set(this.manager.bulletmlUtil.getBulletElm(fire.getBulletElm()), this.bullet.x, this.bullet.y, this.bullet.clr + 1, this.bullet);
                    Direction d = fire.getDirection();
                    if (d == null) {
                        d = bi.drcElm;
                    }
                    if (d != null) {
                        drc = firePrms == null ? this.manager.bulletmlUtil.getFloatValue(d.getContent(), this.prms) : this.manager.bulletmlUtil.getFloatValue(d.getContent(), firePrms);
                        String type2 = d.getType();
                        if (type2 != null) {
                            if (type2.equals("aim")) {
                                drc += this.bullet.getAimDeg();
                            } else if (type2.equals("sequence")) {
                                drc += this.prvFireDrc;
                            } else if (type2.equals("relative")) {
                                drc += this.bullet.direction;
                            }
                        } else {
                            drc += this.bullet.getAimDeg();
                        }
                    } else {
                        drc = this.bullet.getAimDeg();
                    }
                    bi.direction = this.prvFireDrc = drc;
                    Speed s = fire.getSpeed();
                    if (s == null) {
                        s = bi.spdElm;
                    }
                    float spd = 1.0f;
                    if (s != null) {
                        spd = firePrms == null ? this.manager.bulletmlUtil.getFloatValue(s.getContent(), this.prms) : this.manager.bulletmlUtil.getFloatValue(s.getContent(), firePrms);
                        String type3 = s.getType();
                        if (type3 != null && (type3.equals("relative") || type3.equals("sequence"))) {
                            spd += this.prvFireSpeed;
                        }
                    }
                    bi.speed = this.prvFireSpeed = spd;
                    continue;
                }
                if (ac instanceof ChangeSpeed) {
                    Speed s = ((ChangeSpeed)ac).getSpeed();
                    type = s.getType();
                    this.mvspCnt = this.manager.bulletmlUtil.getIntValue(((ChangeSpeed)ac).getTerm(), this.prms);
                    if (type != null && type.equals("sequence")) {
                        this.mvSpeed = this.manager.bulletmlUtil.getFloatValue(s.getContent(), this.prms);
                        continue;
                    }
                    this.aimSpeed = this.manager.bulletmlUtil.getFloatValue(s.getContent(), this.prms);
                    if (type != null && (type.equals("relative") || type.equals("sequence"))) {
                        this.aimSpeed += this.bullet.speed;
                    }
                    this.mvSpeed = (this.aimSpeed - this.bullet.speed) / (float)this.mvspCnt;
                    continue;
                }
                if (ac instanceof ChangeDirection) {
                    Direction d = ((ChangeDirection)ac).getDirection();
                    type = d.getType();
                    this.mvdrCnt = this.manager.bulletmlUtil.getIntValue(((ChangeDirection)ac).getTerm(), this.prms);
                    if (type != null && type.equals("sequence")) {
                        this.isAim = false;
                        this.mvDrc = this.manager.bulletmlUtil.getFloatValue(d.getContent(), this.prms);
                        continue;
                    }
                    this.aimDrc = this.manager.bulletmlUtil.getFloatValue(d.getContent(), this.prms);
                    if (type != null && type.equals("absolute")) {
                        this.isAim = false;
                        this.mvDrc = (this.aimDrc - this.bullet.direction) % 360.0f;
                    } else if (type != null && type.equals("relative")) {
                        this.isAim = false;
                        this.aimDrc += this.bullet.direction;
                        this.mvDrc = (this.aimDrc - this.bullet.direction) % 360.0f;
                    } else {
                        this.isAim = true;
                        this.mvDrc = (this.aimDrc + this.bullet.getAimDeg() - this.bullet.direction) % 360.0f;
                    }
                    if (this.mvDrc > 180.0f) {
                        this.mvDrc -= 360.0f;
                    }
                    if (this.mvDrc < -180.0f) {
                        this.mvDrc += 360.0f;
                    }
                    this.mvDrc /= (float)this.mvdrCnt;
                    continue;
                }
                if (ac instanceof Accel) {
                    Vertical vtc;
                    Accel al = (Accel)ac;
                    Horizontal hrz = al.getHorizontal();
                    this.acclCnt = this.manager.bulletmlUtil.getIntValue(al.getTerm(), this.prms);
                    if (hrz != null) {
                        String type4 = hrz.getType();
                        if (type4 != null && type4.equals("sequence")) {
                            this.mvMx = this.manager.bulletmlUtil.getFloatValue(hrz.getContent(), this.prms);
                        } else {
                            this.aimMx = this.manager.bulletmlUtil.getFloatValue(hrz.getContent(), this.prms);
                            if (type4 != null && type4.equals("relative")) {
                                this.aimMx += this.bullet.mx;
                            }
                            this.mvMx = (this.aimMx - this.bullet.mx) / (float)this.acclCnt;
                        }
                    }
                    if ((vtc = al.getVertical()) == null) continue;
                    String type5 = vtc.getType();
                    if (type5 != null && type5.equals("relative")) {
                        this.mvMy = this.manager.bulletmlUtil.getFloatValue(vtc.getContent(), this.prms);
                        continue;
                    }
                    this.aimMy = this.manager.bulletmlUtil.getFloatValue(vtc.getContent(), this.prms);
                    if (type5 != null && (type5.equals("relative") || type5.equals("sequence"))) {
                        this.aimMy += this.bullet.my;
                    }
                    this.mvMy = (this.aimMy - this.bullet.my) / (float)this.acclCnt;
                    continue;
                }
                if (ac instanceof Wait) {
                    this.waitCnt = this.manager.bulletmlUtil.getIntValue(((Wait)ac).getContent(), this.prms);
                    break block50;
                }
                if (ac instanceof Vanish) break;
            }
            this.bullet.vanish();
        }
    }
}

