/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.abagames.bulletml.Accel;
import jp.gr.java_conf.abagames.bulletml.ActionRef;
import jp.gr.java_conf.abagames.bulletml.ChangeDirection;
import jp.gr.java_conf.abagames.bulletml.ChangeSpeed;
import jp.gr.java_conf.abagames.bulletml.Fire;
import jp.gr.java_conf.abagames.bulletml.FireRef;
import jp.gr.java_conf.abagames.bulletml.IActionChoice;
import jp.gr.java_conf.abagames.bulletml.IActionElmChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletmlChoice;
import jp.gr.java_conf.abagames.bulletml.RStack;
import jp.gr.java_conf.abagames.bulletml.Repeat;
import jp.gr.java_conf.abagames.bulletml.UJAXP;
import jp.gr.java_conf.abagames.bulletml.URelaxer;
import jp.gr.java_conf.abagames.bulletml.Vanish;
import jp.gr.java_conf.abagames.bulletml.Wait;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Action
implements Serializable,
IActionElmChoice,
IActionChoice,
IBulletmlChoice {
    private String label_;
    private List content_ = new ArrayList();

    public Action() {
    }

    public Action(RStack stack) {
        this.setup(stack);
    }

    public Action(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Action(Element element) {
        this.setup(element);
    }

    public Action(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Action(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Action(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Action(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Action(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Action(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.label_ = URelaxer.getAttributePropertyAsString(element, "label");
        this.content_.clear();
        while (true) {
            if (FireRef.isMatch(stack)) {
                this.addContent(new FireRef(stack));
                continue;
            }
            if (ChangeSpeed.isMatch(stack)) {
                this.addContent(new ChangeSpeed(stack));
                continue;
            }
            if (Repeat.isMatch(stack)) {
                this.addContent(new Repeat(stack));
                continue;
            }
            if (Fire.isMatch(stack)) {
                this.addContent(new Fire(stack));
                continue;
            }
            if (ChangeDirection.isMatch(stack)) {
                this.addContent(new ChangeDirection(stack));
                continue;
            }
            if (Accel.isMatch(stack)) {
                this.addContent(new Accel(stack));
                continue;
            }
            if (Action.isMatch(stack)) {
                this.addContent(new Action(stack));
                continue;
            }
            if (ActionRef.isMatch(stack)) {
                this.addContent(new ActionRef(stack));
                continue;
            }
            if (Wait.isMatch(stack)) {
                this.addContent(new Wait(stack));
                continue;
            }
            if (!Vanish.isMatch(stack)) break;
            this.addContent(new Vanish(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("action");
        if (this.label_ != null) {
            URelaxer.setAttributePropertyByString(element, "label", this.label_);
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            IActionChoice value = (IActionChoice)this.content_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getLabel() {
        return this.label_;
    }

    public final void setLabel(String label) {
        this.label_ = label;
    }

    public final IActionChoice[] getContent() {
        IActionChoice[] array = new IActionChoice[this.content_.size()];
        return this.content_.toArray(array);
    }

    public final void setContent(IActionChoice[] content) {
        this.content_.clear();
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
    }

    public final void setContent(IActionChoice content) {
        this.content_.clear();
        this.addContent(content);
    }

    public final void addContent(IActionChoice content) {
        this.content_.add(content);
    }

    public final void addContent(IActionChoice[] content) {
        int i = 0;
        while (i < content.length) {
            this.addContent(content[i]);
            ++i;
        }
    }

    public final int getContentCount() {
        return this.content_.size();
    }

    public final IActionChoice getContent(int index) {
        return (IActionChoice)this.content_.get(index);
    }

    public final void setContent(int index, IActionChoice content) {
        this.content_.set(index, content);
    }

    public final void addContent(int index, IActionChoice content) {
        this.content_.add(index, content);
    }

    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    public final void removeContent(IActionChoice content) {
        this.content_.remove(content);
    }

    public final void clearContent() {
        this.content_.clear();
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        IActionChoice value;
        buffer.append("<action");
        if (this.label_ != null) {
            buffer.append(" label=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLabel())));
            buffer.append("\"");
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            value = (IActionChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.append(">");
        size = this.content_.size();
        i = 0;
        while (i < size) {
            value = (IActionChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</action>");
    }

    public void makeTextElement(PrintWriter buffer) {
        IActionChoice value;
        buffer.print("<action");
        if (this.label_ != null) {
            buffer.print(" label=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLabel())));
            buffer.print("\"");
        }
        int size = this.content_.size();
        int i = 0;
        while (i < size) {
            value = (IActionChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
            ++i;
        }
        buffer.print(">");
        size = this.content_.size();
        i = 0;
        while (i < size) {
            value = (IActionChoice)this.content_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</action>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getLabelAsString() {
        return URelaxer.getString(this.getLabel());
    }

    public void setLabelByString(String string) {
        this.setLabel(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "action")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        while (true) {
            if (FireRef.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (ChangeSpeed.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Repeat.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Fire.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (ChangeDirection.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Accel.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Action.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (ActionRef.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (Wait.isMatchHungry(target)) {
                $match$ = true;
                continue;
            }
            if (!Vanish.isMatchHungry(target)) break;
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Action.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Action.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

