package jp.gr.java_conf.abagames.bulletml;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>ChangeSpeed</b> is generated by Relaxer based on bulletml.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="changeSpeed">
 *   <sequence>
 *     <ref label="speed"/>
 *     <ref label="term"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="changeSpeed"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="changeSpeed"&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="speed"/&gt;
 *     &lt;ref label="term"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="changeSpeed"/&gt;
 * </pre>
 *
 * @version bulletml.rlx 0.21 (Fri Feb 08 22:06:25 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class ChangeSpeed implements java.io.Serializable, IActionChoice {
    private Speed speed_;
    private String term_;

    /**
     * Creates a <code>ChangeSpeed</code>.
     *
     */
    public ChangeSpeed() {
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ChangeSpeed(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public ChangeSpeed(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public ChangeSpeed(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ChangeSpeed(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>ChangeSpeed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ChangeSpeed(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ChangeSpeed(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ChangeSpeed(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ChangeSpeed(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>ChangeSpeed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ChangeSpeed(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        setSpeed(new Speed(stack));
        term_ = URelaxer.getElementPropertyAsString(stack.popElement());
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("changeSpeed");
        int size;
        this.speed_.makeElement(element);
        URelaxer.setElementPropertyByString(element, "term", this.term_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>ChangeSpeed</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ChangeSpeed</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Speed property <b>speed</b>.
     *
     * @return Speed
     */
    public final Speed getSpeed() {
        return (speed_);
    }

    /**
     * Sets the Speed property <b>speed</b>.
     *
     * @param speed
     */
    public final void setSpeed(Speed speed) {
        this.speed_ = speed;
    }

    /**
     * Gets the String property <b>term</b>.
     *
     * @return String
     */
    public final String getTerm() {
        return (term_);
    }

    /**
     * Sets the String property <b>term</b>.
     *
     * @param term
     */
    public final void setTerm(String term) {
        this.term_ = term;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<changeSpeed");
        buffer.append(">");
        speed_.makeTextElement(buffer);
        buffer.append("<term>");
        buffer.append(URelaxer.escapeCharData(getTerm()));
        buffer.append("</term>");
        buffer.append("</changeSpeed>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<changeSpeed");
        buffer.print(">");
        speed_.makeTextElement(buffer);
        buffer.print("<term>");
        buffer.print(URelaxer.escapeCharData(getTerm()));
        buffer.print("</term>");
        buffer.print("</changeSpeed>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTermAsString() {
        return (URelaxer.getString(getTerm()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTermByString(String string) {
        setTerm(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>ChangeSpeed</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "changeSpeed")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!Speed.isMatchHungry(target)) {
            return (false);
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "term")) {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ChangeSpeed</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ChangeSpeed</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
