package jp.gr.java_conf.abagames.bulletml;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Bullet</b> is generated by Relaxer based on bulletml.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="bullet">
 *   <sequence>
 *     <ref label="direction" occurs="?"/>
 *     <ref label="speed" occurs="?"/>
 *     <hedgeRef label="actionElm" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="bullet">
 *   <attribute name="label" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="bullet"&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="direction" occurs="?"/&gt;
 *     &lt;ref label="speed" occurs="?"/&gt;
 *     &lt;hedgeRef label="actionElm" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="bullet"&gt;
 *   &lt;attribute name="label" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version bulletml.rlx 0.21 (Fri Feb 08 22:06:25 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class Bullet implements java.io.Serializable, IBulletElmChoice, IBulletmlChoice {
    private String label_;
    private Direction direction_;
    private Speed speed_;
    // List<IActionElmChoice>
    private java.util.List actionElm_ = new java.util.ArrayList();

    /**
     * Creates a <code>Bullet</code>.
     *
     */
    public Bullet() {
    }

    /**
     * Creates a <code>Bullet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Bullet(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Bullet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Bullet(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Bullet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Bullet(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Bullet</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bullet(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Bullet</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bullet(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Bullet</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bullet(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Bullet</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bullet(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Bullet</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bullet(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Bullet</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bullet(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Bullet</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Bullet</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Bullet</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        label_ = URelaxer.getAttributePropertyAsString(element, "label");
        if (Direction.isMatch(stack)) {
            setDirection(new Direction(stack));
        }
        if (Speed.isMatch(stack)) {
            setSpeed(new Speed(stack));
        }
        actionElm_.clear();
        while (!stack.isEmptyElement()) {
            if (Action.isMatch(stack)) {
                addActionElm(new Action(stack));
            } else if (ActionRef.isMatch(stack)) {
                addActionElm(new ActionRef(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("bullet");
        int size;
        if (this.label_ != null) {
            URelaxer.setAttributePropertyByString(element, "label", this.label_);
        }
        if (this.direction_ != null) {
            this.direction_.makeElement(element);
        }
        if (this.speed_ != null) {
            this.speed_.makeElement(element);
        }
        size = this.actionElm_.size();
        for (int i = 0;i < size;i++) {
            IActionElmChoice value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Bullet</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Bullet</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bullet</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bullet</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bullet</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bullet</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>label</b>.
     *
     * @return String
     */
    public final String getLabel() {
        return (label_);
    }

    /**
     * Sets the String property <b>label</b>.
     *
     * @param label
     */
    public final void setLabel(String label) {
        this.label_ = label;
    }

    /**
     * Gets the Direction property <b>direction</b>.
     *
     * @return Direction
     */
    public final Direction getDirection() {
        return (direction_);
    }

    /**
     * Sets the Direction property <b>direction</b>.
     *
     * @param direction
     */
    public final void setDirection(Direction direction) {
        this.direction_ = direction;
    }

    /**
     * Gets the Speed property <b>speed</b>.
     *
     * @return Speed
     */
    public final Speed getSpeed() {
        return (speed_);
    }

    /**
     * Sets the Speed property <b>speed</b>.
     *
     * @param speed
     */
    public final void setSpeed(Speed speed) {
        this.speed_ = speed;
    }

    /**
     * Gets the IActionElmChoice property <b>actionElm</b>.
     *
     * @return IActionElmChoice[]
     */
    public final IActionElmChoice[] getActionElm() {
        IActionElmChoice[] array = new IActionElmChoice[actionElm_.size()];
        return ((IActionElmChoice[])actionElm_.toArray(array));
    }

    /**
     * Sets the IActionElmChoice property <b>actionElm</b>.
     *
     * @param actionElm
     */
    public final void setActionElm(IActionElmChoice[] actionElm) {
        this.actionElm_.clear();
        this.actionElm_.addAll(java.util.Arrays.asList(actionElm));
    }

    /**
     * Sets the IActionElmChoice property <b>actionElm</b>.
     *
     * @param actionElm
     */
    public final void setActionElm(IActionElmChoice actionElm) {
        this.actionElm_.clear();
        this.actionElm_.add(actionElm);
    }

    /**
     * Adds the IActionElmChoice property <b>actionElm</b>.
     *
     * @param actionElm
     */
    public final void addActionElm(IActionElmChoice actionElm) {
        this.actionElm_.add(actionElm);
    }

    /**
     * Gets number of the IActionElmChoice property <b>actionElm</b>.
     *
     * @return int
     */
    public final int getActionElmCount() {
        return (actionElm_.size());
    }

    /**
     * Gets the IActionElmChoice property <b>actionElm</b> by index.
     *
     * @param index
     * @return IActionElmChoice
     */
    public final IActionElmChoice getActionElm(int index) {
        return ((IActionElmChoice)actionElm_.get(index));
    }

    /**
     * Sets the IActionElmChoice property <b>actionElm</b> by index.
     *
     * @param index
     * @param actionElm
     */
    public final void setActionElm(int index, IActionElmChoice actionElm) {
        this.actionElm_.set(index, actionElm);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<bullet");
        if (label_ != null) {
            buffer.append(" label=\"");
            buffer.append(URelaxer.escapeAttrQuot(getLabel()));
            buffer.append("\"");
        }
        buffer.append(">");
        if (direction_ != null) {
            direction_.makeTextElement(buffer);
        }
        if (speed_ != null) {
            speed_.makeTextElement(buffer);
        }
        size = this.actionElm_.size();
        for (int i = 0;i < size;i++) {
            IActionElmChoice value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</bullet>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<bullet");
        if (label_ != null) {
            buffer.print(" label=\"");
            buffer.print(URelaxer.escapeAttrQuot(getLabel()));
            buffer.print("\"");
        }
        buffer.print(">");
        if (direction_ != null) {
            direction_.makeTextElement(buffer);
        }
        if (speed_ != null) {
            speed_.makeTextElement(buffer);
        }
        size = this.actionElm_.size();
        for (int i = 0;i < size;i++) {
            IActionElmChoice value = (IActionElmChoice)this.actionElm_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</bullet>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLabelAsString() {
        return (URelaxer.getString(getLabel()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLabelByString(String string) {
        setLabel(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Bullet</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "bullet")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (Direction.isMatchHungry(target)) {
        }
        if (Speed.isMatchHungry(target)) {
        }
        while (!target.isEmptyElement()) {
            if (Action.isMatchHungry(target)) {
            } else if (ActionRef.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Bullet</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Bullet</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
