package jp.gr.java_conf.abagames.bulletml;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Action</b> is generated by Relaxer based on bulletml.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="action">
 *   <choice occurs="*">
 *     <ref label="repeat"/>
 *     <hedgeRef label="fireElm"/>
 *     <ref label="changeSpeed"/>
 *     <ref label="changeDirection"/>
 *     <ref label="accel"/>
 *     <ref label="wait"/>
 *     <ref label="vanish"/>
 *     <hedgeRef label="actionElm"/>
 *   </choice>
 * </elementRule>
 * 
 * <tag name="action">
 *   <attribute name="label" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="action"&gt;
 *   &lt;choice occurs="*"&gt;
 *     &lt;ref label="repeat"/&gt;
 *     &lt;hedgeRef label="fireElm"/&gt;
 *     &lt;ref label="changeSpeed"/&gt;
 *     &lt;ref label="changeDirection"/&gt;
 *     &lt;ref label="accel"/&gt;
 *     &lt;ref label="wait"/&gt;
 *     &lt;ref label="vanish"/&gt;
 *     &lt;hedgeRef label="actionElm"/&gt;
 *   &lt;/choice&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="action"&gt;
 *   &lt;attribute name="label" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version bulletml.rlx 0.21 (Fri Feb 08 22:06:25 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class Action implements java.io.Serializable, IActionElmChoice, IActionChoice, IBulletmlChoice {
    private String label_;
    // List<IActionChoice>
    private java.util.List content_ = new java.util.ArrayList();

    /**
     * Creates a <code>Action</code>.
     *
     */
    public Action() {
    }

    /**
     * Creates a <code>Action</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Action(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Action</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Action(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Action</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Action(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Action</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Action(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Action</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Action(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Action</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Action(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Action</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Action(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Action</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Action(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Action</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Action(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Action</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Action</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Action</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        label_ = URelaxer.getAttributePropertyAsString(element, "label");
        content_.clear();
        while (!stack.isEmptyElement()) {
            if (Repeat.isMatch(stack)) {
                addContent(new Repeat(stack));
            } else if (Fire.isMatch(stack)) {
                addContent(new Fire(stack));
            } else if (FireRef.isMatch(stack)) {
                addContent(new FireRef(stack));
            } else if (ChangeSpeed.isMatch(stack)) {
                addContent(new ChangeSpeed(stack));
            } else if (ChangeDirection.isMatch(stack)) {
                addContent(new ChangeDirection(stack));
            } else if (Accel.isMatch(stack)) {
                addContent(new Accel(stack));
            } else if (Wait.isMatch(stack)) {
                addContent(new Wait(stack));
            } else if (Vanish.isMatch(stack)) {
                addContent(new Vanish(stack));
            } else if (Action.isMatch(stack)) {
                addContent(new Action(stack));
            } else if (ActionRef.isMatch(stack)) {
                addContent(new ActionRef(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("action");
        int size;
        if (this.label_ != null) {
            URelaxer.setAttributePropertyByString(element, "label", this.label_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IActionChoice value = (IActionChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Action</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Action</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Action</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Action</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Action</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Action</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>label</b>.
     *
     * @return String
     */
    public final String getLabel() {
        return (label_);
    }

    /**
     * Sets the String property <b>label</b>.
     *
     * @param label
     */
    public final void setLabel(String label) {
        this.label_ = label;
    }

    /**
     * Gets the IActionChoice property <b>content</b>.
     *
     * @return IActionChoice[]
     */
    public final IActionChoice[] getContent() {
        IActionChoice[] array = new IActionChoice[content_.size()];
        return ((IActionChoice[])content_.toArray(array));
    }

    /**
     * Sets the IActionChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IActionChoice[] content) {
        this.content_.clear();
        this.content_.addAll(java.util.Arrays.asList(content));
    }

    /**
     * Sets the IActionChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IActionChoice content) {
        this.content_.clear();
        this.content_.add(content);
    }

    /**
     * Adds the IActionChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IActionChoice content) {
        this.content_.add(content);
    }

    /**
     * Gets number of the IActionChoice property <b>content</b>.
     *
     * @return int
     */
    public final int getContentCount() {
        return (content_.size());
    }

    /**
     * Gets the IActionChoice property <b>content</b> by index.
     *
     * @param index
     * @return IActionChoice
     */
    public final IActionChoice getContent(int index) {
        return ((IActionChoice)content_.get(index));
    }

    /**
     * Sets the IActionChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IActionChoice content) {
        this.content_.set(index, content);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<action");
        if (label_ != null) {
            buffer.append(" label=\"");
            buffer.append(URelaxer.escapeAttrQuot(getLabel()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IActionChoice value = (IActionChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</action>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<action");
        if (label_ != null) {
            buffer.print(" label=\"");
            buffer.print(URelaxer.escapeAttrQuot(getLabel()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IActionChoice value = (IActionChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</action>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLabelAsString() {
        return (URelaxer.getString(getLabel()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLabelByString(String string) {
        setLabel(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Action</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "action")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (Repeat.isMatchHungry(target)) {
            } else if (Fire.isMatchHungry(target)) {
            } else if (FireRef.isMatchHungry(target)) {
            } else if (ChangeSpeed.isMatchHungry(target)) {
            } else if (ChangeDirection.isMatchHungry(target)) {
            } else if (Accel.isMatchHungry(target)) {
            } else if (Wait.isMatchHungry(target)) {
            } else if (Vanish.isMatchHungry(target)) {
            } else if (Action.isMatchHungry(target)) {
            } else if (ActionRef.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Action</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Action</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
