/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final Enumeration EMPTY_ENUMERATION;
    private Context[] contexts;
    private Context currentContext;
    private int contextPos;

    public NamespaceSupport() {
        this.reset();
    }

    public void reset() {
        this.contexts = new Context[32];
        this.contextPos = 0;
        this.contexts[this.contextPos] = this.currentContext = new Context(this);
        this.currentContext.declarePrefix("xml", XMLNS);
    }

    public void pushContext() {
        int max = this.contexts.length;
        ++this.contextPos;
        if (this.contextPos >= max) {
            Context[] newContexts = new Context[max * 2];
            System.arraycopy(this.contexts, 0, newContexts, 0, max);
            max *= 2;
            this.contexts = newContexts;
        }
        this.currentContext = this.contexts[this.contextPos];
        if (this.currentContext == null) {
            this.contexts[this.contextPos] = this.currentContext = new Context(this);
        }
        if (this.contextPos > 0) {
            this.currentContext.setParent(this.contexts[this.contextPos - 1]);
        }
    }

    public void popContext() {
        --this.contextPos;
        if (this.contextPos < 0) {
            throw new EmptyStackException();
        }
        this.currentContext = this.contexts[this.contextPos];
    }

    public boolean declarePrefix(String prefix, String uri) {
        if (prefix.equals("xml") || prefix.equals("xmlns")) {
            return false;
        }
        this.currentContext.declarePrefix(prefix, uri);
        return true;
    }

    public String[] processName(String qName, String[] parts, boolean isAttribute) {
        String[] myParts = this.currentContext.processName(qName, isAttribute);
        if (myParts == null) {
            return null;
        }
        parts[0] = myParts[0];
        parts[1] = myParts[1];
        parts[2] = myParts[2];
        return parts;
    }

    public String getURI(String prefix) {
        return this.currentContext.getURI(prefix);
    }

    public Enumeration getPrefixes() {
        return this.currentContext.getPrefixes();
    }

    public String getPrefix(String uri) {
        return this.currentContext.getPrefix(uri);
    }

    public Enumeration getPrefixes(String uri) {
        Vector<String> prefixes = new Vector<String>();
        Enumeration allPrefixes = this.getPrefixes();
        while (allPrefixes.hasMoreElements()) {
            String prefix = (String)allPrefixes.nextElement();
            if (!uri.equals(this.getURI(prefix))) continue;
            prefixes.addElement(prefix);
        }
        return prefixes.elements();
    }

    public Enumeration getDeclaredPrefixes() {
        return this.currentContext.getDeclaredPrefixes();
    }

    static {
        XMLNS = XMLNS;
        EMPTY_ENUMERATION = new Vector().elements();
    }

    final class Context {
        Hashtable prefixTable;
        Hashtable uriTable;
        Hashtable elementNameTable;
        Hashtable attributeNameTable;
        String defaultNS = null;
        private Vector declarations = null;
        private boolean tablesDirty = false;
        private Context parent = null;

        Context(NamespaceSupport this$0) {
            this.copyTables();
        }

        void setParent(Context parent) {
            this.parent = parent;
            this.declarations = null;
            this.prefixTable = parent.prefixTable;
            this.uriTable = parent.uriTable;
            this.elementNameTable = parent.elementNameTable;
            this.attributeNameTable = parent.attributeNameTable;
            this.defaultNS = parent.defaultNS;
            this.tablesDirty = false;
        }

        void declarePrefix(String prefix, String uri) {
            if (!this.tablesDirty) {
                this.copyTables();
            }
            if (this.declarations == null) {
                this.declarations = new Vector();
            }
            prefix = prefix.intern();
            uri = uri.intern();
            if ("".equals(prefix)) {
                this.defaultNS = "".equals(uri) ? null : uri;
            } else {
                this.prefixTable.put(prefix, uri);
                this.uriTable.put(uri, prefix);
            }
            this.declarations.addElement(prefix);
        }

        String[] processName(String qName, boolean isAttribute) {
            Hashtable table = isAttribute ? this.elementNameTable : this.attributeNameTable;
            String[] name = (String[])table.get(qName);
            if (name != null) {
                return name;
            }
            name = new String[3];
            int index = qName.indexOf(58);
            if (index == -1) {
                name[0] = isAttribute || this.defaultNS == null ? "" : this.defaultNS;
                name[1] = qName.intern();
                name[2] = name[1];
            } else {
                String prefix = qName.substring(0, index);
                String local = qName.substring(index + 1);
                String uri = "".equals(prefix) ? this.defaultNS : (String)this.prefixTable.get(prefix);
                if (uri == null) {
                    return null;
                }
                name[0] = uri;
                name[1] = local.intern();
                name[2] = qName.intern();
            }
            table.put(name[2], name);
            this.tablesDirty = true;
            return name;
        }

        String getURI(String prefix) {
            if ("".equals(prefix)) {
                return this.defaultNS;
            }
            if (this.prefixTable == null) {
                return null;
            }
            return (String)this.prefixTable.get(prefix);
        }

        String getPrefix(String uri) {
            if (this.uriTable == null) {
                return null;
            }
            return (String)this.uriTable.get(uri);
        }

        Enumeration getDeclaredPrefixes() {
            if (this.declarations == null) {
                return EMPTY_ENUMERATION;
            }
            return this.declarations.elements();
        }

        Enumeration getPrefixes() {
            if (this.prefixTable == null) {
                return EMPTY_ENUMERATION;
            }
            return this.prefixTable.keys();
        }

        private void copyTables() {
            this.prefixTable = this.prefixTable != null ? (Hashtable)this.prefixTable.clone() : new Hashtable();
            this.uriTable = this.uriTable != null ? (Hashtable)this.uriTable.clone() : new Hashtable();
            this.elementNameTable = new Hashtable();
            this.attributeNameTable = new Hashtable();
            this.tablesDirty = true;
        }
    }
}

