/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.util.xml;

import com.anotherbigidea.util.xml.SaxHandlerBase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLWriter
extends SaxHandlerBase {
    protected Writer out;
    protected boolean started = false;

    public XMLWriter(OutputStream outstream) {
        this.out = new PrintWriter(outstream);
    }

    public XMLWriter(PrintWriter writer) {
        this.out = writer;
    }

    public void startDocument() throws SAXException {
        try {
            this.out.write("<?xml version='1.0'?>");
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    protected void completeElement() throws IOException {
        if (!this.started) {
            return;
        }
        this.out.write(" >");
        this.started = false;
    }

    public static String normalize(char[] chars, int start, int length) {
        StringBuffer buff = new StringBuffer();
        block7: for (int i = start; i < start + length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\'': {
                    buff.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block7;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block7;
                }
                case '<': {
                    buff.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block7;
                }
                default: {
                    buff.append(c);
                }
            }
        }
        return buff.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.completeElement();
            this.started = true;
            this.out.write("<".concat(String.valueOf(String.valueOf(qName))));
            if (atts != null) {
                int count = atts.getLength();
                for (int i = 0; i < count; ++i) {
                    String name = atts.getQName(i);
                    String value = atts.getValue(i);
                    this.out.write(String.valueOf(String.valueOf(new StringBuffer(" ").append(name).append("='").append(XMLWriter.normalize(value.toCharArray(), 0, value.length())).append("'"))));
                }
            }
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this.started) {
                this.out.write(" />");
            } else {
                this.out.write(String.valueOf(String.valueOf(new StringBuffer("</").append(qName).append(">"))));
            }
            this.started = false;
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.completeElement();
            this.out.write(XMLWriter.normalize(ch, start, length));
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.completeElement();
            this.out.write(String.valueOf(String.valueOf(new StringBuffer("<?").append(target).append(" ").append(data).append("?>"))));
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }
}

