/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutStream {
    protected OutputStream out;
    protected long bytesWritten = 0L;
    protected int bitBuf;
    protected int bitPos;

    public OutStream(OutputStream out) {
        this.out = out;
        this.initBits();
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(long written) {
        this.bytesWritten = written;
    }

    public void writeSBits(int numBits, int value) throws IOException {
        long lval = value & Integer.MAX_VALUE;
        if (value < 0) {
            lval |= 1L << numBits - 1;
        }
        this.writeUBits(numBits, lval);
    }

    public void flush() throws IOException {
        this.flushBits();
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flushBits() throws IOException {
        if (this.bitPos == 0) {
            return;
        }
        this.out.write(this.bitBuf);
        this.bitBuf = 0;
        this.bitPos = 0;
        ++this.bytesWritten;
    }

    public void writeUBits(int numBits, long value) throws IOException {
        if (numBits == 0) {
            return;
        }
        if (this.bitPos == 0) {
            this.bitPos = 8;
        }
        int bitNum = numBits;
        while (bitNum > 0) {
            while (this.bitPos > 0 && bitNum > 0) {
                if (OutStream.getBit(bitNum, value)) {
                    this.bitBuf = OutStream.setBit(this.bitPos, this.bitBuf);
                }
                --bitNum;
                --this.bitPos;
            }
            if (this.bitPos != 0) continue;
            this.writeUI8(this.bitBuf);
            this.bitBuf = 0;
            if (bitNum <= 0) continue;
            this.bitPos = 8;
        }
    }

    public static boolean getBit(int bitNum, long value) {
        return (value & 1L << bitNum - 1) != (long)0;
    }

    public static int setBit(int bitNum, int value) {
        return value | 1 << bitNum - 1;
    }

    public void write(byte[] bytes) throws IOException {
        this.flushBits();
        if (bytes != null && bytes.length > 0) {
            this.out.write(bytes);
            this.bytesWritten += (long)bytes.length;
        }
    }

    public void write(byte[] bytes, int start, int length) throws IOException {
        this.flushBits();
        if (bytes != null && length > 0) {
            this.out.write(bytes, start, length);
            this.bytesWritten += (long)length;
        }
    }

    public void writeUI8(int value) throws IOException {
        this.flushBits();
        this.out.write(value);
        ++this.bytesWritten;
    }

    public void writeUI16(int value) throws IOException {
        this.flushBits();
        this.out.write(value & 0xFF);
        this.out.write(value >> 8);
        this.bytesWritten += (long)2;
    }

    public void writeSI16(short value) throws IOException {
        this.flushBits();
        this.out.write(value & 0xFF);
        this.out.write(value >> 8);
        this.bytesWritten += (long)2;
    }

    public void writeUI32(long value) throws IOException {
        this.flushBits();
        this.out.write((int)(value & (long)255));
        this.out.write((int)(value >> 8));
        this.out.write((int)(value >> 16));
        this.out.write((int)(value >> 24));
        this.bytesWritten += (long)4;
    }

    public void writeString(String s) throws IOException {
        if (s == null) {
            s = "";
        }
        this.writeString(s.getBytes());
    }

    public void writeString(byte[] string) throws IOException {
        this.flushBits();
        if (string != null) {
            this.out.write(string);
        }
        this.out.write(0);
        this.bytesWritten += (long)(string.length + 1);
    }

    public static int getStringLength(byte[] string) {
        if (string == null) {
            return 1;
        }
        return string.length + 1;
    }

    public static int getStringLength(String string) {
        if (string == null) {
            return 1;
        }
        byte[] bytes = string.getBytes();
        return bytes.length + 1;
    }

    protected void initBits() {
        this.bitBuf = 0;
        this.bitPos = 0;
    }

    public static int determineSignedBitSize(int value) {
        int topBit;
        if (value >= 0) {
            return OutStream.determineUnsignedBitSize(value) + 1;
        }
        long mask = 0x40000000L;
        for (topBit = 31; topBit > 0 && ((long)value & mask) != (long)0; --topBit) {
            mask >>= 1;
        }
        if (topBit == 0) {
            return 2;
        }
        int val2 = value & (1 << topBit) - 1;
        if (val2 == 0) {
            ++topBit;
        }
        return topBit + 1;
    }

    public static int determineUnsignedBitSize(long value) {
        long mask = 0x80000000L;
        for (int topBit = 32; topBit > 0; --topBit) {
            if ((value & mask) != (long)0) {
                return topBit;
            }
            mask >>= 1;
        }
        return 0;
    }

    public void writeFloat(float value) throws IOException {
        this.writeSI32(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(baos);
        dout.writeDouble(value);
        dout.flush();
        byte[] bytes = baos.toByteArray();
        byte[] bytes2 = new byte[]{bytes[3], bytes[2], bytes[1], bytes[0], bytes[7], bytes[6], bytes[5], bytes[4]};
        this.write(bytes2);
    }

    public void writeSI32(int value) throws IOException {
        this.flushBits();
        this.out.write(value & 0xFF);
        this.out.write(value >> 8);
        this.out.write(value >> 16);
        this.out.write(value >> 24);
        this.bytesWritten += (long)4;
    }

    public static byte[] sintTo2Bytes(int value) {
        return new byte[]{OutStream.uintToByte(value & 0xFF), OutStream.uintToByte(value >> 8)};
    }

    public static byte[] uintTo2Bytes(int value) {
        return new byte[]{OutStream.uintToByte(value & 0xFF), OutStream.uintToByte(value >> 8)};
    }

    public static byte[] uintTo4Bytes(int value) {
        return new byte[]{OutStream.uintToByte(value & 0xFF), OutStream.uintToByte(value >> 8), OutStream.uintToByte(value >> 16), OutStream.uintToByte(value >> 24)};
    }

    public static byte uintToByte(int value) {
        int lowbit = value & 1;
        byte b = (byte)(value >>= 1);
        b = (byte)(b << 1);
        b = (byte)(b | (byte)lowbit);
        return b;
    }
}

