/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.io;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class Byte4ByteDebugStreams
extends OutputStream {
    protected ByteArrayInputStream in;
    protected byte[] bytesIn;
    protected byte[] bytesOut;
    protected int bytePtr = 0;

    public Byte4ByteDebugStreams(String filenameIn) throws Exception {
        RandomAccessFile raIn = new RandomAccessFile(filenameIn, "r");
        this.bytesIn = new byte[(int)raIn.length()];
        this.bytesOut = new byte[(int)raIn.length()];
        raIn.readFully(this.bytesIn);
        raIn.close();
    }

    public Byte4ByteDebugStreams(byte[] bytesIn) {
        this.bytesIn = bytesIn;
        this.bytesOut = new byte[bytesIn.length];
    }

    public InputStream getInputStream() {
        if (this.in != null) {
            return this.in;
        }
        this.in = new ByteArrayInputStream(this.bytesIn);
        return this.in;
    }

    public void setInputBytes(byte[] inBytes) {
        this.bytesIn = inBytes;
    }

    public void write(int b) throws IOException {
        if (b > 127) {
            b = (b & 0x7F) - 128;
        }
        this.bytesOut[this.bytePtr] = (byte)b;
        if (this.bytesOut[this.bytePtr] != this.bytesIn[this.bytePtr]) {
            IOException ioe = new IOException(String.valueOf(String.valueOf(new StringBuffer("Byte mismatch between input and output at byte #").append(this.bytePtr).append(" 0x").append(Integer.toHexString(this.bytePtr)).append("\nexpected 0x").append(Integer.toHexString(this.bytesIn[this.bytePtr])).append(" but got 0x").append(Integer.toHexString(b)))));
            ioe.printStackTrace();
            throw ioe;
        }
        ++this.bytePtr;
    }

    public void write(String filenameOut) throws IOException {
        FileOutputStream out = new FileOutputStream(filenameOut);
        out.write(this.bytesOut);
        out.flush();
        out.close();
    }
}

