/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.actionscript.Decompiler;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.flash.writers.ActionTextWriter;
import com.anotherbigidea.util.Hex;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class SWFTagDumper
implements SWFTagTypes,
SWFShape,
SWFText {
    protected PrintWriter writer;
    protected String dashes = "---------------";
    protected boolean dumpHex;
    protected String indent = "";
    protected boolean decompileActions = false;

    public SWFTagDumper(boolean dumpHex, boolean decompileActions) {
        this(System.out, dumpHex, decompileActions);
    }

    public SWFTagDumper(OutputStream out, boolean dumpHex, boolean decompileActions) {
        this.writer = new PrintWriter(out);
        this.dumpHex = dumpHex;
        this.decompileActions = decompileActions;
    }

    public SWFTagDumper(PrintWriter writer, boolean dumpHex, boolean decompileActions) {
        this.writer = writer;
        this.dumpHex = dumpHex;
        this.decompileActions = decompileActions;
    }

    protected void println(String line) {
        this.writer.println(String.valueOf(String.valueOf(this.indent)).concat(String.valueOf(String.valueOf(line))));
    }

    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("Tag ").append(tagType).append(" length=").append(contents.length))));
        if (this.dumpHex) {
            Hex.dump(this.writer, contents, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("header: version=").append(version).append(" length=").append(length).append(" width=").append(twipsWidth).append(" height=").append(twipsHeight).append(" rate=").append(frameRate).append(" frame-count=").append(frameCount))));
    }

    public void tagEnd() throws IOException {
        this.println("end");
        this.println(this.dashes);
    }

    public void tagStartSound(int soundId, SoundInfo info) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("start-sound id=").append(soundId).append(" ").append(info))));
    }

    public void tagSoundStreamHead(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.printSoundStreamHead("sound-stream-head", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void tagSoundStreamHead2(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.printSoundStreamHead("sound-stream-head-2", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void printSoundStreamHead(String name, int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        String playFreq = "5.5";
        if (playbackFrequency == 1) {
            playFreq = "11";
        }
        if (playbackFrequency == 2) {
            playFreq = "22";
        }
        if (playbackFrequency == 3) {
            playFreq = "44";
        }
        String streamFreq = "5.5";
        if (streamFrequency == 1) {
            streamFreq = "11";
        }
        if (streamFrequency == 2) {
            streamFreq = "22";
        }
        if (streamFrequency == 3) {
            streamFreq = "44";
        }
        String format = "RawSamples";
        if (streamFormat == 1) {
            format = "ADPCM";
        }
        if (streamFormat == 2) {
            format = "MP3";
        }
        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(name))).append(" play at ").append(playFreq).append("kHz stereo=").append(playbackStereo).append(" 16bit=").append(playback16bit).append(" | Stream at ").append(streamFreq).append("kHz format=").append(format).append(" stereo=").append(streamStereo).append(" 16bit=").append(stream16bit).append(" Avg-Samples=").append(averageSampleCount))));
    }

    public void tagSoundStreamBlock(byte[] soundData) throws IOException {
        this.println("sound-stream-block");
        if (this.dumpHex) {
            Hex.dump(this.writer, soundData, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagSerialNumber(String serialNumber) throws IOException {
        this.println("serial number =".concat(String.valueOf(String.valueOf(serialNumber))));
    }

    public void tagGenerator(byte[] data) throws IOException {
        this.println("generator tag");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorText(byte[] data) throws IOException {
        this.println("generator text");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorFont(byte[] data) throws IOException {
        this.println("generator font");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagGeneratorCommand(byte[] data) throws IOException {
        this.println("generator command");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagNameCharacter(byte[] data) throws IOException {
        this.println("generator name character");
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBits(int id, byte[] imageData) throws IOException {
        this.println("jpeg bits");
        if (this.dumpHex) {
            Hex.dump(this.writer, imageData, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagJPEGTables(byte[] jpegEncodingData) throws IOException {
        this.println("jpeg encoding data");
        if (this.dumpHex) {
            Hex.dump(this.writer, jpegEncodingData, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBitsJPEG3(int id, byte[] imageData, byte[] alphaData) throws IOException {
        this.println("jpeg with alpha");
        if (this.dumpHex) {
            Hex.dump(this.writer, imageData, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println("--- Alpha Channel follows ---");
            Hex.dump(this.writer, alphaData, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagDefineSound(int id, int format, int frequency, boolean bits16, boolean stereo, int sampleCount, byte[] soundData) throws IOException {
        String freq = "5.5";
        if (frequency == 1) {
            freq = "11";
        }
        if (frequency == 2) {
            freq = "22";
        }
        if (frequency == 3) {
            freq = "44";
        }
        String formatS = "RawSamples";
        if (format == 1) {
            formatS = "ADPCM";
        }
        if (format == 2) {
            formatS = "MP3";
        }
        this.println(String.valueOf(String.valueOf(new StringBuffer("define sound: id=").append(id).append(" format=").append(formatS).append(" freq=").append(freq).append("kHz 16bit=").append(bits16).append(" stereo=").append(stereo).append(" samples=").append(sampleCount))));
        if (this.dumpHex) {
            Hex.dump(this.writer, soundData, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagDefineButtonSound(int buttonId, int rollOverSoundId, SoundInfo rollOverSoundInfo, int rollOutSoundId, SoundInfo rollOutSoundInfo, int pressSoundId, SoundInfo pressSoundInfo, int releaseSoundId, SoundInfo releaseSoundInfo) throws IOException {
        this.println("define button sound: id=".concat(String.valueOf(String.valueOf(buttonId))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("    roll-over sound=").append(rollOverSoundId).append(" ").append(rollOverSoundInfo))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("    roll-out  sound=").append(rollOutSoundId).append(" ").append(rollOutSoundInfo))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("    press     sound=").append(pressSoundId).append(" ").append(pressSoundInfo))));
        this.println(String.valueOf(String.valueOf(new StringBuffer("    release   sound=").append(releaseSoundId).append(" ").append(releaseSoundInfo))));
    }

    public void tagShowFrame() throws IOException {
        this.println("---------- frame ----------");
    }

    public SWFActions tagDoAction() throws IOException {
        this.println("actions:");
        if (this.decompileActions) {
            return new Decompiler(this.writer, 1 + this.indent.length() / 4);
        }
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    ".concat(String.valueOf(String.valueOf(this.indent)));
        return acts;
    }

    public SWFShape tagDefineShape(int id, Rect outline) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("shape id=").append(id).append("   ").append(outline))));
        return this;
    }

    public SWFShape tagDefineShape2(int id, Rect outline) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("shape2 id=").append(id).append("   ").append(outline))));
        return this;
    }

    public SWFShape tagDefineShape3(int id, Rect outline) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("shape3 id=").append(id).append("   ").append(outline))));
        return this;
    }

    public void tagFreeCharacter(int charId) throws IOException {
        this.println("free character id=".concat(String.valueOf(String.valueOf(charId))));
    }

    public void tagPlaceObject(int charId, int depth, Matrix matrix, AlphaTransform cxform) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("place-object id=").append(charId).append(" depth=").append(depth).append("  ").append(matrix).append("  ").append(cxform))));
    }

    public SWFActions tagPlaceObject2(boolean isMove, int clipDepth, int depth, int charId, Matrix matrix, AlphaTransform cxform, int ratio, String name, int clipActionFlags) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("place-object2 move=").append(isMove).append(" id=").append(charId).append(" depth=").append(depth).append(" clip=").append(clipDepth).append(" ratio=").append(ratio).append(" name=").append(name).append("  ").append(matrix).append("  ").append(cxform))));
        if (clipActionFlags != 0) {
            this.println("  clip-actions:");
            if (this.decompileActions) {
                return new Decompiler(this.writer, 1 + this.indent.length() / 4);
            }
            ActionTextWriter acts = new ActionTextWriter(this.writer);
            acts.indent = "    ".concat(String.valueOf(String.valueOf(this.indent)));
            return acts;
        }
        return null;
    }

    public void tagRemoveObject(int charId, int depth) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("remove-object id=").append(charId).append(" depth=").append(depth))));
    }

    public void tagRemoveObject2(int depth) throws IOException {
        this.println("remove-object2 depth=".concat(String.valueOf(String.valueOf(depth))));
    }

    public void tagSetBackgroundColor(Color color) throws IOException {
        this.println("background-color  ".concat(String.valueOf(String.valueOf(color))));
    }

    public void tagFrameLabel(String label) throws IOException {
        this.println("frame-label ".concat(String.valueOf(String.valueOf(label))));
    }

    public SWFTagTypes tagDefineSprite(int id) throws IOException {
        this.println("sprite id=".concat(String.valueOf(String.valueOf(id))));
        SWFTagDumper dumper = new SWFTagDumper(this.writer, this.dumpHex, this.decompileActions);
        dumper.indent = String.valueOf(String.valueOf(this.indent)).concat("    ");
        return dumper;
    }

    public void tagProtect(byte[] password) throws IOException {
        this.println("protect");
    }

    public void tagEnableDebug(byte[] password) throws IOException {
        this.println("enable-debug");
    }

    public SWFVectors tagDefineFont(int id, int numGlyphs) throws IOException {
        this.println("font id=".concat(String.valueOf(String.valueOf(id))));
        return this;
    }

    public void tagDefineFontInfo(int fontId, String fontName, int flags, int[] codes) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("font-info id=").append(fontId).append(" name=").append(fontName).append(" flags=").append(Integer.toBinaryString(flags)).append(" codes=").append(codes.length))));
    }

    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("font2 id=").append(id).append(" flags=").append(Integer.toBinaryString(flags)).append(" name=").append(name).append(" ascent=").append(ascent).append(" descent=").append(descent).append(" leading=").append(leading).append(" has-kerns=").append(kernCodes1 != null))));
        return this;
    }

    public void tagDefineTextField(int fieldId, String fieldName, String initialText, Rect boundary, int flags, AlphaColor textColor, int alignment, int fontId, int fontSize, int charLimit, int leftMargin, int rightMargin, int indentation, int lineSpacing) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("edit-field id=").append(fieldId).append(" name=").append(fieldName).append(" text=").append(initialText).append(" font=").append(fontId).append(" size=").append(fontSize).append(" chars=").append(charLimit).append(" left=").append(leftMargin).append(" right=").append(rightMargin).append(" indent=").append(indentation).append(" spacing=").append(lineSpacing).append(" alignment=").append(alignment).append(" flags=").append(Integer.toBinaryString(flags)).append(" ").append(textColor))));
    }

    public SWFText tagDefineText(int id, Rect bounds, Matrix matrix) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("text id=").append(id).append(" ").append(bounds).append(" ").append(matrix))));
        return this;
    }

    public SWFText tagDefineText2(int id, Rect bounds, Matrix matrix) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("text2 id=").append(id).append(" ").append(bounds).append(" ").append(matrix))));
        return this;
    }

    public SWFActions tagDefineButton(int id, Vector buttonRecords) throws IOException {
        this.println("button id=".concat(String.valueOf(String.valueOf(id))));
        Enumeration enumeration = buttonRecords.elements();
        while (enumeration.hasMoreElements()) {
            ButtonRecord rec = (ButtonRecord)enumeration.nextElement();
            this.println("  ".concat(String.valueOf(String.valueOf(rec))));
        }
        this.println("  actions:");
        if (this.decompileActions) {
            return new Decompiler(this.writer, 1 + this.indent.length() / 4);
        }
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    ".concat(String.valueOf(String.valueOf(this.indent)));
        return acts;
    }

    public void tagButtonCXForm(int buttonId, ColorTransform transform) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("button-cxform id=").append(buttonId).append("  ").append(transform))));
    }

    public SWFActions tagDefineButton2(int id, boolean trackAsMenu, Vector buttonRecord2s) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("button2 id=").append(id).append(" track-as-menu=").append(trackAsMenu))));
        Enumeration enumeration = buttonRecord2s.elements();
        while (enumeration.hasMoreElements()) {
            ButtonRecord2 rec = (ButtonRecord2)enumeration.nextElement();
            this.println("  ".concat(String.valueOf(String.valueOf(rec))));
        }
        this.println("  actions:");
        if (this.decompileActions) {
            return new Decompiler(this.writer, 1 + this.indent.length() / 4);
        }
        ActionTextWriter acts = new ActionTextWriter(this.writer);
        acts.indent = "    ".concat(String.valueOf(String.valueOf(this.indent)));
        return acts;
    }

    public void tagExport(String[] names, int[] ids) throws IOException {
        this.println("export");
        for (int i = 0; i < names.length && i < ids.length; ++i) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("  id=").append(ids[i]).append(" name=").append(names[i]))));
        }
    }

    public void tagImport(String movieName, String[] names, int[] ids) throws IOException {
        this.println("import library-movie=".concat(String.valueOf(String.valueOf(movieName))));
        for (int i = 0; i < names.length && i < ids.length; ++i) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("  id=").append(ids[i]).append(" name=").append(names[i]))));
        }
    }

    public void tagDefineQuickTimeMovie(int id, String filename) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("quicktime-movie id=").append(id).append(" name=").append(filename))));
    }

    public void tagDefineBitsJPEG2(int id, byte[] data) throws IOException {
        this.println("jpeg2 id=".concat(String.valueOf(String.valueOf(id))));
        if (this.dumpHex) {
            Hex.dump(this.writer, data, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void tagDefineBitsJPEG2(int id, InputStream jpegImage) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("jpeg2 id=").append(id).append(" (from input stream)"))));
    }

    public SWFShape tagDefineMorphShape(int id, Rect startBounds, Rect endBounds) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("morph-shape id=").append(id).append(" start: ").append(startBounds).append("  end: ").append(endBounds))));
        return this;
    }

    public void tagDefineBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.dumpBitsLossless("bits-lossless", id, format, width, height, colors, imageData);
    }

    public void tagDefineBitsLossless2(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.dumpBitsLossless("bits-lossless2", id, format, width, height, colors, imageData);
    }

    public void dumpBitsLossless(String name, int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        int size = 0;
        if (format == 3) {
            size = 8;
        } else if (format == 4) {
            size = 16;
        } else if (format == 5) {
            size = 32;
        }
        this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(name))).append(" id=").append(id).append(" bits=").append(size).append(" width=").append(width).append(" height=").append(height))));
        if (this.dumpHex) {
            for (int i = 0; i < colors.length; ++i) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("    ").append(i).append(": ").append(colors[i]))));
            }
            Hex.dump(this.writer, imageData, 0L, String.valueOf(String.valueOf(this.indent)).concat("    "), false);
            this.println(this.dashes);
        }
    }

    public void done() throws IOException {
        this.println("    ".concat(String.valueOf(String.valueOf(this.dashes))));
    }

    public void line(int dx, int dy) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("    line  ").append(dx).append(",").append(dy))));
    }

    public void curve(int cx, int cy, int dx, int dy) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("    curve ").append(cx).append(",").append(cy).append(" - ").append(dx).append(",").append(dy))));
    }

    public void move(int x, int y) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("    move  ").append(x).append(",").append(y))));
    }

    public void setFillStyle0(int styleIndex) throws IOException {
        this.println("    fill0 = ".concat(String.valueOf(String.valueOf(styleIndex))));
    }

    public void setFillStyle1(int styleIndex) throws IOException {
        this.println("    fill1 = ".concat(String.valueOf(String.valueOf(styleIndex))));
    }

    public void setLineStyle(int styleIndex) throws IOException {
        this.println("    line  = ".concat(String.valueOf(String.valueOf(styleIndex))));
    }

    public void defineFillStyle(Color color) throws IOException {
        this.println("    fill ".concat(String.valueOf(String.valueOf(color))));
    }

    public void defineFillStyle(Matrix matrix, int[] ratios, Color[] colors, boolean radial) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("    fill radial=").append(radial).append("  ").append(matrix))));
        for (int i = 0; i < ratios.length && i < colors.length; ++i) {
            if (colors[i] == null) continue;
            this.println(String.valueOf(String.valueOf(new StringBuffer("         ratio=").append(ratios[i]).append(" ").append(colors[i]))));
        }
    }

    public void defineFillStyle(int bitmapId, Matrix matrix, boolean clipped) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("    fill clipped=").append(clipped).append(" image=").append(bitmapId).append(" ").append(matrix))));
    }

    public void defineLineStyle(int width, Color color) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("    line-style width=").append(width).append("  ").append(color))));
    }

    public void font(int fontId, int textHeight) throws IOException {
        this.println(String.valueOf(String.valueOf(new StringBuffer("    font id=").append(fontId).append(" size=").append(textHeight))));
    }

    public void color(Color color) throws IOException {
        this.println("    color ".concat(String.valueOf(String.valueOf(color))));
    }

    public void setX(int x) throws IOException {
        this.println("    x = ".concat(String.valueOf(String.valueOf(x))));
    }

    public void setY(int y) throws IOException {
        this.println("    y = ".concat(String.valueOf(String.valueOf(y))));
    }

    public void text(int[] glyphIndices, int[] glyphAdvances) throws IOException {
        StringBuffer buff1 = new StringBuffer();
        StringBuffer buff2 = new StringBuffer();
        buff1.append("(");
        buff2.append("(");
        for (int i = 0; i < glyphIndices.length && i < glyphAdvances.length; ++i) {
            buff1.append(" ");
            buff2.append(" ");
            buff1.append(glyphIndices[i]);
            buff2.append(glyphAdvances[i]);
        }
        buff1.append(" )");
        buff2.append(" )");
        this.println("    text");
        this.println("        glyph indices = ".concat(String.valueOf(String.valueOf(buff1))));
        this.println("        advances      = ".concat(String.valueOf(String.valueOf(buff2))));
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public static void main(String[] args) throws IOException {
        SWFTagDumper dumper = new SWFTagDumper(args.length > 1, args.length > 2);
        FileInputStream in = new FileInputStream(args[0]);
        TagParser tagparser = new TagParser(dumper);
        SWFReader reader = new SWFReader((SWFTags)tagparser, in);
        reader.readFile();
        dumper.flush();
        in.close();
    }
}

