/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.util.Base64;
import com.anotherbigidea.util.xml.SaxHandlerBase;
import java.io.FileInputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SWFSaxWriter
extends SaxHandlerBase {
    protected SWFTagTypes tags;
    protected SWFTagTypes movieTags;
    protected SWFShape shape;
    protected SWFVectors vectors;
    protected SWFActions actions;
    protected SWFText text;
    protected int actionMode = 0;
    protected int flashVersion = 5;
    protected boolean idAllocate = false;
    protected int newId = 1;
    protected Matrix matrix;
    protected Color color;
    protected AlphaTransform cxform;
    protected boolean hasAlpha;
    protected Map ids = new HashMap();
    protected Vector buttonRecords = new Vector();
    protected ArrayList bitmapColors;
    protected byte[] pixelData;
    protected byte[] jpegAlpha;
    protected ArrayList colors;
    protected ArrayList ratios;
    protected ArrayList symbols;
    protected ArrayList chars;
    protected ArrayList codes;
    protected Vector lookupValues = new Vector();
    protected ArrayList soundInfos;

    public SWFSaxWriter(SWFTagTypes tags) {
        this.setTagTypes(tags);
        this.initElements();
    }

    public void setTagTypes(SWFTagTypes tags) {
        this.tags = tags;
        this.movieTags = tags;
    }

    protected int getId(String id) throws SAXException {
        if (id == null) {
            throw new SAXException("Missing id.");
        }
        if (this.idAllocate) {
            Integer idI = (Integer)this.ids.get(id);
            if (idI != null) {
                return idI;
            }
            throw new SAXException("Id not found: ".concat(String.valueOf(String.valueOf(id))));
        }
        try {
            int idI = Integer.parseInt(id);
            return idI;
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("Invalid id: ".concat(String.valueOf(String.valueOf(id))));
        }
    }

    protected int getOrAllocateId(String id) throws SAXException {
        if (id == null) {
            throw new SAXException("Missing id.");
        }
        if (this.idAllocate) {
            Integer idI = (Integer)this.ids.get(id);
            if (idI != null) {
                return idI;
            }
            this.ids.put(id, new Integer(this.newId));
            return this.newId++;
        }
        try {
            int idI = Integer.parseInt(id);
            return idI;
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("Invalid id: ".concat(String.valueOf(String.valueOf(id))));
        }
    }

    protected int newId(String id) throws SAXException {
        if (id == null) {
            throw new SAXException("Missing id.");
        }
        if (this.idAllocate) {
            this.ids.put(id, new Integer(this.newId));
            return this.newId++;
        }
        try {
            int n = Integer.parseInt(id);
            return n;
        }
        catch (NumberFormatException nfe) {
            throw new SAXException("Invalid id: ".concat(String.valueOf(String.valueOf(id))));
        }
    }

    protected void initElements() {
        this.elementTypes.put("movie", new Movie());
        this.elementTypes.put("sprite", new Sprite());
        this.elementTypes.put("frame", new Frame());
        this.elementTypes.put("tag", new Tag());
        this.elementTypes.put("background-color", new BackgroundColor());
        this.elementTypes.put("protect", new Protect());
        this.elementTypes.put("enable-debug", new EnableDebug());
        this.elementTypes.put("actions", new Actions());
        this.elementTypes.put("shape", new Shape());
        this.elementTypes.put("release", new Release());
        this.elementTypes.put("remove", new Remove());
        this.elementTypes.put("place", new Place());
        this.elementTypes.put("jpeg", new Jpeg());
        this.elementTypes.put("bitmap", new Bitmap());
        this.elementTypes.put("import", new Import());
        this.elementTypes.put("export", new Export());
        this.elementTypes.put("quicktime-movie", new QTMovie());
        this.elementTypes.put("text-font", new TextFont());
        this.elementTypes.put("text", new Text());
        this.elementTypes.put("font-info", new FontInfo());
        this.elementTypes.put("edit-font", new EditFont());
        this.elementTypes.put("edit-field", new EditField());
        this.elementTypes.put("morph", new Morph());
        this.elementTypes.put("button", new Button());
        this.elementTypes.put("jpeg-header", new JPEGHeader());
        this.elementTypes.put("sound", new Sound());
        this.elementTypes.put("button-sound", new ButtonSound());
        this.elementTypes.put("sound-info", new Sound_Info());
        this.elementTypes.put("start-sound", new StartSound());
        this.elementTypes.put("sound-stream-header", new SoundHeader());
        this.elementTypes.put("sound-stream-block", new SoundBlock());
        this.elementTypes.put("image", new JPEGImage());
        this.elementTypes.put("alpha", new JPEGAlpha());
        this.elementTypes.put("layer", new Layer());
        this.elementTypes.put("serial-number", new SerialNumber());
        this.elementTypes.put("generator", new Generator());
        this.elementTypes.put("generator-text", new GeneratorText());
        this.elementTypes.put("generator-command", new GeneratorCommand());
        this.elementTypes.put("generator-font", new GeneratorFont());
        this.elementTypes.put("generator-name-character", new GeneratorNameCharacter());
        this.elementTypes.put("set-font", new SetFont());
        this.elementTypes.put("set-x", new SetX());
        this.elementTypes.put("set-y", new SetY());
        this.elementTypes.put("char", new Char());
        this.elementTypes.put("glyph", new Glyph());
        this.elementTypes.put("code", new Code());
        this.elementTypes.put("anticlockwise", new Anticlockwise());
        this.elementTypes.put("symbol", new Symbol());
        this.elementTypes.put("colors", new Colors());
        this.elementTypes.put("pixels", new Pixels());
        this.elementTypes.put("color", new ColorElem());
        this.elementTypes.put("matrix", new MatrixElem());
        this.elementTypes.put("color-transform", new CXFormElem());
        this.elementTypes.put("line", new ShapeLine());
        this.elementTypes.put("curve", new ShapeCurve());
        this.elementTypes.put("move", new ShapeMove());
        this.elementTypes.put("set-primary-fill", new ShapeFill0());
        this.elementTypes.put("set-secondary-fill", new ShapeFill1());
        this.elementTypes.put("set-line-style", new ShapeSetLine());
        this.elementTypes.put("color-fill", new ShapeColorFill());
        this.elementTypes.put("gradient-fill", new ShapeGradient());
        this.elementTypes.put("image-fill", new ShapeImage());
        this.elementTypes.put("line-style", new ShapeLineStyle());
        this.elementTypes.put("step", new Step());
        this.elementTypes.put("unknown", new ActionUnknown());
        this.elementTypes.put("jump-label", new ActionJumpLabel());
        this.elementTypes.put("comment", new ActionComment());
        this.elementTypes.put("goto-frame", new ActionGotoFrame());
        this.elementTypes.put("get-url", new ActionGetUrl());
        this.elementTypes.put("next-frame", new ActionNextFrame());
        this.elementTypes.put("prev-frame", new ActionPrevFrame());
        this.elementTypes.put("play", new ActionPlay());
        this.elementTypes.put("stop", new ActionStop());
        this.elementTypes.put("toggle-quality", new ActionToggleQuality());
        this.elementTypes.put("stop-sounds", new ActionStopSounds());
        this.elementTypes.put("wait-for-frame", new ActionWaitForFrame());
        this.elementTypes.put("set-target", new ActionSetTarget());
        this.elementTypes.put("push", new ActionPush());
        this.elementTypes.put("pop", new ActionPop());
        this.elementTypes.put("add", new ActionAdd());
        this.elementTypes.put("subtract", new ActionSubtract());
        this.elementTypes.put("multiply", new ActionMultiply());
        this.elementTypes.put("divide", new ActionDivide());
        this.elementTypes.put("equals", new ActionEquals());
        this.elementTypes.put("less-than", new ActionLessThan());
        this.elementTypes.put("and", new ActionAnd());
        this.elementTypes.put("or", new ActionOr());
        this.elementTypes.put("not", new ActionNot());
        this.elementTypes.put("string-equals", new ActionStringEquals());
        this.elementTypes.put("string-length", new ActionStringLength());
        this.elementTypes.put("concat", new ActionConcat());
        this.elementTypes.put("substring", new ActionSubstring());
        this.elementTypes.put("string-less-than", new ActionStringLessThan());
        this.elementTypes.put("mutlibyte-string-length", new ActionMutlibyteStringLength());
        this.elementTypes.put("multibyte-substring", new ActionMultibyteSubstring());
        this.elementTypes.put("to-integer", new ActionToInteger());
        this.elementTypes.put("char-to-ascii", new ActionCharToAscii());
        this.elementTypes.put("ascii-to-char", new ActionAsciiToChar());
        this.elementTypes.put("mutlibyte-char-to-ascii", new ActionMutlibyteCharToAscii());
        this.elementTypes.put("ascii-to-multibyte-char", new ActionAsciiToMultibyteChar());
        this.elementTypes.put("jump", new ActionJump());
        this.elementTypes.put("if", new ActionIf());
        this.elementTypes.put("call", new ActionCall());
        this.elementTypes.put("get-variable", new ActionGetVariable());
        this.elementTypes.put("set-variable", new ActionSetVariable());
        this.elementTypes.put("set-target", new ActionSetTarget());
        this.elementTypes.put("get-property", new ActionGetProperty());
        this.elementTypes.put("set-property", new ActionSetProperty());
        this.elementTypes.put("clone-sprite", new ActionCloneSprite());
        this.elementTypes.put("remove-sprite", new ActionRemoveSprite());
        this.elementTypes.put("start-drag", new ActionStartDrag());
        this.elementTypes.put("end-drag", new ActionEndDrag());
        this.elementTypes.put("wait-for-frame", new ActionWaitForFrame());
        this.elementTypes.put("trace", new ActionTrace());
        this.elementTypes.put("get-time", new ActionGetTime());
        this.elementTypes.put("random-number", new ActionRandomNumber());
        this.elementTypes.put("call-function", new ActionCallFunction());
        this.elementTypes.put("call-method", new ActionCallMethod());
        this.elementTypes.put("lookup-table", new ActionLookupTable());
        this.elementTypes.put("function", new ActionFunction());
        this.elementTypes.put("define-local-value", new ActionDefineLocalValue());
        this.elementTypes.put("define-local", new ActionDefineLocal());
        this.elementTypes.put("delete-property", new ActionDeleteProperty());
        this.elementTypes.put("delete-thread-vars", new ActionDeleteThreadVars());
        this.elementTypes.put("enumerate", new ActionEnumerate());
        this.elementTypes.put("typed-equals", new ActionTypedEquals());
        this.elementTypes.put("get-member", new ActionGetMember());
        this.elementTypes.put("init-array", new ActionInitArray());
        this.elementTypes.put("init-object", new ActionInitObject());
        this.elementTypes.put("new-method", new ActionNewMethod());
        this.elementTypes.put("new-object", new ActionNewObject());
        this.elementTypes.put("set-member", new ActionSetMember());
        this.elementTypes.put("get-target-path", new ActionGetTargetPath());
        this.elementTypes.put("with", new ActionWith());
        this.elementTypes.put("to-number", new ActionToNumber());
        this.elementTypes.put("to-string", new ActionToString());
        this.elementTypes.put("type-of", new ActionTypeOf());
        this.elementTypes.put("typed-add", new ActionTypedAdd());
        this.elementTypes.put("typed-less-than", new ActionTypedLessThan());
        this.elementTypes.put("modulo", new ActionModulo());
        this.elementTypes.put("bit-and", new ActionBitAnd());
        this.elementTypes.put("bit-or", new ActionBitOr());
        this.elementTypes.put("bit-xor", new ActionBitXor());
        this.elementTypes.put("shift-left", new ActionShiftLeft());
        this.elementTypes.put("shift-right", new ActionShiftRight());
        this.elementTypes.put("shift-right-unsigned", new ActionShiftRightUnsigned());
        this.elementTypes.put("decrement", new ActionDecrement());
        this.elementTypes.put("increment", new ActionIncrement());
        this.elementTypes.put("duplicate", new ActionDuplicate());
        this.elementTypes.put("return", new ActionReturn());
        this.elementTypes.put("swap", new ActionSwap());
        this.elementTypes.put("store", new ActionStore());
        this.elementTypes.put("value", new LookupValue());
    }

    protected void flushChars() throws Exception {
        if (this.chars.isEmpty()) {
            return;
        }
        int[] indices = new int[this.chars.size()];
        int[] advances = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            int[] ii = (int[])this.chars.get(i);
            indices[i] = ii[0];
            advances[i] = ii[1];
        }
        this.text.text(indices, advances);
        this.chars.clear();
    }

    protected class ActionFunction
    extends SaxHandlerBase.ElementType {
        protected ActionFunction() {
        }

        public void startElement(Attributes atts) throws Exception {
            String name = SaxHandlerBase.getAttr(atts, "name", "");
            String parms = SaxHandlerBase.getAttr(atts, "params", "");
            StringTokenizer tok = new StringTokenizer(parms);
            Vector<String> p = new Vector<String>();
            while (tok.hasMoreTokens()) {
                p.add(tok.nextToken());
            }
            Object[] params = new String[p.size()];
            p.copyInto(params);
            SWFSaxWriter.this.actions.startFunction(name, (String[])params);
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.actions.endBlock();
        }
    }

    protected class ActionWith
    extends SaxHandlerBase.ElementType {
        protected ActionWith() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.startWith();
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.actions.endBlock();
        }
    }

    protected class ActionStore
    extends SaxHandlerBase.ElementType {
        protected ActionStore() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.storeInRegister(SaxHandlerBase.getAttrInt(atts, "register", 0));
        }
    }

    protected class ActionIf
    extends SaxHandlerBase.ElementType {
        protected ActionIf() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.ifJump(SaxHandlerBase.getAttr(atts, "jump-label", ""));
        }
    }

    protected class ActionJump
    extends SaxHandlerBase.ElementType {
        protected ActionJump() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.jump(SaxHandlerBase.getAttr(atts, "jump-label", ""));
        }
    }

    protected class LookupValue
    extends SaxHandlerBase.ContentElementType {
        protected LookupValue() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.lookupValues.add(this.buff.toString());
        }
    }

    protected class ActionLookupTable
    extends SaxHandlerBase.ElementType {
        protected ActionLookupTable() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.lookupValues.clear();
        }

        public void endElement() throws Exception {
            Object[] values = new String[SWFSaxWriter.this.lookupValues.size()];
            SWFSaxWriter.this.lookupValues.copyInto(values);
            SWFSaxWriter.this.lookupValues.clear();
            SWFSaxWriter.this.actions.lookupTable((String[])values);
        }
    }

    protected class ActionSwap
    extends SaxHandlerBase.ElementType {
        protected ActionSwap() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.swap();
        }
    }

    protected class ActionReturn
    extends SaxHandlerBase.ElementType {
        protected ActionReturn() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.returnValue();
        }
    }

    protected class ActionDuplicate
    extends SaxHandlerBase.ElementType {
        protected ActionDuplicate() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.duplicate();
        }
    }

    protected class ActionIncrement
    extends SaxHandlerBase.ElementType {
        protected ActionIncrement() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.increment();
        }
    }

    protected class ActionDecrement
    extends SaxHandlerBase.ElementType {
        protected ActionDecrement() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.decrement();
        }
    }

    protected class ActionShiftRightUnsigned
    extends SaxHandlerBase.ElementType {
        protected ActionShiftRightUnsigned() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.shiftRightUnsigned();
        }
    }

    protected class ActionShiftRight
    extends SaxHandlerBase.ElementType {
        protected ActionShiftRight() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.shiftRight();
        }
    }

    protected class ActionShiftLeft
    extends SaxHandlerBase.ElementType {
        protected ActionShiftLeft() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.shiftLeft();
        }
    }

    protected class ActionBitXor
    extends SaxHandlerBase.ElementType {
        protected ActionBitXor() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.bitXor();
        }
    }

    protected class ActionBitOr
    extends SaxHandlerBase.ElementType {
        protected ActionBitOr() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.bitOr();
        }
    }

    protected class ActionBitAnd
    extends SaxHandlerBase.ElementType {
        protected ActionBitAnd() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.bitAnd();
        }
    }

    protected class ActionModulo
    extends SaxHandlerBase.ElementType {
        protected ActionModulo() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.modulo();
        }
    }

    protected class ActionTypedLessThan
    extends SaxHandlerBase.ElementType {
        protected ActionTypedLessThan() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.typedLessThan();
        }
    }

    protected class ActionTypedAdd
    extends SaxHandlerBase.ElementType {
        protected ActionTypedAdd() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.typedAdd();
        }
    }

    protected class ActionTypeOf
    extends SaxHandlerBase.ElementType {
        protected ActionTypeOf() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.typeOf();
        }
    }

    protected class ActionToString
    extends SaxHandlerBase.ElementType {
        protected ActionToString() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.convertToString();
        }
    }

    protected class ActionToNumber
    extends SaxHandlerBase.ElementType {
        protected ActionToNumber() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.convertToNumber();
        }
    }

    protected class ActionGetTargetPath
    extends SaxHandlerBase.ElementType {
        protected ActionGetTargetPath() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.getTargetPath();
        }
    }

    protected class ActionSetMember
    extends SaxHandlerBase.ElementType {
        protected ActionSetMember() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.setMember();
        }
    }

    protected class ActionNewObject
    extends SaxHandlerBase.ElementType {
        protected ActionNewObject() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.newObject();
        }
    }

    protected class ActionNewMethod
    extends SaxHandlerBase.ElementType {
        protected ActionNewMethod() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.newMethod();
        }
    }

    protected class ActionInitObject
    extends SaxHandlerBase.ElementType {
        protected ActionInitObject() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.initObject();
        }
    }

    protected class ActionInitArray
    extends SaxHandlerBase.ElementType {
        protected ActionInitArray() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.initArray();
        }
    }

    protected class ActionGetMember
    extends SaxHandlerBase.ElementType {
        protected ActionGetMember() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.getMember();
        }
    }

    protected class ActionTypedEquals
    extends SaxHandlerBase.ElementType {
        protected ActionTypedEquals() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.typedEquals();
        }
    }

    protected class ActionEnumerate
    extends SaxHandlerBase.ElementType {
        protected ActionEnumerate() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.enumerate();
        }
    }

    protected class ActionDeleteThreadVars
    extends SaxHandlerBase.ElementType {
        protected ActionDeleteThreadVars() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.deleteThreadVars();
        }
    }

    protected class ActionDeleteProperty
    extends SaxHandlerBase.ElementType {
        protected ActionDeleteProperty() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.deleteProperty();
        }
    }

    protected class ActionDefineLocal
    extends SaxHandlerBase.ElementType {
        protected ActionDefineLocal() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.defineLocal();
        }
    }

    protected class ActionDefineLocalValue
    extends SaxHandlerBase.ElementType {
        protected ActionDefineLocalValue() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.defineLocalValue();
        }
    }

    protected class ActionCallMethod
    extends SaxHandlerBase.ElementType {
        protected ActionCallMethod() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.callMethod();
        }
    }

    protected class ActionCallFunction
    extends SaxHandlerBase.ElementType {
        protected ActionCallFunction() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.callFunction();
        }
    }

    protected class ActionRandomNumber
    extends SaxHandlerBase.ElementType {
        protected ActionRandomNumber() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.randomNumber();
        }
    }

    protected class ActionGetTime
    extends SaxHandlerBase.ElementType {
        protected ActionGetTime() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.getTime();
        }
    }

    protected class ActionTrace
    extends SaxHandlerBase.ElementType {
        protected ActionTrace() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.trace();
        }
    }

    protected class ActionEndDrag
    extends SaxHandlerBase.ElementType {
        protected ActionEndDrag() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.endDrag();
        }
    }

    protected class ActionStartDrag
    extends SaxHandlerBase.ElementType {
        protected ActionStartDrag() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.startDrag();
        }
    }

    protected class ActionRemoveSprite
    extends SaxHandlerBase.ElementType {
        protected ActionRemoveSprite() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.removeSprite();
        }
    }

    protected class ActionCloneSprite
    extends SaxHandlerBase.ElementType {
        protected ActionCloneSprite() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.cloneSprite();
        }
    }

    protected class ActionSetProperty
    extends SaxHandlerBase.ElementType {
        protected ActionSetProperty() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.setProperty();
        }
    }

    protected class ActionGetProperty
    extends SaxHandlerBase.ElementType {
        protected ActionGetProperty() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.getProperty();
        }
    }

    protected class ActionSetVariable
    extends SaxHandlerBase.ElementType {
        protected ActionSetVariable() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.setVariable();
        }
    }

    protected class ActionGetVariable
    extends SaxHandlerBase.ElementType {
        protected ActionGetVariable() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.getVariable();
        }
    }

    protected class ActionCall
    extends SaxHandlerBase.ElementType {
        protected ActionCall() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.call();
        }
    }

    protected class ActionAsciiToMultibyteChar
    extends SaxHandlerBase.ElementType {
        protected ActionAsciiToMultibyteChar() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.asciiToCharMB();
        }
    }

    protected class ActionMutlibyteCharToAscii
    extends SaxHandlerBase.ElementType {
        protected ActionMutlibyteCharToAscii() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.charMBToAscii();
        }
    }

    protected class ActionAsciiToChar
    extends SaxHandlerBase.ElementType {
        protected ActionAsciiToChar() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.asciiToChar();
        }
    }

    protected class ActionCharToAscii
    extends SaxHandlerBase.ElementType {
        protected ActionCharToAscii() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.charToAscii();
        }
    }

    protected class ActionToInteger
    extends SaxHandlerBase.ElementType {
        protected ActionToInteger() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.toInteger();
        }
    }

    protected class ActionMultibyteSubstring
    extends SaxHandlerBase.ElementType {
        protected ActionMultibyteSubstring() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.substringMB();
        }
    }

    protected class ActionMutlibyteStringLength
    extends SaxHandlerBase.ElementType {
        protected ActionMutlibyteStringLength() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.stringLengthMB();
        }
    }

    protected class ActionStringLessThan
    extends SaxHandlerBase.ElementType {
        protected ActionStringLessThan() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.stringLessThan();
        }
    }

    protected class ActionSubstring
    extends SaxHandlerBase.ElementType {
        protected ActionSubstring() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.substring();
        }
    }

    protected class ActionConcat
    extends SaxHandlerBase.ElementType {
        protected ActionConcat() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.concat();
        }
    }

    protected class ActionStringLength
    extends SaxHandlerBase.ElementType {
        protected ActionStringLength() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.stringLength();
        }
    }

    protected class ActionStringEquals
    extends SaxHandlerBase.ElementType {
        protected ActionStringEquals() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.stringEquals();
        }
    }

    protected class ActionNot
    extends SaxHandlerBase.ElementType {
        protected ActionNot() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.not();
        }
    }

    protected class ActionOr
    extends SaxHandlerBase.ElementType {
        protected ActionOr() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.or();
        }
    }

    protected class ActionAnd
    extends SaxHandlerBase.ElementType {
        protected ActionAnd() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.and();
        }
    }

    protected class ActionLessThan
    extends SaxHandlerBase.ElementType {
        protected ActionLessThan() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.lessThan();
        }
    }

    protected class ActionEquals
    extends SaxHandlerBase.ElementType {
        protected ActionEquals() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.equals();
        }
    }

    protected class ActionDivide
    extends SaxHandlerBase.ElementType {
        protected ActionDivide() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.divide();
        }
    }

    protected class ActionMultiply
    extends SaxHandlerBase.ElementType {
        protected ActionMultiply() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.multiply();
        }
    }

    protected class ActionSubtract
    extends SaxHandlerBase.ElementType {
        protected ActionSubtract() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.substract();
        }
    }

    protected class ActionAdd
    extends SaxHandlerBase.ElementType {
        protected ActionAdd() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.add();
        }
    }

    protected class ActionPop
    extends SaxHandlerBase.ElementType {
        protected ActionPop() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.pop();
        }
    }

    protected class ActionPush
    extends SaxHandlerBase.ElementType {
        protected ActionPush() {
        }

        public void startElement(Attributes atts) throws Exception {
            String value = atts.getValue("", "string");
            if (value != null) {
                SWFSaxWriter.this.actions.push(value);
                return;
            }
            value = atts.getValue("", "float");
            if (value != null) {
                SWFSaxWriter.this.actions.push(Float.parseFloat(value));
                return;
            }
            value = atts.getValue("", "double");
            if (value != null) {
                SWFSaxWriter.this.actions.push(Double.parseDouble(value));
                return;
            }
            value = atts.getValue("", "register");
            if (value != null) {
                SWFSaxWriter.this.actions.pushRegister(Integer.parseInt(value));
                return;
            }
            value = atts.getValue("", "boolean");
            if (value != null) {
                SWFSaxWriter.this.actions.push(value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true"));
                return;
            }
            value = atts.getValue("", "int");
            if (value != null) {
                SWFSaxWriter.this.actions.push(Integer.parseInt(value));
                return;
            }
            value = atts.getValue("", "lookup");
            if (value != null) {
                SWFSaxWriter.this.actions.lookup(Integer.parseInt(value));
                return;
            }
            SWFSaxWriter.this.actions.pushNull();
        }
    }

    protected class ActionSetTarget
    extends SaxHandlerBase.ElementType {
        protected ActionSetTarget() {
        }

        public void startElement(Attributes atts) throws Exception {
            String target = atts.getValue("", "target");
            if (target != null) {
                SWFSaxWriter.this.actions.setTarget(target);
            } else {
                SWFSaxWriter.this.actions.setTarget();
            }
        }
    }

    protected class ActionWaitForFrame
    extends SaxHandlerBase.ElementType {
        protected ActionWaitForFrame() {
        }

        public void startElement(Attributes atts) throws Exception {
            int number = SaxHandlerBase.getAttrInt(atts, "number", -1);
            String jumpLabel = SaxHandlerBase.getAttr(atts, "jump-label", "");
            if (number >= 0) {
                SWFSaxWriter.this.actions.waitForFrame(number, jumpLabel);
            } else {
                SWFSaxWriter.this.actions.waitForFrame(jumpLabel);
            }
        }
    }

    protected class ActionStopSounds
    extends SaxHandlerBase.ElementType {
        protected ActionStopSounds() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.stopSounds();
        }
    }

    protected class ActionToggleQuality
    extends SaxHandlerBase.ElementType {
        protected ActionToggleQuality() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.toggleQuality();
        }
    }

    protected class ActionStop
    extends SaxHandlerBase.ElementType {
        protected ActionStop() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.stop();
        }
    }

    protected class ActionPlay
    extends SaxHandlerBase.ElementType {
        protected ActionPlay() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.play();
        }
    }

    protected class ActionPrevFrame
    extends SaxHandlerBase.ElementType {
        protected ActionPrevFrame() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.prevFrame();
        }
    }

    protected class ActionNextFrame
    extends SaxHandlerBase.ElementType {
        protected ActionNextFrame() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.nextFrame();
        }
    }

    protected class ActionGetUrl
    extends SaxHandlerBase.ElementType {
        protected ActionGetUrl() {
        }

        public void startElement(Attributes atts) throws Exception {
            String url = atts.getValue("", "url");
            String target = atts.getValue("", "target");
            if (url != null || target != null) {
                if (url == null) {
                    url = "";
                }
                if (target == null) {
                    target = "";
                }
                SWFSaxWriter.this.actions.getURL(url, target);
                return;
            }
            String sendVars = SaxHandlerBase.getAttr(atts, "send-vars", "none");
            boolean targetSprite = SaxHandlerBase.getAttrBool(atts, "target-sprite", false);
            String loadVars = atts.getValue("", "load-vars-into");
            int send = 2;
            if (sendVars.equalsIgnoreCase("post")) {
                send = 2;
            } else if (sendVars.equalsIgnoreCase("get")) {
                send = 1;
            }
            int load = 0;
            if (loadVars != null) {
                load = 3;
                if (loadVars.equalsIgnoreCase("sprite")) {
                    load = 4;
                }
            } else {
                load = targetSprite ? 1 : 0;
            }
            SWFSaxWriter.this.actions.getURL(send, load);
        }
    }

    protected class ActionGotoFrame
    extends SaxHandlerBase.ContentElementType {
        protected ActionGotoFrame() {
        }

        public void endElement() throws Exception {
            String label = this.attrs.getValue("", "label");
            if (label != null) {
                SWFSaxWriter.this.actions.gotoFrame(label);
                return;
            }
            int number = SaxHandlerBase.getAttrInt(this.attrs, "number", -1);
            if (number >= 0) {
                SWFSaxWriter.this.actions.gotoFrame(number);
                return;
            }
            boolean play = SaxHandlerBase.getAttrBool(this.attrs, "play", true);
            SWFSaxWriter.this.actions.gotoFrame(play);
        }
    }

    protected class ActionComment
    extends SaxHandlerBase.ContentElementType {
        protected ActionComment() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.actions.comment(this.buff.toString());
            this.buff = null;
        }
    }

    protected class ActionJumpLabel
    extends SaxHandlerBase.ElementType {
        protected ActionJumpLabel() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.actions.jumpLabel(SaxHandlerBase.getAttr(atts, "label", ""));
        }
    }

    protected class ActionUnknown
    extends SaxHandlerBase.ContentElementType {
        protected ActionUnknown() {
        }

        public void endElement() throws Exception {
            int code = SaxHandlerBase.getAttrInt(this.attrs, "code", 0);
            byte[] data = Base64.decode(this.buff.toString());
            this.buff = null;
            SWFSaxWriter.this.actions.unknown(code, data);
        }
    }

    protected class Actions
    extends SaxHandlerBase.ElementType {
        protected Actions() {
        }

        public void startElement(Attributes atts) throws Exception {
            if (SWFSaxWriter.this.actionMode == 0) {
                SWFSaxWriter.this.actions = SWFSaxWriter.this.tags.tagDoAction();
            }
            int actionFlags = 0;
            if (SWFSaxWriter.this.actionMode == 1) {
                String flags = SaxHandlerBase.getAttr(atts, "conditions", "release");
                StringTokenizer tok = new StringTokenizer(flags);
                while (tok.hasMoreTokens()) {
                    String f = tok.nextToken();
                    if (f.equals("menu-drag-out")) {
                        actionFlags |= 0x100;
                        continue;
                    }
                    if (f.equals("menu-drag-over")) {
                        actionFlags |= 0x80;
                        continue;
                    }
                    if (f.equals("release-outside")) {
                        actionFlags |= 0x40;
                        continue;
                    }
                    if (f.equals("drag-over")) {
                        actionFlags |= 0x20;
                        continue;
                    }
                    if (f.equals("drag-out")) {
                        actionFlags |= 0x10;
                        continue;
                    }
                    if (f.equals("release")) {
                        actionFlags |= 8;
                        continue;
                    }
                    if (f.equals("press")) {
                        actionFlags |= 4;
                        continue;
                    }
                    if (f.equals("roll-out")) {
                        actionFlags |= 2;
                        continue;
                    }
                    if (!f.equals("roll-over")) continue;
                    actionFlags |= 1;
                }
                int charCode = SaxHandlerBase.getAttrInt(atts, "char-code", 0);
                if (charCode > 0) {
                    actionFlags |= charCode << 9 & 0xFE00;
                }
            } else if (SWFSaxWriter.this.actionMode == 2) {
                String flags = SaxHandlerBase.getAttr(atts, "conditions", "");
                StringTokenizer tok = new StringTokenizer(flags);
                while (tok.hasMoreTokens()) {
                    String f = tok.nextToken();
                    if (f.equals("load")) {
                        actionFlags |= 1;
                        continue;
                    }
                    if (f.equals("enter-frame")) {
                        actionFlags |= 2;
                        continue;
                    }
                    if (f.equals("unload")) {
                        actionFlags |= 4;
                        continue;
                    }
                    if (f.equals("mouse-move")) {
                        actionFlags |= 8;
                        continue;
                    }
                    if (f.equals("mouse-down")) {
                        actionFlags |= 0x10;
                        continue;
                    }
                    if (f.equals("mouse-up")) {
                        actionFlags |= 0x20;
                        continue;
                    }
                    if (f.equals("key-down")) {
                        actionFlags |= 0x40;
                        continue;
                    }
                    if (f.equals("key-up")) {
                        actionFlags |= 0x80;
                        continue;
                    }
                    if (!f.equals("data")) continue;
                    actionFlags |= 0x100;
                }
            }
            SWFSaxWriter.this.actions.start(actionFlags);
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.actions.end();
            if (SWFSaxWriter.this.actionMode == 0) {
                SWFSaxWriter.this.actions.done();
            }
        }
    }

    protected class CXFormElem
    extends SaxHandlerBase.ElementType {
        protected CXFormElem() {
        }

        public void startElement(Attributes atts) throws Exception {
            int addRed = SaxHandlerBase.getAttrInt(atts, "add-red", 0);
            int addGreen = SaxHandlerBase.getAttrInt(atts, "add-green", 0);
            int addBlue = SaxHandlerBase.getAttrInt(atts, "add-blue", 0);
            int addAlpha = SaxHandlerBase.getAttrInt(atts, "add-alpha", 0);
            double multRed = SaxHandlerBase.getAttrDouble(atts, "mult-red", 1.0);
            double multGreen = SaxHandlerBase.getAttrDouble(atts, "mult-green", 1.0);
            double multBlue = SaxHandlerBase.getAttrDouble(atts, "mult-blue", 1.0);
            double multAlpha = SaxHandlerBase.getAttrDouble(atts, "mult-alpha", 1.0);
            SWFSaxWriter.this.cxform = new AlphaTransform(multRed, multGreen, multBlue, multAlpha, addRed, addGreen, addBlue, addAlpha);
        }
    }

    protected class MatrixElem
    extends SaxHandlerBase.ElementType {
        protected MatrixElem() {
        }

        public void startElement(Attributes atts) throws Exception {
            double skew0 = SaxHandlerBase.getAttrDouble(atts, "skew0", 0.0);
            double skew1 = SaxHandlerBase.getAttrDouble(atts, "skew1", 0.0);
            double scalex = SaxHandlerBase.getAttrDouble(atts, "scale-x", 1.0);
            double scaley = SaxHandlerBase.getAttrDouble(atts, "scale-y", 1.0);
            double x = SaxHandlerBase.getAttrDouble(atts, "x", 0.0);
            double y = SaxHandlerBase.getAttrDouble(atts, "y", 0.0);
            SWFSaxWriter.this.matrix = new Matrix(scalex, scaley, skew0, skew1, x * (double)20, y * (double)20);
        }
    }

    protected class ColorElem
    extends SaxHandlerBase.ElementType {
        protected ColorElem() {
        }

        public void startElement(Attributes atts) throws Exception {
            int red = SaxHandlerBase.getAttrInt(atts, "red", 0);
            int green = SaxHandlerBase.getAttrInt(atts, "green", 0);
            int blue = SaxHandlerBase.getAttrInt(atts, "blue", 0);
            int alpha = SaxHandlerBase.getAttrInt(atts, "alpha", 255);
            SWFSaxWriter.this.color = alpha != 255 ? new AlphaColor(red, green, blue, alpha) : new Color(red, green, blue);
            if (SWFSaxWriter.this.bitmapColors != null) {
                SWFSaxWriter.this.bitmapColors.add(SWFSaxWriter.this.color);
                SWFSaxWriter.this.color = null;
            }
            if (SWFSaxWriter.this.text != null) {
                SWFSaxWriter.this.flushChars();
                SWFSaxWriter.this.text.color(SWFSaxWriter.this.color);
                SWFSaxWriter.this.color = null;
            }
        }
    }

    protected class QTMovie
    extends SaxHandlerBase.ElementType {
        protected QTMovie() {
        }

        public void startElement(Attributes atts) throws Exception {
            int id = SWFSaxWriter.this.newId(atts.getValue("", "id"));
            String name = atts.getValue("", "name");
            if (name == null) {
                throw new SAXException("Missing name for QuickTime movie");
            }
            if (id < 1) {
                throw new SAXException("Invalid id for QuickTime movie");
            }
            SWFSaxWriter.this.tags.tagDefineQuickTimeMovie(id, name);
        }
    }

    protected class Char
    extends SaxHandlerBase.ElementType {
        protected Char() {
        }

        public void startElement(Attributes atts) throws Exception {
            double adv = SaxHandlerBase.getAttrDouble(atts, "advance", 0.0);
            int idx = SaxHandlerBase.getAttrInt(atts, "glyph-index", 0);
            SWFSaxWriter.this.chars.add(new int[]{idx, (int)(adv * (double)20)});
        }
    }

    protected class SetY
    extends SaxHandlerBase.ElementType {
        protected SetY() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.flushChars();
            double y = SaxHandlerBase.getAttrDouble(atts, "y", 0.0);
            SWFSaxWriter.this.text.setY((int)(y * (double)20));
        }
    }

    protected class SetX
    extends SaxHandlerBase.ElementType {
        protected SetX() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.flushChars();
            double x = SaxHandlerBase.getAttrDouble(atts, "x", 0.0);
            SWFSaxWriter.this.text.setX((int)(x * (double)20));
        }
    }

    protected class SetFont
    extends SaxHandlerBase.ElementType {
        protected SetFont() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.flushChars();
            int id = SWFSaxWriter.this.getId(atts.getValue("", "id"));
            double size = SaxHandlerBase.getAttrDouble(atts, "size", 0.0);
            if (id < 1) {
                throw new SAXException("Invalid id for font in text");
            }
            SWFSaxWriter.this.text.font(id, (int)(size * (double)20));
        }
    }

    protected class Text
    extends SaxHandlerBase.GatheringElementType {
        protected Text() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.startGatherMode(this);
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            boolean hasAlpha = SaxHandlerBase.getAttrBool(this.attrs, "has-alpha", false);
            double minx = SaxHandlerBase.getAttrDouble(this.attrs, "min-x", 0.0);
            double miny = SaxHandlerBase.getAttrDouble(this.attrs, "min-y", 0.0);
            double maxx = SaxHandlerBase.getAttrDouble(this.attrs, "max-x", 0.0);
            double maxy = SaxHandlerBase.getAttrDouble(this.attrs, "max-y", 0.0);
            Rect rect = new Rect((int)(minx * (double)20), (int)(miny * (double)20), (int)(maxx * (double)20), (int)(maxy * (double)20));
            SWFSaxWriter.this.dispatchGatheredElement("matrix");
            SWFSaxWriter.this.text = hasAlpha ? SWFSaxWriter.this.tags.tagDefineText2(id, rect, SWFSaxWriter.this.matrix) : SWFSaxWriter.this.tags.tagDefineText(id, rect, SWFSaxWriter.this.matrix);
            SWFSaxWriter.this.chars = new ArrayList();
            SWFSaxWriter.this.endGatherMode();
            SWFSaxWriter.this.flushChars();
            SWFSaxWriter.this.chars = null;
            SWFSaxWriter.this.text.done();
            SWFSaxWriter.this.text = null;
        }
    }

    protected class Code
    extends SaxHandlerBase.ElementType {
        protected Code() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.codes.add(new Integer(SaxHandlerBase.getAttrInt(atts, "code", 0)));
        }
    }

    protected class FontInfo
    extends SaxHandlerBase.ContentElementType {
        protected FontInfo() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.codes = new ArrayList();
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.getId(this.attrs.getValue("", "id"));
            String fs = this.attrs.getValue("", "flags");
            String name = this.attrs.getValue("", "name");
            if (name == null) {
                throw new SAXException("Missing name in font-info");
            }
            if (fs == null) {
                fs = "";
            }
            int flags = 0;
            StringTokenizer tok = new StringTokenizer(fs);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                if (s.equalsIgnoreCase("unicode")) {
                    flags += 32;
                    continue;
                }
                if (s.equalsIgnoreCase("shiftjis")) {
                    flags += 16;
                    continue;
                }
                if (s.equalsIgnoreCase("ansi")) {
                    flags += 8;
                    continue;
                }
                if (s.equalsIgnoreCase("italic")) {
                    flags += 4;
                    continue;
                }
                if (!s.equalsIgnoreCase("bold")) continue;
                flags += 2;
            }
            int[] codesA = new int[SWFSaxWriter.this.codes.size()];
            for (int i = 0; i < codesA.length; ++i) {
                codesA[i] = (Integer)SWFSaxWriter.this.codes.get(i);
            }
            SWFSaxWriter.this.codes = null;
            SWFSaxWriter.this.tags.tagDefineFontInfo(id, name, flags, codesA);
        }
    }

    protected class Anticlockwise
    extends SaxHandlerBase.ElementType {
        protected Anticlockwise() {
        }

        public void endElement() throws Exception {
            SWFShape shape;
            SWFShape sWFShape = shape = SWFSaxWriter.this.vectors instanceof SWFShape ? (SWFShape)SWFSaxWriter.this.vectors : null;
            if (shape != null) {
                shape.setFillStyle0(1);
            }
        }
    }

    protected class Glyph
    extends SaxHandlerBase.ElementType {
        protected Glyph() {
        }

        public void startElement(Attributes atts) throws Exception {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.vectors.done();
        }
    }

    protected class EditFont
    extends SaxHandlerBase.GatheringElementType {
        protected int glyphCount;
        protected ArrayList codes = new ArrayList();
        protected ArrayList advances = new ArrayList();
        protected ArrayList bounds = new ArrayList();
        protected ArrayList kerns = new ArrayList();
        protected boolean hasLayout;

        protected EditFont() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            this.codes.clear();
            this.advances.clear();
            this.bounds.clear();
            this.kerns.clear();
            this.hasLayout = false;
            this.glyphCount = 0;
            SWFSaxWriter.this.startGatherMode(this);
        }

        public boolean gatherElement(String localName, Attributes atts) {
            if (localName.equals("glyph")) {
                ++this.glyphCount;
                double minx = SaxHandlerBase.getAttrDouble(atts, "min-x", 0.0);
                double miny = SaxHandlerBase.getAttrDouble(atts, "min-y", 0.0);
                double maxx = SaxHandlerBase.getAttrDouble(atts, "max-x", 0.0);
                double maxy = SaxHandlerBase.getAttrDouble(atts, "max-y", 0.0);
                Rect rect = new Rect((int)(minx * (double)20), (int)(miny * (double)20), (int)(maxx * (double)20), (int)(maxy * (double)20));
                this.bounds.add(rect);
                int code = SaxHandlerBase.getAttrInt(atts, "code", 0);
                int advance = (int)(SaxHandlerBase.getAttrDouble(atts, "advance", 0.0) * (double)20);
                if (code > 0 && advance != 0) {
                    this.hasLayout = true;
                }
                this.codes.add(new Integer(code));
                this.advances.add(new Integer(advance));
            } else if (localName.equals("kerning")) {
                this.hasLayout = true;
                int[] info = new int[]{SaxHandlerBase.getAttrInt(atts, "code-1", 0), SaxHandlerBase.getAttrInt(atts, "code-2", 0), (int)(SaxHandlerBase.getAttrDouble(atts, "offset", 0.0) * (double)20)};
                this.kerns.add(info);
                return false;
            }
            return true;
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            int flags = 0;
            String f = SaxHandlerBase.getAttr(this.attrs, "flags", "");
            StringTokenizer tok = new StringTokenizer(f);
            while (tok.hasMoreTokens()) {
                String t = tok.nextToken();
                if (t.equals("unicode")) {
                    flags |= 0x20;
                }
                if (t.equals("shiftjis")) {
                    flags |= 0x40;
                }
                if (t.equals("ansi")) {
                    flags |= 0x10;
                }
                if (t.equals("italic")) {
                    flags |= 2;
                }
                if (!t.equals("bold")) continue;
                flags |= 1;
            }
            String name = SaxHandlerBase.getAttr(this.attrs, "name", "unknown");
            int ascent = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "ascent", 0.0) * (double)20);
            int descent = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "descent", 0.0) * (double)20);
            int leading = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "leading", 0.0) * (double)20);
            int[] advancesA = new int[this.glyphCount];
            int[] codesA = new int[this.glyphCount];
            Rect[] boundsA = new Rect[this.glyphCount];
            for (int i = 0; i < this.glyphCount; ++i) {
                advancesA[i] = (Integer)this.advances.get(i);
                codesA[i] = (Integer)this.codes.get(i);
                boundsA[i] = (Rect)this.bounds.get(i);
            }
            int[] kern1 = new int[this.kerns.size()];
            int[] kern2 = new int[this.kerns.size()];
            int[] kernA = new int[this.kerns.size()];
            for (int i = 0; i < kern1.length; ++i) {
                int[] info = (int[])this.kerns.get(i);
                kern1[i] = info[0];
                kern2[i] = info[1];
                kernA[i] = info[2];
            }
            if (ascent > 0 || descent > 0 || leading > 0 || this.hasLayout) {
                flags |= 0x80;
            }
            SWFSaxWriter.this.vectors = SWFSaxWriter.this.tags.tagDefineFont2(id, flags, name, this.glyphCount, ascent, descent, leading, codesA, advancesA, boundsA, kern1, kern2, kernA);
            SWFSaxWriter.this.endGatherMode();
            if (this.glyphCount == 0) {
                SWFSaxWriter.this.vectors.done();
            }
            SWFSaxWriter.this.vectors = null;
        }
    }

    protected class Morph
    extends SaxHandlerBase.GatheringElementType {
        protected Rect startBounds;
        protected Rect endBounds;

        protected Morph() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            this.startBounds = null;
            this.endBounds = null;
            SWFSaxWriter.this.startGatherMode(this);
        }

        public boolean gatherElement(String localName, Attributes atts) {
            if (localName.equals("shape")) {
                double minx = SaxHandlerBase.getAttrDouble(atts, "min-x", 0.0);
                double miny = SaxHandlerBase.getAttrDouble(atts, "min-y", 0.0);
                double maxx = SaxHandlerBase.getAttrDouble(atts, "max-x", 0.0);
                double maxy = SaxHandlerBase.getAttrDouble(atts, "max-y", 0.0);
                Rect rect = new Rect((int)(minx * (double)20), (int)(miny * (double)20), (int)(maxx * (double)20), (int)(maxy * (double)20));
                if (this.startBounds == null) {
                    this.startBounds = rect;
                } else {
                    this.endBounds = rect;
                }
            }
            return true;
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            SWFSaxWriter.this.shape = SWFSaxWriter.this.tags.tagDefineMorphShape(id, this.startBounds, this.endBounds);
            SWFSaxWriter.this.vectors = SWFSaxWriter.this.shape;
            SWFSaxWriter.this.endGatherMode();
            SWFSaxWriter.this.shape = null;
            SWFSaxWriter.this.vectors = null;
        }
    }

    protected class Layer
    extends SaxHandlerBase.ContentElementType {
        protected Layer() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.cxform = null;
            SWFSaxWriter.this.matrix = null;
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.getId(this.attrs.getValue("", "id"));
            int depth = SaxHandlerBase.getAttrInt(this.attrs, "depth", 1);
            String fors = SaxHandlerBase.getAttr(this.attrs, "for", "hit over up down");
            int flags = 0;
            StringTokenizer tok = new StringTokenizer(fors);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (token.equals("hit")) {
                    flags |= 8;
                    continue;
                }
                if (token.equals("over")) {
                    flags |= 2;
                    continue;
                }
                if (token.equals("up")) {
                    flags |= 1;
                    continue;
                }
                if (!token.equals("down")) continue;
                flags |= 4;
            }
            ButtonRecord2 rec = new ButtonRecord2(id, depth, SWFSaxWriter.this.matrix, SWFSaxWriter.this.cxform, flags);
            SWFSaxWriter.this.buttonRecords.add(rec);
        }
    }

    protected class Button
    extends SaxHandlerBase.GatheringElementType {
        protected Button() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.buttonRecords.clear();
            SWFSaxWriter.this.startGatherMode(this);
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            boolean menu = SaxHandlerBase.getAttrBool(this.attrs, "menu", false);
            SWFSaxWriter.this.dispatchAllMatchingGatheredElements("layer");
            SWFSaxWriter.this.actions = SWFSaxWriter.this.tags.tagDefineButton2(id, menu, SWFSaxWriter.this.buttonRecords);
            if (SWFSaxWriter.this.actions != null) {
                SWFSaxWriter.this.actionMode = 1;
                SWFSaxWriter.this.endGatherMode();
                SWFSaxWriter.this.actions.done();
                SWFSaxWriter.this.actionMode = 0;
            }
            SWFSaxWriter.this.buttonRecords.clear();
        }
    }

    protected class EditField
    extends SaxHandlerBase.ContentElementType {
        protected EditField() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.color = null;
        }

        public void endElement() throws Exception {
            int flags;
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            String name = SaxHandlerBase.getAttr(this.attrs, "name", "");
            String text = this.attrs.getValue("", "text");
            double minx = SaxHandlerBase.getAttrDouble(this.attrs, "min-x", 0.0);
            double miny = SaxHandlerBase.getAttrDouble(this.attrs, "min-y", 0.0);
            double maxx = SaxHandlerBase.getAttrDouble(this.attrs, "max-x", 0.0);
            double maxy = SaxHandlerBase.getAttrDouble(this.attrs, "max-y", 0.0);
            Rect rect = new Rect((int)(minx * (double)20), (int)(miny * (double)20), (int)(maxx * (double)20), (int)(maxy * (double)20));
            String align = SaxHandlerBase.getAttr(this.attrs, "align", "left").trim();
            int alignment = 0;
            if (align.equals("right")) {
                alignment = 1;
            }
            if (align.equals("center")) {
                alignment = 2;
            }
            if (align.equals("justify")) {
                alignment = 3;
            }
            int fontId = SWFSaxWriter.this.getId(this.attrs.getValue("", "font"));
            int fontSize = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "size", 12.0) * (double)20);
            int limit = SaxHandlerBase.getAttrInt(this.attrs, "limit", 0);
            int leftMargin = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "left-margin", 12.0) * (double)20);
            int rightMargin = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "right-margin", 12.0) * (double)20);
            int indentation = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "indentation", 12.0) * (double)20);
            int lineSpacing = (int)(SaxHandlerBase.getAttrDouble(this.attrs, "linespacing", 12.0) * (double)20);
            int n = flags = text != null ? 128 : 0;
            if (!SaxHandlerBase.getAttrBool(this.attrs, "selectable", true)) {
                flags |= 0x1000;
            }
            if (SaxHandlerBase.getAttrBool(this.attrs, "border", true)) {
                flags |= 0x800;
            }
            if (SaxHandlerBase.getAttrBool(this.attrs, "html", false)) {
                flags |= 0x200;
            }
            if (!SaxHandlerBase.getAttrBool(this.attrs, "system-font", false)) {
                flags |= 0x100;
            }
            if (SaxHandlerBase.getAttrBool(this.attrs, "wordwrap", false)) {
                flags |= 0x40;
            }
            if (SaxHandlerBase.getAttrBool(this.attrs, "multiline", false)) {
                flags |= 0x20;
            }
            if (SaxHandlerBase.getAttrBool(this.attrs, "password", false)) {
                flags |= 0x10;
            }
            if (SaxHandlerBase.getAttrBool(this.attrs, "read-only", false)) {
                flags |= 8;
            }
            if (SWFSaxWriter.this.color == null) {
                SWFSaxWriter.this.color = new AlphaColor(0, 0, 0, 0);
            } else if (!(SWFSaxWriter.this.color instanceof AlphaColor)) {
                SWFSaxWriter.this.color = new AlphaColor(SWFSaxWriter.this.color, 255);
            }
            SWFSaxWriter.this.tags.tagDefineTextField(id, name, text, rect, flags, (AlphaColor)SWFSaxWriter.this.color, alignment, fontId, fontSize, limit, leftMargin, rightMargin, indentation, lineSpacing);
        }
    }

    protected class TextFont
    extends SaxHandlerBase.GatheringElementType {
        protected int glyphCount;

        protected TextFont() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            this.glyphCount = 0;
            SWFSaxWriter.this.startGatherMode(this);
        }

        public boolean gatherElement(String localName, Attributes atts) {
            if (localName.equals("glyph")) {
                ++this.glyphCount;
            }
            return true;
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            SWFSaxWriter.this.vectors = SWFSaxWriter.this.tags.tagDefineFont(id, this.glyphCount);
            SWFSaxWriter.this.endGatherMode();
            SWFSaxWriter.this.vectors = null;
        }
    }

    protected class Symbol
    extends SaxHandlerBase.ElementType {
        protected Symbol() {
        }

        public void startElement(Attributes atts) throws Exception {
            int id = SWFSaxWriter.this.getOrAllocateId(atts.getValue("", "id"));
            String name = atts.getValue("", "name");
            if (name == null) {
                throw new SAXException("Missing name in import/export symbol");
            }
            if (id < 1) {
                throw new SAXException("Invalid id in import/export symbol");
            }
            if (SWFSaxWriter.this.symbols != null) {
                SWFSaxWriter.this.symbols.add(new Object[]{name, new Integer(id)});
            }
        }
    }

    protected class Export
    extends SaxHandlerBase.ElementType {
        protected Export() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.symbols = new ArrayList();
        }

        public void endElement() throws Exception {
            String[] names = new String[SWFSaxWriter.this.symbols.size()];
            int[] ids = new int[names.length];
            for (int i = 0; i < names.length; ++i) {
                Object[] sym = (Object[])SWFSaxWriter.this.symbols.get(i);
                names[i] = (String)sym[0];
                ids[i] = (Integer)sym[1];
            }
            SWFSaxWriter.this.tags.tagExport(names, ids);
            SWFSaxWriter.this.symbols = null;
        }
    }

    protected class Import
    extends SaxHandlerBase.ContentElementType {
        protected Import() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.symbols = new ArrayList();
        }

        public void endElement() throws Exception {
            String movie = this.attrs.getValue("", "movie");
            if (movie == null) {
                throw new SAXException("Missing movie name in import.");
            }
            String[] names = new String[SWFSaxWriter.this.symbols.size()];
            int[] ids = new int[names.length];
            for (int i = 0; i < names.length; ++i) {
                Object[] sym = (Object[])SWFSaxWriter.this.symbols.get(i);
                names[i] = (String)sym[0];
                ids[i] = (Integer)sym[1];
            }
            SWFSaxWriter.this.tags.tagImport(movie, names, ids);
            SWFSaxWriter.this.symbols = null;
        }
    }

    protected class Pixels
    extends SaxHandlerBase.ContentElementType {
        protected Pixels() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.pixelData = Base64.decode(this.buff.toString().trim());
        }
    }

    protected class Colors
    extends SaxHandlerBase.ElementType {
        protected Colors() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.bitmapColors = new ArrayList();
        }

        public void endElement() throws Exception {
        }
    }

    protected class Bitmap
    extends SaxHandlerBase.ContentElementType {
        protected Bitmap() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.bitmapColors = null;
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            boolean hasAlpha = SaxHandlerBase.getAttrBool(this.attrs, "has-alpha", false);
            int width = SaxHandlerBase.getAttrInt(this.attrs, "width", 0);
            int height = SaxHandlerBase.getAttrInt(this.attrs, "height", 0);
            int bits = SaxHandlerBase.getAttrInt(this.attrs, "bits", 32);
            int format = 5;
            if (bits == 8) {
                format = 3;
            }
            if (bits == 16) {
                format = 4;
            }
            Color[] colors = null;
            if (SWFSaxWriter.this.bitmapColors != null && !SWFSaxWriter.this.bitmapColors.isEmpty()) {
                colors = new Color[SWFSaxWriter.this.bitmapColors.size()];
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = (Color)SWFSaxWriter.this.bitmapColors.get(i);
                }
            } else if (format != 5) {
                colors = new Color[]{};
            }
            if (hasAlpha) {
                SWFSaxWriter.this.tags.tagDefineBitsLossless2(id, format, width, height, colors, SWFSaxWriter.this.pixelData);
            } else {
                SWFSaxWriter.this.tags.tagDefineBitsLossless(id, format, width, height, colors, SWFSaxWriter.this.pixelData);
            }
            SWFSaxWriter.this.bitmapColors = null;
            SWFSaxWriter.this.pixelData = null;
        }
    }

    protected class JPEGHeader
    extends SaxHandlerBase.ContentElementType {
        protected JPEGHeader() {
        }

        public void endElement() throws Exception {
            byte[] data = Base64.decode(this.buff.toString());
            SWFSaxWriter.this.tags.tagJPEGTables(data);
        }
    }

    protected class JPEGAlpha
    extends SaxHandlerBase.ContentElementType {
        protected JPEGAlpha() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.jpegAlpha = Base64.decode(this.buff.toString());
        }
    }

    protected class JPEGImage
    extends SaxHandlerBase.ContentElementType {
        protected JPEGImage() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.pixelData = Base64.decode(this.buff.toString());
        }
    }

    protected class Jpeg
    extends SaxHandlerBase.ContentElementType {
        protected Jpeg() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.pixelData = null;
            SWFSaxWriter.this.jpegAlpha = null;
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            String filename = this.attrs.getValue("", "file");
            boolean commonHeader = SaxHandlerBase.getAttrBool(this.attrs, "common-header", false);
            if (filename != null) {
                SWFSaxWriter.this.tags.tagDefineBitsJPEG2(id, new FileInputStream(filename));
                return;
            }
            if (SWFSaxWriter.this.jpegAlpha != null) {
                SWFSaxWriter.this.tags.tagDefineBitsJPEG3(id, SWFSaxWriter.this.pixelData, SWFSaxWriter.this.jpegAlpha);
            } else if (commonHeader) {
                SWFSaxWriter.this.tags.tagDefineBits(id, SWFSaxWriter.this.pixelData);
            } else {
                SWFSaxWriter.this.tags.tagDefineBitsJPEG2(id, SWFSaxWriter.this.pixelData);
            }
            SWFSaxWriter.this.pixelData = null;
            SWFSaxWriter.this.jpegAlpha = null;
        }
    }

    protected class Place
    extends SaxHandlerBase.GatheringElementType {
        protected int actionFlags;

        protected Place() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.matrix = null;
            SWFSaxWriter.this.cxform = null;
            this.actionFlags = 0;
            SWFSaxWriter.this.startGatherMode(this);
        }

        public boolean gatherElement(String localName, Attributes atts) {
            if (localName.equals("actions")) {
                String flags = SaxHandlerBase.getAttr(atts, "conditions", "");
                StringTokenizer tok = new StringTokenizer(flags);
                while (tok.hasMoreTokens()) {
                    String f = tok.nextToken();
                    if (f.equals("load")) {
                        this.actionFlags |= 1;
                        continue;
                    }
                    if (f.equals("enter-frame")) {
                        this.actionFlags |= 2;
                        continue;
                    }
                    if (f.equals("unload")) {
                        this.actionFlags |= 4;
                        continue;
                    }
                    if (f.equals("mouse-move")) {
                        this.actionFlags |= 8;
                        continue;
                    }
                    if (f.equals("mouse-down")) {
                        this.actionFlags |= 0x10;
                        continue;
                    }
                    if (f.equals("mouse-up")) {
                        this.actionFlags |= 0x20;
                        continue;
                    }
                    if (f.equals("key-down")) {
                        this.actionFlags |= 0x40;
                        continue;
                    }
                    if (f.equals("key-up")) {
                        this.actionFlags |= 0x80;
                        continue;
                    }
                    if (!f.equals("data")) continue;
                    this.actionFlags |= 0x100;
                }
            }
            return true;
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.getId(SaxHandlerBase.getAttr(this.attrs, "id", "-1"));
            boolean alter = SaxHandlerBase.getAttrBool(this.attrs, "alter", false);
            int clip = SaxHandlerBase.getAttrInt(this.attrs, "clip-depth", -1);
            int ratio = SaxHandlerBase.getAttrInt(this.attrs, "ratio", -1);
            int depth = SaxHandlerBase.getAttrInt(this.attrs, "depth", -1);
            String name = this.attrs.getValue("", "name");
            SWFSaxWriter.this.dispatchGatheredElement("matrix");
            SWFSaxWriter.this.dispatchGatheredElement("color-transform");
            SWFSaxWriter.this.actions = SWFSaxWriter.this.tags.tagPlaceObject2(alter, clip, depth, id, SWFSaxWriter.this.matrix, SWFSaxWriter.this.cxform, ratio, name, this.actionFlags);
            if (this.actionFlags != 0 && SWFSaxWriter.this.actions != null) {
                SWFSaxWriter.this.actionMode = 2;
                SWFSaxWriter.this.endGatherMode();
                SWFSaxWriter.this.actions.done();
                SWFSaxWriter.this.actionMode = 0;
            }
            SWFSaxWriter.this.matrix = null;
            SWFSaxWriter.this.cxform = null;
            SWFSaxWriter.this.actions = null;
        }
    }

    protected class Remove
    extends SaxHandlerBase.ElementType {
        protected Remove() {
        }

        public void startElement(Attributes atts) throws Exception {
            int depth = SaxHandlerBase.getAttrInt(atts, "depth", 0);
            SWFSaxWriter.this.tags.tagRemoveObject2(depth);
        }
    }

    protected class Release
    extends SaxHandlerBase.ElementType {
        protected Release() {
        }

        public void startElement(Attributes atts) throws Exception {
            int id = SWFSaxWriter.this.getId(atts.getValue("", "id"));
            SWFSaxWriter.this.tags.tagFreeCharacter(id);
        }
    }

    protected class Step
    extends SaxHandlerBase.ContentElementType {
        protected Step() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.color = null;
        }

        public void endElement() throws Exception {
            if (SWFSaxWriter.this.color == null) {
                SWFSaxWriter.this.color = new Color(0, 0, 0);
            }
            int ratio = SaxHandlerBase.getAttrInt(this.attrs, "ratio", 0);
            SWFSaxWriter.this.ratios.add(new Integer(ratio));
            SWFSaxWriter.this.colors.add(SWFSaxWriter.this.color);
        }
    }

    protected class ShapeLineStyle
    extends SaxHandlerBase.ContentElementType {
        protected ShapeLineStyle() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.color = null;
        }

        public void endElement() throws Exception {
            double width = SaxHandlerBase.getAttrDouble(this.attrs, "width", 1.0);
            if (SWFSaxWriter.this.color == null) {
                SWFSaxWriter.this.color = new Color(0, 0, 0);
            }
            SWFSaxWriter.this.shape.defineLineStyle((int)(width * (double)20), SWFSaxWriter.this.color);
            SWFSaxWriter.this.color = null;
        }
    }

    protected class ShapeImage
    extends SaxHandlerBase.ContentElementType {
        protected ShapeImage() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.matrix = null;
        }

        public void endElement() throws Exception {
            if (SWFSaxWriter.this.matrix == null) {
                SWFSaxWriter.this.matrix = new Matrix();
            }
            int bitmapId = SWFSaxWriter.this.getId(this.attrs.getValue("", "image-id"));
            boolean clipped = SaxHandlerBase.getAttrBool(this.attrs, "clipped", false);
            SWFSaxWriter.this.shape.defineFillStyle(bitmapId, SWFSaxWriter.this.matrix, clipped);
            SWFSaxWriter.this.matrix = null;
        }
    }

    protected class ShapeGradient
    extends SaxHandlerBase.ContentElementType {
        protected ShapeGradient() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.colors = new ArrayList();
            SWFSaxWriter.this.ratios = new ArrayList();
            SWFSaxWriter.this.matrix = null;
        }

        public void endElement() throws Exception {
            boolean radial = SaxHandlerBase.getAttrBool(this.attrs, "radial", false);
            if (SWFSaxWriter.this.matrix == null) {
                SWFSaxWriter.this.matrix = new Matrix();
            }
            Color[] colorsA = new Color[SWFSaxWriter.this.colors.size()];
            int[] ratiosA = new int[SWFSaxWriter.this.colors.size()];
            for (int i = 0; i < colorsA.length; ++i) {
                colorsA[i] = (Color)SWFSaxWriter.this.colors.get(i);
                ratiosA[i] = (Integer)SWFSaxWriter.this.ratios.get(i);
            }
            SWFSaxWriter.this.shape.defineFillStyle(SWFSaxWriter.this.matrix, ratiosA, colorsA, radial);
            SWFSaxWriter.this.matrix = null;
        }
    }

    protected class ShapeColorFill
    extends SaxHandlerBase.ElementType {
        protected ShapeColorFill() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.color = null;
        }

        public void endElement() throws Exception {
            if (SWFSaxWriter.this.color == null) {
                SWFSaxWriter.this.color = new Color(255, 255, 255);
            }
            SWFSaxWriter.this.shape.defineFillStyle(SWFSaxWriter.this.color);
            SWFSaxWriter.this.color = null;
        }
    }

    protected class ShapeSetLine
    extends SaxHandlerBase.ElementType {
        protected ShapeSetLine() {
        }

        public void startElement(Attributes atts) throws Exception {
            int index = SaxHandlerBase.getAttrInt(atts, "index", 1);
            SWFSaxWriter.this.shape.setLineStyle(index);
        }
    }

    protected class ShapeFill1
    extends SaxHandlerBase.ElementType {
        protected ShapeFill1() {
        }

        public void startElement(Attributes atts) throws Exception {
            int index = SaxHandlerBase.getAttrInt(atts, "index", 1);
            SWFSaxWriter.this.shape.setFillStyle1(index);
        }
    }

    protected class ShapeFill0
    extends SaxHandlerBase.ElementType {
        protected ShapeFill0() {
        }

        public void startElement(Attributes atts) throws Exception {
            int index = SaxHandlerBase.getAttrInt(atts, "index", 1);
            SWFSaxWriter.this.shape.setFillStyle0(index);
        }
    }

    protected class ShapeMove
    extends SaxHandlerBase.ElementType {
        protected ShapeMove() {
        }

        public void startElement(Attributes atts) throws Exception {
            double x = SaxHandlerBase.getAttrDouble(atts, "x", 0.0);
            double y = SaxHandlerBase.getAttrDouble(atts, "y", 0.0);
            SWFSaxWriter.this.vectors.move((int)(x * (double)20), (int)(y * (double)20));
        }
    }

    protected class ShapeCurve
    extends SaxHandlerBase.ElementType {
        protected ShapeCurve() {
        }

        public void startElement(Attributes atts) throws Exception {
            double cx = SaxHandlerBase.getAttrDouble(atts, "cx", 0.0);
            double cy = SaxHandlerBase.getAttrDouble(atts, "cy", 0.0);
            double dx = SaxHandlerBase.getAttrDouble(atts, "dx", 0.0);
            double dy = SaxHandlerBase.getAttrDouble(atts, "dy", 0.0);
            SWFSaxWriter.this.vectors.curve((int)(cx * (double)20), (int)(cy * (double)20), (int)(dx * (double)20), (int)(dy * (double)20));
        }
    }

    protected class ShapeLine
    extends SaxHandlerBase.ElementType {
        protected ShapeLine() {
        }

        public void startElement(Attributes atts) throws Exception {
            double dx = SaxHandlerBase.getAttrDouble(atts, "dx", 0.0);
            double dy = SaxHandlerBase.getAttrDouble(atts, "dy", 0.0);
            SWFSaxWriter.this.vectors.line((int)(dx * (double)20), (int)(dy * (double)20));
        }
    }

    protected class Shape
    extends SaxHandlerBase.ElementType {
        protected boolean insideMorph;

        protected Shape() {
        }

        public void startElement(Attributes atts) throws Exception {
            if (SWFSaxWriter.this.shape == null) {
                this.insideMorph = false;
                SWFSaxWriter.this.hasAlpha = SaxHandlerBase.getAttrBool(atts, "has-alpha", false);
                int id = SWFSaxWriter.this.newId(atts.getValue("", "id"));
                double minx = SaxHandlerBase.getAttrDouble(atts, "min-x", 0.0);
                double miny = SaxHandlerBase.getAttrDouble(atts, "min-y", 0.0);
                double maxx = SaxHandlerBase.getAttrDouble(atts, "max-x", 0.0);
                double maxy = SaxHandlerBase.getAttrDouble(atts, "max-y", 0.0);
                Rect rect = new Rect((int)(minx * (double)20), (int)(miny * (double)20), (int)(maxx * (double)20), (int)(maxy * (double)20));
                SWFSaxWriter.this.shape = SWFSaxWriter.this.hasAlpha ? SWFSaxWriter.this.tags.tagDefineShape3(id, rect) : SWFSaxWriter.this.tags.tagDefineShape2(id, rect);
                SWFSaxWriter.this.vectors = SWFSaxWriter.this.shape;
            } else {
                this.insideMorph = true;
            }
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.vectors.done();
            if (!this.insideMorph) {
                SWFSaxWriter.this.vectors = null;
                SWFSaxWriter.this.shape = null;
            }
        }
    }

    protected class BackgroundColor
    extends SaxHandlerBase.ElementType {
        protected BackgroundColor() {
        }

        public void startElement(Attributes atts) throws Exception {
            int red = SaxHandlerBase.getAttrInt(atts, "red", 255);
            int green = SaxHandlerBase.getAttrInt(atts, "green", 255);
            int blue = SaxHandlerBase.getAttrInt(atts, "blue", 255);
            SWFSaxWriter.this.tags.tagSetBackgroundColor(new Color(red, green, blue));
        }
    }

    protected class EnableDebug
    extends SaxHandlerBase.ElementType {
        protected EnableDebug() {
        }

        public void startElement(Attributes atts) throws Exception {
            String password = atts.getValue("", "password");
            byte[] bytes = null;
            if (password != null && password.length() > 0) {
                bytes = Base64.decode(password);
            }
            SWFSaxWriter.this.tags.tagEnableDebug(bytes);
        }
    }

    protected class Protect
    extends SaxHandlerBase.ElementType {
        protected Protect() {
        }

        public void startElement(Attributes atts) throws Exception {
            String password = atts.getValue("", "password");
            byte[] bytes = null;
            if (password != null && password.length() > 0) {
                bytes = Base64.decode(password);
            }
            SWFSaxWriter.this.tags.tagProtect(bytes);
        }
    }

    protected class Tag
    extends SaxHandlerBase.ContentElementType {
        protected Tag() {
        }

        public void endElement() throws Exception {
            int type = SaxHandlerBase.getAttrInt(this.attrs, "type", 0);
            String base64 = this.buff.toString().trim();
            byte[] bytes = base64.length() > 0 ? Base64.decode(base64) : null;
            SWFSaxWriter.this.tags.tag(type, false, bytes);
        }
    }

    protected class GeneratorNameCharacter
    extends SaxHandlerBase.ContentElementType {
        protected GeneratorNameCharacter() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagNameCharacter(Base64.decode(this.buff.toString()));
        }
    }

    protected class GeneratorFont
    extends SaxHandlerBase.ContentElementType {
        protected GeneratorFont() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagGeneratorFont(Base64.decode(this.buff.toString()));
        }
    }

    protected class GeneratorCommand
    extends SaxHandlerBase.ContentElementType {
        protected GeneratorCommand() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagGeneratorCommand(Base64.decode(this.buff.toString()));
        }
    }

    protected class GeneratorText
    extends SaxHandlerBase.ContentElementType {
        protected GeneratorText() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagGeneratorText(Base64.decode(this.buff.toString()));
        }
    }

    protected class Generator
    extends SaxHandlerBase.ContentElementType {
        protected Generator() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagGenerator(Base64.decode(this.buff.toString()));
        }
    }

    protected class SerialNumber
    extends SaxHandlerBase.ContentElementType {
        protected SerialNumber() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagSerialNumber(this.buff.toString());
        }
    }

    protected class Frame
    extends SaxHandlerBase.ElementType {
        protected Frame() {
        }

        public void startElement(Attributes atts) throws Exception {
            String label = atts.getValue("", "label");
            if (label != null && label.length() > 0) {
                SWFSaxWriter.this.tags.tagFrameLabel(label);
            }
            for (int count = SaxHandlerBase.getAttrInt(atts, "count", 1); count > 0; --count) {
                SWFSaxWriter.this.tags.tagShowFrame();
            }
        }
    }

    protected class Sprite
    extends SaxHandlerBase.ElementType {
        protected Sprite() {
        }

        public void startElement(Attributes atts) throws Exception {
            int id = SWFSaxWriter.this.newId(atts.getValue("", "id"));
            SWFSaxWriter.this.tags = SWFSaxWriter.this.tags.tagDefineSprite(id);
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagEnd();
            SWFSaxWriter.this.tags = SWFSaxWriter.this.movieTags;
        }
    }

    protected class Movie
    extends SaxHandlerBase.ElementType {
        protected Movie() {
        }

        public void startElement(Attributes atts) throws Exception {
            int width = SaxHandlerBase.getAttrInt(atts, "width", 550);
            int height = SaxHandlerBase.getAttrInt(atts, "height", 400);
            int rate = SaxHandlerBase.getAttrInt(atts, "rate", 12);
            int version = SaxHandlerBase.getAttrInt(atts, "version", 5);
            SWFSaxWriter.this.idAllocate = SaxHandlerBase.getAttrBool(atts, "allocate-ids", false);
            SWFSaxWriter.this.flashVersion = version;
            SWFSaxWriter.this.tags.header(version, -1L, width * 20, height * 20, rate, -1);
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagEnd();
        }
    }

    protected class SoundBlock
    extends SaxHandlerBase.ContentElementType {
        protected SoundBlock() {
        }

        public void endElement() throws Exception {
            SWFSaxWriter.this.tags.tagSoundStreamBlock(Base64.decode(this.buff.toString()));
        }
    }

    protected class SoundHeader
    extends SaxHandlerBase.ElementType {
        protected SoundHeader() {
        }

        public void startElement(Attributes atts) throws Exception {
            String form = SaxHandlerBase.getAttr(atts, "stream-format", "mp3");
            int format = 2;
            if (form.equals("raw")) {
                format = 0;
            }
            if (form.equals("adpcm")) {
                format = 1;
            }
            String rate = SaxHandlerBase.getAttr(atts, "play-rate", "11");
            int freq = 1;
            if (rate.equals("5.5")) {
                freq = 0;
            }
            if (rate.equals("22")) {
                freq = 2;
            }
            if (rate.equals("44")) {
                freq = 3;
            }
            int playFreq = freq;
            rate = SaxHandlerBase.getAttr(atts, "stream-rate", "11");
            freq = 1;
            if (rate.equals("5.5")) {
                freq = 0;
            }
            if (rate.equals("22")) {
                freq = 2;
            }
            if (rate.equals("44")) {
                freq = 3;
            }
            int streamFreq = freq;
            boolean play16bit = SaxHandlerBase.getAttr(atts, "play-bits", "16").equals("16");
            boolean stream16bit = SaxHandlerBase.getAttr(atts, "stream-bits", "16").equals("16");
            boolean playStereo = SaxHandlerBase.getAttrBool(atts, "play-stereo", false);
            boolean streamStereo = SaxHandlerBase.getAttrBool(atts, "stream-stereo", false);
            int averageSampleCount = SaxHandlerBase.getAttrInt(atts, "average-sample-count", 0);
            SWFSaxWriter.this.tags.tagSoundStreamHead2(playFreq, play16bit, playStereo, format, streamFreq, stream16bit, streamStereo, averageSampleCount);
        }
    }

    protected class StartSound
    extends SaxHandlerBase.ElementType {
        protected StartSound() {
        }

        public void startElement(Attributes atts) throws Exception {
            SWFSaxWriter.this.soundInfos = new ArrayList();
        }

        public void endElement() throws Exception {
            if (SWFSaxWriter.this.soundInfos.size() < 1) {
                return;
            }
            Object[] oo = (Object[])SWFSaxWriter.this.soundInfos.get(0);
            int id = (Integer)oo[0];
            SoundInfo si = (SoundInfo)oo[2];
            SWFSaxWriter.this.tags.tagStartSound(id, si);
            SWFSaxWriter.this.soundInfos = null;
        }
    }

    protected class ButtonSound
    extends SaxHandlerBase.ContentElementType {
        protected ButtonSound() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            SWFSaxWriter.this.soundInfos = new ArrayList();
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.getId(this.attrs.getValue("", "id"));
            int rolloverId = 0;
            SoundInfo rolloverInfo = null;
            int rolloutId = 0;
            SoundInfo rolloutInfo = null;
            int pressId = 0;
            SoundInfo pressInfo = null;
            int releaseId = 0;
            SoundInfo releaseInfo = null;
            Iterator it = ((AbstractList)SWFSaxWriter.this.soundInfos).iterator();
            while (it.hasNext()) {
                Object[] oo = (Object[])it.next();
                int soundId = (Integer)oo[0];
                String event = (String)oo[1];
                SoundInfo si = (SoundInfo)oo[2];
                if ("roll-over".equals(event)) {
                    rolloverId = soundId;
                    rolloverInfo = si;
                    continue;
                }
                if ("roll-out".equals(event)) {
                    rolloutId = soundId;
                    rolloutInfo = si;
                    continue;
                }
                if ("press".equals(event)) {
                    pressId = soundId;
                    pressInfo = si;
                    continue;
                }
                if (!"release".equals(event)) continue;
                releaseId = soundId;
                releaseInfo = si;
            }
            SWFSaxWriter.this.tags.tagDefineButtonSound(id, rolloverId, rolloverInfo, rolloutId, rolloutInfo, pressId, pressInfo, releaseId, releaseInfo);
            SWFSaxWriter.this.soundInfos = null;
        }
    }

    protected class Sound_Info
    extends SaxHandlerBase.GatheringElementType {
        protected Vector envPoints = new Vector();

        protected Sound_Info() {
        }

        public void startElement(Attributes atts) throws Exception {
            super.startElement(atts);
            this.envPoints.clear();
            SWFSaxWriter.this.startGatherMode(this);
        }

        public boolean gatherElement(String localName, Attributes atts) {
            if (localName.equals("envelope-point")) {
                int position = SaxHandlerBase.getAttrInt(atts, "position", 0);
                int level0 = SaxHandlerBase.getAttrInt(atts, "level-0", 0);
                int level1 = SaxHandlerBase.getAttrInt(atts, "level-1", 0);
                this.envPoints.add(new SoundInfo.EnvelopePoint(position, level0, level1));
            }
            return false;
        }

        public void endElement() throws Exception {
            boolean noMultiplePlay = SaxHandlerBase.getAttrBool(this.attrs, "single-instance", false);
            boolean stopSound = SaxHandlerBase.getAttrBool(this.attrs, "stop-playing", false);
            int inPoint = SaxHandlerBase.getAttrInt(this.attrs, "fade-in", -1);
            int outPoint = SaxHandlerBase.getAttrInt(this.attrs, "fade-out", -1);
            int loopCount = SaxHandlerBase.getAttrInt(this.attrs, "loop-count", 1);
            int id = SWFSaxWriter.this.getId(SaxHandlerBase.getAttr(this.attrs, "sound-id", ""));
            String event = this.attrs.getValue("", "event");
            Object[] envelope = new SoundInfo.EnvelopePoint[this.envPoints.size()];
            this.envPoints.copyInto(envelope);
            this.envPoints.clear();
            SWFSaxWriter.this.soundInfos.add(new Object[]{new Integer(id), event, new SoundInfo(noMultiplePlay, stopSound, (SoundInfo.EnvelopePoint[])envelope, inPoint, outPoint, loopCount)});
        }
    }

    protected class Sound
    extends SaxHandlerBase.ContentElementType {
        protected Sound() {
        }

        public void endElement() throws Exception {
            int id = SWFSaxWriter.this.newId(this.attrs.getValue("", "id"));
            String form = SaxHandlerBase.getAttr(this.attrs, "format", "mp3");
            int format = 2;
            if (form.equals("raw")) {
                format = 0;
            }
            if (form.equals("adpcm")) {
                format = 1;
            }
            String rate = SaxHandlerBase.getAttr(this.attrs, "rate", "11");
            int freq = 1;
            if (rate.equals("5.5")) {
                freq = 0;
            }
            if (rate.equals("22")) {
                freq = 2;
            }
            if (rate.equals("44")) {
                freq = 3;
            }
            String bits = SaxHandlerBase.getAttr(this.attrs, "bits", "16");
            boolean bits16 = bits.equals("16");
            boolean stereo = SaxHandlerBase.getAttrBool(this.attrs, "stereo", false);
            int sampleCount = SaxHandlerBase.getAttrInt(this.attrs, "sample-count", 0);
            SWFSaxWriter.this.tags.tagDefineSound(id, format, freq, bits16, stereo, sampleCount, Base64.decode(this.buff.toString()));
        }
    }
}

