/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class Rect {
    protected int bitSize = -1;
    protected int minX;
    protected int minY;
    protected int maxX;
    protected int maxY;

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMinX(int minX) {
        this.minX = minX;
        this.bitSize = -1;
    }

    public void setMinY(int minY) {
        this.minY = minY;
        this.bitSize = -1;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
        this.bitSize = -1;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
        this.bitSize = -1;
    }

    public Rect(int minX, int minY, int maxX, int maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public Rect(InStream in) throws IOException {
        in.synchBits();
        this.bitSize = (int)in.readUBits(5);
        this.minX = in.readSBits(this.bitSize);
        this.maxX = in.readSBits(this.bitSize);
        this.minY = in.readSBits(this.bitSize);
        this.maxY = in.readSBits(this.bitSize);
    }

    public Rect() {
        this(0, 0, 11000, 8000);
    }

    protected int getBitSize() {
        if (this.bitSize == -1) {
            int bsMinX = OutStream.determineSignedBitSize(this.minX);
            int bsMaxX = OutStream.determineSignedBitSize(this.maxX);
            int bsMinY = OutStream.determineSignedBitSize(this.minY);
            int bsMaxY = OutStream.determineSignedBitSize(this.maxY);
            this.bitSize = bsMinY;
            if (this.bitSize < bsMaxX) {
                this.bitSize = bsMaxX;
            }
            if (this.bitSize < bsMinX) {
                this.bitSize = bsMinX;
            }
            if (this.bitSize < bsMaxY) {
                this.bitSize = bsMaxY;
            }
        }
        return this.bitSize;
    }

    public long getLength() {
        int bits = 5 + this.getBitSize() * 4;
        int bytes = bits / 8;
        if (bytes * 8 < bits) {
            ++bytes;
        }
        return bytes;
    }

    public void write(OutStream out) throws IOException {
        out.flushBits();
        out.writeUBits(5, this.getBitSize());
        out.writeSBits(this.bitSize, this.minX);
        out.writeSBits(this.bitSize, this.maxX);
        out.writeSBits(this.bitSize, this.minY);
        out.writeSBits(this.bitSize, this.maxY);
        out.flushBits();
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("Rect bitsize=").append(this.bitSize).append(" (").append(this.minX).append(",").append(this.minY).append(")-(").append(this.maxX).append(",").append(this.maxY).append(")")));
    }
}

