/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class AlphaTransform
extends ColorTransform {
    public double getMultAlpha() {
        return this.multAlpha;
    }

    public int getAddAlpha() {
        return this.addAlpha;
    }

    public void setMultAlpha(double multAlpha) {
        this.multAlpha = multAlpha;
    }

    public void setAddAlpha(int addAlpha) {
        this.addAlpha = addAlpha;
    }

    public AlphaTransform() {
    }

    public AlphaTransform(ColorTransform copy) {
        if (copy == null) {
            return;
        }
        this.addRed = copy.addRed;
        this.addGreen = copy.addGreen;
        this.addBlue = copy.addBlue;
        this.addAlpha = copy.addAlpha;
        this.multRed = copy.multRed;
        this.multGreen = copy.multGreen;
        this.multBlue = copy.multBlue;
        this.multAlpha = copy.multAlpha;
    }

    public AlphaTransform(double multRed, double multGreen, double multBlue, double multAlpha, int addRed, int addGreen, int addBlue, int addAlpha) {
        super(multRed, multGreen, multBlue, addRed, addGreen, addBlue);
        this.multAlpha = multAlpha;
        this.addAlpha = addAlpha;
    }

    public AlphaTransform(int addRed, int addGreen, int addBlue, int addAlpha) {
        super(addRed, addGreen, addBlue);
        this.addAlpha = addAlpha;
    }

    public AlphaTransform(double multRed, double multGreen, double multBlue, double multAplha) {
        super(multRed, multGreen, multBlue);
        this.multAlpha = this.multAlpha;
    }

    public AlphaTransform(InStream in) throws IOException {
        in.synchBits();
        boolean hasAddTerms = in.readUBits(1) == (long)1;
        boolean hasMultTerms = in.readUBits(1) == (long)1;
        int numBits = (int)in.readUBits(4);
        if (hasMultTerms) {
            this.multRed = (double)in.readSBits(numBits) / 256.0;
            this.multGreen = (double)in.readSBits(numBits) / 256.0;
            this.multBlue = (double)in.readSBits(numBits) / 256.0;
            this.multAlpha = (double)in.readSBits(numBits) / 256.0;
        }
        if (hasAddTerms) {
            this.addRed = in.readSBits(numBits);
            this.addGreen = in.readSBits(numBits);
            this.addBlue = in.readSBits(numBits);
            this.addAlpha = in.readSBits(numBits);
        }
    }

    public void write(OutStream out) throws IOException {
        this.writeWithAlpha(out);
    }

    public void writeWithoutAlpha(OutStream out) throws IOException {
        super.write(out);
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(" cxform(+rgba,*rgba)=(").append(this.addRed).append(",").append(this.addGreen).append(",").append(this.addBlue).append(",").append(this.addAlpha).append(",").append(this.multRed).append(",").append(this.multGreen).append(",").append(this.multBlue).append(",").append(this.multAlpha).append(")")));
    }
}

