/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.io.OutStream;
import com.anotherbigidea.util.Base64;
import com.anotherbigidea.util.xml.SaxParserBase;
import com.anotherbigidea.util.xml.XMLWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SWFSaxParser
extends SaxParserBase
implements SWFTagTypes,
SWFShape,
SWFActions,
SWFText {
    public static final String NAMESPACE = "http://www.anotherbigidea.com/javaswf2";
    protected String frameLabel;
    protected boolean definingSprite;
    protected int actionsType = 0;
    protected int glyphCount = 0;
    protected Rect[] glyphRects;
    protected int[] glyphAdvances;
    protected int[] glyphCodes;
    protected Rect morphEndRect;
    protected boolean morph;

    public SWFSaxParser() {
        super(NAMESPACE);
    }

    public SWFSaxParser(ContentHandler contenthandler, ErrorHandler errorhandler) {
        this();
        this.setContentHandler(contenthandler);
        this.setErrorHandler(errorhandler);
    }

    public void parse(InputSource input) throws SAXException, IOException {
        InputStream istream = input.getByteStream();
        this.parse(istream);
    }

    public void parse(String systemId) throws SAXException, IOException {
        FileInputStream istream = new FileInputStream(systemId);
        this.parse(istream);
    }

    protected void parse(InputStream istream) throws IOException {
        TagParser parser = new TagParser(this);
        SWFReader reader = new SWFReader((SWFTags)parser, istream);
        reader.readFile();
        istream.close();
    }

    public void tag(int tagType, boolean longTag, byte[] contents) throws IOException {
        this.start("tag", new String[]{"type", Integer.toString(tagType)});
        this.text(Base64.encode(contents));
        this.end();
    }

    public void header(int version, long length, int twipsWidth, int twipsHeight, int frameRate, int frameCount) throws IOException {
        this.startDoc();
        this.start("movie", new String[]{"version", Integer.toString(version), "width", Integer.toString(twipsWidth / 20), "height", Integer.toString(twipsHeight / 20), "rate", Integer.toString(frameRate)});
    }

    public void tagEnd() throws IOException {
        this.end();
        if (!this.definingSprite) {
            this.endDoc();
        } else {
            this.definingSprite = false;
        }
    }

    public void tagShowFrame() throws IOException {
        String[] stringArray;
        if (this.frameLabel == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "label";
            stringArray = stringArray2;
            stringArray2[1] = this.frameLabel;
        }
        this.element("frame", stringArray);
        this.frameLabel = null;
    }

    public void tagDefineSound(int id, int format, int frequency, boolean bits16, boolean stereo, int sampleCount, byte[] soundData) throws IOException {
        String sndFormat = null;
        switch (format) {
            case 0: {
                sndFormat = "raw";
                break;
            }
            case 1: {
                sndFormat = "adpcm";
                break;
            }
            case 2: {
                sndFormat = "mp3";
                break;
            }
        }
        String freq = null;
        switch (frequency) {
            case 0: {
                freq = "5.5";
                break;
            }
            case 1: {
                freq = "11";
                break;
            }
            case 2: {
                freq = "22";
                break;
            }
            case 3: {
                freq = "44";
                break;
            }
        }
        this.start("sound", new String[]{"id", Integer.toString(id), "format", sndFormat, "rate", freq, "bits", bits16 ? "16" : "8", "stereo", stereo ? "yes" : "no", "sample-count", Integer.toString(sampleCount)});
        this.text(Base64.encode(soundData));
        this.end();
    }

    protected void soundInfo(SoundInfo info, String event, int id) throws IOException {
        int loopCount = info.getLoopCount();
        int inpoint = info.getInPoint();
        int outpoint = info.getOutPoint();
        String loop = loopCount > 1 ? Integer.toString(loopCount) : null;
        String inpnt = inpoint >= 0 ? Integer.toString(inpoint) : null;
        String outpnt = outpoint >= 0 ? Integer.toString(outpoint) : null;
        this.start("sound-info", new String[]{"event", event, "sound-id", Integer.toString(id), "single-instance", info.isNoMultiplePlay() ? "yes" : "no", "stop-playing", info.isStopPlaying() ? "yes" : "no", "loop-count", loop, "fade-in", inpnt, "fade-out", outpnt});
        SoundInfo.EnvelopePoint[] envelope = info.getEnvelope();
        if (envelope != null && envelope.length > 0) {
            for (int i = 0; i < envelope.length; ++i) {
                this.element("envelope-point", new String[]{"position", Integer.toString(envelope[i].mark44), "level-0", Integer.toString(envelope[i].level0), "level-1", Integer.toString(envelope[i].level1)});
            }
        }
        this.end();
    }

    public void tagDefineButtonSound(int buttonId, int rollOverSoundId, SoundInfo rollOverSoundInfo, int rollOutSoundId, SoundInfo rollOutSoundInfo, int pressSoundId, SoundInfo pressSoundInfo, int releaseSoundId, SoundInfo releaseSoundInfo) throws IOException {
        this.start("button-sound", new String[]{"id", Integer.toString(buttonId)});
        if (rollOverSoundId != 0) {
            this.soundInfo(rollOverSoundInfo, "roll-over", rollOverSoundId);
        }
        if (rollOutSoundId != 0) {
            this.soundInfo(rollOutSoundInfo, "roll-out", rollOutSoundId);
        }
        if (pressSoundId != 0) {
            this.soundInfo(pressSoundInfo, "press", pressSoundId);
        }
        if (releaseSoundId != 0) {
            this.soundInfo(releaseSoundInfo, "release", releaseSoundId);
        }
        this.end();
    }

    public void tagStartSound(int soundId, SoundInfo info) throws IOException {
        this.start("start-sound", null);
        this.soundInfo(info, null, soundId);
        this.end();
    }

    protected void soundStreamHead(String type, int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        String sndFormat = null;
        switch (streamFormat) {
            case 0: {
                sndFormat = "raw";
                break;
            }
            case 1: {
                sndFormat = "adpcm";
                break;
            }
            case 2: {
                sndFormat = "mp3";
                break;
            }
        }
        String playfreq = null;
        switch (playbackFrequency) {
            case 0: {
                playfreq = "5.5";
                break;
            }
            case 1: {
                playfreq = "11";
                break;
            }
            case 2: {
                playfreq = "22";
                break;
            }
            case 3: {
                playfreq = "44";
                break;
            }
        }
        String streamfreq = null;
        switch (streamFrequency) {
            case 0: {
                streamfreq = "5.5";
                break;
            }
            case 1: {
                streamfreq = "11";
                break;
            }
            case 2: {
                streamfreq = "22";
                break;
            }
            case 3: {
                streamfreq = "44";
                break;
            }
        }
        this.element("sound-stream-header", new String[]{"type", type, "play-rate", playfreq, "play-bits", playback16bit ? "16" : "8", "play-stereo", playbackStereo ? "yes" : "no", "stream-format", sndFormat, "stream-rate", streamfreq, "stream-bits", stream16bit ? "16" : "8", "stream-stereo", streamStereo ? "yes" : "no", "average-sample-count", Integer.toString(averageSampleCount)});
    }

    public void tagSoundStreamHead(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.soundStreamHead("1", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void tagSoundStreamHead2(int playbackFrequency, boolean playback16bit, boolean playbackStereo, int streamFormat, int streamFrequency, boolean stream16bit, boolean streamStereo, int averageSampleCount) throws IOException {
        this.soundStreamHead("2", playbackFrequency, playback16bit, playbackStereo, streamFormat, streamFrequency, stream16bit, streamStereo, averageSampleCount);
    }

    public void tagSoundStreamBlock(byte[] soundData) throws IOException {
        this.start("sound-stream-block", null);
        this.text(Base64.encode(soundData));
        this.end();
    }

    public void tagSerialNumber(String serialNumber) throws IOException {
        this.start("serial-number", null);
        this.text(serialNumber);
        this.end();
    }

    public void tagGenerator(byte[] data) throws IOException {
        this.start("generator", null);
        this.text(Base64.encode(data));
        this.end();
    }

    public void tagGeneratorText(byte[] data) throws IOException {
        this.start("generator-text", null);
        this.text(Base64.encode(data));
        this.end();
    }

    public void tagGeneratorCommand(byte[] data) throws IOException {
        this.start("generator-command", null);
        this.text(Base64.encode(data));
        this.end();
    }

    public void tagGeneratorFont(byte[] data) throws IOException {
        this.start("generator-font", null);
        this.text(Base64.encode(data));
        this.end();
    }

    public void tagNameCharacter(byte[] data) throws IOException {
        this.start("generator-name-character", null);
        this.text(Base64.encode(data));
        this.end();
    }

    public void tagDefineBits(int id, byte[] imageData) throws IOException {
        this.start("jpeg", new String[]{"id", Integer.toString(id), "common-header", "yes"});
        this.start("image", null);
        this.text(Base64.encode(imageData));
        this.end();
        this.end();
    }

    public void tagJPEGTables(byte[] jpegEncodingData) throws IOException {
        this.start("jpeg-header", null);
        this.text(Base64.encode(jpegEncodingData));
        this.end();
    }

    public void tagDefineBitsJPEG3(int id, byte[] imageData, byte[] alphaData) throws IOException {
        this.start("jpeg", new String[]{"id", Integer.toString(id)});
        this.start("image", null);
        this.text(Base64.encode(imageData));
        this.end();
        this.start("alpha", null);
        this.text(Base64.encode(alphaData));
        this.end();
        this.end();
    }

    public SWFActions tagDoAction() throws IOException {
        this.actionsType = 1;
        return this;
    }

    public SWFShape tagDefineShape(int id, Rect outline) throws IOException {
        this.start("shape", new String[]{"id", Integer.toString(id), "has-alpha", "no", "min-x", Double.toString((double)outline.getMinX() / (double)20), "min-y", Double.toString((double)outline.getMinY() / (double)20), "max-x", Double.toString((double)outline.getMaxX() / (double)20), "max-y", Double.toString((double)outline.getMaxY() / (double)20)});
        return this;
    }

    public SWFShape tagDefineShape2(int id, Rect outline) throws IOException {
        this.start("shape", new String[]{"id", Integer.toString(id), "has-alpha", "no", "min-x", Double.toString((double)outline.getMinX() / (double)20), "min-y", Double.toString((double)outline.getMinY() / (double)20), "max-x", Double.toString((double)outline.getMaxX() / (double)20), "max-y", Double.toString((double)outline.getMaxY() / (double)20)});
        return this;
    }

    public SWFShape tagDefineShape3(int id, Rect outline) throws IOException {
        this.start("shape", new String[]{"id", Integer.toString(id), "has-alpha", "yes", "min-x", Double.toString((double)outline.getMinX() / (double)20), "min-y", Double.toString((double)outline.getMinY() / (double)20), "max-x", Double.toString((double)outline.getMaxX() / (double)20), "max-y", Double.toString((double)outline.getMaxY() / (double)20)});
        return this;
    }

    public void tagFreeCharacter(int charId) throws IOException {
        this.element("release", new String[]{"id", Integer.toString(charId)});
    }

    public void tagPlaceObject(int charId, int depth, Matrix matrix, AlphaTransform cxform) throws IOException {
        this.start("place", new String[]{"id", Integer.toString(charId), "depth", Integer.toString(depth)});
        if (matrix != null) {
            this.writeMatrix(matrix);
        }
        if (cxform != null) {
            this.writeCXForm(cxform);
        }
        this.end();
    }

    public SWFActions tagPlaceObject2(boolean isMove, int clipDepth, int depth, int charId, Matrix matrix, AlphaTransform cxform, int ratio, String name, int clipActionFlags) throws IOException {
        Vector<String> attrs = new Vector<String>();
        if (charId > 0) {
            attrs.add("id");
            attrs.add(Integer.toString(charId));
        }
        if (isMove) {
            attrs.add("alter");
            attrs.add("yes");
        }
        if (clipDepth > 0) {
            attrs.add("clip-depth");
            attrs.add(Integer.toString(clipDepth));
        }
        if (ratio >= 0) {
            attrs.add("ratio");
            attrs.add(Integer.toString(ratio));
        }
        attrs.add("depth");
        attrs.add(Integer.toString(depth));
        if (name != null && name.length() > 0) {
            attrs.add("name");
            attrs.add(name);
        }
        Object[] attributes = new String[attrs.size()];
        attrs.copyInto(attributes);
        this.start("place", (String[])attributes);
        if (matrix != null) {
            this.writeMatrix(matrix);
        }
        if (cxform != null) {
            this.writeCXForm(cxform);
        }
        if (clipActionFlags == 0) {
            this.end();
            return null;
        }
        this.actionsType = 2;
        return this;
    }

    public void tagRemoveObject(int charId, int depth) throws IOException {
        this.element("remove", new String[]{"depth", Integer.toString(depth)});
    }

    public void tagRemoveObject2(int depth) throws IOException {
        this.element("remove", new String[]{"depth", Integer.toString(depth)});
    }

    public void tagSetBackgroundColor(Color color) throws IOException {
        this.element("background-color", new String[]{"red", Integer.toString(color.getRed()), "green", Integer.toString(color.getGreen()), "blue", Integer.toString(color.getBlue())});
    }

    public void tagFrameLabel(String label) throws IOException {
        this.frameLabel = label;
    }

    public SWFTagTypes tagDefineSprite(int id) throws IOException {
        this.start("sprite", new String[]{"id", Integer.toString(id)});
        this.definingSprite = true;
        return this;
    }

    public void tagProtect(byte[] password) throws IOException {
        String[] stringArray;
        if (password == null || password.length == 0) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "password";
            stringArray = stringArray2;
            stringArray2[1] = Base64.encode(password);
        }
        this.element("protect", stringArray);
    }

    public void tagEnableDebug(byte[] password) throws IOException {
        String[] stringArray;
        if (password == null || password.length == 0) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "password";
            stringArray = stringArray2;
            stringArray2[1] = Base64.encode(password);
        }
        this.element("enable-debug", stringArray);
    }

    public SWFVectors tagDefineFont(int id, int numGlyphs) throws IOException {
        this.start("text-font", new String[]{"id", Integer.toString(id)});
        this.glyphCount = numGlyphs;
        this.start("glyph", null);
        return this;
    }

    public void tagDefineFontInfo(int fontId, String fontName, int flags, int[] codes) throws IOException {
        StringBuffer buff = new StringBuffer();
        if ((flags & 0x20) != 0) {
            buff.append("unicode");
        }
        if ((flags & 0x10) != 0) {
            buff.append(" shiftjis");
        }
        if ((flags & 8) != 0) {
            buff.append(" ansi");
        }
        if ((flags & 4) != 0) {
            buff.append(" italic");
        }
        if ((flags & 2) != 0) {
            buff.append(" bold");
        }
        this.start("font-info", new String[]{"id", Integer.toString(fontId), "name", fontName, "flags", buff.toString().trim()});
        for (int i = 0; i < codes.length; ++i) {
            this.element("code", new String[]{"code", Integer.toString(codes[i])});
        }
        this.end();
    }

    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        StringBuffer buff = new StringBuffer();
        if ((flags & 0x20) != 0) {
            buff.append("unicode");
        }
        if ((flags & 0x40) != 0) {
            buff.append(" shiftjis");
        }
        if ((flags & 0x10) != 0) {
            buff.append(" ansi");
        }
        if ((flags & 2) != 0) {
            buff.append(" italic");
        }
        if ((flags & 1) != 0) {
            buff.append(" bold");
        }
        this.start("edit-font", new String[]{"id", Integer.toString(id), "flags", buff.toString().trim(), "name", name, "ascent", Double.toString((double)ascent / (double)20), "descent", Double.toString((double)descent / (double)20), "leading", Double.toString((double)leading / (double)20)});
        if (kernCodes1 != null && kernCodes1.length > 0) {
            this.start("kerning-info", null);
            for (int i = 0; i < kernCodes1.length; ++i) {
                this.element("kerning", new String[]{"code-1", Integer.toString(kernCodes1[i]), "code-2", Integer.toString(kernCodes2[i]), "offset", Double.toString((double)kernAdjustments[i] / (double)20)});
            }
            this.end();
        }
        if (numGlyphs == 0) {
            this.end();
            return null;
        }
        this.glyphAdvances = advances;
        this.glyphRects = bounds;
        this.glyphCodes = codes;
        this.glyphCount = numGlyphs;
        Rect bound = bounds[0];
        int advance = 0;
        if (advances != null && advances.length >= 1) {
            advance = advances[0];
        }
        this.start("glyph", new String[]{"code", Integer.toString(this.glyphCodes[0]), "advance", Double.toString((double)advance / (double)20), "min-x", Double.toString((double)bound.getMinX() / (double)20), "min-y", Double.toString((double)bound.getMinY() / (double)20), "max-x", Double.toString((double)bound.getMaxX() / (double)20), "max-y", Double.toString((double)bound.getMaxY() / (double)20)});
        return this;
    }

    public void tagDefineTextField(int fieldId, String fieldName, String initialText, Rect boundary, int flags, AlphaColor textColor, int alignment, int fontId, int fontSize, int charLimit, int leftMargin, int rightMargin, int indentation, int lineSpacing) throws IOException {
        String align = null;
        if (alignment == 2) {
            align = "center";
        } else if (alignment == 3) {
            align = "justify";
        } else if (alignment == 0) {
            align = "left";
        } else if (alignment == 1) {
            align = "right";
        }
        this.start("edit-field", new String[]{"id", Integer.toString(fieldId), "font", Integer.toString(fontId), "size", Double.toString((double)fontSize / (double)20), "limit", charLimit > 0 ? Integer.toString(charLimit) : null, "left-margin", Double.toString((double)leftMargin / (double)20), "right-margin", Double.toString((double)rightMargin / (double)20), "indentation", Double.toString((double)indentation / (double)20), "linespacing", Double.toString((double)lineSpacing / (double)20), "name", fieldName, "text", initialText, "align", align, "min-x", Double.toString((double)boundary.getMinX() / (double)20), "min-y", Double.toString((double)boundary.getMinY() / (double)20), "max-x", Double.toString((double)boundary.getMaxX() / (double)20), "max-y", Double.toString((double)boundary.getMaxY() / (double)20), "selectable", (flags & 0x1000) != 0 ? "no" : "yes", "border", (flags & 0x800) != 0 ? "yes" : "no", "html", (flags & 0x200) != 0 ? "yes" : "no", "system-font", (flags & 0x100) != 0 ? "no" : "yes", "wordwrap", (flags & 0x40) != 0 ? "yes" : "no", "multiline", (flags & 0x20) != 0 ? "yes" : "no", "password", (flags & 0x10) != 0 ? "yes" : "no", "read-only", (flags & 8) != 0 ? "yes" : "no"});
        this.writeColor(textColor);
        this.end();
    }

    public SWFText tagDefineText(int id, Rect bounds, Matrix matrix) throws IOException {
        return this.defineText(id, bounds, matrix, false);
    }

    public SWFText tagDefineText2(int id, Rect bounds, Matrix matrix) throws IOException {
        return this.defineText(id, bounds, matrix, true);
    }

    protected SWFText defineText(int id, Rect bounds, Matrix matrix, boolean hasAlpha) throws IOException {
        this.start("text", new String[]{"has-alpha", hasAlpha ? "yes" : "no", "id", Integer.toString(id), "min-x", Double.toString((double)bounds.getMinX() / (double)20), "min-y", Double.toString((double)bounds.getMinY() / (double)20), "max-x", Double.toString((double)bounds.getMaxX() / (double)20), "max-y", Double.toString((double)bounds.getMaxY() / (double)20)});
        this.writeMatrix(matrix);
        return this;
    }

    public SWFActions tagDefineButton(int id, Vector buttonRecords) throws IOException {
        this.start("button", new String[]{"id", Integer.toString(id), "menu", "no"});
        Enumeration e = buttonRecords.elements();
        while (e.hasMoreElements()) {
            ButtonRecord rec = (ButtonRecord)e.nextElement();
            StringBuffer buff = new StringBuffer();
            if (rec.isHitTest()) {
                buff.append("hit");
            }
            if (rec.isOver()) {
                buff.append(" over");
            }
            if (rec.isUp()) {
                buff.append(" up");
            }
            if (rec.isDown()) {
                buff.append(" down");
            }
            this.start("layer", new String[]{"id", Integer.toString(rec.getCharId()), "depth", Integer.toString(rec.getLayer()), "for", buff.toString().trim()});
            Matrix matrix = rec.getMatrix();
            if (matrix != null) {
                this.writeMatrix(matrix);
            }
            this.end();
        }
        this.actionsType = 3;
        return this;
    }

    public void tagButtonCXForm(int buttonId, ColorTransform transform) throws IOException {
        this.start("button-cxform", new String[]{"id", Integer.toString(buttonId)});
        this.writeCXForm(transform);
        this.end();
    }

    public SWFActions tagDefineButton2(int id, boolean trackAsMenu, Vector buttonRecord2s) throws IOException {
        this.start("button", new String[]{"id", Integer.toString(id), "menu", trackAsMenu ? "yes" : "no"});
        Enumeration e = buttonRecord2s.elements();
        while (e.hasMoreElements()) {
            ButtonRecord2 rec = (ButtonRecord2)e.nextElement();
            StringBuffer buff = new StringBuffer();
            if (rec.isHitTest()) {
                buff.append("hit");
            }
            if (rec.isOver()) {
                buff.append(" over");
            }
            if (rec.isUp()) {
                buff.append(" up");
            }
            if (rec.isDown()) {
                buff.append(" down");
            }
            this.start("layer", new String[]{"id", Integer.toString(rec.getCharId()), "depth", Integer.toString(rec.getLayer()), "for", buff.toString().trim()});
            Matrix matrix = rec.getMatrix();
            AlphaTransform cxform = rec.getTransform();
            if (matrix != null) {
                this.writeMatrix(matrix);
            }
            if (cxform != null) {
                this.writeCXForm(cxform);
            }
            this.end();
        }
        this.actionsType = 3;
        return this;
    }

    public void tagExport(String[] names, int[] ids) throws IOException {
        this.start("export", null);
        for (int i = 0; i < names.length; ++i) {
            this.element("symbol", new String[]{"name", names[i], "id", Integer.toString(ids[i])});
        }
        this.end();
    }

    public void tagImport(String movieName, String[] names, int[] ids) throws IOException {
        this.start("import", new String[]{"movie", movieName});
        for (int i = 0; i < names.length; ++i) {
            this.element("symbol", new String[]{"name", names[i], "id", Integer.toString(ids[i])});
        }
        this.end();
    }

    public void tagDefineQuickTimeMovie(int id, String filename) throws IOException {
        this.element("quicktime-movie", new String[]{"id", Integer.toString(id), "name", filename});
    }

    public void tagDefineBitsJPEG2(int id, byte[] data) throws IOException {
        this.start("jpeg", new String[]{"id", Integer.toString(id)});
        this.start("image", null);
        this.text(Base64.encode(data));
        this.end();
        this.end();
    }

    public void tagDefineBitsJPEG2(int id, InputStream jpegImage) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutStream out = new OutStream(bout);
        out.writeUI8(255);
        out.writeUI8(217);
        out.writeUI8(255);
        out.writeUI8(216);
        int read = 0;
        byte[] bytes = new byte[10000];
        while ((read = jpegImage.read(bytes)) >= 0) {
            out.write(bytes, 0, read);
        }
        jpegImage.close();
        this.tagDefineBitsJPEG2(id, bout.toByteArray());
    }

    public SWFShape tagDefineMorphShape(int id, Rect startBounds, Rect endBounds) throws IOException {
        this.start("morph", new String[]{"id", Integer.toString(id)});
        this.start("shape", new String[]{"min-x", Double.toString((double)startBounds.getMinX() / (double)20), "min-y", Double.toString((double)startBounds.getMinY() / (double)20), "max-x", Double.toString((double)startBounds.getMaxX() / (double)20), "max-y", Double.toString((double)startBounds.getMaxY() / (double)20)});
        this.morphEndRect = endBounds;
        this.morph = true;
        return this;
    }

    public void tagDefineBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.defineBitsLossless(id, format, width, height, colors, imageData, false);
    }

    public void tagDefineBitsLossless2(int id, int format, int width, int height, Color[] colors, byte[] imageData) throws IOException {
        this.defineBitsLossless(id, format, width, height, colors, imageData, true);
    }

    public void defineBitsLossless(int id, int format, int width, int height, Color[] colors, byte[] imageData, boolean hasAlpha) throws IOException {
        String bits = null;
        bits = format == 3 ? "8" : (format == 4 ? "16" : "32");
        this.start("bitmap", new String[]{"id", Integer.toString(id), "width", Integer.toString(width), "height", Integer.toString(height), "has-alpha", hasAlpha ? "yes" : "no", "bits", bits});
        if (colors != null && colors.length > 0) {
            this.start("colors", null);
            for (int i = 0; i < colors.length; ++i) {
                this.writeColor(colors[i]);
            }
            this.end();
        }
        this.start("pixels", null);
        this.text(Base64.encode(imageData));
        this.end();
        this.end();
    }

    public void done() throws IOException {
        if (this.actionsType == 1) {
            this.actionsType = 0;
            return;
        }
        this.actionsType = 0;
        this.end();
        if (this.morph) {
            if (this.morphEndRect != null) {
                this.start("shape", new String[]{"min-x", Double.toString((double)this.morphEndRect.getMinX() / (double)20), "min-y", Double.toString((double)this.morphEndRect.getMinY() / (double)20), "max-x", Double.toString((double)this.morphEndRect.getMaxX() / (double)20), "max-y", Double.toString((double)this.morphEndRect.getMaxY() / (double)20)});
                this.morphEndRect = null;
            } else {
                this.end();
                this.morph = false;
            }
            return;
        }
        if (this.glyphCount > 0) {
            if (this.glyphCount == 1) {
                this.glyphCount = 0;
                this.glyphRects = null;
                this.glyphAdvances = null;
                this.glyphCodes = null;
                this.end();
            } else if (this.glyphRects == null) {
                this.start("glyph", null);
            } else {
                int idx = this.glyphRects.length - this.glyphCount + 1;
                Rect bound = this.glyphRects[idx];
                int advance = 0;
                if (this.glyphAdvances != null && this.glyphAdvances.length >= 1) {
                    advance = this.glyphAdvances[idx];
                }
                this.start("glyph", new String[]{"code", Integer.toString(this.glyphCodes[idx]), "advance", Double.toString((double)advance / (double)20), "min-x", Double.toString((double)bound.getMinX() / (double)20), "min-y", Double.toString((double)bound.getMinY() / (double)20), "max-x", Double.toString((double)bound.getMaxX() / (double)20), "max-y", Double.toString((double)bound.getMaxY() / (double)20)});
            }
            --this.glyphCount;
        }
    }

    public void line(int dx, int dy) throws IOException {
        this.element("line", new String[]{"dx", Double.toString((double)dx / (double)20), "dy", Double.toString((double)dy / (double)20)});
    }

    public void curve(int cx, int cy, int dx, int dy) throws IOException {
        this.element("curve", new String[]{"cx", Double.toString((double)cx / (double)20), "cy", Double.toString((double)cy / (double)20), "dx", Double.toString((double)dx / (double)20), "dy", Double.toString((double)dy / (double)20)});
    }

    public void move(int x, int y) throws IOException {
        this.element("move", new String[]{"x", Double.toString((double)x / (double)20), "y", Double.toString((double)y / (double)20)});
    }

    public void setFillStyle0(int styleIndex) throws IOException {
        if (this.glyphCount > 0) {
            this.element("anticlockwise", null);
            return;
        }
        this.element("set-primary-fill", new String[]{"index", Integer.toString(styleIndex)});
    }

    public void setFillStyle1(int styleIndex) throws IOException {
        if (this.glyphCount > 0) {
            return;
        }
        this.element("set-secondary-fill", new String[]{"index", Integer.toString(styleIndex)});
    }

    public void setLineStyle(int styleIndex) throws IOException {
        if (this.glyphCount > 0) {
            return;
        }
        this.element("set-line-style", new String[]{"index", Integer.toString(styleIndex)});
    }

    public void defineFillStyle(Color color) throws IOException {
        this.start("color-fill", null);
        this.writeColor(color);
        this.end();
    }

    public void defineFillStyle(Matrix matrix, int[] ratios, Color[] colors, boolean radial) throws IOException {
        this.start("gradient-fill", new String[]{"radial", radial ? "yes" : "no"});
        this.writeMatrix(matrix);
        this.start("gradient", null);
        for (int i = 0; i < ratios.length; ++i) {
            this.start("step", new String[]{"ratio", Integer.toString(ratios[i])});
            this.writeColor(colors[i]);
            this.end();
        }
        this.end();
        this.end();
    }

    public void defineFillStyle(int bitmapId, Matrix matrix, boolean clipped) throws IOException {
        this.start("image-fill", new String[]{"clipped", clipped ? "yes" : "no", "image-id", Integer.toString(bitmapId)});
        this.writeMatrix(matrix);
        this.end();
    }

    public void defineLineStyle(int width, Color color) throws IOException {
        this.start("line-style", new String[]{"width", Double.toString((double)width / (double)20)});
        this.writeColor(color);
        this.end();
    }

    protected void writeMatrix(Matrix matrix) throws IOException {
        this.element("matrix", new String[]{"skew0", Double.toString(matrix.getSkew0()), "skew1", Double.toString(matrix.getSkew1()), "scale-x", Double.toString(matrix.getScaleX()), "scale-y", Double.toString(matrix.getScaleY()), "x", Double.toString(matrix.getTranslateX() / (double)20), "y", Double.toString(matrix.getTranslateY() / (double)20)});
    }

    protected void writeColor(Color color) throws IOException {
        if (color instanceof AlphaColor) {
            AlphaColor acolor = (AlphaColor)color;
            this.element("color", new String[]{"red", Integer.toString(acolor.getRed()), "green", Integer.toString(acolor.getGreen()), "blue", Integer.toString(acolor.getBlue()), "alpha", Integer.toString(acolor.getAlpha())});
        } else {
            this.element("color", new String[]{"red", Integer.toString(color.getRed()), "green", Integer.toString(color.getGreen()), "blue", Integer.toString(color.getBlue())});
        }
    }

    protected void writeCXForm(ColorTransform cxform) throws IOException {
        Vector<String> attrs = new Vector<String>();
        int addRed = cxform.getAddRed();
        int addGreen = cxform.getAddGreen();
        int addBlue = cxform.getAddBlue();
        double multRed = cxform.getMultRed();
        double multGreen = cxform.getMultGreen();
        double multBlue = cxform.getMultBlue();
        if (addRed != 0) {
            attrs.add("add-red");
            attrs.add(Integer.toString(addRed));
        }
        if (addGreen != 0) {
            attrs.add("add-green");
            attrs.add(Integer.toString(addGreen));
        }
        if (addBlue != 0) {
            attrs.add("add-blue");
            attrs.add(Integer.toString(addBlue));
        }
        if (multRed != 1.0) {
            attrs.add("mult-red");
            attrs.add(Double.toString(multRed));
        }
        if (multGreen != 1.0) {
            attrs.add("mult-green");
            attrs.add(Double.toString(multGreen));
        }
        if (multBlue != 1.0) {
            attrs.add("mult-blue");
            attrs.add(Double.toString(multBlue));
        }
        if (cxform instanceof AlphaTransform) {
            AlphaTransform axform = (AlphaTransform)cxform;
            int addAlpha = axform.getAddAlpha();
            double multAlpha = axform.getMultAlpha();
            if (addAlpha != 0) {
                attrs.add("add-alpha");
                attrs.add(Integer.toString(addAlpha));
            }
            if (multAlpha != 1.0) {
                attrs.add("mult-alpha");
                attrs.add(Double.toString(multAlpha));
            }
        }
        Object[] attributes = new String[attrs.size()];
        attrs.copyInto(attributes);
        this.element("color-transform", (String[])attributes);
    }

    public void start(int flags) throws IOException {
        String[] attrs = null;
        if (this.actionsType != 1) {
            if (this.actionsType == 2) {
                StringBuffer conds = new StringBuffer();
                if ((flags & 1) > 0) {
                    conds.append("load");
                }
                if ((flags & 2) > 0) {
                    conds.append(" enter-frame");
                }
                if ((flags & 4) > 0) {
                    conds.append(" unload");
                }
                if ((flags & 8) > 0) {
                    conds.append(" mouse-move");
                }
                if ((flags & 0x10) > 0) {
                    conds.append(" mouse-down");
                }
                if ((flags & 0x20) > 0) {
                    conds.append(" mouse-up");
                }
                if ((flags & 0x40) > 0) {
                    conds.append(" key-down");
                }
                if ((flags & 0x80) > 0) {
                    conds.append(" key-up");
                }
                if ((flags & 0x100) > 0) {
                    conds.append(" data");
                }
                String conditions = conds.toString().trim();
                attrs = new String[]{"conditions", conditions};
            } else if (this.actionsType == 3) {
                StringBuffer conds = new StringBuffer();
                if (flags == 0) {
                    flags = 8;
                }
                if ((flags & 0x100) > 0) {
                    conds.append("menu-drag-out");
                }
                if ((flags & 0x80) > 0) {
                    conds.append(" menu-drag-over");
                }
                if ((flags & 0x40) > 0) {
                    conds.append(" release-outside");
                }
                if ((flags & 0x20) > 0) {
                    conds.append(" drag-over");
                }
                if ((flags & 0x10) > 0) {
                    conds.append(" drag-out");
                }
                if ((flags & 8) > 0) {
                    conds.append(" release");
                }
                if ((flags & 4) > 0) {
                    conds.append(" press");
                }
                if ((flags & 2) > 0) {
                    conds.append(" roll-out");
                }
                if ((flags & 1) > 0) {
                    conds.append(" roll-over");
                }
                String conditions = conds.toString().trim();
                if ((flags & 0xFE00) > 0) {
                    int charcode = (flags & 0xFE00) >> 9;
                    attrs = new String[]{"conditions", conditions, "char-code", Integer.toString(charcode)};
                } else {
                    attrs = new String[]{"conditions", conditions};
                }
            }
        }
        this.start("actions", attrs);
    }

    public void end() throws IOException {
        super.end();
    }

    public void blob(byte[] blob) throws IOException {
    }

    public void unknown(int code, byte[] data) throws IOException {
        this.start("unknown", new String[]{"code", Integer.toString(code)});
        this.text(Base64.encode(data));
        this.end();
    }

    public void jumpLabel(String label) throws IOException {
        this.element("jump-label", new String[]{"label", label});
    }

    public void comment(String comment) throws IOException {
        this.start("comment", null);
        this.text(comment);
        this.end();
    }

    public void gotoFrame(int frameNumber) throws IOException {
        this.element("goto-frame", new String[]{"number", Integer.toString(frameNumber)});
    }

    public void gotoFrame(String label) throws IOException {
        this.element("goto-frame", new String[]{"label", label});
    }

    public void getURL(String url, String target) throws IOException {
        this.element("get-url", new String[]{"url", url, "target", target});
    }

    public void nextFrame() throws IOException {
        this.element("next-frame", null);
    }

    public void prevFrame() throws IOException {
        this.element("prev-frame", null);
    }

    public void play() throws IOException {
        this.element("play", null);
    }

    public void stop() throws IOException {
        this.element("stop", null);
    }

    public void toggleQuality() throws IOException {
        this.element("toggle-quality", null);
    }

    public void stopSounds() throws IOException {
        this.element("stop-sounds", null);
    }

    public void waitForFrame(int frameNumber, String jumpLabel) throws IOException {
        this.element("wait-for-frame", new String[]{"number", Integer.toString(frameNumber), "jump-label", jumpLabel});
    }

    public void setTarget(String target) throws IOException {
        this.element("set-target", new String[]{"target", target});
    }

    public void push(String value) throws IOException {
        this.element("push", new String[]{"string", value});
    }

    public void push(float value) throws IOException {
        this.element("push", new String[]{"float", Float.toString(value)});
    }

    public void pop() throws IOException {
        this.element("pop", null);
    }

    public void add() throws IOException {
        this.element("add", null);
    }

    public void substract() throws IOException {
        this.element("subtract", null);
    }

    public void multiply() throws IOException {
        this.element("multiply", null);
    }

    public void divide() throws IOException {
        this.element("divide", null);
    }

    public void equals() throws IOException {
        this.element("equals", null);
    }

    public void lessThan() throws IOException {
        this.element("less-than", null);
    }

    public void and() throws IOException {
        this.element("and", null);
    }

    public void or() throws IOException {
        this.element("or", null);
    }

    public void not() throws IOException {
        this.element("not", null);
    }

    public void stringEquals() throws IOException {
        this.element("string-equals", null);
    }

    public void stringLength() throws IOException {
        this.element("string-length", null);
    }

    public void concat() throws IOException {
        this.element("concat", null);
    }

    public void substring() throws IOException {
        this.element("substring", null);
    }

    public void stringLessThan() throws IOException {
        this.element("string-less-than", null);
    }

    public void stringLengthMB() throws IOException {
        this.element("mutlibyte-string-length", null);
    }

    public void substringMB() throws IOException {
        this.element("multibyte-substring", null);
    }

    public void toInteger() throws IOException {
        this.element("to-integer", null);
    }

    public void charToAscii() throws IOException {
        this.element("char-to-ascii", null);
    }

    public void asciiToChar() throws IOException {
        this.element("ascii-to-char", null);
    }

    public void charMBToAscii() throws IOException {
        this.element("mutlibyte-char-to-ascii", null);
    }

    public void asciiToCharMB() throws IOException {
        this.element("ascii-to-multibyte-char", null);
    }

    public void jump(String jumpLabel) throws IOException {
        this.element("jump", new String[]{"jump-label", jumpLabel});
    }

    public void ifJump(String jumpLabel) throws IOException {
        this.element("if", new String[]{"jump-label", jumpLabel});
    }

    public void call() throws IOException {
        this.element("call", null);
    }

    public void getVariable() throws IOException {
        this.element("get-variable", null);
    }

    public void setVariable() throws IOException {
        this.element("set-variable", null);
    }

    public void getURL(int sendVars, int loadMode) throws IOException {
        String method = "none";
        if (sendVars == 1) {
            method = "get";
        } else if (sendVars == 2) {
            method = "post";
        }
        String mode = null;
        String target = null;
        if (loadMode == 1) {
            mode = "yes";
            target = "target-sprite";
        } else if (loadMode == 3) {
            mode = "level";
            target = "load-vars-into";
        } else if (loadMode == 4) {
            mode = "sprite";
            target = "load-vars-into";
        }
        this.element("get-url", new String[]{"send-vars", method, target, mode});
    }

    public void gotoFrame(boolean play) throws IOException {
        this.element("goto-frame", new String[]{"play", play ? "yes" : "no"});
    }

    public void setTarget() throws IOException {
        this.element("set-target", null);
    }

    public void getProperty() throws IOException {
        this.element("get-property", null);
    }

    public void setProperty() throws IOException {
        this.element("set-property", null);
    }

    public void cloneSprite() throws IOException {
        this.element("clone-sprite", null);
    }

    public void removeSprite() throws IOException {
        this.element("remove-sprite", null);
    }

    public void startDrag() throws IOException {
        this.element("start-drag", null);
    }

    public void endDrag() throws IOException {
        this.element("end-drag", null);
    }

    public void waitForFrame(String jumpLabel) throws IOException {
        this.element("wait-for-frame", new String[]{"jump-label", jumpLabel});
    }

    public void trace() throws IOException {
        this.element("trace", null);
    }

    public void getTime() throws IOException {
        this.element("get-time", null);
    }

    public void randomNumber() throws IOException {
        this.element("random-number", null);
    }

    public void callFunction() throws IOException {
        this.element("call-function", null);
    }

    public void callMethod() throws IOException {
        this.element("call-method", null);
    }

    public void lookupTable(String[] values) throws IOException {
        this.start("lookup-table", null);
        for (int i = 0; i < values.length; ++i) {
            this.start("value", null);
            this.text(values[i]);
            this.end();
        }
        this.end();
    }

    public void startFunction(String name, String[] paramNames) throws IOException {
        StringBuffer parms = new StringBuffer();
        for (int i = 0; i < paramNames.length; ++i) {
            parms.append(" ");
            parms.append(paramNames[i]);
        }
        this.start("function", new String[]{"name", name, "params", parms.toString().trim()});
    }

    public void endBlock() throws IOException {
        this.end();
    }

    public void defineLocalValue() throws IOException {
        this.element("define-local-value", null);
    }

    public void defineLocal() throws IOException {
        this.element("define-local", null);
    }

    public void deleteProperty() throws IOException {
        this.element("delete-property", null);
    }

    public void deleteThreadVars() throws IOException {
        this.element("delete-thread-vars", null);
    }

    public void enumerate() throws IOException {
        this.element("enumerate", null);
    }

    public void typedEquals() throws IOException {
        this.element("typed-equals", null);
    }

    public void getMember() throws IOException {
        this.element("get-member", null);
    }

    public void initArray() throws IOException {
        this.element("init-array", null);
    }

    public void initObject() throws IOException {
        this.element("init-object", null);
    }

    public void newMethod() throws IOException {
        this.element("new-method", null);
    }

    public void newObject() throws IOException {
        this.element("new-object", null);
    }

    public void setMember() throws IOException {
        this.element("set-member", null);
    }

    public void getTargetPath() throws IOException {
        this.element("get-target-path", null);
    }

    public void startWith() throws IOException {
        this.start("with", null);
    }

    public void convertToNumber() throws IOException {
        this.element("to-number", null);
    }

    public void convertToString() throws IOException {
        this.element("to-string", null);
    }

    public void typeOf() throws IOException {
        this.element("type-of", null);
    }

    public void typedAdd() throws IOException {
        this.element("typed-add", null);
    }

    public void typedLessThan() throws IOException {
        this.element("typed-less-than", null);
    }

    public void modulo() throws IOException {
        this.element("modulo", null);
    }

    public void bitAnd() throws IOException {
        this.element("bit-and", null);
    }

    public void bitOr() throws IOException {
        this.element("bit-or", null);
    }

    public void bitXor() throws IOException {
        this.element("bit-xor", null);
    }

    public void shiftLeft() throws IOException {
        this.element("shift-left", null);
    }

    public void shiftRight() throws IOException {
        this.element("shift-right", null);
    }

    public void shiftRightUnsigned() throws IOException {
        this.element("shift-right-unsigned", null);
    }

    public void decrement() throws IOException {
        this.element("decrement", null);
    }

    public void increment() throws IOException {
        this.element("increment", null);
    }

    public void duplicate() throws IOException {
        this.element("duplicate", null);
    }

    public void returnValue() throws IOException {
        this.element("return", null);
    }

    public void swap() throws IOException {
        this.element("swap", null);
    }

    public void storeInRegister(int registerNumber) throws IOException {
        this.element("store", new String[]{"register", Integer.toString(registerNumber)});
    }

    public void push(double value) throws IOException {
        this.element("push", new String[]{"double", Double.toString(value)});
    }

    public void pushNull() throws IOException {
        this.element("push", null);
    }

    public void pushRegister(int registerNumber) throws IOException {
        this.element("push", new String[]{"register", Integer.toString(registerNumber)});
    }

    public void push(boolean value) throws IOException {
        this.element("push", new String[]{"boolean", "".concat(String.valueOf(String.valueOf(value)))});
    }

    public void push(int value) throws IOException {
        this.element("push", new String[]{"int", Integer.toString(value)});
    }

    public void lookup(int dictionaryIndex) throws IOException {
        this.element("push", new String[]{"lookup", Integer.toString(dictionaryIndex)});
    }

    public void font(int fontId, int textHeight) throws IOException {
        this.element("set-font", new String[]{"id", Integer.toString(fontId), "size", Double.toString((double)textHeight / (double)20)});
    }

    public void color(Color color) throws IOException {
        this.writeColor(color);
    }

    public void setX(int x) throws IOException {
        this.element("set-x", new String[]{"x", Double.toString((double)x / (double)20)});
    }

    public void setY(int y) throws IOException {
        this.element("set-y", new String[]{"y", Double.toString((double)y / (double)20)});
    }

    public void text(int[] glyphIndices, int[] glyphAdvances) throws IOException {
        for (int i = 0; i < glyphIndices.length; ++i) {
            this.element("char", new String[]{"glyph-index", Integer.toString(glyphIndices[i]), "advance", Double.toString((double)glyphAdvances[i] / (double)20)});
        }
    }

    public static void main(String[] args) throws Exception {
        FileOutputStream out = new FileOutputStream(args[1]);
        XMLWriter writer = new XMLWriter(out);
        SWFSaxParser parser = new SWFSaxParser(writer, writer);
        parser.parse(args[0]);
        ((OutputStream)out).close();
    }

    static {
        NAMESPACE = NAMESPACE;
    }
}

