/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.io.InStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ActionParser
implements SWFActionCodes {
    protected SWFActions actions;
    protected int blockDepth = 0;

    public ActionParser(SWFActions actions) {
        this.actions = actions;
    }

    public synchronized void parse(byte[] bytes) throws IOException {
        Vector records = this.createRecords(bytes);
        this.processRecords(records);
    }

    public synchronized void parse(InStream in) throws IOException {
        Vector records = this.createRecords(in);
        this.processRecords(records);
    }

    protected void processRecords(Vector records) throws IOException {
        Enumeration enumeration = records.elements();
        block91: while (enumeration.hasMoreElements()) {
            ActionRecord rec = (ActionRecord)enumeration.nextElement();
            if (rec.blockDepth < this.blockDepth) {
                --this.blockDepth;
                this.actions.endBlock();
            }
            if (rec.label != null) {
                this.actions.jumpLabel(rec.label);
            }
            int code = rec.code;
            byte[] data = rec.data;
            InStream in = data != null && data.length > 0 ? new InStream(data) : null;
            switch (code) {
                case 0: {
                    this.actions.end();
                    continue block91;
                }
                case 129: {
                    this.actions.gotoFrame(in.readUI16());
                    continue block91;
                }
                case 131: {
                    this.actions.getURL(in.readString(), in.readString());
                    continue block91;
                }
                case 4: {
                    this.actions.nextFrame();
                    continue block91;
                }
                case 5: {
                    this.actions.prevFrame();
                    continue block91;
                }
                case 6: {
                    this.actions.play();
                    continue block91;
                }
                case 7: {
                    this.actions.stop();
                    continue block91;
                }
                case 8: {
                    this.actions.toggleQuality();
                    continue block91;
                }
                case 9: {
                    this.actions.stopSounds();
                    continue block91;
                }
                case 138: {
                    this.actions.waitForFrame(in.readUI16(), rec.jumpLabel);
                    continue block91;
                }
                case 139: {
                    this.actions.setTarget(in.readString());
                    continue block91;
                }
                case 140: {
                    this.actions.gotoFrame(in.readString());
                    continue block91;
                }
                case 157: {
                    this.actions.ifJump(rec.jumpLabel);
                    continue block91;
                }
                case 153: {
                    this.actions.jump(rec.jumpLabel);
                    continue block91;
                }
                case 141: {
                    this.actions.waitForFrame(rec.jumpLabel);
                    continue block91;
                }
                case 23: {
                    this.actions.pop();
                    continue block91;
                }
                case 150: {
                    this.parsePush(data.length, in);
                    continue block91;
                }
                case 10: {
                    this.actions.add();
                    continue block91;
                }
                case 11: {
                    this.actions.substract();
                    continue block91;
                }
                case 12: {
                    this.actions.multiply();
                    continue block91;
                }
                case 13: {
                    this.actions.divide();
                    continue block91;
                }
                case 14: {
                    this.actions.equals();
                    continue block91;
                }
                case 15: {
                    this.actions.lessThan();
                    continue block91;
                }
                case 16: {
                    this.actions.and();
                    continue block91;
                }
                case 17: {
                    this.actions.or();
                    continue block91;
                }
                case 18: {
                    this.actions.not();
                    continue block91;
                }
                case 19: {
                    this.actions.stringEquals();
                    continue block91;
                }
                case 20: {
                    this.actions.stringLength();
                    continue block91;
                }
                case 33: {
                    this.actions.concat();
                    continue block91;
                }
                case 21: {
                    this.actions.substring();
                    continue block91;
                }
                case 41: {
                    this.actions.stringLessThan();
                    continue block91;
                }
                case 53: {
                    this.actions.substringMB();
                    continue block91;
                }
                case 49: {
                    this.actions.stringLengthMB();
                    continue block91;
                }
                case 24: {
                    this.actions.toInteger();
                    continue block91;
                }
                case 50: {
                    this.actions.charToAscii();
                    continue block91;
                }
                case 51: {
                    this.actions.asciiToChar();
                    continue block91;
                }
                case 54: {
                    this.actions.charMBToAscii();
                    continue block91;
                }
                case 55: {
                    this.actions.asciiToCharMB();
                    continue block91;
                }
                case 158: {
                    this.actions.call();
                    continue block91;
                }
                case 28: {
                    this.actions.getVariable();
                    continue block91;
                }
                case 29: {
                    this.actions.setVariable();
                    continue block91;
                }
                case 154: {
                    this.parseGetURL2(in.readUI8());
                    continue block91;
                }
                case 159: {
                    this.actions.gotoFrame(in.readUI8() != 0);
                    continue block91;
                }
                case 32: {
                    this.actions.setTarget();
                    continue block91;
                }
                case 34: {
                    this.actions.getProperty();
                    continue block91;
                }
                case 35: {
                    this.actions.setProperty();
                    continue block91;
                }
                case 36: {
                    this.actions.cloneSprite();
                    continue block91;
                }
                case 37: {
                    this.actions.removeSprite();
                    continue block91;
                }
                case 39: {
                    this.actions.startDrag();
                    continue block91;
                }
                case 40: {
                    this.actions.endDrag();
                    continue block91;
                }
                case 38: {
                    this.actions.trace();
                    continue block91;
                }
                case 52: {
                    this.actions.getTime();
                    continue block91;
                }
                case 48: {
                    this.actions.randomNumber();
                    continue block91;
                }
                case 66: {
                    this.actions.initArray();
                    continue block91;
                }
                case 136: {
                    this.parseLookupTable(in);
                    continue block91;
                }
                case 61: {
                    this.actions.callFunction();
                    continue block91;
                }
                case 82: {
                    this.actions.callMethod();
                    continue block91;
                }
                case 155: {
                    this.parseDefineFunction(in);
                    continue block91;
                }
                case 60: {
                    this.actions.defineLocalValue();
                    continue block91;
                }
                case 65: {
                    this.actions.defineLocal();
                    continue block91;
                }
                case 58: {
                    this.actions.deleteProperty();
                    continue block91;
                }
                case 59: {
                    this.actions.deleteThreadVars();
                    continue block91;
                }
                case 70: {
                    this.actions.enumerate();
                    continue block91;
                }
                case 73: {
                    this.actions.typedEquals();
                    continue block91;
                }
                case 78: {
                    this.actions.getMember();
                    continue block91;
                }
                case 67: {
                    this.actions.initObject();
                    continue block91;
                }
                case 83: {
                    this.actions.newMethod();
                    continue block91;
                }
                case 64: {
                    this.actions.newObject();
                    continue block91;
                }
                case 79: {
                    this.actions.setMember();
                    continue block91;
                }
                case 69: {
                    this.actions.getTargetPath();
                    continue block91;
                }
                case 148: {
                    this.parseWith(in);
                    continue block91;
                }
                case 76: {
                    this.actions.duplicate();
                    continue block91;
                }
                case 62: {
                    this.actions.returnValue();
                    continue block91;
                }
                case 77: {
                    this.actions.swap();
                    continue block91;
                }
                case 135: {
                    this.actions.storeInRegister(in.readUI8());
                    continue block91;
                }
                case 63: {
                    this.actions.modulo();
                    continue block91;
                }
                case 68: {
                    this.actions.typeOf();
                    continue block91;
                }
                case 71: {
                    this.actions.typedAdd();
                    continue block91;
                }
                case 72: {
                    this.actions.typedLessThan();
                    continue block91;
                }
                case 74: {
                    this.actions.convertToNumber();
                    continue block91;
                }
                case 75: {
                    this.actions.convertToString();
                    continue block91;
                }
                case 80: {
                    this.actions.increment();
                    continue block91;
                }
                case 81: {
                    this.actions.decrement();
                    continue block91;
                }
                case 96: {
                    this.actions.bitAnd();
                    continue block91;
                }
                case 97: {
                    this.actions.bitOr();
                    continue block91;
                }
                case 98: {
                    this.actions.bitXor();
                    continue block91;
                }
                case 99: {
                    this.actions.shiftLeft();
                    continue block91;
                }
                case 100: {
                    this.actions.shiftRight();
                    continue block91;
                }
                case 101: {
                    this.actions.shiftRightUnsigned();
                    continue block91;
                }
            }
            this.actions.unknown(code, data);
        }
    }

    protected void parseDefineFunction(InStream in) throws IOException {
        String name = in.readString();
        int paramCount = in.readUI16();
        String[] params = new String[paramCount];
        for (int i = 0; i < params.length; ++i) {
            params[i] = in.readString();
        }
        int codesize = in.readUI16();
        this.actions.startFunction(name, params);
        ++this.blockDepth;
    }

    protected void parseWith(InStream in) throws IOException {
        int codesize = in.readUI16();
        this.actions.startWith();
        ++this.blockDepth;
    }

    protected void parseLookupTable(InStream in) throws IOException {
        String[] strings = new String[in.readUI16()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = in.readString();
        }
        this.actions.lookupTable(strings);
    }

    protected void parseGetURL2(int flags) throws IOException {
        int sendVars = flags & 3;
        int mode = 0;
        switch (flags & 0xF0) {
            case 64: {
                mode = 1;
                break;
            }
            case 128: {
                mode = 3;
                break;
            }
            case 192: {
                mode = 4;
                break;
            }
            default: {
                mode = 0;
            }
        }
        this.actions.getURL(sendVars, mode);
    }

    protected void parsePush(int length, InStream in) throws IOException {
        block11: while (in.getBytesRead() < (long)length) {
            int pushType = in.readUI8();
            switch (pushType) {
                case 0: {
                    this.actions.push(in.readString());
                    continue block11;
                }
                case 1: {
                    this.actions.push(in.readFloat());
                    continue block11;
                }
                case 2: {
                    this.actions.pushNull();
                    continue block11;
                }
                case 3: {
                    continue block11;
                }
                case 4: {
                    this.actions.pushRegister(in.readUI8());
                    continue block11;
                }
                case 5: {
                    this.actions.push(in.readUI8() != 0);
                    continue block11;
                }
                case 6: {
                    this.actions.push(in.readDouble());
                    continue block11;
                }
                case 7: {
                    this.actions.push(in.readSI32());
                    continue block11;
                }
                case 8: {
                    this.actions.lookup(in.readUI8());
                    continue block11;
                }
            }
        }
    }

    protected Vector createRecords(byte[] bytes) throws IOException {
        return this.createRecords(new InStream(bytes));
    }

    protected Vector createRecords(InStream in) throws IOException {
        Vector<ActionRecord> records = new Vector<ActionRecord>();
        Vector<ActionRecord> jumpers = new Vector<ActionRecord>();
        Vector<Integer> skippers = new Vector<Integer>();
        Hashtable<Integer, ActionRecord> offsetTable = new Hashtable<Integer, ActionRecord>();
        Stack<int[]> blockSizes = new Stack<int[]>();
        int labelIndex = 0;
        while (true) {
            int i;
            int offset = (int)in.getBytesRead();
            int code = in.readUI8();
            int dataLength = code >= 128 ? in.readUI16() : 0;
            byte[] data = dataLength > 0 ? in.read(dataLength) : null;
            ActionRecord rec = new ActionRecord(offset, code, data);
            records.addElement(rec);
            offsetTable.put(new Integer(offset), rec);
            if (!blockSizes.isEmpty()) {
                int depth;
                rec.blockDepth = depth = blockSizes.size();
                int blockDecrement = dataLength > 0 ? dataLength + 3 : 1;
                for (i = depth - 1; i >= 0; --i) {
                    int[] blockSize = (int[])blockSizes.elementAt(i);
                    int size = blockSize[0];
                    if ((size -= blockDecrement) <= 0) {
                        blockSizes.pop();
                        continue;
                    }
                    blockSize[0] = size;
                }
            }
            if (code == 0) break;
            if (code == 155) {
                InStream in2 = new InStream(rec.data);
                in2.readString();
                int params = in2.readUI16();
                for (i = 0; i < params; ++i) {
                    in2.readString();
                }
                int blockSize = in2.readUI16();
                blockSizes.push(new int[]{blockSize});
                continue;
            }
            if (code == 148) {
                InStream in2 = new InStream(rec.data);
                int blockSize = in2.readUI16();
                blockSizes.push(new int[]{blockSize});
                continue;
            }
            if (code == 138 || code == 141) {
                skippers.addElement(new Integer(records.size() - 1));
                continue;
            }
            if (code != 157 && code != 153) continue;
            jumpers.addElement(rec);
        }
        Enumeration enumeration = jumpers.elements();
        while (enumeration.hasMoreElements()) {
            ActionRecord rec = (ActionRecord)enumeration.nextElement();
            int offset = rec.offset + 5;
            InStream in2 = new InStream(rec.data);
            short jumpOffset = in2.readSI16();
            int absoluteOffset = offset + jumpOffset;
            ActionRecord target = (ActionRecord)offsetTable.get(new Integer(absoluteOffset));
            if (target == null) continue;
            if (target.label == null) {
                target.label = rec.jumpLabel = "label".concat(String.valueOf(String.valueOf(labelIndex++)));
                continue;
            }
            rec.jumpLabel = target.label;
        }
        enumeration = skippers.elements();
        while (enumeration.hasMoreElements()) {
            int skip;
            int skipIndex;
            int idx = (Integer)enumeration.nextElement();
            ActionRecord rec = (ActionRecord)records.elementAt(idx);
            InStream in2 = new InStream(rec.data);
            if (rec.code == 138) {
                in2.readUI16();
            }
            if ((skipIndex = idx + (skip = in2.readUI8()) + 1) >= records.size()) continue;
            ActionRecord target = (ActionRecord)records.elementAt(skipIndex);
            if (target.label == null) {
                target.label = rec.jumpLabel = "label".concat(String.valueOf(String.valueOf(labelIndex++)));
                continue;
            }
            rec.jumpLabel = target.label;
        }
        return records;
    }

    protected static class ActionRecord {
        public int offset;
        public int code;
        public String label;
        public String jumpLabel;
        public byte[] data;
        public int blockDepth = 0;

        protected ActionRecord(int offset, int code, byte[] data) {
            this.offset = offset;
            this.code = code;
            this.data = data;
        }
    }
}

