/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.movie.Font;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Rect;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class Text
extends Symbol {
    protected boolean hasAlpha;
    protected Transform matrix;
    protected ArrayList rows = new ArrayList();

    public Text(Transform matrix) {
        if (matrix == null) {
            matrix = new Transform();
        }
        this.matrix = matrix;
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public Transform getTransform() {
        return this.matrix;
    }

    public void setTransform(Transform matrix) {
        this.matrix = matrix;
    }

    public Row row(Font.Chars chars, Color color, double x, double y, boolean hasX, boolean hasY) {
        Row row = new Row(chars, color, x, y, hasX, hasY);
        this.rows.add(row);
        return row;
    }

    protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        Font currentFont = null;
        double currentSize = 0.0;
        Color currentColor = null;
        boolean hasAlpha = false;
        double currentX = 0.0;
        double currentY = 0.0;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        Iterator it = ((AbstractList)this.rows).iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Row)) continue;
            Row row = (Row)obj;
            if (row.color != null && row.color instanceof AlphaColor) {
                hasAlpha = true;
            }
            Font font = row.chars.getFont();
            double size = row.chars.getSize();
            if (currentFont == null || font != currentFont) {
                font.define(true, movie, definitionWriter);
            }
            currentFont = font;
            if (row.hasX) {
                currentX = row.x;
            }
            if (row.hasY) {
                currentY = row.y;
            }
            double leftEdge = currentX - row.chars.getLeftMargin();
            double rightEdge = currentX + row.chars.getTotalAdvance() + row.chars.getRightMargin();
            double topEdge = currentY - row.chars.getAscent();
            double bottomEdge = currentY + row.chars.getDescent();
            if (leftEdge < minX) {
                minX = leftEdge;
            }
            if (rightEdge > maxX) {
                maxX = rightEdge;
            }
            if (topEdge < minY) {
                minY = topEdge;
            }
            if (bottomEdge > maxY) {
                maxY = bottomEdge;
            }
            currentX += row.chars.getTotalAdvance();
        }
        int id = this.getNextId(movie);
        Rect bounds = new Rect((int)(minX * (double)20), (int)(minY * (double)20), (int)(maxX * (double)20), (int)(maxY * (double)20));
        SWFText text = hasAlpha ? definitionWriter.tagDefineText2(id, bounds, this.matrix) : definitionWriter.tagDefineText(id, bounds, this.matrix);
        currentFont = null;
        currentSize = 0.0;
        currentColor = null;
        Iterator it2 = ((AbstractList)this.rows).iterator();
        while (it2.hasNext()) {
            Object obj = it2.next();
            if (!(obj instanceof Row)) continue;
            Row row = (Row)obj;
            Font font = row.chars.getFont();
            double size = row.chars.getSize();
            Color color = row.color;
            boolean changeFont = currentFont == null || font != currentFont || size != currentSize;
            boolean changeColor = currentColor == null || color != null && !color.equals(currentColor);
            row.write(text, changeColor, changeFont);
            if (color == null) continue;
            currentColor = color;
        }
        text.done();
        return id;
    }

    public static class Row {
        protected Font.Chars chars;
        protected double x;
        protected double y;
        protected boolean hasX;
        protected boolean hasY;
        protected Color color;

        public Font.Chars getChars() {
            return this.chars;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean hasX() {
            return this.hasX;
        }

        public boolean hasY() {
            return this.hasY;
        }

        public Row(Font.Chars chars, Color color, double x, double y, boolean hasX, boolean hasY) {
            this.chars = chars;
            this.color = color;
            this.x = x;
            this.y = y;
            this.hasX = hasX;
            this.hasY = hasY;
        }

        protected void write(SWFText text, boolean changeColor, boolean changeFont) throws IOException {
            if (changeFont) {
                Font font = this.chars.getFont();
                int fontid = font.getId();
                text.font(fontid, (int)(this.chars.getSize() * (double)20));
            }
            if (changeColor) {
                text.color(this.color);
            }
            if (this.hasX) {
                text.setX((int)(this.x * (double)20));
            }
            if (this.hasY) {
                text.setY((int)(this.y * (double)20));
            }
            text.text(this.chars.indices, this.chars.advances);
        }
    }
}

