/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Actions;
import com.anotherbigidea.flash.movie.Instance;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.structs.AlphaTransform;
import java.io.IOException;

public class Placement {
    protected boolean isAlteration;
    protected boolean isReplacement;
    protected int frameNumber;
    protected Instance instance;
    protected Transform matrix;
    protected AlphaTransform cxform;
    protected String name;
    protected int ratio = -1;
    protected int clipDepth = -1;
    protected boolean isRemove = false;
    protected Actions[] clipActions;

    public boolean isReplacement() {
        return this.isReplacement;
    }

    public boolean isAlteration() {
        return this.isAlteration;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public Transform getTransform() {
        return this.matrix;
    }

    public AlphaTransform getColorTransform() {
        return this.cxform;
    }

    public String getName() {
        return this.name;
    }

    public int getRatio() {
        return this.ratio;
    }

    public int getClipDepth() {
        return this.clipDepth;
    }

    public boolean isRemove() {
        return this.isRemove;
    }

    public Actions[] getClipActions() {
        return this.clipActions;
    }

    public void setClipActions(Actions[] clipActions) {
        this.clipActions = clipActions;
    }

    protected Placement(Instance instance, int frameNumber) {
        this.instance = instance;
        this.frameNumber = frameNumber;
        this.isRemove = true;
    }

    protected Placement(Instance instance, Transform matrix, AlphaTransform cxform, String name, int ratio, int clipDepth, int frameNumber, boolean alteration, boolean replacement, Actions[] clipActions) {
        this.instance = instance;
        this.frameNumber = frameNumber;
        this.matrix = matrix;
        this.cxform = cxform;
        this.name = name;
        this.ratio = ratio;
        this.clipDepth = clipDepth;
        this.isRemove = false;
        this.isAlteration = alteration;
        this.isReplacement = replacement;
        this.clipActions = clipActions;
    }

    protected void flushDefinitions(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        if (!this.isAlteration && !this.isRemove) {
            Symbol symbol = this.instance.getSymbol();
            symbol.define(movie, timelineWriter, definitionWriter);
        }
    }

    protected void write(Movie movie, SWFTagTypes movieTagWriter, SWFTagTypes timelineTagWriter) throws IOException {
        int depth = this.instance.getDepth();
        if (depth < 0) {
            return;
        }
        if (this.isRemove) {
            timelineTagWriter.tagRemoveObject2(depth);
            return;
        }
        if (!this.isAlteration) {
            Symbol symbol = this.instance.getSymbol();
            int id = symbol.define(movie, timelineTagWriter, movieTagWriter);
            int flags = 0;
            if (this.clipActions != null && this.clipActions.length > 0) {
                for (int i = 0; i < this.clipActions.length; ++i) {
                    flags |= this.clipActions[i].getConditions();
                }
            }
            SWFActions acts = timelineTagWriter.tagPlaceObject2(this.isReplacement, this.clipDepth, depth, id, this.matrix, this.cxform, this.ratio, this.name, flags);
            if (this.clipActions != null && this.clipActions.length > 0) {
                for (int i = 0; i < this.clipActions.length; ++i) {
                    acts.start(this.clipActions[i].getConditions());
                    acts.blob(this.clipActions[i].bytes);
                }
                acts.done();
            }
        } else {
            timelineTagWriter.tagPlaceObject2(true, this.clipDepth, depth, -1, this.matrix, this.cxform, this.ratio, null, 0);
        }
    }
}

