;--------------------------------------------------------------------------------
;	PIC16F690EXs[h[^[ & dv
;	Programmed by GRANADA
;	Ver 1.0		2010/10/25 ` 2010/11/09	Speed_Meter4 x[Xɂ
;
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Speed_Meter6.htm
;--------------------------------------------------------------------------------

	LIST		P=16F690
	INCLUDE		P16F690.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT & _IESO_OFF & _WDT_OFF

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'			; [U[pt@CWX^iϐ̈j擪AhX

	TMR1_CNT_H			; Lv` TMR1 JEgl
	TMR1_CNT_L

	SPEED				; Xs[hi10iǒl Km/hj
	PREV_SPEED			; ÕXs[h

	LED					; _o[ LED ̌

	PULSE_FACTOR1		; gϊt@N^[
	PULSE_FACTOR2		; gϊt@N^[
	PULSE_FACTOR3		; gϊt@N^[

	DISP_LOOP			; _[v

ENDC

CBLOCK	H'70'			; SoNʃt@CWX^擪AhX

	W_WORK				; 荞ݎ W WX^ޔp
	ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

	ILLEGULAR			; CM[lJEgp

	COUNTER1			; ԑ҂p
	COUNTER2			; ԑ҂p
	COUNTER3			; ԑ҂p

	USER_FLAG			; etO

ENDC

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		PULSE			D'4'	; ԑpX͂Őݒ

#DEFINE		SPEED_QUALITY	D'10'	; Km/hA1 pX̃Xs[hωʂȏȂCM[lƂ݂Ȃ
#DEFINE		ILLEGULAR_TH	D'10'	; AŃCM[l琳lƂ݂Ȃăf[^XV邩

#DEFINE		LED_MAX			D'14'	;  LED 
#DEFINE		CYCLE			D'12'	; _Ci~bN_[v񐔂̊

#DEFINE		AD_FACTOR		D'5'	; A/Dϊl  10iǒlx10ւ̕ϊt@N^[
									; drd 1/4 ē͂ 20V = 1000JEgB
									;  5 ŊΒǒl x 10 (=200) 

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		START_MODE_PORT	PORTA,5		; N[hݒ|[g`
#DEFINE		SW_PORT			PORTA,3		; \؂ւXCb`|[g`

#DEFINE		PULSE_PORT		PORTC,5		; ԑpX̓|[g`

#DEFINE		V_MODE			USER_FLAG,0	; 1 = d\[h
#DEFINE		TMR1_OF			USER_FLAG,1	; 1 = TMR1 over flow 

#DEFINE		LED01_PORT	PORTA,0
#DEFINE		LED02_PORT	PORTA,1
#DEFINE		LED03_PORT	PORTA,2
#DEFINE		LED04_PORT	PORTC,0
#DEFINE		LED05_PORT	PORTC,1
#DEFINE		LED06_PORT	PORTC,2
#DEFINE		LED07_PORT	PORTB,4
#DEFINE		LED08_PORT	PORTB,5
#DEFINE		LED09_PORT	PORTB,6
#DEFINE		LED10_PORT	PORTC,6
#DEFINE		LED11_PORT	PORTC,7
#DEFINE		LED12_PORT	PORTB,7
#DEFINE		LED13_PORT	PORTC,4
#DEFINE		LED14_PORT	PORTC,3

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX

	MOVWF	W_WORK			; WX^Ҕ
	SWAPF	STATUS,W		; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK			; STATUS WX^ۑ Bank A\

	BANK0					; BANK 1 ̎Ɋ荞ł悤 BANK 0 ɋݒ
							; A BANK ͎IɌɖ߂
;
;	Lv` ?
;

CHK_CAPTURE:

	BTFSS	PIR1,CCP1IF		; Bank0
	GOTO	CHK_TMR1_OVERF	; TMR1 over flow `FbN

	CLRF	TMR1L			; Bank0, TMR1 NAĎ̑ɔ
	CLRF	TMR1H			; Bank0

	BCF		PIR1,CCP1IF		; Bank0, ݌tONA

	BTFSC	TMR1_OF			; 0 = TMR1 Over Flow ̃pXł͂ȂƂmF
	GOTO	CAPTURE2		; TMR1 Over Flow ̃pXł͎gvZłȂ̂Œl͍XVȂ

	MOVF	CCPR1H,W		; Bank0, TMR1 JE^lۑ
	MOVWF	TMR1_CNT_H
	MOVF	CCPR1L,W		; Bank0
	MOVWF	TMR1_CNT_L

CAPTURE2:

	BCF		TMR1_OF			; Over Flow tONA

	GOTO	POP_REG			; Lv`݂ TMR1 I[o[t[͓ɂ͂蓾Ȃ̂Ŋ荞݂I

;
;	TMR1 I[o[t[ ?
;

CHK_TMR1_OVERF:				; iTMR1 ͎I 0 ăJEgAbvJnj

	BTFSS	PIR1,TMR1IF		; TMR1 over flow ?
	GOTO	POP_REG			; No

	BCF		PIR1,TMR1IF		; ݌tONA

	CLRF	TMR1_CNT_H		; K莞ԓɃpX̂ŃJE^lNA
	CLRF	TMR1_CNT_L

	BSF		TMR1_OF			; Over Flow tO𗧂ĂĂi̒̃pX̎gvZh߁j

;
;	ݏI
;

POP_REG:					; WX^A`荞ݏI

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	vOX^[g
;--------------------------------------------------------------------------------

INITIALIZE:

	CALL	ALL_LED_OFF		; ƂɂŏɃ|[g

	BANK1

	MOVLW	B'01110100'		; NbN 8MHz
	MOVWF	OSCCON			; Bank 1

	MOVLW	B'00111000'		; |[go͎w
	MOVWF	TRISA			; Bank 1
	CLRF	TRISB			; Bank 1
	MOVLW	B'00100000'		; |[go͎w
	MOVWF	TRISC			; Bank 1

	BANK2

	MOVLW	B'00001000'
	MOVWF	ANSEL			; Bank 2, gϊWݒ|[g(AN3)AiOɐݒ
	CLRF	ANSELH			; Bank 2

;--------------------------------------------------------------------------------
;	10bit A/D Ro[^[ݒ
;--------------------------------------------------------------------------------

	BANK1

	MOVLW	B'00100000'		; Bank 1, 32 Tosc
	MOVWF	ADCON1

	BANK0

	MOVLW	B'10001101'		; El(10bit A/Dϊ), Vref=VDD, AN3 (bit 5-2) gp, AD Ro[^d ON
	MOVWF	ADCON0			; Bank 0

;--------------------------------------------------------------------------------
;	TMR1 & Lv`ݒ
;--------------------------------------------------------------------------------

	MOVLW	B'00000101'		; Capture mode with rising edge
	MOVWF	CCP1CON			; Bank0

	CLRF	TMR1H			; Bank0, TMR1 NA
	CLRF	TMR1L			; Bank0

	MOVLW	B'00110100'		; vXP[ 1:8 -> 65536 x 8 x 0.5(us) = ő 262ms ܂ŃgKpX҂
	MOVWF	T1CON			; Bank0

;--------------------------------------------------------------------------------
;	ϐݒ (Bank0)
;--------------------------------------------------------------------------------

	CLRF	USER_FLAG		; etO
	BSF		TMR1_OF			; Over Flow tONAiŏ̃pX̎̓AeɂȂȂj

	CALL	START_UP_DEMO	; X^[gAbv\

	CALL	CLR_ILLE_CNT

	CLRF	TMR1_CNT_H
	CLRF	TMR1_CNT_L

	CLRF	LED

	CLRF	SPEED
	MOVLW	D'1'
	MOVWF	PREV_SPEED		; NɃf[^\邽߂̍׍H

;--------------------------------------------------------------------------------
;	N[hݒǂݍ
;--------------------------------------------------------------------------------

	BTFSC	START_MODE_PORT
	BSF		V_MODE			; |[g = H Ȃd\ŋN

;--------------------------------------------------------------------------------
;	ԑpX֘Aݒ
;--------------------------------------------------------------------------------

	MOVLW	PULSE			; ԑpX

	MOVWF	B3				; 鐔iԑpXݒlj
	CLRF	B2
	CLRF	B1

	MOVLW	H'98'			; &H989680 = 10,000,000
	MOVWF	A1				; A1A2A3 = 鐔
	MOVLW	H'96'
	MOVWF	A2
	MOVLW	H'80'
	MOVWF	A3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3

	MOVF	A1,W
	MOVWF	PULSE_FACTOR1	; gϊt@N^[ۑĂ
	MOVF	A2,W
	MOVWF	PULSE_FACTOR2
	MOVF	A3,W
	MOVWF	PULSE_FACTOR3

;--------------------------------------------------------------------------------
;	ݏJn
;--------------------------------------------------------------------------------

START_INT:

	BSF		INTCON,GIE		; Bank0, S̊荞݋
	NOP
	BSF		INTCON,PEIE		; Bank0, ӊ (e.g. TMR1) 

	BANK1

	BSF		PIE1,TMR1IE		; Bank1, TMR1 over flow ݋
	NOP
	BSF		PIE1,CCP1IE		; Bank1, Lv`݋

	BANK0

	BSF		T1CON,TMR1ON	; Bank0, TMR1 X^[g

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

MAIN_LOOP:

;
;	L[̓`FbN
;

	BTFSC	SW_PORT			; L = Ă
	GOTO	MAIN2

	CALL	WAIT_25ms		; `^Oh~

	BTFSC	SW_PORT			; ܂Ă邩
	GOTO	MAIN2			; L[͉ĂȂ

	MOVLW	B'00000001'		; V_MODE tÕrbgʒu 1 ɂ
	XORWF	USER_FLAG,F		; XOR  V_MODE rbĝ݃tO]

	CALL	WAIT_500ms		; Ah~

MAIN2:

	BTFSS	V_MODE			; 1 = d\[h
	GOTO	SPEED_MODE		; 0 Ȃ̂Ŏԑ\

;
;	d\[h
;

	CALL	READ_VOLTAGE	; dǂœ_vZ
	CALL	VOLTAGE_BAR

	GOTO	MAIN_LOOP

;
;	x\[h
;

SPEED_MODE:

	CALL	CONV_DATA		; g  x (SPEED)
;
;	xωʃ`FbN
;

	MOVF	PREV_SPEED,W
	SUBWF	SPEED,W			; SPEED - PREV_SPEED(W) -> Wiωʁj
	BTFSC	STATUS,Z
	GOTO	UPDATE			; Z=1, xω͖\[hύX̂߂ɃAbvf[g

	BTFSC	STATUS,C		; if SPEED < PREV_SPEED, C=0 Ŏ؂ꔭ
	GOTO	SPEED_UP		; ؂ꂪȂ  W = ̒lł̂܂

;
;	
;

SPEED_DOWN:

	MOVF	SPEED,W			; ωʂɂȂ悤ZȂ
	SUBWF	PREV_SPEED,W	; PREV_SPEED - SPEED -> Wiωʁj

;
;	
;

SPEED_UP:

	SUBLW	SPEED_QUALITY	; Mۏl - Wiωʁj-> W
	BTFSC	STATUS,C		; if Mۏl < W, C=0
	GOTO	UPDATE			; Xs[hωMۏlȓȂ̂Ńf[^𐳏XV

	DECFSZ	ILLEGULAR,F		; ACM[l`FbN
	GOTO	ILLEGULAR_SPEED

;
;	񐔘AăCM[l
;

	GOTO	UPDATE			; \XVǐɃCM[lJE^̓Zbgjj

;
;	񐔈ȉ̃CM[l̏ꍇ
;

ILLEGULAR_SPEED:

	MOVF	PREV_SPEED,W
	MOVWF	SPEED			; xÕf[^ɏC

	GOTO	EXEC_DISP		; \l̕ωBJE^̓ZbgȂ

;
;	f[^Abvf[g
;

UPDATE:

	MOVF	SPEED,W
	MOVWF	PREV_SPEED		; ̕ω`FbN̂ߌ݂̃Xs[hlۑ

	CALL	CLR_ILLE_CNT	; CM[lJE^Zbg

;
;	f[^\
;

EXEC_DISP:

	CALL	SET_PARAMETERS	; _ LED vZ
	CALL	CALC_LOOP		; [vvZ

EXEC_DISP2:

	CALL	SPEED_BAR		; o[ LED _
	DECFSZ	DISP_LOOP,F
	GOTO	EXEC_DISP2		; 񐔃[v

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	x LED \
;	IN		SPEED			xi10iǒl, Km/hj
;	RETURN	LED				_
;--------------------------------------------------------------------------------

SET_PARAMETERS:

	MOVF	SPEED,W
	MOVWF	A1				; q

	MOVLW	D'10'			; 10Km/h 
	MOVWF	B1				; 

	CALL	DIV8			; in Math24_v2.lib, returns A1ij, B1i]j

	MOVF	A1,W			; ǂݏo
	MOVWF	LED				; _ LED ̌֕ۑ
;
;	NbsO
;
	MOVLW	LED_MAX
	SUBWF	LED,W			; LED - LED  -> W
	BTFSS	STATUS,C		; if LED >= LED , C=1
	RETURN

	MOVLW	LED_MAX
	MOVWF	LED				;  LED ȏȂ␳

	RETURN

;--------------------------------------------------------------------------------
;	_Ci~bN_̕\񐔂肷i_ɂ鎞ԍxj
;	IN:			LEDi_j
;	RETURN:		DISP_LOOP
;--------------------------------------------------------------------------------

CALC_LOOP:

	MOVF	LED,W
	BTFSC	STATUS,Z			; _ni 0  ?
	GOTO	LED_ZERO			; _ 0

	MOVWF	B1					; ȊO͒l𕪕ꑤɃZbg

	MOVLW	CYCLE
	MOVWF	A1					; qZbg

	CALL	DIV8				; in Math24_v2.lib, _񐔌vZ

SET_VALUE:

	MOVF	A1,W				; A1 = 
	BTFSC	STATUS,Z
	MOVLW	D'1'				;  0 łŒ 1 ͕\悤C

	MOVWF	DISP_LOOP			; \񐔂XgA

	RETURN

LED_ZERO:

	MOVLW	CYCLE / 2			; 0 Ȃ疳_ԂŃ[v񐔉
	MOVWF	DISP_LOOP

	RETURN

;--------------------------------------------------------------------------------
;	Xs[h_Ci~bN_ĩ[`͓̂_Ŗ߂莞Ԃωj
;	IN:		LED ij
;--------------------------------------------------------------------------------

SPEED_BAR:

	CALL	ALL_LED_OFF			; S

;LED1							; 10Km/h 

	MOVLW	D'1'
	SUBWF	LED,W				; LED_IN - 1 -> W
	BTFSS	STATUS,C			; if LED_IN >= 1, C = 1
	RETURN

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_BAR4

;LED2							; 20Km/h 

	MOVLW	D'2'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_BAR4

;LED3							; 30Km/h 

	MOVLW	D'3'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_BAR4

;LED4							; 40Km/h 

	MOVLW	D'4'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_BAR4

;LED5							; 50Km/h 

	MOVLW	D'5'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_BAR4

;LED6							; 60Km/h 

	MOVLW	D'6'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_BAR4

;LED7							; 70Km/h 

	MOVLW	D'7'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_BAR4

;LED8							; 80Km/h 

	MOVLW	D'8'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_BAR4

;LED9							; 90Km/h 

	MOVLW	D'9'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_BAR4

;LED10							; 100Km/h sN

	MOVLW	D'10'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_BAR4

;LED11							; 110Km/h sN

	MOVLW	D'11'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_BAR4

;LED12							; 120Km/h sN

	MOVLW	D'12'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR4

;LED13							; 130Km/h 

	MOVLW	D'13'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_BAR4

;LED14							; 140Km/h 

	MOVLW	D'14'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_BAR4

	RETURN

;--------------------------------------------------------------------------------
;	10bit A/D ϊs ` d\ LED 
;	RETURN: LED = _
;--------------------------------------------------------------------------------

READ_VOLTAGE:

	BSF		ADCON0,GO		; GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ A/D ϊ

	MOVF	ADRESH,W		; Bank 0, A/D ϊliʁjǂݏo
	MOVWF	A2				; ɃXgA

	BANKSEL	ADRESL			; Bank 1
	MOVF	ADRESL,W		; Bank 1, A/D ϊliʁjǂݏo

	BANKSEL	ADRESH			; Bank 0 ɖ߂
	MOVWF	A3				; ɃXgA (BANK0ɂ_ɒӁj

;
;	Ǔdl x 10 ֕ϊ
;
	CLRF	A1

	CLRF	B1
	CLRF	B2
	MOVLW	AD_FACTOR		; AD_FACTOR ŊƒǓdl x 10 
	MOVWF	B3

	CALL	DIV24			; A1A2A3 = 

;
;	LED _`FbN
;

	MOVLW	D'100'
	SUBWF	A3,W			; A3 - 100 -> W
	BTFSS	STATUS,C		; if A3 >= 100, C=1, skip next line
	GOTO	ZERO_LED		; 10V ȉȂ̂ LED  0 

	MOVLW	D'140'
	SUBWF	A3,W			; A3 - 140 -> W
	BTFSS	STATUS,C		; if A3 >= 140, C=0, skip next line
	GOTO	CALC_LED		; 14V ȉȂ̂ LED vZŋ߂

	MOVLW	D'150'
	SUBWF	A3,W			; A3 - 150 -> W
	BTFSS	STATUS,C		; if A3 >= 150, C=0, skip next line
	GOTO	LED_13			; 14V ` 14.9V Ȃ̂ LED  13m

	MOVLW	D'14'			; 15V ȏȂ̂ LED  14m
	MOVWF	LED

	RETURN

ZERO_LED:					; _ 0

	CLRF	LED

	RETURN

LED_13:						; _ 13

	MOVLW	D'13'
	MOVWF	LED

	RETURN

;
;	d 11V ` 13.9V ̏ꍇ 0.2V Xebvœ_
;

CALC_LED:

	INCF	A3,F			; 11.0V _悤Q^͂
	INCF	A3,F

	MOVLW	D'110'
	SUBWF	A3,W			; A3 - 110 -> W, _Jnd 11V Ԃ
	BTFSS	STATUS,C		; if A3 >= 110, C=1
	CLRW					; 110 ȉȂ 0 ɕ␳

	MOVWF	LED
	BCF		STATUS,C
	RRF		LED,F			; LED / 2 -> LED, 2 Ŋ邱Ƃ 0.2V Xebv LED _܂

	INCF	LED,F			; ŏ1ԂQ^͂

	MOVLW	D'12'			; _ 12 Ɏ܂
	SUBWF	LED,W			; LED - 12 -> W
	BTFSS	STATUS,C		; if  LED >= 12, C=1
	RETURN

	MOVLW	D'12'
	MOVWF	LED				; _őlɃNbsO

	RETURN

;--------------------------------------------------------------------------------
;	d_Ci~bN_ĩ[`͓̂_Ŗ߂莞Ԃωj
;	IN:		LED ij
;--------------------------------------------------------------------------------

VOLTAGE_BAR:

	CALL	ALL_LED_OFF			; S

;LED1							; 11.0V 

	MOVLW	D'1'
	SUBWF	LED,W				; LED_IN - 1 -> W
	BTFSS	STATUS,C			; if LED_IN >= 1, C = 1
	RETURN

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_BAR4

;LED2							; 11.2V 

	MOVLW	D'2'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_BAR4

;LED3							; 11.4V sN

	MOVLW	D'3'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR4

;LED4							; 11.6V sN

	MOVLW	D'4'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_BAR4

;LED5							; 11.8V sN

	MOVLW	D'5'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_BAR4

;LED6							; 12.0V 

	MOVLW	D'6'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_BAR4

;LED7							; 12.2V 

	MOVLW	D'7'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_BAR4

;LED8							; 12.4V 

	MOVLW	D'8'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_BAR4

;LED9							; 12.6V 

	MOVLW	D'9'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_BAR4

;LED10							; 12.8V 

	MOVLW	D'10'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_BAR4

;LED11							; 13.0V 

	MOVLW	D'11'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_BAR4

;LED12							; 13.2V 

	MOVLW	D'12'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_BAR4

;LED13							; 13.4V 

	MOVLW	D'13'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_BAR4

;LED14							; 13.6V 

	MOVLW	D'14'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_BAR4

	RETURN

;--------------------------------------------------------------------------------
;	TMR1 JEgl  g  xϊ
;	IN:		TMR1_CNT_H, TMR1_CNT_L
;	RETURN:	SPEEDi10iǒl Km/hj
;	NbN 8MHz, TMR1 vXP[ 8 ̏ꍇA
;	g = 250000(4pXԂ̏ꍇB24bit) / TMR1 JEgl(16bit) xmۂ̂ߎg10{ČvZ
;	x   = gx10(16bit) x 1500(16bit) / 10000(16bit)  24bit ZɎ߂xグ
;--------------------------------------------------------------------------------

CONV_DATA:

	CLRF	B1
	MOVF	TMR1_CNT_H,W	; vZɊݏŏȂ悤lޔĂ
	MOVWF	B2				; B1B2B3 = 鐔
	MOVF	TMR1_CNT_L,W
	MOVWF	B3

	MOVF	B2,W			; x 0 (16bit) `FbN
	BTFSS	STATUS,Z
	GOTO	CONV_DATA2

	MOVF	B3,W
	BTFSC	STATUS,Z
	GOTO	ZERO_PULSE		; 鐔 = 0 Ȃ瑬x 0 m

CONV_DATA2:

	MOVF	PULSE_FACTOR1,W	; gvZpt@N^[ipXݒŕςjǂݏo
	MOVWF	A1
	MOVF	PULSE_FACTOR2,W
	MOVWF	A2
	MOVF	PULSE_FACTOR3,W
	MOVWF	A3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3
							; ig x 10j 16bit ȓm A2A3

	CLRF	A1				; ŏ 8bit ͔Ô߃NA
	CLRF	B1
	MOVLW	H'05'			; &H05DC = 1500 (16bit)
	MOVWF	B2
	MOVLW	H'DC'
	MOVWF	B3

	CALL	MUL24			; in Math24_v2.lib,  A1A2A3B1B2B3 (48bit)
							; 16bit x 16bit Ȃ̂ŌIɂ͓ 32bit ɂȂ邪A
							;  200Km/h łg 133Hz ɉ߂Ȃ̂ŁA
							; 133 x 10 x 1500 = 1995000 ŉ 24bit (B1B2B3) ɏ\܂

	MOVF	B1,W			; 𕪎qɓ]
	MOVWF	A1
	MOVF	B2,W
	MOVWF	A2
	MOVF	B3,W
	MOVWF	A3

	CLRF	B1
	MOVLW	H'27'			; &H2710 = 10000
	MOVWF	B2
	MOVLW	H'10'
	MOVWF	B3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3

	MOVF	A3,W			; A3 = Ǒxi 8 bit ȓmj
	MOVWF	SPEED

	RETURN

ZERO_PULSE:

	CLRF	SPEED			; x 0

	RETURN

;--------------------------------------------------------------------------------
;	CM[lJE^NA
;--------------------------------------------------------------------------------

CLR_ILLE_CNT:

	MOVLW	ILLEGULAR_TH	; ̘ACM[lf[^XV邩
	MOVWF	ILLEGULAR

	RETURN

;--------------------------------------------------------------------------------
;	X^[gAbvf
;--------------------------------------------------------------------------------

START_UP_DEMO:

	CALL	ALL_LED_OFF

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_BAR1
	BSF		LED01_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_BAR2

	CALL	ALL_LED_OFF

	RETURN

;--------------------------------------------------------------------------------
;	LED Si H = LED OFF j
;--------------------------------------------------------------------------------

ALL_LED_OFF:

	MOVLW	B'11000111'		; Ôߓ̓|[g L ɂĒZh
	MOVWF	PORTA
	MOVLW	B'11011111'		; Ôߓ̓|[g L ɂĒZh
	MOVWF	PORTC
	MOVLW	B'11111111'
	MOVWF	PORTB

	RETURN

;--------------------------------------------------------------------------------
;	o[ LED \ێ
;--------------------------------------------------------------------------------

HOLD_BAR1:						; X^[gAbvfp

	CALL	WAIT_10ms
	RETURN

HOLD_BAR2:

	CALL	WAIT_1ms			; X^[gAbvfp
	RETURN

HOLD_BAR5:						; sNʏ\pi_Ă݂̋Pxj

	CALL	WAIT_1ms
	CALL	WAIT_1ms

HOLD_BAR3:

	CALL	WAIT_500us
	RETURN

HOLD_BAR4:

	CALL	WAIT_5us			; ʏ\p
	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Time-8MHz.lib	; NbN8MHzpԑ҂[vCu
	INCLUDE		Math24-v2.lib	; 24bit lZCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
