;--------------------------------------------------------------------------------
;	PIC16F887EԑvEdv v5 Programmed by GRANADA
;	Ver 1.0		2010/09/27 `		PIC16F887 Xs[h[^[x[Xɉ
;	Ver 1.5		2010/10/04			Px 7 ZO LED piobt@jɉ
;	Ver 1.5		2010/10/06			^ 7 ZO LED pɉ
;	Ver 1.6		2010/10/29			WDT Ao[\ 34ǉ
;	Ver 1.7		2010/11/13			o[\ 23֕ύX
;	Ver 2.0		2010/12/16			NbN 4MHz ֕ύXA3Km/h 猟o\
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Speed_Meter5.htm
;--------------------------------------------------------------------------------

	LIST		P=16F887
	INCLUDE		P16F887.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

    __CONFIG    _CONFIG1, _DEBUG_OFF & _LVP_OFF & _FCMEN_ON & _IESO_OFF & _BOR_ON & _CPD_OFF & _CP_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
    __CONFIG    _CONFIG2, _WRT_OFF & _BOR40V

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'			; [U[pt@CWX^iϐ̈j擪AhX

	TMR1_CNT_H			; Lv` TMR1 JEgl
	TMR1_CNT_L

	SPEED				; Xs[hi10iǒl Km/hj
	PREV_SPEED			; ÕXs[h

	LED					; _ LED 

	BCD_H				; BCD ϊl
	BCD_M				; BCD ϊl
	BCD_L				; BCD ϊl

	PATTERN_H			; ʃrbgp^[E}X^[p^[
	PATTERN_M			; ʃrbgp^[E}X^[p^[
	PATTERN_L			; ʃrbgp^[E}X^[p^[

	SEGMENT				; \rbgp^[

	SP_FACTOR			; \x␳pt@N^[

ENDC

CBLOCK	H'70'			; SoNʃt@CWX^擪AhX

	W_WORK				; 荞ݎ W WX^ޔp
	ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

	COUNTER1			; ԑ҂p
	COUNTER2			; ԑ҂p
	COUNTER3			; ԑ҂p

	DISP_LOOP			; _Ci~bN_

	ILLEGULAR			; CM[lJE^

	USER_FLAG			; etO

ENDC

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		LED_MAX			D'24'	; Ăo[ LED ̌
#DEFINE		CYCLE			D'18'	; _Ci~bN_̃[v񐔊

#DEFINE		SPEED_QUALITY	D'15'	; (Km/h) 1 pXłȏ̕ωꍇ̓f[^𖳎
#DEFINE		ILLEGULAR_TH	D'10'	; ACM[l琳lƂăf[^XV邩

#DEFINE		FACTOR_H		H'13'	; &H1312d0 = 1250000
#DEFINE		FACTOR_M		H'12'	; 4 pXԈȊOȂ炱ύX
#DEFINE		FACTOR_L		H'D0'	; e.g. 2 pXԂȂ{A8pXԂȂ甼

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		MODE_PORT	PORTE,3			; [hݒ|[g`A1 = ␳
#DEFINE		PULSE		2
#DEFINE		PULSE_PORT	PORTC,PULSE		; pX̓|[g`

#DEFINE		C1_PORT		PORTA,1			; LED 1ڐ|[g
#DEFINE		C2_PORT		PORTA,0			; LED 2ڐ|[g
#DEFINE		C3_PORT		PORTB,7			; LED 3ڐ|[g

#DEFINE		A_SEG		PORTB,0			; LED  a ZOg̃|[gԍ
#DEFINE		B_SEG		PORTB,1			; LED  b ZOg̃|[gԍ
#DEFINE		C_SEG		PORTB,2			; LED  c ZOg̃|[gԍ
#DEFINE		D_SEG		PORTB,3			; LED  d ZOg̃|[gԍ
#DEFINE		E_SEG		PORTB,4			; LED  e ZOg̃|[gԍ
#DEFINE		F_SEG		PORTB,5			; LED  f ZOg̃|[gԍ
#DEFINE		G_SEG		PORTB,6			; LED  g ZOg̃|[gԍ

#DEFINE		LED01_PORT	PORTD,7			; o[ LED |[g`
#DEFINE		LED02_PORT	PORTA,2
#DEFINE		LED03_PORT	PORTA,3
#DEFINE		LED04_PORT	PORTA,4
#DEFINE		LED05_PORT	PORTA,5
#DEFINE		LED06_PORT	PORTE,0
#DEFINE		LED07_PORT	PORTE,1
#DEFINE		LED08_PORT	PORTE,2
#DEFINE		LED09_PORT	PORTD,6
#DEFINE		LED10_PORT	PORTD,5
#DEFINE		LED11_PORT	PORTA,7
#DEFINE		LED12_PORT	PORTA,6
#DEFINE		LED13_PORT	PORTC,0
#DEFINE		LED14_PORT	PORTC,1
#DEFINE		LED15_PORT	PORTD,4
#DEFINE		LED16_PORT	PORTC,3
#DEFINE		LED17_PORT	PORTD,0
#DEFINE		LED18_PORT	PORTD,1
#DEFINE		LED19_PORT	PORTC,7
#DEFINE		LED20_PORT	PORTC,6
#DEFINE		LED21_PORT	PORTC,5
#DEFINE		LED22_PORT	PORTC,4
#DEFINE		LED23_PORT	PORTD,3
#DEFINE		LED24_PORT	PORTD,2

#DEFINE		TMR1_OF		USER_FLAG,0		; 1 = TMR1 I[o[t[
#DEFINE		DISP_MODE	USER_FLAG,1		; 1 = HUD \, 0 = m[}\

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX

	MOVWF	W_WORK			; WX^Ҕ
	SWAPF	STATUS,W		; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK			; STATUS WX^ۑ Bank A\

;
;	Lv` ?
;

	BANKSEL	PORTA			; m Bank 0 ɂĂiK{j

CHK_CAPTURE:

	BTFSS	PIR1,CCP1IF		; Bank0
	GOTO	CHK_TMR1_OVERF	; TMR1 over flow `FbN

	CLRF	TMR1L			; Bank0, TMR1 NAĎ̑ɔ
	CLRF	TMR1H			; Bank0

	BCF		PIR1,CCP1IF		; ݌tONA

	BTFSC	TMR1_OF			; 0 = TMR1 Over Flow ̃pXł͂ȂƂmF
	GOTO	CAPTURE2		; TMR1 Over Flow ̃pXł͎gvZłȂ̂Œl͕ۑȂ

	MOVF	CCPR1H,W		; Bank0, TMR1 JE^lۑ
	MOVWF	TMR1_CNT_H
	MOVF	CCPR1L,W		; Bank0
	MOVWF	TMR1_CNT_L

CAPTURE2:

	BCF		TMR1_OF			; Over Flow tONA

	GOTO	POP_REG			; Lv`݂ TMR1 I[o[t[͓ɂ͂蓾Ȃ̂Ŋ荞݂I

;
;	TMR1 I[o[t[ ?
;

CHK_TMR1_OVERF:				; iTMR1 ͎I 0 ăJEgAbvJnj

	BTFSS	PIR1,TMR1IF		; TMR1 over flow ?
	GOTO	POP_REG			; No

	BCF		PIR1,TMR1IF		; ݌tONA

	CLRF	TMR1_CNT_H		; K莞ԓɃpX̂ŃJE^lNA
	CLRF	TMR1_CNT_L

	BSF		TMR1_OF			; Over Flow tO𗧂ĂĂi̒̃pX̎gvZh߁j

;
;	ݏI
;

POP_REG:					; WX^A`荞ݏI

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	1̐7ZOgrbgp^[Ԃ
;--------------------------------------------------------------------------------

GET_7SEG_PATTERN:				;	ʏ\p

	ADDWF	PCL,F
;              gfedcba
	RETLW	B'00111111'	;	0
	RETLW	B'00000110'	;	1
	RETLW	B'01011011'	;	2
	RETLW	B'01001111'	;	3
	RETLW	B'01100110'	;	4
	RETLW	B'01101101'	;	5
	RETLW	B'01111101'	;	6
	RETLW	B'00100111'	;	7
	RETLW	B'01111111'	;	8
	RETLW	B'01101111'	;	9

GET_7SEG_PATTERN_HUD:			;	HUD \p

	ADDWF	PCL,F
;              gfedcba
	RETLW	B'00111111'	;	0
	RETLW	B'00110000'	;	1
	RETLW	B'01101101'	;	2
	RETLW	B'01111001'	;	3
	RETLW	B'01110010'	;	4
	RETLW	B'01011011'	;	5
	RETLW	B'01011111'	;	6
	RETLW	B'00110011'	;	7
	RETLW	B'01111111'	;	8
	RETLW	B'01111011'	;	9

;--------------------------------------------------------------------------------
; Lϊe[u̓AZuAhX100ԒnɎ߂邱ƁI
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	vOX^[g
;--------------------------------------------------------------------------------

INITIALIZE:

	CALL	CLR_ALL_LED

	BANK1

	CLRF	TRISA			; Bank 1, ЂƂ܂S|[go͂Ɏw
	CLRF	TRISB			; Bank 1
	CLRF	TRISC			; Bank 1
	BSF		TRISC,PULSE		; pX́iLv`j|[g͂

	CLRF	TRISD			; Bank 1
	CLRF	TRISE			; Bank 1

	MOVLW	B'01100001'		; NbN 4MHz ɐݒ
	MOVWF	OSCCON			; Bank 1

	BANK3

	CLRF	ANSEL			; Bank 3, S|[gfW^ݒ
	CLRF	ANSELH			; Bank 3

;--------------------------------------------------------------------------------
;	TMR1 ݒ, Lv`@\ݒ
;--------------------------------------------------------------------------------

	BANK0

	MOVLW	B'00000101'		; Capture mode with rising edge
	MOVWF	CCP1CON			; Bank0

	CLRF	TMR1H			; Bank0, TMR1 NA
	CLRF	TMR1L			; Bank0

	MOVLW	B'00110100'		; vXP[ 1:8 -> 65536 x 8 x 1(us) = ő 524ms ܂ŃgKpX҂
	MOVWF	T1CON			; Bank0

;--------------------------------------------------------------------------------
;	̑ݒ (Bank0)
;--------------------------------------------------------------------------------

	CALL	CLR_ILLE_CNT

	CLRF	TMR1_CNT_H
	CLRF	TMR1_CNT_L

	CLRF	SPEED
	MOVLW	D'1'
	MOVWF	PREV_SPEED		; NɃf[^\邽߂̍׍H

	CLRF	LED

	CLRF	USER_FLAG		; etO
	BSF		TMR1_OF			; Over Flow tONAiŏ̃pX̎̓AeɂȂȂj
	NOP
	BSF		DISP_MODE		; 1 = HUDAm[}\͂̍s폜

	CLRF	PATTERN_H		; uN\ŃX^[g
	CLRF	PATTERN_M
	CLRF	PATTERN_L

	BTFSC	STATUS,NOT_TO	; 0 = WDT Zbg
	CALL	START_UP		; ʏNɂ̂݃X^[gAbvf

;--------------------------------------------------------------------------------
;	\x␳t@N^[ݒ
;-------------------------------------------------------------------------------

	MOVLW	H'84'			; |[g L = &H0584 = 1412 (16bit)A␳i JIS Kiǂj
	BTFSC	MODE_PORT		; t@N^[ݒ|[g̏Ԃǂ
	MOVLW	H'DC'			; |[g H = &H05DC = 1500 (16bit)A␳
	MOVWF	SP_FACTOR

;--------------------------------------------------------------------------------
;	ݏJn
;--------------------------------------------------------------------------------

	BSF		INTCON,GIE		; Bank0, S̊荞݋
	NOP
	BSF		INTCON,PEIE		; Bank0, ӊ (e.g. TMR1) 
	NOP

	BANK1

	BSF		PIE1,TMR1IE		; Bank1, TMR1 over flow ݋
	BSF		PIE1,CCP1IE		; Bank1, Lv`݋

	BANK0

	BSF		T1CON, TMR1ON	; Bank 0, TMR1 X^[g

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

MAIN_LOOP:

	CALL	RESET_WDT		; EIb`hbO^C}[Zbg

	CALL	CONV_DATA		; g  x (SPEED)

;
;	xωʃ`FbN
;

	MOVF	PREV_SPEED,W
	SUBWF	SPEED,W			; SPEED - PREV_SPEED(W) -> Wiωʁj
	BTFSC	STATUS,Z
	GOTO	UPDATE			; Z-1, xω[hؑ֎lĕ\͍XVACM[JE^̓Zbg

	BTFSC	STATUS,C		; if SPEED < PREV_SPEED, C=0 Ŏ؂ꔭ
	GOTO	SPEED_UP		; ؂ꂪȂ  W = ̒lł̂܂

;
;	
;

SPEED_DOWN:

	MOVF	SPEED,W			; ωʂɂȂ悤ZȂ
	SUBWF	PREV_SPEED,W	; PREV_SPEED - SPEED -> Wiωʁj

;
;	
;

SPEED_UP:

	SUBLW	SPEED_QUALITY	; Mۏl - Wiωʁj-> W
	BTFSC	STATUS,C		; if Mۏl < W, C=0
	GOTO	UPDATE			; Xs[hωMۏlȓȂ̂Ńf[^𐳏XV

	DECFSZ	ILLEGULAR,F		; ACM[l`FbN
	GOTO	ILLEGULAR_SPEED

;
;	񐔘AăCM[l
;

	GOTO	UPDATE			; \XV

;
;	񐔈ȉ̃CM[l̏ꍇ
;

ILLEGULAR_SPEED:

	MOVF	PREV_SPEED,W
	MOVWF	SPEED			; xÕf[^ɏC

	GOTO	EXEC_DISPLAY2	; \l̕ῶȂ̓JE^̓ZbgȂ

;
;	f[^Abvf[g
;

UPDATE:

	MOVF	SPEED,W
	MOVWF	PREV_SPEED		; ̕ω`FbN̂ߌ݂̃Xs[hlۑ

EXEC_DISPLAY:

	CALL	CLR_ILLE_CNT

EXEC_DISPLAY2:

	CALL	CALC_BAR		; _ LED vZ
	CALL	CALC_LOOP		; [v񐔌vZ

EXEC_DISPLAY3:

	CALL	BAR_DISPLAY

	DECFSZ	DISP_LOOP,F
	GOTO	EXEC_DISPLAY3	; 񐔃[v

	CALL	SET_PARAMETERS	; LED _vZA7ZOp^[Zbg
	CALL	DISPLAY			; 7ZO\

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------
;--------------------------------------------------------------------------------
;	LED \
;	IN		SPEED			xi10iǒl, Km/hj
;	RETURN	LED				_
;--------------------------------------------------------------------------------

CALC_BAR:

	MOVF	SPEED,W
	MOVWF	A1				; q

	MOVLW	D'5'			; 5Km/h 
	MOVWF	B1				; 

	CALL	DIV8			; in Math24_v2.lib, returns A1ij, B1i]j
;
;	23
;
	MOVLW	D'3'
	SUBWF	B1,W			; B1i]j - 3 -> W
	BTFSC	STATUS,C		; if ] < 3, C=0
	INCF	A1,F			; ]肪3ȏȂ_悹

	MOVF	A1,W			; ǂݏo
	MOVWF	LED				; _ LED ̌֕ۑ
;
;	NbsO
;
	MOVLW	LED_MAX
	SUBWF	LED,W			; LED - LED  -> W
	BTFSS	STATUS,C		; if LED >= LED , C=1
	RETURN

	MOVLW	LED_MAX
	MOVWF	LED				;  LED ȏȂ␳

	RETURN

;--------------------------------------------------------------------------------
;	LED \ZOgp^[𓾂
;	IN		SPEED			xi10iǒl, Km/hj
;	RETURN	PATTERN_H		ʂ̃ZOgp^[
;			PATTERN_M		ʂ̃ZOgp^[
;			PATTERN_L		ʂ̃ZOgp^[
;--------------------------------------------------------------------------------

SET_PARAMETERS:

	CLRF	prm1b			;  8bit ̓NA
	MOVF	SPEED,W			; 10iǒl͉ 8bit
	MOVWF	prm1a			; ʃZbg

	CALL	HEX2DEC16		; 16bitl -> 5 BCD ϊ

	MOVF	prm3a,W			; BCD 
	MOVWF	BCD_L			; XgA
	MOVF	prm3b,W			; BCD 
	MOVWF	BCD_M			; XgA
	MOVF	prm3c,W			; BCD 
	MOVWF	BCD_H			; XgA

;--------------------------------------------------------------------------------
;	BCD lɊÂ LED \p^[ɃZbg
;--------------------------------------------------------------------------------

	MOVF	BCD_H,W
	BTFSS	STATUS,Z			; ŏʂ0 ?
	GOTO	SET_H_PATTERN		; 0 łȂ̂Œʏ폈

	CLRF	PATTERN_H			; ŏʂ̓uN

	MOVF	BCD_M,W
	BTFSS	STATUS,Z			; 2ڂ0 ?
	GOTO	SET_M_PATTERN		; 2ڂ 0 łȂ̂Œʏ폈

	CLRF	PATTERN_M			; 2ڂuN

	GOTO	SET_L_PATTERN		; ŏI 0 ł\

SET_H_PATTERN:

	MOVF	BCD_H,W				; 100̈ʂ𓾂
	CALL	GET_PATTERN			; ϊ
	MOVWF	PATTERN_H			; p^[ۑ

SET_M_PATTERN:

	MOVF	BCD_M,W				; 10̈ʂ𓾂
	CALL	GET_PATTERN			; ϊ
	MOVWF	PATTERN_M			; p^[ۑ

SET_L_PATTERN:

	MOVF	BCD_L,W				; 1̈ʂ𓾂
	CALL	GET_PATTERN			; ϊ
	MOVWF	PATTERN_L			; p^[ۑ

	RETURN

;--------------------------------------------------------------------------------
;	7ZO\p^[𓾂iHUDΉj
;	IN:		WiBCDlj
;	IN:		DISP_MODE tO
;	RETURN:	W (ZOgp^[j
;--------------------------------------------------------------------------------

GET_PATTERN:

	BTFSC	DISP_MODE			; ݒ|[g̏Ԃ`FbNA1 = HUD [h
	GOTO	GET_HUD_DATA

	CALL	GET_7SEG_PATTERN
	RETURN

GET_HUD_DATA:

	CALL	GET_7SEG_PATTERN_HUD
	RETURN

;--------------------------------------------------------------------------------
;	_Ci~bN_
;	PATTERN_H	ʌZOgp^[
;	PATTERN_M	ʌZOgp^[
;	PATTERN_L	ʌZOgp^[
;--------------------------------------------------------------------------------

DISPLAY:

	CALL	CLR_ALL_LED			; S
;
;	LED1 \
;
	BCF		C1_PORT				; H ON (L=_)

	MOVF	PATTERN_H,W			; ʌp^[ǂݏo
	CALL	DYNAMIC				; ZOgJn

	BSF		C1_PORT				; H OFF
;
;	LED2 \
;
	BCF		C2_PORT				; M ON (L=_)

	MOVF	PATTERN_M,W			; ʌp^[ǂݏo
	CALL	DYNAMIC				; ZOgJn

	BSF		C2_PORT				; M OFF
;
;	LED3 \
;
	BCF		C3_PORT				; L ON (L=_)

	MOVF	PATTERN_L,W			; ʌp^[ǂݏo
	CALL	DYNAMIC				; ZOgJn

	BSF		C3_PORT				; L OFF

	RETURN

;--------------------------------------------------------------------------------
;	S_Ci~bN_EZOg
;	IN: W = rbgp^[
;--------------------------------------------------------------------------------

DYNAMIC:

	MOVWF	SEGMENT				; ZOgp^[ۑĂ
	BTFSC	STATUS,Z
	GOTO	DISP_BLANK			; \uNȂ玞Ԃ

	BTFSS	SEGMENT,0			; a ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_B				; ̃ZOg

	BSF		A_SEG				; a ZOg_
	CALL	HOLD_LED
	BCF		A_SEG				; a ZOg
	CALL	HOLD_LED_SHORT

SEG_B:

	BTFSS	SEGMENT,1			; b ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_C				; ̃ZOg

	BSF		B_SEG				; b ZOg_
	CALL	HOLD_LED
	BCF		B_SEG				; b ZOg
	CALL	HOLD_LED_SHORT

SEG_C:

	BTFSS	SEGMENT,2			; c ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_D				; ̃ZOg

	BSF		C_SEG				; c ZOg_
	CALL	HOLD_LED
	BCF		C_SEG				; c ZOg
	CALL	HOLD_LED_SHORT

SEG_D:

	BTFSS	SEGMENT,3			; d ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_E				; ̃ZOg

	BSF		D_SEG				; d ZOg_
	CALL	HOLD_LED
	BCF		D_SEG				; d ZOg
	CALL	HOLD_LED_SHORT

SEG_E:

	BTFSS	SEGMENT,4			; e ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_F				; ̃ZOg

	BSF		E_SEG				; e ZOg_
	CALL	HOLD_LED
	BCF		E_SEG				; e ZOg
	CALL	HOLD_LED_SHORT

SEG_F:

	BTFSS	SEGMENT,5			; f ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_G				; ̃ZOg

	BSF		F_SEG				; f ZOg_
	CALL	HOLD_LED
	BCF		F_SEG				; f ZOg
	CALL	HOLD_LED_SHORT

SEG_G:

	BTFSS	SEGMENT,6			; g ZOgrbg 1 Ȃ玟̖߂XLbv
	RETURN						; \I

	BSF		G_SEG				; g ZOg_
	CALL	HOLD_LED
	BCF		G_SEG				; g ZOg
	CALL	HOLD_LED_SHORT

	RETURN						; SZOgI

DISP_BLANK:						; uN\̏ꍇł莞Ԃ͏
								; 7 ZO LED PxȂׂ艻
	CALL	WAIT_2ms_4MHz

	RETURN

;--------------------------------------------------------------------------------
;	_Ci~bN_̕\񐔂肷i_ɂ鎞ԍxj
;	IN:			LEDi_j
;	RETURN:		DISP_LOOP
;--------------------------------------------------------------------------------

CALC_LOOP:

	MOVF	LED,W
	BTFSC	STATUS,Z			; _ni 0  ?
	GOTO	LED_ZERO			; _ 0

	MOVWF	B1					; ȊO͒l𕪕ꑤɃZbg

	MOVLW	CYCLE
	MOVWF	A1					; qZbg

	CALL	DIV8				; in Math24_v2.lib, _񐔌vZ

SET_VALUE:

	MOVF	A1,W				; A1 = 
	BTFSC	STATUS,Z
	MOVLW	D'1'				;  0 łŒ 1 ͕\悤C

	MOVWF	DISP_LOOP			; \񐔂XgA

	RETURN

LED_ZERO:

	MOVLW	CYCLE / 2			; 0 Ȃ疳_ԂŃ[v񐔉
	MOVWF	DISP_LOOP

	RETURN

;--------------------------------------------------------------------------------
;	o[ LED _Ci~bN_ĩ[`͓̂_Ŗ߂莞Ԃωj
;	IN:		LED ij
;--------------------------------------------------------------------------------

BAR_DISPLAY:

	CALL	CLR_ALL_LED			; S

LED1:							; 5Km/h 

	MOVLW	D'1'
	SUBWF	LED,W				; LED_IN - 1 -> W
	BTFSS	STATUS,C			; if LED_IN >= 1, C = 1
	RETURN

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_BAR4

LED2:							; 10Km/h 

	MOVLW	D'2'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_BAR4

LED3:							; 15Km/h 

	MOVLW	D'3'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_BAR4

LED4:							; 20Km/h 

	MOVLW	D'4'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_BAR4

LED5:							; 25Km/h 

	MOVLW	D'5'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_BAR4

LED6:							; 30Km/h 

	MOVLW	D'6'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_BAR4

LED7:							; 35Km/h 

	MOVLW	D'7'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_BAR4

LED8:							; 40Km/h 

	MOVLW	D'8'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_BAR4

LED9:							; 45Km/h 

	MOVLW	D'9'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_BAR4

LED10:							; 50Km/h 

	MOVLW	D'10'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_BAR4

LED11:							; 55Km/h 

	MOVLW	D'11'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_BAR4

LED12:							; 60Km/h 

	MOVLW	D'12'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR4

LED13:							; 65Km/h 

	MOVLW	D'13'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_BAR4

LED14:							; 70Km/h 

	MOVLW	D'14'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_BAR4

LED15:							; 75Km/h 

	MOVLW	D'15'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED15_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED15_PORT			; 
	CALL	HOLD_BAR4

LED16:							; 80Km/h 

	MOVLW	D'16'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED16_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED16_PORT			; 
	CALL	HOLD_BAR4

LED17:							; 85Km/h 

	MOVLW	D'17'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED17_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED17_PORT			; 
	CALL	HOLD_BAR4

LED18:							; 90Km/h 

	MOVLW	D'18'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED18_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED18_PORT			; 
	CALL	HOLD_BAR4

LED19:							; 95Km/h 

	MOVLW	D'19'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED19_PORT			; _i L = _j
	CALL	HOLD_BAR3			; LED _΂炭z[h
	BSF		LED19_PORT			; 
	CALL	HOLD_BAR4

LED20:							; 100Km/h sN

	MOVLW	D'20'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED20_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED20_PORT			; 
	CALL	HOLD_BAR4

LED21:							; 105Km/h sN

	MOVLW	D'21'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED21_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED21_PORT			; 
	CALL	HOLD_BAR4

LED22:							; 110Km/h sN

	MOVLW	D'22'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED22_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED22_PORT			; 
	CALL	HOLD_BAR4

LED23:							; 115Km/h sN

	MOVLW	D'23'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED23_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED23_PORT			; 
	CALL	HOLD_BAR4

LED24:							; 120Km/h 

	MOVLW	D'24'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED24_PORT			; _i L = _j
	CALL	HOLD_BAR5			; LED _΂炭z[h
	BSF		LED24_PORT			; 
	CALL	HOLD_BAR4

	RETURN

;--------------------------------------------------------------------------------
;	TMR1 JEgl  g  xϊ
;
;	IN:			TMR1_CNT_H, TMR1_CNT_L
;	RETURN:		SPEEDi10iǒl Km/hj
;
;	NbN 4MHz, TMR1 vXP[ 8 ̏ꍇATMR1  8us  1 JEg
;	Ďg = 1000000us / ( 8us x TMR1 JEgl ) B
;	g = 125000 (16bit) / TMR1 JEgl (16bit) xmۂ̂ߎg10{ČvZ
;	x   = g x 10(16bit) x 1500(16bit) / 10000(16bit)  24bit ZɎ߂xグ
;--------------------------------------------------------------------------------

CONV_DATA:

	CLRF	SPEED			; ^C}l 0 ɔăNAĂ

	CLRF	B1
	MOVF	TMR1_CNT_H,W	; vZɊݏŏȂ悤lޔĂ
	MOVWF	B2				; B1B2B3 = 鐔
	MOVF	TMR1_CNT_L,W
	MOVWF	B3

	MOVF	B2,W			; JEg 0 (16bit) `FbN
	BTFSS	STATUS,Z
	GOTO	CONV_DATA2

	MOVF	B3,W
	BTFSC	STATUS,Z
	RETURN					; 鐔 = 0 Ȃ SPEED = 0 mȂ̂Ŗ߂

CONV_DATA2:

	MOVLW	FACTOR_H
	MOVWF	A1				; A1A2A3 = 鐔
	MOVLW	FACTOR_M
	MOVWF	A2
	MOVLW	FACTOR_L
	MOVWF	A3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3
							; ig x 10j 16bit ȓm A2A3

	CLRF	A1				; ŏ 8bit ͔Ô߃NA

	CLRF	B1				; ŏʂ̓NA
	MOVLW	H'05'			; 16bit͋
	MOVWF	B2
	MOVF	SP_FACTOR,W		; \x␳t@N^[ǂݏo
	MOVWF	B3

	CALL	MUL24			; in Math24_v2.lib,  A1A2A3B1B2B3 (48bit)
							; 16bit x 16bit Ȃ̂ŌIɂ͓ 32bit ɂȂ邪A
							;  200Km/h łg 4pXԂȂ 133Hz ɉ߂Ȃ̂ŁA
							; 133 x 10 x 1500 = 1995000  24bit ɏ\܂

	MOVF	B1,W			; 𕪎qɈړ
	MOVWF	A1
	MOVF	B2,W
	MOVWF	A2
	MOVF	B3,W
	MOVWF	A3

	CLRF	B1				; ꑤݒ
	MOVLW	H'27'			; &H2710 = 10000
	MOVWF	B2
	MOVLW	H'10'
	MOVWF	B3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3

	MOVF	A3,W			; A3 = ǑxB 8 bit ȓm
	MOVWF	SPEED

	RETURN

;--------------------------------------------------------------------------------
;	7 ZO LED \ێ
;--------------------------------------------------------------------------------

HOLD_LED:

	CALL	WAIT_400us_4MHz
	CALL	WAIT_400us_4MHz
	RETURN

HOLD_LED_SHORT:

	NOP		;	1us at 4MHz
	RETURN	;	1us at 4MHz

;--------------------------------------------------------------------------------
;	o[ LED \ێ
;--------------------------------------------------------------------------------

HOLD_BAR1:						; X^[gAbvfp

	CALL	WAIT_10ms_4MHz
	RETURN

HOLD_BAR2:

	CALL	WAIT_1ms_4MHz		; X^[gAbvfp
	RETURN

HOLD_BAR5:						; sNʏ\pi_Ă݂̋Pxj

	CALL	WAIT_200us_4MHz		; ʏ\p
	CALL	WAIT_100us_4MHz

HOLD_BAR3:

	CALL	WAIT_200us_4MHz		; ʏ\p
	RETURN

HOLD_BAR4:

	NOP		;	1us at 4MHz
	RETURN	;	1us at 4MHz

;--------------------------------------------------------------------------------
;	S LED OFF
;--------------------------------------------------------------------------------

CLR_ALL_LED:

	MOVLW	B'10000000'			; 7 ZO LED OFF
	MOVWF	PORTB

	MOVLW	B'11111111'			; BAR LED  H = OFF

	MOVWF	PORTA
	MOVWF	PORTC
	MOVWF	PORTD
	MOVWF	PORTE

	RETURN

;--------------------------------------------------------------------------------
;	CM[lJE^NA
;--------------------------------------------------------------------------------

CLR_ILLE_CNT:

	MOVLW	ILLEGULAR_TH	; ̘ACM[lf[^XV邩
	MOVWF	ILLEGULAR

	RETURN

;--------------------------------------------------------------------------------
;	WDT ݒ, 1000000(us) / 31000 (Hz)  32 us x 256 JEg = 8.2ms
;	8.2ms x 32 =  262.4ms  WDT ZbgAx͂قǍȂ
;	ł 150`175ms ȓ
;--------------------------------------------------------------------------------

RESET_WDT:

	CLRWDT					; CLRWDT sɂvXP[[Zbg_ɒ

	BANK2

	MOVLW	B'00000001'		; WDT Prescale 1:32, WDT ON
	MOVWF	WDTCON			; Bank 2

	BANK0

	RETURN

;--------------------------------------------------------------------------------
;	X^[gAbvf
;--------------------------------------------------------------------------------

START_UP:

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED15_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED15_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED16_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED16_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED17_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED17_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED18_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED18_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED19_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED19_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED20_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED20_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED21_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED21_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED22_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED22_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED23_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED23_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED24_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED24_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED23_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED23_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED22_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED22_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED21_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED21_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED20_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED20_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED19_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED19_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED18_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED18_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED17_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED17_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED16_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED16_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED15_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED15_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_BAR2

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_BAR1			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_BAR2

	CALL	CLR_ALL_LED

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Wait.lib		; ԑ҂[vCu
	INCLUDE		Math24-v2.lib	; 24bit lZCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
