;--------------------------------------------------------------------------------
;	PIC16F690ESX^eBbNo[\Xs[h[^[
;	Programmed by GRANADA
;	Ver 1.0		2010/09/13 `		Speed_Meter2,3 x[Xɂ
;
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Speed_Meter4.htm
;--------------------------------------------------------------------------------

	LIST		P=16F690
	INCLUDE		P16F690.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT & _IESO_OFF & _WDT_OFF

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'			; [U[pt@CWX^iϐ̈j擪AhX

	TMR1_CNT_H			; Lv` TMR1 JEgl
	TMR1_CNT_L

	SPEED				; Xs[hi10iǒl Km/hj
	PREV_SPEED			; ÕXs[h

	LED					; _o[ LED ̌

	PULSE_FACTOR1		; pXvZp萔
	PULSE_FACTOR2
	PULSE_FACTOR3

	FREQ_FACTOR1		; gvZpW 8 bit
	FREQ_FACTOR2		; gvZpW 8 bit

	ALARM_SPEED			; ݒxXs[h

ENDC

CBLOCK	H'70'			; SoNʃt@CWX^擪AhX

	W_WORK				; 荞ݎ W WX^ޔp
	ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

	ILLEGULAR			; CM[lJEgp

	COUNTER1			; ԑ҂p
	COUNTER2			; ԑ҂p
	COUNTER3			; ԑ҂p

	USER_FLAG			; etO

	TMP					; Gp

ENDC

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		SPEED_QUALITY	D'10'		; Km/hA1 pX̃Xs[hωʂȏȂCM[lƂ݂Ȃ
#DEFINE		ILLEGULAR_TH	D'10'		; AŃCM[l琳lƂ݂Ȃăf[^XV邩

#DEFINE		LED_MAX			D'12'		;  LED 

#DEFINE		SPEED1			D'100'		; xA[ݒl 1
#DEFINE		SPEED2			D'15'		; xA[ݒl 2

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

;RA5	A[xݒ	DIGITAL IN
;RA4	xvZWݒ 	ANALOG  IN
;RA3	ԑpXݒ 1	DIGITAL IN
;RC4	ԑpXݒ 2	DIGITAL IN

;RC5	PULSE_IN	DIGITAL IN		ԑpX̓|[g
;RC3	ALARM		DIGITAL OUT		A[o

;RA0	LED01		DIGITAL OUT
;RA1	LED02		DIGITAL OUT
;RA2	LED03		DIGITAL OUT
;RC0	LED04		DIGITAL OUT
;RC1	LED05		DIGITAL OUT
;RC2	LED06		DIGITAL OUT
;RB4	LED07		DIGITAL OUT
;RB5	LED08		DIGITAL OUT
;RB6	LED09		DIGITAL OUT
;RC6	LED10		DIGITAL OUT
;RC7	LED11		DIGITAL OUT
;RB7	LED12		DIGITAL OUT

;--------------------------------------------------------------------------------

#DEFINE		SPEED_SET_PORT	PORTA,5		; A[xݒ|[g`
#DEFINE		PULSE1_PORT		PORTA,3		; ԑpXݒ 1 |[g`
#DEFINE		PULSE2_PORT		PORTC,4		; ԑpXݒ 2 |[g`
#DEFINE		PULS_PORT		PORTC,5		; ԑpX̓|[g`

#DEFINE		ALARM			3
#DEFINE		ALARM_PORT		PORTC,ALARM	; x߃A[o̓|[g

#DEFINE		TMR1_OF			USER_FLAG,0	; 1 = TMR1 over flow 
#DEFINE		ALARM_FLAG		USER_FLAG,1	; 1 = ݒ葬xȏ

#DEFINE		LED01_PORT	PORTA,0
#DEFINE		LED02_PORT	PORTA,1
#DEFINE		LED03_PORT	PORTA,2
#DEFINE		LED04_PORT	PORTC,0
#DEFINE		LED05_PORT	PORTC,1
#DEFINE		LED06_PORT	PORTC,2
#DEFINE		LED07_PORT	PORTB,4
#DEFINE		LED08_PORT	PORTB,5
#DEFINE		LED09_PORT	PORTB,6
#DEFINE		LED10_PORT	PORTC,6
#DEFINE		LED11_PORT	PORTC,7
#DEFINE		LED12_PORT	PORTB,7

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX

	MOVWF	W_WORK			; WX^Ҕ
	SWAPF	STATUS,W		; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK			; STATUS WX^ۑ Bank A\

	BANK0					; WDT ݒ (BANK 1jɊ荞ł悤 BANK 0 ɍĐݒ
;
;	Lv` ?
;

CHK_CAPTURE:

	BTFSS	PIR1,CCP1IF		; Bank0
	GOTO	CHK_TMR1_OVERF	; TMR1 over flow `FbN

	CLRF	TMR1L			; Bank0, TMR1 NAĎ̑ɔ
	CLRF	TMR1H			; Bank0

	BCF		PIR1,CCP1IF		; Bank0, ݌tONA

	BTFSC	TMR1_OF			; 0 = TMR1 Over Flow ̃pXł͂ȂƂmF
	GOTO	CAPTURE2		; TMR1 Over Flow ̃pXł͎gvZłȂ̂Œl͍XVȂ

	MOVF	CCPR1H,W		; Bank0, TMR1 JE^lۑ
	MOVWF	TMR1_CNT_H
	MOVF	CCPR1L,W		; Bank0
	MOVWF	TMR1_CNT_L

CAPTURE2:

	BCF		TMR1_OF			; Over Flow tONA

	GOTO	POP_REG			; Lv`݂ TMR1 I[o[t[͓ɂ͂蓾Ȃ̂Ŋ荞݂I

;
;	TMR1 I[o[t[ ?
;

CHK_TMR1_OVERF:				; iTMR1 ͎I 0 ăJEgAbvJnj

	BTFSS	PIR1,TMR1IF		; TMR1 over flow ?
	GOTO	POP_REG			; No

	BCF		PIR1,TMR1IF		; ݌tONA

	CLRF	TMR1_CNT_H		; K莞ԓɃpX̂ŃJE^lNA
	CLRF	TMR1_CNT_L

	BSF		TMR1_OF			; Over Flow tO𗧂ĂĂi̒̃pX̎gvZh߁j

;
;	ݏI
;

POP_REG:					; WX^A`荞ݏI

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
; ݒԍ  ԑpXϊ
;--------------------------------------------------------------------------------

GET_PULSE_VALUE:

	ADDWF	PCL,F

	RETLW	D'4'				; ݒ 1 (ON  ON )
	RETLW	D'2'				; ݒ 2 (ON  OFF)
	RETLW	D'8'				; ݒ 3 (OFF ON )
	RETLW	D'16'				; ݒ 4 (OFF OFF)

;--------------------------------------------------------------------------------
; Lϊe[u̓AZuAhX100ԒnɎ߂邱ƁI
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	vOX^[g
;--------------------------------------------------------------------------------

INITIALIZE:

	CALL	ALL_LED_OFF		; ƂɂŏɃ|[g

	BANK1

	MOVLW	B'01110100'		; NbN 8MHz
	MOVWF	OSCCON			; Bank 1

	MOVLW	B'00111000'		; |[go͎w
	MOVWF	TRISA			; Bank 1
	CLRF	TRISB			; Bank 1
	MOVLW	B'00110000'		; |[go͎w
	MOVWF	TRISC			; Bank 1

	BANK2

	MOVLW	B'00001000'
	MOVWF	ANSEL			; Bank 2, gϊWݒ|[g(AN3)AiOɐݒ
	CLRF	ANSELH			; Bank 2

;--------------------------------------------------------------------------------
;	8bit A/D Ro[^[ݒ
;--------------------------------------------------------------------------------

	BANK1

	MOVLW	B'00100000'		; Bank 1, 32 Tosc
	MOVWF	ADCON1

	BANK0

	MOVLW	B'00001101'		; l(8bit A/Dϊ), Vref=VDD, AN3 (bit 5-2) gp, AD Ro[^d ON
	MOVWF	ADCON0			; Bank 0

;--------------------------------------------------------------------------------
;	TMR1 & Lv`ݒ
;--------------------------------------------------------------------------------

	MOVLW	B'00000101'		; Capture mode with rising edge
	MOVWF	CCP1CON			; Bank0

	CLRF	TMR1H			; Bank0, TMR1 NA
	CLRF	TMR1L			; Bank0

	MOVLW	B'00110100'		; vXP[ 1:8 -> 65536 x 8 x 0.5(us) = ő 262ms ܂ŃgKpX҂
	MOVWF	T1CON			; Bank0

;--------------------------------------------------------------------------------
;	ϐݒ (Bank0)
;--------------------------------------------------------------------------------

	CLRF	USER_FLAG		; etO
	BSF		TMR1_OF			; Over Flow tONAiŏ̃pX̎̓AeɂȂȂj

	BTFSC	STATUS,NOT_TO	; {Ԏɂ͕邱ƁB0 = WDT Zbg ?
	CALL	START_UP_DEMO	; ʏNX^[gAbv\AWDT Zbg̓pX

	CALL	CLR_ILLE_CNT

	CLRF	TMR1_CNT_H
	CLRF	TMR1_CNT_L

	CLRF	LED

	CLRF	SPEED
	MOVLW	D'1'
	MOVWF	PREV_SPEED		; NɃf[^\邽߂̍׍H

;--------------------------------------------------------------------------------
;	xxݒlǂݍ
;--------------------------------------------------------------------------------

	MOVLW	SPEED1

	BTFSC	SPEED_SET_PORT	; SW ԊmFASW ON = L
	MOVLW	SPEED2

	MOVWF	ALARM_SPEED		; ݒXs[hۑ

;--------------------------------------------------------------------------------
;	ԑpXݒlǂݍ
;--------------------------------------------------------------------------------

READ_PULSE_SETTING:

	CLRF	TMP

	BTFSC	PULSE1_PORT
	BSF		TMP,1
	BTFSC	PULSE2_PORT
	BSF		TMP,0			; TMP = 0 ` 3
	MOVF	TMP,W

	CALL	GET_PULSE_VALUE	; ԑpXf[^e[u擾

	MOVWF	B3				; 鐔iԑpXݒlj
	CLRF	B2
	CLRF	B1

	MOVLW	H'98'			; &H989680 = 10,000,000
	MOVWF	A1				; A1A2A3 = 鐔
	MOVLW	H'96'
	MOVWF	A2
	MOVLW	H'80'
	MOVWF	A3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3

	MOVF	A1,W
	MOVWF	PULSE_FACTOR1	; gϊt@N^[ۑĂ
	MOVF	A2,W
	MOVWF	PULSE_FACTOR2
	MOVF	A3,W
	MOVWF	PULSE_FACTOR3

;--------------------------------------------------------------------------------
;	ݏJn
;--------------------------------------------------------------------------------

START_INT:

	BSF		INTCON,GIE		; Bank0, S̊荞݋
	NOP
	BSF		INTCON,PEIE		; Bank0, ӊ (e.g. TMR1) 

	BANK1

	BSF		PIE1,TMR1IE		; Bank1, TMR1 over flow ݋
	NOP
	BSF		PIE1,CCP1IE		; Bank1, Lv`݋

	BANK0

	BSF		T1CON,TMR1ON	; Bank0, TMR1 X^[g

;--------------------------------------------------------------------------------
;	EIb`hbO^C}Zbg
;--------------------------------------------------------------------------------

	CALL	RESET_WDT

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

MAIN_LOOP:

;
;	x\
;

	CALL	CONV_DATA		; g  x (SPEED)
;
;	xωʃ`FbN
;

	MOVF	PREV_SPEED,W
	SUBWF	SPEED,W			; SPEED - PREV_SPEED(W) -> Wiωʁj
	BTFSC	STATUS,Z
	GOTO	UPDATE			; Z=1, xω͖\[hύX̂߂ɃAbvf[g

	BTFSC	STATUS,C		; if SPEED < PREV_SPEED, C=0 Ŏ؂ꔭ
	GOTO	SPEED_UP		; ؂ꂪȂ  W = ̒lł̂܂

;
;	
;

SPEED_DOWN:

	MOVF	SPEED,W			; ωʂɂȂ悤ZȂ
	SUBWF	PREV_SPEED,W	; PREV_SPEED - SPEED -> Wiωʁj

;
;	
;

SPEED_UP:

	SUBLW	SPEED_QUALITY	; Mۏl - Wiωʁj-> W
	BTFSC	STATUS,C		; if Mۏl < W, C=0
	GOTO	UPDATE			; Xs[hωMۏlȓȂ̂Ńf[^𐳏XV

	DECFSZ	ILLEGULAR,F		; ACM[l`FbN
	GOTO	ILLEGULAR_SPEED

;
;	񐔘AăCM[l
;

	GOTO	UPDATE			; \XVǐɃCM[lJE^̓Zbgjj

;
;	񐔈ȉ̃CM[l̏ꍇ
;

ILLEGULAR_SPEED:

	MOVF	PREV_SPEED,W
	MOVWF	SPEED			; xÕf[^ɏC

	GOTO	UPDATE2			; \l̕ωBJE^̓ZbgȂ

;
;	f[^Abvf[g
;

UPDATE:

	MOVF	SPEED,W
	MOVWF	PREV_SPEED		; ̕ω`FbN̂ߌ݂̃Xs[hlۑ

	CALL	CLR_ILLE_CNT	; CM[lJE^Zbg

UPDATE2:

;
;	xݒXs[hƔr
;

	BCF		ALARM_FLAG		; x߃tONA

	MOVF	ALARM_SPEED,W
	SUBWF	SPEED,W			; ݂̃Xs[h - xݒXs[h
	BTFSC	STATUS,C		; ݂̃Xs[h < xݒXs[hȂ C=0 Ŏ̍sXLbv
	BSF		ALARM_FLAG		; x߃tOZbg

;
;	x|[go͂֔f
;

	BTFSC	ALARM_FLAG
	GOTO	SPEED_OVER

	BCF		ALARM_PORT		; |[g L ɖ߂
	GOTO	EXEC_DISP

SPEED_OVER:

	BSF		ALARM_PORT		; |[g H 

;
;	f[^\
;

EXEC_DISP:

	CALL	RESET_WDT		; EIb`hbO^C}Zbg

	CALL	SET_PARAMETERS	; _ LED vZ

	CALL	BAR_DISPLAY		; X^eBbN_

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	LED \
;	IN		SPEED			xi10iǒl, Km/hj
;	RETURN	LED				_
;--------------------------------------------------------------------------------

SET_PARAMETERS:

	MOVF	SPEED,W
	MOVWF	A1				; q

	MOVLW	D'10'			; 10Km/h 
	MOVWF	B1				; 

	CALL	DIV8			; in Math24_v2.lib, returns A1ij, B1i]j

	MOVF	A1,W			; ǂݏo
	MOVWF	LED				; _ LED ̌֕ۑ
;
;	NbsO
;
	MOVLW	LED_MAX
	SUBWF	LED,W			; LED - LED  -> W
	BTFSS	STATUS,C		; if LED >= LED , C=1
	RETURN

	MOVLW	LED_MAX
	MOVWF	LED				;  LED ȏȂ␳

	RETURN

;--------------------------------------------------------------------------------
;	xX^eBbN_ ( Low Active )
;	IN:		LED ij
;--------------------------------------------------------------------------------

BAR_DISPLAY:

LED1:

	MOVLW	D'1'
	SUBWF	LED,W				; LED_IN - 1 -> W
	BTFSS	STATUS,C			; if LED_IN >= 1, C = 1
	GOTO	LED1_OFF

	BCF		LED01_PORT			; _i L = _ j
	GOTO	LED2

LED1_OFF:

	BSF		LED01_PORT			; i H =  j

LED2:

	MOVLW	D'2'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED2_OFF

	BCF		LED02_PORT			; _i L = _j
	GOTO	LED3

LED2_OFF:

	BSF		LED02_PORT			; i H =  j

LED3:

	MOVLW	D'3'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED3_OFF

	BCF		LED03_PORT			; _i L = _j
	GOTO	LED4

LED3_OFF:

	BSF		LED03_PORT			; i H =  j

LED4:

	MOVLW	D'4'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED4_OFF

	BCF		LED04_PORT			; _i L = _j
	GOTO	LED5

LED4_OFF:

	BSF		LED04_PORT			; i H =  j

LED5:

	MOVLW	D'5'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED5_OFF

	BCF		LED05_PORT			; _i L = _j
	GOTO	LED6

LED5_OFF:

	BSF		LED05_PORT			; i H =  j

LED6:

	MOVLW	D'6'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED6_OFF

	BCF		LED06_PORT			; _i L = _j
	GOTO	LED7

LED6_OFF:

	BSF		LED06_PORT			; i H =  j

LED7:

	MOVLW	D'7'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED7_OFF

	BCF		LED07_PORT			; _i L = _j
	GOTO	LED8

LED7_OFF:

	BSF		LED07_PORT			; i H =  j

LED8:

	MOVLW	D'8'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED8_OFF

	BCF		LED08_PORT			; _i L = _j
	GOTO	LED9

LED8_OFF:

	BSF		LED08_PORT			; i H =  j

LED9:

	MOVLW	D'9'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED9_OFF

	BCF		LED09_PORT			; _i L = _j
	GOTO	LED10

LED9_OFF:

	BSF		LED09_PORT			; i H =  j

LED10:

	MOVLW	D'10'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED10_OFF

	BCF		LED10_PORT			; _i L = _j
	GOTO	LED11

LED10_OFF:

	BSF		LED10_PORT			; i H =  j

LED11:

	MOVLW	D'11'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED11_OFF

	BCF		LED11_PORT			; _i L = _j
	GOTO	LED12

LED11_OFF:

	BSF		LED11_PORT			; i H =  j

LED12:

	MOVLW	D'12'
	SUBWF	LED,W
	BTFSS	STATUS,C
	GOTO	LED12_OFF

	BCF		LED12_PORT			; _i L = _j
	RETURN

LED12_OFF:

	BSF		LED12_PORT			; i H =  j
	RETURN

;--------------------------------------------------------------------------------
;	LED Si H = LED OFF j
;--------------------------------------------------------------------------------

ALL_LED_OFF:

	MOVLW	B'11000111'		; ̓|[g L ɂĒZh
	MOVWF	PORTA
	MOVLW	B'11111111'
	MOVWF	PORTB
	MOVLW	B'11101111'		; ̓|[g L ɂĒZh
	MOVWF	TMP

	BTFSS	ALARM_FLAG		; xߒȂA[o̓|[g H ̂܂
	BCF		TMP,ALARM

	MOVF	TMP,W
	MOVWF	PORTC

	RETURN

;--------------------------------------------------------------------------------
;	TMR1 JEgl  g  xϊ
;	IN:		TMR1_CNT_H, TMR1_CNT_L
;	RETURN:	SPEEDi10iǒl Km/hj
;	NbN 8MHz, TMR1 vXP[ 8 ̏ꍇA
;	g = 250000(4pXԂ̏ꍇB24bit) / TMR1 JEgl(16bit) xmۂ̂ߎg10{ČvZ
;	x   = gx10(16bit) x 1500(16bit) / 10000(16bit)  24bit ZɎ߂xグ
;--------------------------------------------------------------------------------

CONV_DATA:

;
;	xϊWݒl AD ϊœǂݍ
;
	CALL	READ_AD			; xϊWǂݏo

	MOVWF	B3
	CLRF	B2
	CLRF	B1

	CLRF	A1
	MOVLW	H'05'
	MOVWF	A2
	MOVLW	H'84'
	MOVWF	A3

	CALL	ADD24			; in Math24_v2.lib,  A1A2A3

	MOVF	A2,W
	MOVWF	FREQ_FACTOR1
	MOVF	A3,W
	MOVWF	FREQ_FACTOR2
;
;	xvZ{
;

TEST:

	CLRF	B1
	MOVF	TMR1_CNT_H,W	; vZɊݏŏȂ悤lޔĂ
	MOVWF	B2				; B1B2B3 = 鐔
	MOVF	TMR1_CNT_L,W
	MOVWF	B3

	MOVF	B2,W			; x 0 (16bit) `FbN
	BTFSS	STATUS,Z
	GOTO	CONV_DATA2

	MOVF	B3,W
	BTFSC	STATUS,Z
	GOTO	ZERO_PULSE		; 鐔 = 0 Ȃ瑬x 0 m

CONV_DATA2:

	MOVF	PULSE_FACTOR1,W	; gvZpt@N^[ipXݒŕςjǂݏo
	MOVWF	A1
	MOVF	PULSE_FACTOR2,W
	MOVWF	A2
	MOVF	PULSE_FACTOR3,W
	MOVWF	A3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3

							; ig x 10j 16bit ȓm A2A3

	CLRF	A1				; ŏ 8bit ͔Ô߃NA

	CLRF	B1
	MOVF	FREQ_FACTOR1,W	; gxϊWǂݏo
	MOVWF	B2
	MOVF	FREQ_FACTOR2,W
	MOVWF	B3

	CALL	MUL24			; in Math24_v2.lib,  A1A2A3B1B2B3 (48bit)
							; 16bit x 16bit Ȃ̂ŌIɂ͓ 32bit ɂȂ邪A
							;  200Km/h łg 133Hz ɉ߂Ȃ̂ŁA
							; 133 x 10 x 1412 = 1877960 ŉ 24bit (B1B2B3) ɏ\܂

	MOVF	B1,W			; 𕪎qɓ]
	MOVWF	A1
	MOVF	B2,W
	MOVWF	A2
	MOVF	B3,W
	MOVWF	A3

	CLRF	B1
	MOVLW	H'27'			; &H2710 = 10000
	MOVWF	B2
	MOVLW	H'10'
	MOVWF	B3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3

	MOVF	A3,W			; A3 = Ǒxi 8 bit ȓmj
	MOVWF	SPEED

	RETURN

ZERO_PULSE:

	CLRF	SPEED			; x 0

	RETURN

;--------------------------------------------------------------------------------
;	CM[lJE^NA
;--------------------------------------------------------------------------------

CLR_ILLE_CNT:

	MOVLW	ILLEGULAR_TH	; ̘ACM[lf[^XV邩
	MOVWF	ILLEGULAR

	RETURN

;--------------------------------------------------------------------------------
;	WDT ݒ, 1000000(us) / 31000 (Hz)  32 us x 256 JEg = 8.2ms
;	8.2ms x 32 =  2644ms  WDT ZbgAx͂قǍȂ
;	ł 150`175ms ȓ
;--------------------------------------------------------------------------------

RESET_WDT:

	CLRWDT					; CLRWDT sɂvXP[[Zbg_ɒ

	BANK1

	MOVLW	B'00000001'		; WDT Prescale 1:32, WDT ON
	MOVWF	WDTCON			; Bank 1

	BANK0

	RETURN

;--------------------------------------------------------------------------------
;	X^[gAbvf
;--------------------------------------------------------------------------------

START_UP_DEMO:

	CALL	ALL_LED_OFF

	BCF		LED01_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	WAIT_5ms

	BCF		LED02_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	WAIT_5ms

	BCF		LED03_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	WAIT_5ms

	BCF		LED04_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	WAIT_5ms

	BCF		LED05_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	WAIT_5ms

	BCF		LED06_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	WAIT_5ms

	BCF		LED07_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	WAIT_5ms

	BCF		LED08_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	WAIT_5ms

	BCF		LED09_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	WAIT_5ms

	BCF		LED10_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	WAIT_5ms

	BCF		LED11_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	WAIT_5ms

	BCF		LED12_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	WAIT_5ms

	BCF		LED11_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	WAIT_5ms

	BCF		LED10_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	WAIT_5ms

	BCF		LED09_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	WAIT_5ms

	BCF		LED08_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	WAIT_5ms

	BCF		LED07_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	WAIT_5ms

	BCF		LED06_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	WAIT_5ms

	BCF		LED05_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	WAIT_5ms

	BCF		LED04_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	WAIT_5ms

	BCF		LED03_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	WAIT_5ms

	BCF		LED02_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	WAIT_5ms

	BCF		LED01_PORT			; _i L = _j
	CALL	WAIT_25ms			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	WAIT_5ms

	CALL	ALL_LED_OFF

	RETURN

;--------------------------------------------------------------------------------
;	A/D ϊs
;	RETURN: W
;--------------------------------------------------------------------------------

READ_AD:

	BSF		ADCON0,GO		; Bank 0, GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ϊ

	MOVF	ADRESH,W		; Bank 0, A/D ϊlǂݏo

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Time-8MHz.lib	; NbN8MHzpԑ҂[vCu
	INCLUDE		Math24-v2.lib	; 24bit lZCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
