;------------------------------------------------------------------------
;	PIC12F1822 Power Save LED Marker
;
;	Programmed by GRANADA since 2012/11/21
;
;	v1.0	2012/11/21 - 2012/11/26		vg^Cv version
;	v1.1	2012/11/28					zdr̖邳odݒύX
;	v1.2	2012/11/29					A/D ϊAWdɂ܂߂ ON/OFF
;										_ŎԁEύX
;	v1.3	2012/12/03					~̌\
;
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Power_Save_Marker.htm
;
;------------------------------------------------------------------------

	LIST		P=12LF1822
	INCLUDE		P12LF1822.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

    __CONFIG _CONFIG1, _FOSC_INTOSC & _WDTE_SWDTEN & _PWRTE_OFF & _MCLRE_OFF & _CP_OFF & _CPD_OFF & _BOREN_OFF & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
    __CONFIG _CONFIG2, _WRT_OFF & _PLLEN_OFF & _STVREN_ON & _BORV_19 & _LVP_OFF

;---------------------------------------------------------------------------
;	ėp}N`
;---------------------------------------------------------------------------

MOVLF		MACRO	L,FILE
			MOVLW	L
			MOVWF	FILE
			ENDM

MOVFF		MACRO	SRC,DST
			MOVF	SRC,W
			MOVWF	DST
			ENDM

SET_FSR0	MACRO	ADDRESS
			MOVLW	HIGH ADDRESS
			MOVWF	FSR0H
			MOVLW	LOW ADDRESS
			MOVWF	FSR0L
			ENDM

SET_FSR1	MACRO	ADDRESS
			MOVLW	HIGH ADDRESS
			MOVWF	FSR1H
			MOVLW	LOW ADDRESS
			MOVWF	FSR1L
			ENDM

SUBFSR		MACRO	REGISTER LITERAL
			ADDFSR	REGISTER	D'64' - LITERAL
			ENDM

SET_PAGE	MACRO PAGE_NUM
			MOVLP PAGE_NUM * D'8'
			ENDM

SET_BANK	MACRO BANK_NUM
			MOVLB BANK_NUM
			ENDM

;---------------------------------------------------------------------------
; ϐ̈`
;---------------------------------------------------------------------------

CBLOCK	H'20'

	KEY_ON_CNT			; KEY ON o

	DAY_COUNT			; opJE^
	NIGHT_COUNT			; 錟opJE^

	LBAT_CNT			; dቺopJE^
	HBAT_CNT			; d팟opJE^

	BEEP_CNT

	PON_CNT				; d ON ̃L[XLpJE^

	KEY_HOLD			; L[

ENDC

CBLOCK	H'70'			; SoNʃGA擪AhX

	AD_VALUE			; A/D ϊlۑp

	USER_FLAG			; R[hX^[gptO

	USER_FLAG2			; zbgX^[gptO

	WORK				; ėp[N

ENDC

;---------------------------------------------------------------------------
;	|[g`
;---------------------------------------------------------------------------

#DEFINE		BRI_PORT			PORTA,0			; AN0, 邳̓|[g
#DEFINE		LBAT_PORT			PORTA,1			; AN1, dop|[g
#DEFINE		KEY_PORT			PORTA,2			; L[|[g
#DEFINE		LED1_PORT			PORTA,5			; _ŗp LED |[g
#DEFINE		LED2_PORT			PORTA,4			; A_p LED |[g

;
;	R[hX^[gptO
;

#DEFINE		DAY_FLAG			USER_FLAG,0		; 0 = ԁA1 = 
#DEFINE		LOW_BAT_FLAG		USER_FLAG,1		; 0 = dA1 = d
#DEFINE		KEY_LONG_FLAG		USER_FLAG,2		; 1 = L[ꂽ
#DEFINE		KEY_SHORT_FLAG		USER_FLAG,3		; 1 = L[ʏ퉟ꂽ
#DEFINE		LED1_ON_FLAG		USER_FLAG,4		; 1 = LED1 ON
#DEFINE		LED2_ON_FLAG		USER_FLAG,5		; 1 = LED2 ON


;
;	zbgX^[gptO
;

#DEFINE		MODE_FLAG			USER_FLAG2,0	; 0 = _ŁA1 = A_

;---------------------------------------------------------------------------
;	萔`
;---------------------------------------------------------------------------

#DEFINE		KEY_SHORT_C			D'4'			; ʏ퉟Ɣ肷XL񐔁A1  64ms
#DEFINE		KEY_LONG_C			D'30'			; Ɣ肷XL񐔁A1  64ms
#DEFINE		PON_C				D'190'			; d ON ̃L[XL񐔁A1  10ms

#DEFINE		DAY_CHECK_C			D'5'			; o܂ł̗P\		i 1  2.1b j
#DEFINE		NIGHT_CHECK_C		D'5'			; o܂ł̗P\		i 1  2.1b j
#DEFINE		LBAT_C				D'5'			; do܂ł̗P\	i 1  2.1b j
#DEFINE		HBAT_C				D'5'			; do܂ł̗P\	i 1  2.1b j

;
;	2.048 = 255A1/2 ɂdô 2.7 / 2 = 1.35V = 169
;

#DEFINE		B2.7V_C				D'169'			; 2.7V i1/2j A/D ϊlA~d
#DEFINE		B3.0V_C				D'187'			; 3.0V i1/2j A/D ϊlAĊJdA[d OK ݒd
;#DEFINE		B3.2V_C				D'200'			; 3.2V i1/2j A/D ϊlAĊJdA[d OK ݒd
;#DEFINE		B3.6V_C				D'225'			; 3.6V i1/2j A/D ϊl
#DEFINE		B3.9V_C				D'243'			; 3.9V i1/2j A/D ϊlA[dd

#DEFINE		BRIGHT_C			D'250'			; uvƔf邽߂̑zdrdA250 -> 2V

;---------------------------------------------------------------------------
;	dxN^
;---------------------------------------------------------------------------

	ORG		0x00

	GOTO	INITIALIZE		; 

;---------------------------------------------------------------------------
; ݃xN^
;---------------------------------------------------------------------------

	ORG		H'4'

	RETFIE					; 荞ݏI

;---------------------------------------------------------------------------
;	vO@X^[g|Cg
;	WX^ނ̏
;---------------------------------------------------------------------------

INITIALIZE:

	SET_BANK 0

	CLRF	PORTA			; Bank 0AƂ肠S|[gNA

	CLRF	INTCON			; Bank 0A荞ݑSĒ~

	SET_BANK 1

	MOVLW	B'00000011'		; Weak pull up enable, TMR0 = internal clock, PS=16, 132us x 256 x 16 = 540ms
	MOVWF	OPTION_REG		; Bank 1

	MOVLW	B'00010010'		; WDT PS:16384 = 512ms, WDT OFF
	MOVWF	WDTCON			; Bank 1

	MOVLW	B'00000010'		; Clock = internal 31KHz
	MOVWF	OSCCON			; Bank 1, gݒ

	CLRF	OSCTUNE			; Bank 1, NbN

	MOVLW	B'00001111'		; 0 = OUT, 1 = IN
	MOVWF	TRISA			; Bank 1, e|[go͐ݒ

	MOVLW	B'01110011'		; Frc,  REFAli8bitj
	MOVWF	ADCON1			; Bank 1

	MOVLW	B'00000001'		; AN0, ADC ON
	MOVWF	ADCON0			; Bank 1

	SET_BANK 3

	MOVLW	B'00000011'		; Frc, AN0 = AiO
	MOVWF	ANSELA			; Bank 3

	SET_BANK 4

	MOVLW	B'00000100'		; Weak pull up enable
	MOVWF	WPUA			; Bank 4

	SET_BANK 0

;---------------------------------------------------------------------------
;	ϐ̏
;---------------------------------------------------------------------------

	CLRF	USER_FLAG2			; R[hX^[gł̓NAłȂtONA

COLD_START:

	BTFSC	MODE_FLAG
	BSF		LED2_PORT			; A_ŋNꍇ LED2 _

	SET_BANK 2

	MOVLW	B'10000010'			; Internal VREF ON, 2.048V
	MOVWF	FVRCON				; Bank 2

	SET_BANK 0

	CALL	CLR_LBAT_COUNTER	; dopϐNA
	CALL	CLR_HBAT_COUNTER	; dopϐNA

	CALL	CLR_DAY_COUNTER		; ԃ`FbNpϐNA
	CALL	CLR_NIGHT_COUNTER	; ԃ`FbNpϐNA

	CLRF	USER_FLAG			; R[hX^[gptO

	CALL	CLR_KEY_CNT			; L[͊֘ANA

;---------------------------------------------------------------------------
;	C[v
;---------------------------------------------------------------------------

MAIN_LOOP:

;---------------------------------------------------------------------------
;	A/D ϊAWd ON
;---------------------------------------------------------------------------

	CALL	AD_VREF_ON

;---------------------------------------------------------------------------
;	d`FbN
;---------------------------------------------------------------------------

	CALL	LOW_BAT_CHECK

;---------------------------------------------------------------------------
;	邳`FbN
;---------------------------------------------------------------------------

	BTFSS	MODE_FLAG			; 1 = A_
	CALL	BRIGHTNESS_CHECK	; _œ̎̂ݖ邳`FbN

;---------------------------------------------------------------------------
;	A/D ϊAWd OFF
;---------------------------------------------------------------------------

	CALL	AD_VREF_OFF

;---------------------------------------------------------------------------
;	etO`FbN LED 1  ON
;---------------------------------------------------------------------------

	CALL	CHECK_FLAG			; tO`FbN

;---------------------------------------------------------------------------
;	LED1 _Ŋ
;---------------------------------------------------------------------------

	BTFSC	LED1_ON_FLAG		; tOɉ
	BSF		LED1_PORT			; LED 1 ON

	CALL	SCAN_LOOP			; L[XL
	BTFSC	KEY_LONG_FLAG
	GOTO	SHUTDOWN
	BTFSC	KEY_SHORT_FLAG
	GOTO	MODE_CHANGE

;---------------------------------------------------------------------------
;	LED1 
;---------------------------------------------------------------------------

	BCF		LED1_PORT			; LED1 OFF

	CALL	SCAN_LOOP			; L[XL
	BTFSC	KEY_LONG_FLAG
	GOTO	SHUTDOWN
	BTFSC	KEY_SHORT_FLAG
	GOTO	MODE_CHANGE

	CALL	SCAN_LOOP			; L[XL
	BTFSC	KEY_LONG_FLAG
	GOTO	SHUTDOWN
	BTFSC	KEY_SHORT_FLAG
	GOTO	MODE_CHANGE

	CALL	SCAN_LOOP			; L[XL
	BTFSC	KEY_LONG_FLAG
	GOTO	SHUTDOWN
	BTFSC	KEY_SHORT_FLAG
	GOTO	MODE_CHANGE

;---------------------------------------------------------------------------
;	ʂ菈I
;---------------------------------------------------------------------------

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	_[hύX
;--------------------------------------------------------------------------------

MODE_CHANGE:

	BCF		KEY_SHORT_FLAG

	BTFSC	MODE_FLAG			; 0 = _ŁA1 = A_
	GOTO	CHANGE_FLASH

CHANGE_CONTINUOUS:

	BSF		MODE_FLAG

	BCF		LED1_PORT			; LED 1  (for safety)
	NOP
	BSF		LED2_PORT			; LED 2 _

	GOTO	MAIN_LOOP

CHANGE_FLASH:

	BCF		MODE_FLAG

	BCF		LED2_PORT			; LED 2 

	CALL	CLR_DAY_COUNTER		; ԃ`FbNpϐNA
	CALL	CLR_NIGHT_COUNTER	; ԃ`FbNpϐNA

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	df
;--------------------------------------------------------------------------------

SHUTDOWN:

	BCF		KEY_LONG_FLAG

	CALL	DISP_BATTERY				; d\

	CALL	AD_VREF_OFF					; ADC, VREF ~iȓd͉j

	CALL	CLR_KEY_CNT					; L[͊֘ANA

;
;	L[܂ő҂
;

WAIT_KEY_OFF:

	MOVLF	D'5',WORK

WAIT_KEY_OFF_2:

	CALL	SLEEP_64ms

	BTFSS	KEY_PORT					; KEY |[g`FbN
	GOTO	WAIT_KEY_OFF				; L = L[Ă

	DECFSZ	WORK,F						; 񐔗ꑱ ?
	GOTO	WAIT_KEY_OFF_2				; ܂

;
;	L[莞ԗꂽ
;

;	BCF		INTCON,GIE					; Bank 0, O[o荞ݒ~ASLEEP ̂݊荞݌o
;	BTFSC	INTCON,GIE					; GIE rbgSɃNAꂽƂmF
;	GOTO	$-2

	SET_BANK 7

	BSF		IOCAN,IOCAN2				; Bank7, ԕω荞 enable

	SET_BANK 0

	BSF		INTCON,IOCIE				; Bank 0, ԕω荞݋

EXEC_SLEEP:

	SET_BANK 7

	BCF		IOCAF, IOCAF2				; Bank 7, |[gʏԕωtONA

	SET_BANK 0

	BCF		INTCON,IOCIF				; Bank 0, ԕω荞݃tONA

	SLEEP
	NOP									; 畜A

;--------------------------------------------------------------------------------
;	A
;--------------------------------------------------------------------------------

RESUME:

	MOVLF	PON_C,PON_CNT				; 񐔃XL

WAIT_PON_SCAN:

	CALL	WAIT_10ms

	BTFSC	KEY_PORT					; L = KEY ON
	GOTO	EXEC_SLEEP					; Ȃ΍ēx SLEEP

	DECFSZ	PON_CNT,F					; 񐔃XL
	GOTO	WAIT_PON_SCAN

;
;	d ONiAj
;

POWER_ON:

	SET_BANK 7							; 񐔉ꑱ

	BCF		IOCAN,IOCAN2				; Bank 7, ԕω荞 disable

	SET_BANK 0

	BCF		INTCON,IOCIE				; Bank 0, ԕω荞݋֎~

	CALL	DISP_BATTERY				; drd\

;	BTFSS	KEY_PORT					; H = KEY OFF
;	GOTO	$-1							; ēxL[܂ő҂ăL[̘Ah~

	GOTO	COLD_START					; čĊJ

;---------------------------------------------------------------------------
;
;	ȍ~ATu[`
;
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;	LED1 _ėǂ`FbN
;	_sԂłd ON/OFF ̃XL͕Kv
;---------------------------------------------------------------------------

CHECK_FLAG:

	BCF		LED1_ON_FLAG

	BTFSC	DAY_FLAG			; 1 = 
	RETURN

	BTFSC	LOW_BAT_FLAG		; 1 = d
	RETURN

	BTFSC	MODE_FLAG			; 0 = _ŁA1 = A_
	RETURN

	BSF		LED1_PORT			; A_Ȃ LED1 ͓_Ȃ
	BSF		LED1_ON_FLAG

	RETURN

;--------------------------------------------------------------------------------
;	L[XLƎԒ
;	RETURN:		KEY_LONG_FLAG		1 = 莞ԃL[ꂽ
;--------------------------------------------------------------------------------

SCAN_LOOP:

	BCF		KEY_LONG_FLAG			; 0 = L[ĂȂ
	NOP
	BCF		KEY_SHORT_FLAG			; 0 = L[ʏ퉟ĂȂ

	MOVLF	D'4',WORK

;
;	L[XL
;

SCAN_LOOP_2:

	BTFSS	KEY_PORT				; L[XLAL = KEY ON
	GOTO	CHECK_SHUTDOWN			; Ă

;
;	L[Ă
;

	MOVF	KEY_ON_CNT,W
	BTFSC	STATUS,Z
	GOTO	SCAN_LOOP_3				; ܂ 1L[ĂȂȂ玞Ԃ

	GOTO	CHECK_KEY_CNT			; L[Œ 1 񉟂Ă痣ꂽ

;
;	L[Ă
;	Vbg_E񐔂ɒBĂ邩
;

CHECK_SHUTDOWN:

	MOVLW	KEY_LONG_C
	SUBWF	KEY_ON_CNT,W
	BTFSC	STATUS,C				; if KEY_ON_CNT < ݒl, C=0, Skip next line
	GOTO	KEY_LONG_ON				; ꂽ̂ő߂

;
;	Vbg_E񐔖܂L[Ă
;

	INCF	KEY_ON_CNT,F
	BTFSC	STATUS,Z
	DECF	KEY_ON_CNT,F			; 255 őł~

SCAN_LOOP_3:

	CALL	SLEEP_64ms

	DECFSZ	WORK,F					; 񐔃XLs
	GOTO	SCAN_LOOP_2

	RETURN							; ЂƂ܂XLI

;
;	L[Ԃ̔
;	Ԗłɔł
;

CHECK_KEY_CNT:

	MOVLW	KEY_SHORT_C
	SUBWF	KEY_ON_CNT,W
	BTFSC	STATUS,C				; if KEY_ON_CNT < ʏ퉟ݒl, C=0, Skip next line
	GOTO	KEY_SHORT_ON			; ʏ퉟ꂽ

;
;	L[XLpJE^NA
;

CLR_KEY_CNT:

	CLRF	KEY_ON_CNT

	RETURN

;
;	m
;

KEY_LONG_ON:

	BSF		KEY_LONG_FLAG			; tOZbg

	GOTO	CLR_KEY_CNT

;
;	ʏ퉟m
;

KEY_SHORT_ON:

	BSF		KEY_SHORT_FLAG			; ʏ퉟tOZbg

	GOTO	CLR_KEY_CNT

;---------------------------------------------------------------------------
;	邳`FbN
;---------------------------------------------------------------------------

BRIGHTNESS_CHECK:

;--------------------------------------------------------------------------------
;	AD ϊ
;--------------------------------------------------------------------------------

	SET_BANK 1

	MOVLW	B'00000001'		; AN0, l (8bit), ADC ON
	MOVWF	ADCON0			; Bank 1

	CALL	READ_V			; A/D ϊs

;
;	邳
;	2.048V = 255
;

	MOVLW	BRIGHT_C		; uvƔfd萔
	SUBWF	AD_VALUE,W		; ADRESH - ݒl -> W
	BTFSS	STATUS,C		; if ADRESH >= ݒl, C=1, skip next line
	GOTO	DETECT_NIGHT	; 錟o

;
;	Ԍo
;

	CALL	CLR_NIGHT_COUNTER	; Ԍoϐ̓NA

	BTFSC	DAY_FLAG		;  = 1
	RETURN					; ɒԏ

	DECFSZ	DAY_COUNT,F		; ԌoJE^炷
	RETURN					; ܂e͈͓Ȃ̂ł̂܂ܖ߂

	BSF		DAY_FLAG		; ԃtO𗧂Ă

	CALL	ALERT

	RETURN

;
;	Ԍo
;

DETECT_NIGHT:

	CALL	CLR_DAY_COUNTER		; Ԍoϐ̓NA

	BTFSS	DAY_FLAG		;  = 0
	RETURN					; ɖԏ

	DECFSZ	NIGHT_COUNT,F	; ԌoJE^炷
	RETURN					; ܂e͈͓Ȃ̂ł̂܂ܖ߂

	BCF		DAY_FLAG		; ԃtOZbg = 

;	CALL	ALERT

	RETURN

;--------------------------------------------------------------------------------
;	Ԍo֘AϐZbg
;--------------------------------------------------------------------------------

CLR_DAY_COUNTER:

	MOVLW	DAY_CHECK_C
	MOVWF	DAY_COUNT		; ԃJE^l

	RETURN

;--------------------------------------------------------------------------------
;	Ԍo֘AϐZbg
;--------------------------------------------------------------------------------

CLR_NIGHT_COUNTER:

	MOVLW	NIGHT_CHECK_C
	MOVWF	NIGHT_COUNT		; ԃJE^l

	RETURN

;--------------------------------------------------------------------------------
;	dopϐZbg
;--------------------------------------------------------------------------------

CLR_LBAT_COUNTER			; dopJE^l

	MOVLW	LBAT_C
	MOVWF	LBAT_CNT

	RETURN

;--------------------------------------------------------------------------------
;	dopϐZbg
;--------------------------------------------------------------------------------

CLR_HBAT_COUNTER			; dopJE^l

	MOVLW	HBAT_C
	MOVWF	HBAT_CNT

	RETURN

;---------------------------------------------------------------------------
;	d`FbN
;---------------------------------------------------------------------------

LOW_BAT_CHECK:

	SET_BANK 1

	MOVLW	B'00000101'		; AN1, l (8bit), ADC ON
	MOVWF	ADCON0			; Bank 1

	CALL	READ_V			; dǂݍ

;
;	dd

	MOVLW	B2.7V_C					; 2.7V ݒl
	SUBWF	AD_VALUE,W				; ADRESH - ݒl -> W, ݒlȉ͒dƔ
	BTFSC	STATUS,C				; if ADRESH < ݒl, C=0, skip next line
	GOTO	VOLTAGE_OK				; d

;
;	d
;

	CALL	CLR_HBAT_COUNTER		; 팟opJE^NA

	BTFSC	LOW_BAT_FLAG			; ɒdݒ ?
	RETURN							; Yes, Ȃ OK

	DECFSZ	LBAT_CNT,F
	RETURN							; 񐔂܂ł͉Ȃ

	BSF		LOW_BAT_FLAG			; doʒm

	CALL	ALERT

	CALL	CLR_LBAT_COUNTER		; Ô߃Zbg

	RETURN

;
;	d
;

VOLTAGE_OK:

	CALL	CLR_LBAT_COUNTER		; dopJE^NA

	BTFSS	LOW_BAT_FLAG			; ݁AdԂőҋ@ ?
	RETURN							; No, Ȃ OK

	DECFSZ	HBAT_CNT,F
	RETURN							; 񐔂܂ł͉Ȃ

	CALL	CLR_HBAT_COUNTER		; Ô߃Zbg

;
;	d񕜂͂荂dɖ߂ƂmFĂĊJ
;

	MOVLW	B3.0V_C
	SUBWF	AD_VALUE,W				; ADRESH - ݒl -> W, dA͐ݒlȏƂ
	BTFSS	STATUS,C				; if ADRESH >= ݒl, C=1, skip next line
	RETURN							; ܂AF߂Ȃ

;
;	\ɓdA
;

;	CALL	ALERT

	BCF		LOW_BAT_FLAG			; dʒm

	BTFSC	MODE_FLAG
	BSF		LED2_PORT				; A_ŕAꍇ LED2 _

	RETURN

;---------------------------------------------------------------------------
;	A/D ϊs
;	BANK 1  CALL, Bank 0 Ń^[
;---------------------------------------------------------------------------

READ_V:

	CALL	WAIT_10ms		; v`[W҂

	BSF		ADCON0,GO		; Bank 0, AD ϊJn

	BTFSC	ADCON0,GO		; ϊI ?
	GOTO	$-1				; No

	BCF		ADCON0,ADON		; ADC OFF

	MOVFF	ADRESH,AD_VALUE	; Bank 1 -> oN

	SET_BANK 0

	RETURN

;--------------------------------------------------------------------------------
;	drd LED \
;--------------------------------------------------------------------------------

DISP_BATTERY:

	SET_BANK 2

	MOVLW	B'10000010'		; Internal VREF ON, 2.048V
	MOVWF	FVRCON			; Bank 2

	SET_BANK 1

	MOVLW	B'00000101'		; AN1, l (8bit), ADC ON
	MOVWF	ADCON0			; Bank 1

	CALL	READ_V			; Bank 1 ̂܂ CALLAA/D ϊs with v`[W҂ABank 0 Ń^[

;
;	dɉtO̐ݒ
;

	BSF		LED1_ON_FLAG	; ԓ_
	BCF		LED2_ON_FLAG	; 

	MOVLW	B3.0V_C
	SUBWF	AD_VALUE,W
	BTFSS	STATUS,C		; if AD_VALUE >= ݒl, C=1, skip next line
	GOTO	FLASH_LED		; tOύXsv

;
;	3.0V ` 3.9V
;

	BSF		LED2_ON_FLAG	; _

	MOVLW	B3.9V_C
	SUBWF	AD_VALUE,W
	BTFSS	STATUS,C		; if AD_VALUE >= ݒl, C=1, skip next line
	GOTO	FLASH_LED

;
;	3.9V ȏ
;

	BCF		LED1_ON_FLAG	; ԏ

;
;	dɉ LED _
;

FLASH_LED:

	BCF		LED1_PORT		; 
	NOP
	BCF		LED2_PORT		; 

	MOVLF	D'4',WORK

FLASH_LED_2:

	BTFSC	LED1_ON_FLAG
	BSF		LED1_PORT

	BTFSC	LED2_ON_FLAG
	BSF		LED2_PORT

	CALL	SLEEP_64ms

	BCF		LED1_PORT
	NOP
	BCF		LED2_PORT

	CALL	SLEEP_64ms

	DECFSZ	WORK,F			; 񐔓_
	GOTO	FLASH_LED_2

	CALL	SLEEP_512ms

	RETURN

;---------------------------------------------------------------------------
;	ɉmFTCiLED2 _Łjo
;	d  LED 1iԁj_
;	Ԍo    LED 2ij_
;---------------------------------------------------------------------------

ALERT:

	BCF		LED1_PORT
	NOP
	BCF		LED2_PORT

	BTFSC	LOW_BAT_FLAG
	BSF		LED1_PORT			; dȂ LED 1 _

	BTFSC	DAY_FLAG
	BSF		LED2_PORT			; ԌoȂ LED 2 _

	CALL	SLEEP_64ms

	BCF		LED1_PORT			; LED 1 
	NOP
	BCF		LED2_PORT			; LED 2 

	CALL	SLEEP_64ms

	BTFSC	LOW_BAT_FLAG
	BSF		LED1_PORT			; dȂ LED 1 _

	BTFSC	DAY_FLAG
	BSF		LED2_PORT			; ԌoȂ LED 2 _

	CALL	SLEEP_64ms

	BCF		LED1_PORT			; LED 1 
	NOP
	BCF		LED2_PORT			; LED 2 

	CALL	SLEEP_64ms

	RETURN

;---------------------------------------------------------------------------
;	WDT  64ms 点ďȓd͉
;---------------------------------------------------------------------------

SLEEP_64ms:

	MOVLW	B'00001100'		; WDT PS:2048 = 64ms

	GOTO	SLEEP_WAIT

;---------------------------------------------------------------------------
;	WDT  128ms 点ďȓd͉
;---------------------------------------------------------------------------

SLEEP_128ms:

	MOVLW	B'00001110'		; WDT PS:4096 = 128ms

	GOTO	SLEEP_WAIT

;---------------------------------------------------------------------------
;	WDT  256ms 点ďȓd͉
;---------------------------------------------------------------------------

SLEEP_256ms:

	MOVLW	B'00010000'		; WDT PS:8192 = 256ms

	GOTO	SLEEP_WAIT

;---------------------------------------------------------------------------
;	WDT  512ms 点ďȓd͉
;---------------------------------------------------------------------------

SLEEP_512ms:

	MOVLW	B'00010010'		; WDT PS:16384 = 512ms

	GOTO	SLEEP_WAIT

;---------------------------------------------------------------------------
;	w莞 SLEEP sAWDT ŕA
;	IN		W = WDTCON WX^l
;---------------------------------------------------------------------------

SLEEP_WAIT:

	SET_BANK 1

	MOVWF	WDTCON			; Bank 1

	BSF		WDTCON,SWDTEN	; Bank 1, WDT ON

	SLEEP
	NOP						; A|Cg

	BCF		WDTCON,SWDTEN	; Bank 1, WDT OFF

	SET_BANK 0

	RETURN

;---------------------------------------------------------------------------
;	 SLEEP Ŗ 10ms ҂
;---------------------------------------------------------------------------

WAIT_10ms:

	MOVLF	D'24',WORK		; 132us
	DECFSZ	WORK,F			; 132us
	GOTO	$-1				; 132us

	RETURN

;---------------------------------------------------------------------------
;	A/D ϊAWdd
;---------------------------------------------------------------------------

AD_VREF_ON:

	SET_BANK 2

	BSF		FVRCON,FVREN		; Bank 2

	SET_BANK 1

	BSF		ADCON0,ADON			; Bank 1

	SET_BANK 0

	RETURN


AD_VREF_OFF:

	SET_BANK 2

	BCF		FVRCON,FVREN		; Bank 2

	SET_BANK 1

	BCF		ADCON0,ADON

	SET_BANK 0

	RETURN

;---------------------------------------------------------------------------
;	EEPROM ̈
;---------------------------------------------------------------------------
;
;	ORG		H'2100'			; EEPROM JnԒnw
;
;	DE		D'0'			; &H00
;
	END

