;********************************************************************************
;	LCD `FbJ[ v1.00
;	For PIC16F88, for 8MHz clock
;	v1.00	2009/09/08`2009/09/23
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/LED_Checker.htm
;********************************************************************************

	LIST		P=16F88
	INCLUDE		P16F88.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

	__CONFIG  _CONFIG1, _CP_OFF & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;	̓ZbgL

	__CONFIG  _CONFIG2, _IESO_OFF & _FCMEN_OFF

;--------------------------------------------------------------------------------
;	\ʃCAEg
;--------------------------------------------------------------------------------
;POS
;0 2     8     EF	AhX
;N 0.1mA VF:3.40V
;R   2mA VF:3.40V

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK			 H'20'	; ϐGA擪AhX

VOLTAGE_H				; A/D ϊl
VOLTAGE_L				; A/D ϊl
CURRENT					; dlǗp
MEASURE_COUNTER			; JE^
SCAN_COUNTER			; L[XLpJE^
TMP0					; ėp
MOD_H					; Vf vZp[N
MOD_L					; Vf vZp[N
USER_FLAG				; etO

ENDC

;---------------------------------------------------------------------------

CBLOCK			H'78'	; SoNʕϐGAɊm, 16F88 ̏ꍇ 0070H-007FH

EEPROM_COUNTER			; EEPROM ANZXpJE^
EEPROM_ADRS				; EEPROM AhXۑp
EEPROM_LENGTH			; EEPROM 擾镶

START_POS				; \J[\ʒu

TMP1					; AhXvZp[N
TMP2					; AhXvZp[N

ENDC

;--------------------------------------------------------------------------------
;	|[g蓖
;--------------------------------------------------------------------------------
;
;	RA0		AN	IN		Vf p
;	RA1		D	OUT		 3.0mA
;	RA2		D	OUT		 5.6mA
;	RA3		D	OUT		11.2mA
;	RA4		D	IN		UP SW
;	RA5		D	IN		RESET
;	RA6		D	OUT		 15mA
;	RA7		D	OUT		 30mA

;	RB0		D	OUT		LCD RS
;	RB1		D	OUT		LCD E
;	RB2		D	IN		DOWN SW
;	RB3		D	OUT		[
;	RB4		D	OUT		LCD DB4
;	RB5		D	OUT		LCD DB5
;	RB6		D	OUT		LCD DB6
;	RB7		D	OUT		LCD DB7
;
;---------------------------------------------------------------------------
; |[g`iEQU  DEFINE ̕fobOɕ֗j
;---------------------------------------------------------------------------

#DEFINE		CTRLTRIS	TRISA		; e I/O |[g
#DEFINE		LCDTRIS		TRISB

#DEFINE		LCDPORT		PORTB
#DEFINE		CTRLPORT	PORTA		; LCD ȊÕRg[|[g

#DEFINE		VF		0
#DEFINE		UP_SW	4

#DEFINE		DW_SW	2
#DEFINE		RELAY	3

#DEFINE		VF_PORT			CTRLPORT,VF
#DEFINE		UP_KEY_PORT		CTRLPORT,UP_SW

#DEFINE		RELAY_PORT		LCDPORT,RELAY
#DEFINE		DW_KEY_PORT		LCDPORT,DW_SW

#DEFINE		UP_KEY_STATUS		USER_FLAG,0		; 1 = L[ꂽ
#DEFINE		DW_KEY_STATUS		USER_FLAG,1		; 1 = L[ꂽ
#DEFINE		RELAY_FLAG			USER_FLAG,RELAY	; 1 = ɐ]
#DEFINE		REVERSE_FLAG		USER_FLAG,4		; 1 = Ɉxɐ]݂
#DEFINE		LED_CON_FLAG		USER_FLAG,5		; 0 = LED ڑ

;---------------------------------------------------------------------------
; 萔`
;---------------------------------------------------------------------------

#DEFINE		MEASURE_TIMES		D'20'	; 񐔁iő65j

;--------------------------------------------------------------------------------
;	vOX^[g
;--------------------------------------------------------------------------------

	ORG		H'0'			; vOJnԒn̎w
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏigpj
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX
	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	dlɉ|[g̏o̓p^[𓾂
;--------------------------------------------------------------------------------

GET_PORT_BIT:

	ADDWF	PCL,F
;               xx   x
	RETLW	B'00000000'	;	0.1
	RETLW	B'00000010'	;	  3
	RETLW	B'00000100'	;	  5
	RETLW	B'00000110'	;	  8
	RETLW	B'00001000'	;	 10
	RETLW	B'01000000'	;	 15
	RETLW	B'01000100'	;	 20
	RETLW	B'10000000'	;	 30
	RETLW	B'10001000'	;	 40
	RETLW	B'10010100'	;	 50
	RETLW	B'10011100'	;	 60

;--------------------------------------------------------------------------------
; Lϊe[u̓AZuAhX100ԒnɎ߂邱ƁI
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	
;--------------------------------------------------------------------------------

INITIALIZE:

	BANKSEL	PORTA			; Bank 0
	CLRF	PORTA
	CLRF	PORTB

	BANKSEL	OSCCON			; Bank 1
	MOVLW	B'01111100'		; NbN 8MHz ɐݒ
	MOVWF	OSCCON

	CLRF	PIE1			; Bank1, 荞݂͑Sĕs

	BANKSEL	ANSEL			; Bank 1, ANSEL ݒ TRISA/B ݒOłȂ_ƂET
	CLRF	ANSEL			; S|[gfW^ɐݒ

	BSF		ANSEL,VF		; Vf do|[gAiO

	CLRF	TRISB			; Bank 1, S|[go͂
	CLRF	TRISA

	BSF		VF_PORT			; IN Đݒ
	NOP	
	BSF		UP_KEY_PORT		; IN Đݒ
	NOP	
	BSF		DW_KEY_PORT		; IN Đݒ

	BANKSEL CMCON			; Bank 0
	MOVLW	B'00000111'		; Rp[^gp
	MOVWF	CMCON

;--------------------------------------------------------------------------------
;	A/D Ro[^[ݒ (10bit)
;--------------------------------------------------------------------------------

	BANKSEL	ADCON1			; Bank 1
	MOVLW	B'10000000'		; El(10bit A/Dϊ)A32 Tosci̍ŏʃrbgj, Vref+ = Vdd, Vref- = Vss
	MOVWF	ADCON1

	BANKSEL ADCON0			; Bank 0
	MOVLW	B'10000001'		; 32 Tosc, AN0 gp, AD Ro[^d ON
	MOVWF	ADCON0

;--------------------------------------------------------------------------------
;	ϐAʏ
;--------------------------------------------------------------------------------

	CALL	WAIT_10ms		; d苟̂ߏ҂
	CALL	LCD_INI			; LCD 

START:

	CLRF	USER_FLAG		; etONA
	CLRF	CURRENT			; dǗl 0 = 0.1mA X^[g
	INCF	CURRENT,F		; dǗl 1 =   3mA X^[g

;--------------------------------------------------------------------------------
;	C[`
;--------------------------------------------------------------------------------

SWEEP:

	CALL	CHANGE_CURRENT	; dݒ蔽f

	MOVLW	D'10'			; 200ms x 10 = 2 sec
	MOVWF	SCAN_COUNTER

SWEEP2:

	CALL	GET_VF			; VF 擾 (Total 200ms)

	CALL	CHECK_VF		; LED ڑĂ邩`FbN
	BTFSS	LED_CON_FLAG	; 1 Ȃ LED ͐ڑĂ̂Ŏ̍sXLbv
	GOTO	LED_NO_CONNECT	; LED ڑBڑ҂āAC^NeBu[hōĊJ

	CALL	UP_KEY_CHECK

	BTFSC	UP_KEY_STATUS
	GOTO	WAIT_KEY		; L[ꂽ炽ɃC^NeBu[h

	CALL	DW_KEY_CHECK

	BTFSC	DW_KEY_STATUS
	GOTO	WAIT_KEY		; L[ꂽ炽ɃC^NeBu[h

	DECFSZ	SCAN_COUNTER,F
	GOTO	SWEEP2			; 莞ԃL[XL

	INCF	CURRENT,F		; dlǗԍ + 1

	MOVF	CURRENT,W
	SUBLW	D'5'			; dlǗԍ 5 = 15mA, 5 - W - > W
	BTFSS	STATUS,Z		; W = 5 Ȃ Z=1 Ŏ̍sXLbv
	GOTO	SWEEP			; 15mA ȉȂ̂ŃXC[vs

INTERACTIVE:				; 15mA ̓C^NeBu

	CALL	CHANGE_CURRENT	; dݒ蔽f

WAIT_KEY:

	MOVF	CURRENT,W
	SUBLW	D'10'			; dǗԍől - CURRENT -> W
	BTFSC	STATUS,Z
	GOTO	WAIT_KEY2		; ɍődȂ UP L[͖

	CALL	UP_KEY_CHECK	; UP L[`FbN
	BTFSS	UP_KEY_STATUS
	GOTO	WAIT_KEY2		; UP L[ĂȂ̂ DW L[`FbN

	INCF	CURRENT,F		; dl

	CALL	WAIT_100ms		; L[̘Ah~
	CALL	WAIT_100ms
	CALL	WAIT_100ms

	GOTO	INTERACTIVE		; dlf

WAIT_KEY2:

	MOVF	CURRENT,F		; dlɍŏ ?
	BTFSC	STATUS,Z
	GOTO	HOLD_DATA		; ɓdŏȂ DW L[͖

	CALL	DW_KEY_CHECK	; DW L[`FbN
	BTFSS	DW_KEY_STATUS
	GOTO	HOLD_DATA		; DW L[ĂȂ̂ň莞ԃf[^\

	DECF	CURRENT,F		; d

	CALL	WAIT_100ms		; L[̘Ah~
	CALL	WAIT_100ms
	CALL	WAIT_100ms

	GOTO	INTERACTIVE		; dlf

HOLD_DATA:

	MOVLW	D'5'			; 100ms x 5 = 0.5sec
	MOVWF	SCAN_COUNTER	; JE^

HOLD_DATA2:

	CALL	WAIT_100ms		; 莞ԕ\Œ

	DECFSZ	SCAN_COUNTER,F
	GOTO	HOLD_DATA2

	GOTO	INTERACTIVE		; đ`\JԂB_łŃL[͂𑣂


LED_NO_CONNECT:

	CALL	WAIT_CONNECT	; LED ڑ҂

	GOTO	INTERACTIVE

;---------------------------------------------------------------------------
; Tu[`Q
;---------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	dlɂă|[go͕ύX
;--------------------------------------------------------------------------------

CURRENT_SET:

	MOVF	CURRENT,W		; dlǗԍǂݏo

	CALL	GET_PORT_BIT	; o̓rbg𓾂

	MOVWF	CTRLPORT		; dݒ蔽f

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		LCD_16F88.lib
	INCLUDE		Time.lib
	INCLUDE		Math16.lib

;--------------------------------------------------------------------------------
;	dlύX
;	IN: CURRENT idǗԍ 0 - 10 j
;--------------------------------------------------------------------------------

CHANGE_CURRENT:

	MOVLW	H'00'			; f[^\
	MOVWF	EEPROM_ADRS
	MOVLW	POS0			; \ʒu
	MOVWF	START_POS

	MOVLW	LCD_CHR_LEN		; \
	MOVWF	EEPROM_LENGTH	; \Zbg

	CALL	PRINT_EEPROM_DATA	; obt@֕Rs[

	CALL	LCD_PRINT		; LCD \

	CALL	CURRENT_SET		; dlf

	CALL	GET_VF			; VF 擾

	CALL	CHECK_VF		; LED ڑĂ邩`FbN
	BTFSS	LED_CON_FLAG	; 1 Ȃ LED ͐ڑĂ̂Ŏ̍sXLbv
	GOTO	WAIT_CONNECT	; LED ڑAڑ҂

;
;	dlAdl\
;

	CALL	PRINT_DATA		; IF, VF \

	RETURN					; I

;--------------------------------------------------------------------------------
;	LED }܂ő҂
;--------------------------------------------------------------------------------

WAIT_CONNECT:

	MOVLW	H'10'			; INSERT LED bZ[W擪AhX
	MOVWF	EEPROM_ADRS
	MOVLW	POS0			; \ʒu
	MOVWF	START_POS

	MOVLW	LCD_CHR_LEN		; \
	MOVWF	EEPROM_LENGTH	; \Zbg

	CALL	PRINT_EEPROM_DATA	; obt@֕Rs[

	CALL	LCD_PRINT		; LCD \

WAIT_INSERT:

	CALL	GET_VF

	CALL	CHECK_VF
	BTFSC	LED_CON_FLAG	; 0 Ȃ LED ͖ڑȂ̂Ŏ̍sXLbv
	GOTO	CHANGE_CURRENT	; l\

	GOTO	WAIT_INSERT		; LED ڑAđ

;--------------------------------------------------------------------------------
;	VF  LED qĂ邩`FbN
;	VF = 4.8V ȏȂ LED ڑƔ肷
;	RETURN:	 LED_CON_FLAG = 0 Ȃ LED ڑ
;--------------------------------------------------------------------------------

CHECK_VF:

	BCF		REVERSE_FLAG	; ɐ]݂̃tONAĂ
	BCF		LED_CON_FLAG	; LED ڑtONA

CHECK_VF2:
;							; Vref+ 5V  4.8V  ADl = 984 = 03D8H
	MOVF	VOLTAGE_H,W
	SUBLW	H'03'			; 03H - VOLTAGE_H(W) -> W
	BTFSC	STATUS,Z		;  VOLTAGE_H(W) <> 03H Ȃ Z=0 Ŏ̍sXLbv
	GOTO	REVERSE			; VF 4V ȏmA[ŋɐ𔽓]Ă݂

	MOVF	VOLTAGE_L,W
	SUBLW	H'D8'			; E0H - VOLTAGE_L(W) -> W
	BTFSS	STATUS,C		; if VOLTAGE_L(W) <= D8H ȂL[ C=1 Ŏ̍sXLbv
	GOTO	REVERSE			; LED ڑmA[ŋɐ𔽓]Ă݂

	BSF		LED_CON_FLAG	; tO𗧂ĂiLED ͐ڑĂj

	RETURN

REVERSE:

	BTFSC	REVERSE_FLAG	; Ɉxɐ] ?
	RETURN					; ɋɐ]̂ŁALED ڑm

	BSF		REVERSE_FLAG	; ɐ]tO𗧂Ă

	CLRF	TMP0
	BSF		TMP0,RELAY		; [rbgʒu 1 ɂ
	MOVF	TMP0,W
	XORWF	LCDPORT,F		; [ rbĝ݃tO]ă|[g̔f
	XORWF	USER_FLAG,F		; [ rbĝ݃tO]

	CALL	WAIT_100ms		; [̐ړ_肷܂ŏ҂

	BTFSC	RELAY_FLAG
	CALL	WAIT_1sec		; ɐ]͈肷܂Œ҂

	CALL	GET_VF			; ēx Vf 

	GOTO	CHECK_VF2		; ēx`FbN

;--------------------------------------------------------------------------------
;	Vf 
;--------------------------------------------------------------------------------

GET_VF:

	CALL	WAIT_100ms		; d肷܂ŏ҂

	MOVLW	MEASURE_TIMES	; 
	MOVWF	MEASURE_COUNTER	; JE^

	CLRF	A1				; ώZlʃNA
	CLRF	A2				; ώZlʃNA

GET_VF2:

	CALL	WAIT_5ms		; ҂

	CALL	READ_VOLTAGE10	; A/D ϊ

	MOVF	VOLTAGE_H,W
	MOVWF	B1
	MOVF	VOLTAGE_L,W
	MOVWF	B2

	CALL	ADD16			; 16bit ̑ZAA1, A2 ɒl܂

	DECFSZ	MEASURE_COUNTER,F
	GOTO	GET_VF2
							; 鐔i܂ꂽj͊ A1, A2 ɓĂ
	CLRF	B1
	MOVLW	MEASURE_TIMES	; 鐔i񐔁jZbg
	MOVWF	B2

	CALL	DIV16			; 16bit Zŕϒlo

	MOVF	A1,W			; 
	MOVWF	VOLTAGE_H
	MOVF	A2,W			; 
	MOVWF	VOLTAGE_L

	RETURN

;--------------------------------------------------------------------------------
;	10 bit A/D ϊs
;	RETURN: VOLTAGE_H, VOLTAGE_L
;--------------------------------------------------------------------------------

READ_VOLTAGE10:

	BSF		ADCON0,GO		; GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ϊ

	MOVF	ADRESH,W		; Bank 0, A/D ϊliʁjǂݏo
	MOVWF	VOLTAGE_H		; ɃXgA

	BANKSEL	ADRESL			; Bank 1
	MOVF	ADRESL,W		; A/D ϊliʁjǂݏo

	BANKSEL	PORTA			; Bank 0
	MOVWF	VOLTAGE_L		; ɃXgA (BANK0ɂ_ɒӁj

	RETURN

;--------------------------------------------------------------------------------
;	dlAVf l\
;	IN: CURRENT = dlǗԍ 0-11
;--------------------------------------------------------------------------------

PRINT_DATA:

;
;	ɐ\obt@ɃZbg
;

	MOVLW	'N'

	BTFSC	RELAY_FLAG			; [䒆 ?
	MOVLW	'R'					; YES

	MOVWF	POS0				; ɐf[^obt@

;
;	dl\obt@ɃZbg
;

	MOVLW	H'20'
	MOVWF	TMP2				; Idl̐擪AhX

	MOVF	CURRENT,W			; dǗԍ𓾂
	BTFSC	STATUS,Z
	GOTO	SET_ADDRESS			; CURRENT = 0 ȂAhXvZsv

	MOVWF	TMP1				; dlAhX𓾂邽߂ɉ񑫂̃JE^
	MOVLW	D'3'				; ZăAhX𓾂

CALC_ADDRS:

	ADDWF	TMP2,F

	DECFSZ	TMP1,F
	GOTO	CALC_ADDRS

SET_ADDRESS:


	MOVF	TMP2,W				; \擪AhX
	MOVWF	EEPROM_ADRS
	MOVLW	POS2				; dl\Jnʒu
	MOVWF	START_POS
	MOVLW	D'3'				; \
	MOVWF	EEPROM_LENGTH		; \Zbg

	CALL	PRINT_EEPROM_DATA	; dlobt@փRs[

;
;	dl\obt@ɃZbg
;

	CALL	AD2VOLT				; Vf  ASCII ɕϊĕ\obt@ɓ]

;
;	f[^\s
;

	CALL	LCD_CLR
	CALL	LCD_PRINT			; LCD \

	RETURN

;--------------------------------------------------------------------------------
;	A/D ϊ̐l_1ʂ𔺂3̓d(ASCII)ɕϊ
;	IN:		A/D ϊlF	VOLTAGE_Hiʁj, VOLTAGE_Liʁj
;			AD x 5/1024 = Vf, _o߂10{ɂČvZ
;	RETURN:	\obt@ɓd\(ASCII)
;--------------------------------------------------------------------------------

AD2VOLT:

	MOVF	VOLTAGE_H,W
	MOVWF	A1				; ʃZbg
	MOVF	VOLTAGE_L,W
	MOVWF	A2				; ʃZbg

	CLRF	B1				; ʃNA
	MOVLW	D'50'			; ʃZbg
	MOVWF	B2

	CALL	MUL16			; in Math16.lib, 50{B 32bit  16bit  0 m

	MOVF	B1,W
	MOVWF	A1				; A/D ϊl x 50 ̏ʃZbg

	MOVF	B2,W
	MOVWF	A2				; A/D ϊl x 50 ̉ʃZbg

	MOVLW	D'4'			; 1024 = '00000100' + '00000000'
	MOVWF	B1
	CLRF	B2

	CALL	DIV16			; 1024 Ŋ

	MOVF	A1,W			; 
	MOVWF	prm1b
	MOVF	A2,W			; 
	MOVWF	prm1a

	MOVF	B1,W			; ]ʂۑĂ
	MOVWF	MOD_H
	MOVF	B2,W			; ]艺ʂۑĂ
	MOVWF	MOD_L

	CALL	HEX2DEC16		; in Math16.lib, BCD ϊ5̒10i
	CALL	BCD2ASCII16		; in Math16.lib, BCD  ASCII ϊ

	MOVLW	POS11
	MOVWF	FSR				; VF \obt@̐擪AhX

	MOVF	prm3b,W			; 10̈
	MOVWF	INDF
	INCF	FSR,F

	MOVLW	'.'
	MOVWF	INDF
	INCF	FSR,F

	MOVF	prm3a,W			; 1̈
	MOVWF	INDF
	INCF	FSR,F

;
;	Vf _2ʂ߂
;

	MOVF	MOD_H,W			; ]ʂZbg
	MOVWF	A1

	MOVF	MOD_L,W			; ]艺ʂZbg
	MOVWF	A2

	CLRF	B1
	MOVLW	D'10'			; 10{
	MOVWF	B2

	CALL	MUL16			; in Math16.lib

	MOVF	B1,W
	MOVWF	A1				; 鐔ʃZbg

	MOVF	B2,W
	MOVWF	A2				; 鐔ʃZbg

	MOVLW	D'4'			; 1024 = '00000100' + '00000000'
	MOVWF	B1
	CLRF	B2

	CALL	DIV16			; 1024 ŊB 0-9 ɂȂ

	MOVF	A2,W			; ʂ𓾂
	ADDLW	'0'				; W = ASCII R[h 0`9 ɂȂ

	MOVWF	INDF			; _2ʂZbg
	INCF	FSR,F

	MOVLW	'V'
	MOVWF	INDF

	RETURN

;--------------------------------------------------------------------------------
;	EEPROM ̎w蕶Ԃ̃f[^\obt@ɓ]
;	IN: EEPROM_ADRS   = \擪AhX
;	    EEPROM_LENGTH = \
;	    START_POS     = J[\ʒu
;--------------------------------------------------------------------------------

PRINT_EEPROM_DATA:

	MOVF		EEPROM_LENGTH,W
	MOVWF		EEPROM_COUNTER	; ʃoNϐ

	MOVF		START_POS,W
	MOVWF		FSR				; ]AhXݒ

	BSF			STATUS,RP1		; BANK2  RP1=1, RP=0, BANK3  RP1=1, RP0=1
								; BANKSEL  RP0 삵Ȃ_ɒ
COPY_EEPROM_DATA:

	MOVF		EEPROM_ADRS,W	; AhX擾
	BANKSEL		EEADR			; Bank 2
	MOVWF		EEADR			; ǂݏoAhXw

	BANKSEL		EECON1			; Bank 3
	BCF			EECON1,EEPGD	; Point to data memory
	BSF			EECON1,RD		; EE READ

	BANKSEL		EEDATA			; Bank 2
	MOVF		EEDATA,W		; W = EEDATA

	MOVWF		INDF			; ]
	INCF		FSR,F			; ]AhXJEgAbv
	INCF		EEPROM_ADRS,F	; ]AhXJEgAbv

	DECFSZ		EEPROM_COUNTER,F
	GOTO		COPY_EEPROM_DATA

	BCF			STATUS,RP1		; Bank 0 ɖ߂
	NOP
	BCF			STATUS,RP0

	RETURN

;--------------------------------------------------------------------------------
;	L[`FbN
;	RETURN: UP_ or DW_KEYS_STATUS = 0  L[͉ĂȂA1  L[ꂽ
;--------------------------------------------------------------------------------

UP_KEY_CHECK:

	BCF		UP_KEY_STATUS	; tOZbgĂ

	BTFSC	UP_KEY_PORT		; XCb`ꂽ? L = ꂽ
	RETURN

	CALL	WAIT_25ms		; ꂽ炵΂炭҂i`^Oh~j
	CALL	WAIT_25ms		; ꂽ炵΂炭҂i`^Oh~j

	BTFSC	UP_KEY_PORT		; ܂XCb`Ă邩?
	RETURN

	BSF		UP_KEY_STATUS		; L[Ă̂ŃtO𗧂Ă

	RETURN

DW_KEY_CHECK:				; DW KEY ̃XL

	BCF		DW_KEY_STATUS	; tOZbgĂ

	BTFSC	DW_KEY_PORT		; XCb`ꂽ? L = ꂽ
	RETURN

	CALL	WAIT_25ms		; ꂽ炵΂炭҂i`^Oh~j
	CALL	WAIT_25ms		; ꂽ炵΂炭҂i`^Oh~j

	BTFSC	DW_KEY_PORT		; ܂XCb`Ă邩?
	RETURN

	BSF		DW_KEY_STATUS	; L[Ă̂ŃtO𗧂Ă

	RETURN

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	ORG		H'2100'							; EEPROM JnԒnw

	DE	' ',' ',' ',' ',' ','m','A',' ','V','F',':',' ',' ',' ',' ','V' ; H00
	DE	'I','n','s','e','r','t',' ',' ','L','E','D',' ',' ',' ',' ',' ' ; H10

	DE	'0','.','1'		; H20, ȉ̍s͘AAhXŊmۂ邱
	DE	'3','.','1'
	DE	'5','.','7'
	DE	'8','.','7'
	DE	' ','1','1'
	DE	' ','1','5'
	DE	' ','2','0'
	DE	' ','3','0'
	DE	' ','4','0'
	DE	' ','5','0'
	DE	' ','6','0'

	END
