#!/usr/bin/perl
#
#	Geiger Counter log file -> Google Maps KML file converter
#	Programmed by GRANADA, since 2011/08/18
#
#	v1.0	2011/08/18 - 2011/08/27		; 1st release
#	v1.1	2011/09/05					; FÂXbVhꕔύX
#	v1.2	2011/10/07					; 10 CPM oIvVǉ
#	v1.3	2012/01/07					; GPS tf[^Ή
#	v1.4	2012/01/19					; G[`FbN
#	v1.5	2012/01/20					; G[`FbN (Of[^ Ratio = 0 ̏ꍇj
#	v1.6	2012/01/27					; wXbVhȏ̃f[^o[hǉ
#

#
#	ϐݒ
#

#$directory = 'log';		#	ŃOt@CfBNgw
$directory = 'E:';			#	̊ɍ킹ďׂ

$ver = '1.6';


$| = 1;

print STDERR "\nKML converter ver $ver\n";

unless ( -e $directory ) { die "***** Error !! Not found Data directory !! *****\n"; }

@icon = ( "Blue_Icon", "Purple_Icon", "Green_Icon", "Yellow_Icon", "Orange_Icon", "Pink_Icon", "Red_Icon" );

#		        Blue     Purple    Green    Yellow    Orange     Pink      Red
@threshold	= (      0.5,      1.0,     1.5,      3.0,       5.0,     10.0     );	#	7FACR̐F臒l

$converted_file		= 0;				#	ϊt@C
$line				= 0;				#	IWif[^̍sԍ
$place				= 1;				#	Google Maps |Cg
$distance_threshold	= '';				#	-c IvVŃXLbv鋗A1x = 111Km  _ 6 = 11cm
$ratio_threshold	= '';				#	-t IvVŎwB Ratio ȏ̃|Cgo
$extract_cpm		= 0;				#	0 = ŐV CPM Ƃ̑Ίl
										#	1 = ݐϕ CPM
										#	2 = 10 CPM
$total_point		= 0;				#	ϊSt@CԂ̃|Cg
$max_cpm			= 0;				#	ő CPM l
$ulog				= 'Unified_log.txt';


#
#	R}hIvV
#

while ( $cmd = shift @ARGV ) {

	if ( $cmd =~ /^\-c:(\d+)$/i ) {
		$distance = $1;
		print STDERR "Cordinates within }", $distance, "m are removed.\n";
		$skip_flag = 1;
		$distance_threshold = $distance / 100000;
		next;
	}

	if ( $cmd =~ /^\-r:(\d+)$/i ) {
		$reference = $1;
		print STDERR "Reference = $reference\n";
		next;
	}

	if ( $cmd =~ /^\-t:([\d|\.]+)$/i ) {
		$ratio_threshold = $1;
		print STDERR "Convert point over ratio $ratio_threshold only.\n";
		next;
	}

	if ( $cmd =~ /^\-f:(.+)$/i ) {
		$read_file = $1;
		print STDERR "File = $read_file\n";
		next;
	}

	if ( $cmd =~ /^\-v$/i ) {
		print STDERR "Verbose mode.\n";
		$verbose = 1;
		next;
	}

	if ( $cmd =~ /^\-a$/i ) {							#	ݐϕ CPM gpw
		print STDERR "Convert Total Avaraged CPM.\n";
		$extract_cpm = 1;
		next;  
	}

	if ( $cmd =~ /^\-10min$/i ) {						#	10 CPM gpw
		print STDERR "Convert 10min avaraged CPM.\n";
		$extract_cpm = 2;
		next;
	}

	if ( $cmd =~ /^\-m$/i ) {							#	}[NƂ̂݃Ro[g
		print STDERR "Convert Marked point only.\n";
		$marked_flag = 1;
		next;  
	}

	if (( $cmd =~ /^\-(\?|h)$/i ) or ( $cmd =~ /^\?/ )) {	#	HELP
		&usage;
		die;
	}

	if ( $cmd =~ /^\-u$/i ) {
		print STDERR "Convert unified log mode.\n";
		$ulog_flag = 1;
		next;
	}
}

print STDERR "\n";


if ( $ulog_flag eq '' ) {
	open ULOG, ">$ulog" or die "Can't write $ulog $!\n";
	if ( $read_file eq '' ) {
		&file_check;							#	fBNg̃f[^t@Cꗗ擾
			} else {
		@file = ("$read_file");
	}
		} else {
	@file = ("$ulog");
}


#
#	KML oJn
#

&write_header;

#
#	ϊ
#

foreach (@file) {
	&parse($_);
}

#
#	KML oI
#

&write_footer;

#
#	I
#

if ( $converted_file >= 1000 ) {
	print STDERR "*** Warning !! Points over 1000. ***\n\n";
}

if ( $ulog_flag eq '' ) {
	close ULOG;
}

print STDERR "Converted $converted_file files, $total_point points.\n";
print STDERR "Max CPM = $max_cpm\n";

#
#	Subroutines
#

#
#	ϊ{
#

sub parse {

	my $file = $_;

	if ( $verbose ne '' ) { print STDERR "Converting $file ...\n"; }

	my ( $cpm, $ratio, $mark, $icon, $th, $c, $th_max, $point );
	my ( $total_time, $cps, $latest_cpm, $averaged_cpm, $latest_10min_cpm, $latest_1H_count, $total_count, $ratio100, $sv100, $GPS_date, $GPS_time, $latitude, $NS, $longitude, $EW, $quality, $marker);

	my $skipped_point		= 0;				#	Ro[głȂ|Cg
	my $converted_point		= 0;				#	Ro[gł|Cg

	open DATA, "<$file" or die "Can't read $file $!\n";

	while (<DATA>) {

		$line_data = $_;

		$line++;

		chomp;
		s/ //g;

		($total_time, $cps, $latest_cpm, $averaged_cpm, $latest_10min_cpm, $latest_1H_count, $total_count, $ratio100, $sv100, $GPS_date, $GPS_time, $latitude, $NS, $longitude, $EW, $quality, $marker) = split /,/, $_;

#
#		GPS f[^i`FbN
#
		unless (( $quality eq '1' ) or ( $quality eq '2' )) {		#	Quality NG f[^̓pX
			&print_error ('GPS data quality NG');
			$skipped_point++;
			next;
		}

#
#		}[N|Cĝݒo
#

		if (( $marked_flag ne '' ) and ( $marker eq '' )) { &print_error ('No marker'); $skipped_point++; next; }

#
#		Wf[^`FbN
#

		unless  ( $latitude  =~ /^[+|-]\d{2}\.\d{6}$/ ) { &print_error('Illeegular or No cordinate data'); $skipped_point++; next; }
		unless  ( $longitude =~ /^[+|-]\d{3}\.\d{6}$/ ) { &print_error('Illeegular or No cordinate data'); $skipped_point++; next; }

#
#		Ratio f[^̕␳
#

		$ratio = $ratio100 / 100;											#	ŐV CPM ɑ΂Ίl

		if ( $extract_cpm eq '0' ) {										#	ŐV CPM o[h

				$cpm = $latest_cpm;

				} else {													#	ACPM or HCPM o[h

					if ( $ratio == 0 ) {
						&print_error ('Ratio data = 0');					#	Ratio ČvZs\
						$skipped_point++;
						next;
					}

					if ( $reference eq '' ) {
						$ref_cpm = $latest_cpm / $ratio;					#	lȂ瑪莞̊ CPM tZ
							} else{ 
						$ref_cpm = $reference;								#	lw肳ĂC
					}

					if (( $ref_cpm == 0 ) or ( $ref_cpm eq '' )) {			#	l`FbN
						&print_error ('Reference CPM = 0');
						$skipped_point++;
						next;
					}

					if ( $extract_cpm eq '1' ) {								#	ݐϕ CPM o[h

						$ratio = ( int ( $averaged_cpm / $ref_cpm ) / 100);		#	iݐϕ CPM  100{lӁj
						$cpm = int ( $averaged_cpm / 100 );

					} else {															#	10 CPM o[h

						$ratio = (int ($latest_10min_cpm * 100 / $ref_cpm )) / 100;		#	10 CPM  1{l
						$cpm   = $latest_10min_cpm;
				}
		}

#
#		Ratio threshold w肳Ă邩
#

		if (( $ratio_threshold ne '' ) and ( $ratio < $ratio_threshold )) { &print_error ('Under Ratio threshold'); $skipped_point++; next; }

#
#		s
#

		$th_max = scalar @icon;

		$icon = $icon[$th_max];												#	ЂƂ܂Ԃɐݒ

		for ( $c = 0; $c < $th_max; $c++ ) {
			if ( $ratio < $threshold[$c] ) { $icon = $icon[$c]; last; }		#	臒lɊÂĐF
		}

#
#		ܓxEox̂ǂw͈͓ňړ|Cg̓XLbv
#		}[J[tĂΖŃf[^
#

		$latitude =~ s/^\+//;
		$longitude =~ s/^\+//;

		if (( $skip_flag ne '' ) and ( $marker eq '' )) {

			unless (( $prev_latitude eq '' ) and ( $prev_longitude eq '' )) {

				$latitude_movement = abs ( $prev_latitude - $latitude );
				$longitude_movement = abs ( $prev_longitude - $longitude );

				if (( $latitude_movement <= $distance_threshold ) and ( $longitude_movement <= $distance_threshold )) {
					&print_error ('Very Close Cordinate');
					$skipped_point++;
					next;
				}																		
			}
		}

#
#		f[^o
#

		$prev_latitude = $latitude;				# update previous point
		$prev_longitude = $longitude;			# update previous point

		if ( $marker eq '' ) { $point = "P-" . $place; } else { $point = $marker; }

		$place++; 

		unless ( $GPS_date eq '' ) { $time_stamp = '(' . $GPS_date . ')'; }

		unless ( $reference eq '' ) {
			$ratio =  ( int( $cpm / $reference * 100 )) / 100;
		}

		if ( $max_cpm < $cpm ) { $max_cpm = $cpm; }

		print "\n";
		print " <Placemark>\n";
		print "  <name>$point</name>\n";
		print "  <description>$cpm" . "cpm, Ratio:$ratio $time_stamp</description>\n";
		print '  <styleUrl>#' , $icon, "</styleUrl>\n";
		print "  <Point>\n";
		print "   <coordinates>$longitude" . "," . "$latitude</coordinates>\n";
		print "  </Point>\n";
		print " </Placemark>\n";

		$converted_point++;

		print ULOG $line_data;

	}

	if ( $verbose ne '' ) {
		print STDERR "$file\n";
		print STDERR "Converted $converted_point points.\n";
		print STDERR "Skipped $skipped_point points.\n";
		print STDERR "\n";
	}

	$converted_file++;

	close DATA;

	$total_point += $converted_point;

	return
}

#
#	f[^t@CW
#

sub file_check {

	my @tmp;

	opendir  DATA_DIR, $directory;
		@tmp = readdir DATA_DIR;
	closedir DATA_DIR;

	foreach (@tmp) {
		unless ( /\.txt$/i ) { next; }				#	gq .txt 𒊏oΏۂƂ
		if ( /^Unified_log\.txt$/i ) { next; }		#	 Unified_log.txt ͏
		push @file, "$directory/$_";
	}

	return;
}

#
#	ACR̃X^C`
#

sub write_header {

	my $url  = 'http://maps.google.co.jp/mapfiles/ms/icons';

	print '<?xml version="1.0" encoding="UTF-8"?>', "\n";
	print '<kml xmlns="http://www.opengis.net/kml/2.2">', "\n";
	print '<Document>',"\n";

	print '<Style id="Blue_Icon">',"\n";
	print ' <IconStyle>',"\n";
	#print '  <scale>0.5</scale>', "\n";
	print '  <Icon>', "\n";
	print "   <href>$url/blue.png</href>\n";
	print '  </Icon>',"\n";
	print ' </IconStyle>',"\n";
	print '</Style>',"\n";

	print '<Style id="Purple_Icon">',"\n";
	print ' <IconStyle>',"\n";
	#print '  <scale>0.5</scale>', "\n";
	print '  <Icon>', "\n";
	print "   <href>$url/purple.png</href>\n";
	print '  </Icon>',"\n";
	print ' </IconStyle>',"\n";
	print '</Style>',"\n";

	print '<Style id="Green_Icon">',"\n";
	print ' <IconStyle>',"\n";
	#print '  <scale>0.5</scale>', "\n";
	print '  <Icon>', "\n";
	print "   <href>$url/green.png</href>\n";
	print '  </Icon>',"\n";
	print ' </IconStyle>',"\n";
	print '</Style>',"\n";

	print '<Style id="Yellow_Icon">',"\n";
	print ' <IconStyle>',"\n";
	#print '  <scale>0.5</scale>', "\n";
	print '  <Icon>', "\n";
	print "   <href>$url/yellow.png</href>\n";
	print '  </Icon>',"\n";
	print ' </IconStyle>',"\n";
	print '</Style>',"\n";

	print '<Style id="Orange_Icon">',"\n";
	print ' <IconStyle>',"\n";
	#print '  <scale>0.5</scale>', "\n";
	print '  <Icon>', "\n";
	print "   <href>$url/orange.png</href>\n";
	print '  </Icon>',"\n";
	print ' </IconStyle>',"\n";
	print '</Style>',"\n";

	print '<Style id="Pink_Icon">',"\n";
	print ' <IconStyle>',"\n";
	#print '  <scale>0.5</scale>', "\n";
	print '  <Icon>', "\n";
	print "   <href>$url/pink.png</href>\n";
	print '  </Icon>',"\n";
	print ' </IconStyle>',"\n";
	print '</Style>',"\n";

	print '<Style id="Red_Icon">',"\n";
	print ' <IconStyle>',"\n";
	#print '  <scale>0.5</scale>', "\n";
	print '  <Icon>', "\n";
	print "   <href>$url/red.png</href>\n";
	print '  </Icon>',"\n";
	print ' </IconStyle>',"\n";
	print '</Style>',"\n";

	return;
}

sub write_footer {

	print "\n</Document>\n";
	print "</kml>\n";

	return;
}

#
#	gp@\
#

sub usage {

	print STDERR "Usage  : perl make_kml.pl (sampling date) (-c:distance) (-a) (-m) (-r:reference)\n";
	print STDERR "Example: perl make_kml.pl 2011/08/23 -c:100 -a -m -r:24 -v\n";
	print STDERR "\n";
	print STDERR "  -c:distance   : Optional, Cordinate check mode. Cordinates within 'distance' meters are removed.\n";
	print STDERR "  -a            : Optional, Extract Total Averaged CPM.\n";
	print STDERR "  -10min        : Optional, Extract 10min Averaged CPM.\n";
	print STDERR "  -t:ratio      : Optional, Extract point over [thresholod ratio] only.\n";
	print STDERR "  -m            : Optional, Extract Marked point only.\n";
	print STDERR "  -u            : Optional, Convert unified log data.\n";
	print STDERR "  -r:reference  : Optional, Set reference (CPM) for ratio calculation.\n";
	print STDERR "  -v            : Optional, Verbose mode.\n";
	print STDERR "  -h or -? or ? : Help\n";
	print STDERR "\n";
	print STDERR "Data files must be stored in 'Data' directory.\n";
	print STDERR "\n";

	return;
}

sub print_error {

	unless ( $verbose eq '' )  {
		print STDERR "Line $line : Skipeed ($_[0])\n";
	}

	return
}

