;------------------------------------------------------------------------
;
;	CPM O\u[ for PIC16F1938
;
;	Programmed by GRANADA since 2011/07/20 -
;
;	Ver 1.0		2011/07/20 ` 2011/07/22	(16F886) 
;	Ver 1.1		2011/07/26 ` 2011/07/26	(16F886) ߋ10 CPM \ǉ
;	Ver 2.0		2011/07/27 ` 2011/08/05	16F1938 ɈڐA
;
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/CPM_Display.htm
;
;--------------------------------------------------------------------------------

	LIST		P=16F1938
	INCLUDE		P16F1938.INC
	INCLUDE		16F193x_Macro.asm_lib

	ERRORLEVEL	-202		; Bank 2,3 ANZX̃[jO}
	ERRORLEVEL	-205
	ERRORLEVEL	-302
;	ERRORLEVEL	-307		; vOy[W܂[jO}

    __CONFIG    _CONFIG1, _FCMEN_ON & _IESO_OFF & _BOREN_ON & _CPD_OFF & _CP_OFF & _MCLRE_OFF & _PWRTE_ON & _WDTE_OFF & _FOSC_HS & _CLKOUTEN_OFF
    __CONFIG    _CONFIG2, _WRT_OFF & _BORV_25 & _PLLEN_OFF & _STVREN_ON & _LVP_OFF

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'

	USER_FLAG			; etO

	TMR1_CNT			; TMR1 pJE^

	DISP_MODE			; \[hA0 = ŐV CPMA1 = ΊlA 2 = ݐϕ CPMA 3 = ݐσJEg

	BLIGHTNESS			; 邳

	PATTERN_C1			; \prbgp^[i}X^[p^[j
	PATTERN_C2			; \prbgp^[i}X^[p^[j
	PATTERN_C3			; \prbgp^[i}X^[p^[j
	PATTERN_C4			; \prbgp^[i}X^[p^[j

	SEGMENT				; \rbgp^[

	ASCII_CHR			; rbgp^[ϊp[N

	L3_VALUE			; MŐV CPM f[^ (ASCII)
	L2_VALUE
	L1_VALUE

	A3_VALUE			; Mݐϕ CPM f[^ (ASCII)
	A2_VALUE
	A1_VALUE

	C4_VALUE			; MݐσJEgf[^ (ASCII)
	C3_VALUE
	C2_VALUE
	C1_VALUE

	R4_VALUE			; MΊl x 100 f[^ (ASCII)
	R3_VALUE
	R2_VALUE
	R1_VALUE

	H3_VALUE			; Mߋ10 CPM f[^ (ASCII)
	H2_VALUE
	H1_VALUE

	DISP_VALUE_3
	DISP_VALUE_2
	DISP_VALUE_1

	KEY_FLAG			; L[XLp

	SW1_CNT				; L[XLpJE^
	SW2_CNT
	SW3_CNT

	COUNTER1			; ԑ҂p[N
	COUNTER2
	COUNTER3

ENDC

CBLOCK	H'70'			; SoNʃGA

	WORK				; C[`ėp[N
	INT_WORK			; 荞ݏ̔ėp[N

	EEPROM_DATA			; EEPROM ݒlASoNʃGAmەK{

ENDC

;---------------------------------------------------------------------------
;	|[g`
;---------------------------------------------------------------------------

#DEFINE		SW1_PORT	PORTA,1		; \ؑ		XCb`|[g`AL = ON
#DEFINE		SW2_PORT	PORTA,0		; uU[ ON/OFF	XCb`|[g`AL = ON
#DEFINE		SW3_PORT	PORTE,3		; f[^NA	XCb`|[g`AL = ON

#DEFINE		C1_PORT		PORTC,2		; 7 ZO LED 1ڐ|[g`
#DEFINE		C2_PORT		PORTC,3		; 7 ZO LED 2ڐ|[g`
#DEFINE		C3_PORT		PORTC,4		; 7 ZO LED 3ڐ|[g`
#DEFINE		C4_PORT		PORTC,5		; 7 ZO LED 4ڐ|[g`

#DEFINE		A_SEG		PORTB,0		; LED  a ZOg̃|[g`
#DEFINE		B_SEG		PORTB,1		; LED  b ZOg̃|[g`
#DEFINE		C_SEG		PORTB,2		; LED  c ZOg̃|[g`
#DEFINE		D_SEG		PORTB,3		; LED  d ZOg̃|[g`
#DEFINE		E_SEG		PORTB,4		; LED  e ZOg̃|[g`
#DEFINE		F_SEG		PORTB,5		; LED  f ZOg̃|[g`
#DEFINE		G_SEG		PORTB,6		; LED  g ZOg̃|[g`
#DEFINE		DP_SEG		PORTB,7		; LED dp ZOg̃|[g`

#DEFINE		DEBUG_PORT	PORTC,0		; fobOp|[g
#DEFINE		DEBUG_PORT2	PORTA,5

#DEFINE		SAMPLT_FLAG			USER_FLAG,0	; 1 = TvOԌoߍς
#DEFINE		RX_BUFF_FLAG		USER_FLAG,1	; 1 = Mobt@t
#DEFINE		DECODE_ERROR_FLAG	USER_FLAG,2	; 1 = ȊÕf[^Ă
#DEFINE		BLINK_FLAG			USER_FLAG,3	; 
#DEFINE		BLINK_MODE_FLAG		USER_FLAG,4	; 1 = uN[hɓ
#DEFINE		DATA_ERROR_FLAG		USER_FLAG,5	; 1 = Mf[^s
#DEFINE		DATA_SEND_FLAG		USER_FLAG,7	; dummy

#DEFINE		SW1_FLAG			KEY_FLAG,0	; 1 = 莞ԉꑱ
#DEFINE		SW2_FLAG			KEY_FLAG,1	; 1 = 莞ԉꑱ
#DEFINE		SW3_FLAG			KEY_FLAG,2	; 1 = 莞ԉꑱ

;---------------------------------------------------------------------------
;	萔`
;---------------------------------------------------------------------------

#DEFINE		KEY_SCAN_CS		D'20'			; L[ꂽƔf鎞ԁiWj
											; 24ms x 5 = 120ms ԉ
											; ƃXCb` ON 
#DEFINE		KEY_SCAN_CL		D'40'			; L[ꂽƔf鎞ԁi߁j

#DEFINE		PWM_CYCLE		D'250'			; PE2 WX^ݒl12.5KHzA
#DEFINE		DUTY100			D'249'			; DUTY ől
#DEFINE		DUTY0			D'1'			; DUTY ŏl
											; DUTY l傫 PIC  H o͊ԂȂ
											; \[XhCuȂ_]邱Ƃɒ

#DEFINE		A_PATTERN		B'01110111'		; A ̃rbgp^[
#DEFINE		L_PATTERN		B'00111000'		; L ̃rbgp^[
#DEFINE		E_PATTERN		B'01111001'		; E ̃rbgp^[
#DEFINE		H_PATTERN		B'01110110'		; H ̃rbgp^[
#DEFINE		r_PATTERN		B'01010000'		; r ̃rbgp^[

;---------------------------------------------------------------------------
;	dxN^
;---------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;---------------------------------------------------------------------------
;	ݏ
;---------------------------------------------------------------------------

	INCLUDE		CPM_Display_INT.asm_lib

;---------------------------------------------------------------------------
;	vO
;---------------------------------------------------------------------------

INITIALIZE:

	CLRF	PORTA
	CLRF	PORTB
	CLRF	PORTC
	CLRF	PORTE

	SET_BANK 1

	MOVLW	B'00000111'
	MOVWF	TRISA			; Bank 1, RA0, RA1, RA2 

	CLRF	TRISB			; Bank 1, RB ͑Sďo

	MOVLW	B'10000000'
	MOVWF	TRISC			; Bank 1, RX(RC7) ȊOS|[go

	SET_BANK 3

	MOVLW	B'00000100'
	MOVWF	ANSELA			; Bank 3, AN2 gp
	CLRF	ANSELB			; Bank 3
;	CLRF	ANSELD			; Bank 3, 16F1939 only
;	CLRF	ANSELE			; Bank 3, 16F1939 only

;--------------------------------------------------------------------------------
;	10bit A/D Ro[^[ݒ
;--------------------------------------------------------------------------------

	SET_BANK 1

	MOVLW	B'00100000'		; l (8bit A/Dϊ), Fosc/32, Vref+ = VDD, Vref- = VSS
	MOVWF	ADCON1			; Bank 1

	MOVLW	B'00001001'		; AN2 gp, AD Ro[^d ON
	MOVWF	ADCON0			; Bank 1

;--------------------------------------------------------------------------------
;	TMR1 ݒARyA 250ms 荞݂ɐݒ
;--------------------------------------------------------------------------------

	SET_BANK 5

	MOVLW	B'00001011'		; Campare mode with Special event triger enable
	MOVWF	CCP1CON			; Bank 5

	MOVLW	H'F4'			; &HF423 = 62500 - 1A0.5us x 62500 = 31.25ms
	MOVWF	CCPR1H			; Bank 5
	MOVLW	H'23'
	MOVWF	CCPR1L			; Bank 5, vXP[ƕ 31.25 x 8 = 250ms Ŋ荞ݔ

	SET_BANK 0

	MOVLW	B'00110100'		; vXP[ 1:8 ɐݒB31.25ms x 8 = 250ms ݁AJn͂܂
	MOVWF	T1CON			; Bank 0

;---------------------------------------------------------------------------
;	PWM ݒ ` TMR2 X^[g
;---------------------------------------------------------------------------

	SET_BANK 5

	MOVLW	B'10100010'		; Bank 5, CCP2 = TMR2, CCP1,3,4 = TMR6
	MOVWF	CCPTMRS0

	MOVLW	B'00000010'		; Bank 5, CCP5 = TMR6
	MOVWF	CCPTMRS1

	MOVLW	DUTY100			; DUTY 100% ŃX^[g
	MOVWF	CCPR2L			; Bank 5, DUTY ͂̃WX^̒lύXĒ

	MOVLW	B'00001100'		; PWM mode, P1A single output
	MOVWF	CCP2CON			; Bank 5

	SET_BANK 0

	MOVLW	PWM_CYCLE		; PWM 
	MOVWF	PR2				; Bank 0, PWM Zbg

	MOVLW	B'00000100'		; Postscale = 1:1, Prescale = 1, TMR2 ON
	MOVWF	T2CON			; Bank 0, TMR2 X^[g

	MOVLF	D'250',BLIGHTNESS	; ꂪƈÊX^[g PWM ȂȂ

;--------------------------------------------------------------------------------
;	RS232C ֘AWX^̏ݒ
;--------------------------------------------------------------------------------

	CALL	INIT_PIC_RESISTER	; in RS232C.asm_lib		; WX^
	CALL	CLR_RX_BUFF			; in RS232C.asm_lib		; Mobt@
	CALL	CLR_TX_BUFF			; in RS232C.asm_lib		; Mobt@

;---------------------------------------------------------------------------
;	EEPROM  \[hǂݏo
;---------------------------------------------------------------------------

	CLRW						; EEMPROM AhX
	CALL	READ_EEPROM			; in EEPROM.asm_lib, ݒl = W
	MOVWF	DISP_MODE

;--------------------------------------------------------------------------------
;	̑
;--------------------------------------------------------------------------------

	CLRF	USER_FLAG

	MOVLW	' '

	MOVWF	A3_VALUE
	MOVWF	A2_VALUE
	MOVWF	A1_VALUE

	MOVWF	L3_VALUE
	MOVWF	L2_VALUE
	MOVWF	L1_VALUE

	MOVWF	H3_VALUE
	MOVWF	H2_VALUE
	MOVWF	H1_VALUE

	MOVWF	C4_VALUE
	MOVWF	C3_VALUE
	MOVWF	C2_VALUE
	MOVWF	C1_VALUE

	MOVWF	R4_VALUE
	MOVWF	R3_VALUE
	MOVWF	R2_VALUE
	MOVWF	R1_VALUE

	CALL	INIT_KEY_CNT		; L[͏

;--------------------------------------------------------------------------------
;	݊Jn
;--------------------------------------------------------------------------------

	SET_BANK 1

	BSF		PIE1,CCP1IE		; Bank 1, RyA݋
	NOP
	BSF		PIE1,RCIE		; Bank 1, RS-232C M݋

	BSF		INTCON,GIE		; Core SFR, O[o݋
	NOP
	BSF		INTCON,PEIE		; Core SFR, ӊ݋

	SET_BANK 0

;---------------------------------------------------------------------------
;	C[v
;---------------------------------------------------------------------------

MAIN_LOOP:

	CALL	CHECK_BLIGHTNESS	; 邳ǂݍ݁A邳͏Ƀ`FbNifor software PWMj
	CALL	DIMMER				; PWM fB}[

	CALL	SET_PARAMETERS

	CALL	DISPLAY

	CALL	SCAN_SW
	CALL	KEY_JOB

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	ȉTu[`
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	LED \ZOgp^[𓾂
;	IN		L3_VALUE...L1_VALUE or A3_VALUE...A1_VALUE or C4_VALUE...C1_VALUE
;	RETURN	PATTERN_C1..C4
;--------------------------------------------------------------------------------

SET_PARAMETERS:

	MOVF	DISP_MODE,W				; ݐϕ CPM ?
	BTFSC	STATUS,Z
	GOTO	ACPM_MODE

	DECF	DISP_MODE,W				; ߋ10 CPM ?
	BTFSC	STATUS,Z
	GOTO	HCPM_MODE

	MOVLW	D'2'
	SUBWF	DISP_MODE,W				; ŐV CPM ?
	BTFSC	STATUS,Z
	GOTO	LCPM_MODE

	MOVLW	D'3'
	SUBWF	DISP_MODE,W				; Ίl ?
	BTFSC	STATUS,Z
	GOTO	RATIO_MODE

;
;	ݐσJEg[h
;

	MOVF	C4_VALUE,W				; ݐσJEg 4\
	CALL	ASCII2PATTERN
	MOVWF	PATTERN_C1

	SET_FSR0	C3_VALUE			; C3_VALUE ̃AhXݒ

	GOTO	SET_PARAM2

;
;	䃂[h
;

RATIO_MODE:

	MOVF	R4_VALUE,W				;  4\
	CALL	ASCII2PATTERN
	MOVWF	PATTERN_C1

	SET_FSR0	R3_VALUE			; R3_VALUE ̃AhXݒ

	GOTO	SET_PARAM2

;
;	ݐ CPM [h
;

ACPM_MODE:

	MOVLF	A_PATTERN, PATTERN_C1	; A ̃p^[Zbg

	SET_FSR0	A3_VALUE			; A3_VALUE ̃AhXݒ

	GOTO	SET_PARAM2

;
;	ߋ 10 CPM [h
;

HCPM_MODE:

	MOVLF	H_PATTERN, PATTERN_C1	; H ̃p^[Zbg

	SET_FSR0	H3_VALUE			; H3_VALUE ̃AhXݒ

	GOTO	SET_PARAM2

;
;	ŐV CPM [h
;

LCPM_MODE:

	MOVLF	L_PATTERN, PATTERN_C1	; ЂƂ܂ L ̃p^[Zbg

	SET_FSR0	L3_VALUE			; L3_VALUE ̃AhXݒ

SET_PARAM2:

	MOVIW	INDF0++					; f[^\pϐɃRs[
	MOVWF	DISP_VALUE_3			; 3\Ɋ荞ݑŃf[^Ȃ悤ɑޔĂ
	MOVIW	INDF0++
	MOVWF	DISP_VALUE_2
	MOVIW	INDF0++
	MOVWF	DISP_VALUE_1

	BCF		DECODE_ERROR_FLAG		; G[tONA

	MOVF	DISP_VALUE_3,W
	CALL	ASCII2PATTERN
	MOVWF	PATTERN_C2

	MOVF	DISP_VALUE_2,W
	CALL	ASCII2PATTERN
	MOVWF	PATTERN_C3

	MOVF	DISP_VALUE_1,W
	CALL	ASCII2PATTERN
	MOVWF	PATTERN_C4

	BTFSS	DECODE_ERROR_FLAG
	RETURN							; fR[hG[ΏI

;--------------------------------------------------------------------------------
;	fR[hG[ꍇɃrbgp^[ύX
;--------------------------------------------------------------------------------

SET_ERROR:

	CLRF	PATTERN_C1
	MOVLF	E_PATTERN,PATTERN_C2	; E ̃rbgp^[
	MOVLF	r_PATTERN,W
	MOVWF	PATTERN_C3				; r ̃rbgp^[
	MOVWF	PATTERN_C4				; r ̃rbgp^[

	RETURN

;--------------------------------------------------------------------------------
;	obt@ ASCII ZOgp^[ɕϊ
;	IN:		W = ASCII 
;	RETURN	W = rbgp^[
;--------------------------------------------------------------------------------

ASCII2PATTERN:

	MOVWF	ASCII_CHR
	MOVLW	' '
	SUBWF	ASCII_CHR,W
	BTFSC	STATUS,Z
	GOTO	BLANK_PATTERN		; f[^ ' '

	MOVLW	'0'
	SUBWF	ASCII_CHR,W
	BTFSS	STATUS,C			; if ASCII_CHR >= '0', C=1, skip  next line
	GOTO	ERROR_DATA

	MOVLW	':'
	SUBWF	ASCII_CHR,W
	BTFSC	STATUS,C			; if ASCII_CHR < &H4A, C=0, skip  next line
	GOTO	ERROR_DATA

	MOVLW	'0'
	SUBWF	ASCII_CHR,W			; BCD ɕϊ

	CALL	GET_7SEG_PATTERN	; f[^

	RETURN

BLANK_PATTERN:

	MOVLW	B'00000000'			; uNp^[

	RETURN

ERROR_DATA:

	BSF		DECODE_ERROR_FLAG	; G[tO𗧂Ă

	RETURN

;--------------------------------------------------------------------------------
;	1̐7ZOgrbgp^[Ԃ
;	IN:		W = 
;--------------------------------------------------------------------------------

GET_7SEG_PATTERN:

	BRW

	RETLW	B'00111111'	;	0
	RETLW	B'00000110'	;	1
	RETLW	B'01011011'	;	2
	RETLW	B'01001111'	;	3
	RETLW	B'01100110'	;	4
	RETLW	B'01101101'	;	5
	RETLW	B'01111101'	;	6
	RETLW	B'00100111'	;	7
	RETLW	B'01111111'	;	8
	RETLW	B'01101111'	;	9
;              gfedcba

;--------------------------------------------------------------------------------
;	VZO LED \
;	IN:		PATTERN_C1,2,3,4 irbgp^[j
;--------------------------------------------------------------------------------

DISPLAY:

	BTFSC	SAMPLT_FLAG			; TvOԂo߂
	GOTO	DISPLAY2

;
;	TvOԖ̃uN
;

	BTFSC	BLINK_FLAG
	GOTO	DISPLAY2

	CALL	CLR_7SEG			; LED S

	MOVLF	D'4', WORK			; 4Ԃ񎞊Ԃׂ

BLANK_LOOP:

	CALL	HOLD_7SEG			; \ێ
	CALL	HOLD_7SEG2			; ێ

	DECFSZ	WORK,F
	GOTO	BLANK_LOOP

	RETURN

;
;	\s
;

DISPLAY2:

;	1ڕ\

	CALL	CLR_7SEG			; LED S

	MOVF	PATTERN_C1,W
	BTFSS	STATUS,Z			; [TvX`FbN
	BSF		C1_PORT				; uN\ȊOȂ猅 ON

	MOVWF	SEGMENT
	CALL	DYNAMIC				; ZOgJn

;	2ڕ\

	MOVF	PATTERN_C2,W
	BTFSS	STATUS,Z			; [TvX`FbN
	BSF		C2_PORT				; uN\ȊOȂ猅 ON

	MOVWF	SEGMENT
	CALL	DYNAMIC				; ZOgJn

;	3ڕ\

	MOVLW	D'3'
	SUBWF	DISP_MODE,W			; \[h ?
	BTFSC	STATUS,Z
	BSF		PATTERN_C3,7		; Yes

	MOVF	PATTERN_C3,W
	BTFSS	STATUS,Z			; [TvX`FbN
	BSF		C3_PORT				; uN\ȊOȂ猅 ON

	MOVWF	SEGMENT
	CALL	DYNAMIC				; ZOgJn

;	4ڕ\

	BTFSC	DATA_ERROR_FLAG		; Mf[^G[ DP _
	BSF		PATTERN_C4,7

	MOVF	PATTERN_C4,W
	BTFSS	STATUS,Z			; [TvX`FbN
	BSF		C4_PORT				; uN\ȊOȂ猅 ON

	MOVWF	SEGMENT

	CALL	DYNAMIC				; ZOgJn

	RETURN

;--------------------------------------------------------------------------------
;	ʏ_Ci~bN_iX^eBbN_j
;	IN:		SEGMENT = rbgp^[
;--------------------------------------------------------------------------------

DYNAMIC:

	MOVF	SEGMENT,W			; ZOgp^[ '00000000'iuN\j 
	BTFSC	STATUS,Z
	GOTO	DISP_BLANK			; \uNȂ玞Ԃ

	BTFSC	SEGMENT,0
	BSF		A_SEG				; a ZOg_

SEG_B:

	BTFSC	SEGMENT,1
	BSF		B_SEG				; b ZOg_

SEG_C:

	BTFSC	SEGMENT,2
	BSF		C_SEG				; c ZOg_

SEG_D:

	BTFSC	SEGMENT,3
	BSF		D_SEG				; d ZOg_

SEG_E:

	BTFSC	SEGMENT,4
	BSF		E_SEG				; e ZOg_

SEG_F:

	BTFSC	SEGMENT,5
	BSF		F_SEG				; f ZOg_

SEG_G:

	BTFSC	SEGMENT,6
	BSF		G_SEG				; g ZOg_

SEG_DP:

	BTFSC	SEGMENT,7
	BSF		DP_SEG				; dp ZOg_

DISP_BLANK:						; uN\̏ꍇł莞Ԃ͏

	CALL	HOLD_7SEG			; \ێ

	CALL	CLR_7SEG

	CALL	HOLD_7SEG2			; ێ

	RETURN

;--------------------------------------------------------------------------------
;	7 ZO\莞ԕێ
;	n[hEGA PWM ɉAPxŒ̏ꍇ͕\Ԃ𒲐߂ĂɋPx
;	IN:		BLIGHTNESS
;--------------------------------------------------------------------------------

HOLD_7SEG:

	CALL	WAIT_1ms_8MHz

	MOVLW	DUTY0				; ŒPx AD l
	SUBWF	BLIGHTNESS,W
	BTFSS	STATUS,C			; if ADl >= ŒPx, C=1, skip next line
	RETURN

	GOTO	HOLD2

HOLD_7SEG2:

	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz

	MOVLW	DUTY0				; ŒPx AD l
	SUBWF	BLIGHTNESS,W
	BTFSC	STATUS,C			; if ADl < ŒPx, C=0, skip next line
	RETURN

HOLD2:

	CALL	WAIT_1ms_8MHz
	CALL	WAIT_1ms_8MHz

	RETURN

;--------------------------------------------------------------------------------
;	7 ZO\
;--------------------------------------------------------------------------------

CLR_7SEG:

	CLRF	PORTB			; L = OFF

	BCF		C1_PORT			; L =  OFF
	NOP
	BCF		C2_PORT
	NOP
	BCF		C3_PORT
	NOP
	BCF		C4_PORT

	RETURN

;--------------------------------------------------------------------------------
;	L[͂ɉ
;	IN:		L[̓tO
;--------------------------------------------------------------------------------

KEY_JOB:

	BTFSS	SW1_FLAG		; SW1 ꂽ
	GOTO	KEY_JOB2		; ĂȂ

;
;	\[hύX
;

	INCF	DISP_MODE,F
	MOVLW	D'5'
	SUBWF	DISP_MODE,W
	BTFSC	STATUS,Z
	CLRF	DISP_MODE		; NbsO

SAVE_DATA:

	MOVFF	DISP_MODE, EEPROM_DATA	; ۑf[^
	CLRW							; EEPROM AhX
	CALL	WRITE_EEPROM			; EEPROM ֕ۑ

	GOTO	KEY_JOB_END

KEY_JOB2:

	BTFSS	SW2_FLAG		; SW2 ꂽ
	GOTO	KEY_JOB3		; ĂȂ

	MOVLW	'B'				; uU[ ON/OFF R}h
	CALL	PREPARE_CMD

	CALL	SEND_CMD_DATA	; R}hM

	GOTO	KEY_JOB_END

KEY_JOB3:

	BTFSS	SW3_FLAG		; SW3 ꂽ
	RETURN					; ĂȂ̂ŏI

	MOVLW	'C'				; Sf[^NAR}h
	CALL	PREPARE_CMD

	CALL	SEND_CMD_DATA	; R}hM

	SET_BANK 1
	BCF		PIE1,RCIE		; Bank 1, RS-232C M~
	SET_BANK 0

	CALL	CLR_RX_BUFF		; in RS232C.asm_lib, Mobt@

	SET_BANK 1
	BSF		PIE1,RCIE		; Bank 1, RS-232C MĊJ
	SET_BANK 0

KEY_JOB_END:

	SET_BANK 0

	CALL	INIT_KEY_CNT_LONG	; L[͏AXLԒ

	RETURN

;--------------------------------------------------------------------------------
;	R}h쐬
;	IN:		W = M
;--------------------------------------------------------------------------------

PREPARE_CMD:

	MOVWF	WORK				; W ۑĂ

	SET_FSR0	TX_BUFFER		; o擪AhX

	MOVLW	'/'
	MOVWI	INDF0++

	MOVF	WORK,W				; R}hZbg
	MOVWI	FSR0++

	MOVLW	H'0D'
	MOVWI	INDF0++				; sR[h

	MOVLW	H'0A'
	MOVWI	INDF0++

	CLRF	INDF0				; I[R[h

	RETURN

;--------------------------------------------------------------------------------
;	RS-232C ɃR}h𑗂
;	 Bank 2 ̃obt@ɃZbg
;	FSR0 ͉
;--------------------------------------------------------------------------------

SEND_CMD_DATA:

	SET_FSR0	TX_BUFFER			; o擪AhX

	CALL	SEND_STR_232C			; 񑗏o, in RS232C.asm_lib

	RETURN

;--------------------------------------------------------------------------------
;	XCb`XL
;	w񐔘AăL[ĂtO𗧂ĂiΉj
;	RETURN:		SW1_FLAG, SW2_FLAG, SW3_FLAG, SW4_FLAG (1 = ꂽ)
;--------------------------------------------------------------------------------

SCAN_SW:

	BTFSS	SW1_PORT			; SW1 Ă邩
	GOTO	PUSH_SW1			; L = ꂽ

	MOVLF	KEY_SCAN_CS,SW1_CNT	; ĂȂ̂ŃJE^
	BCF		SW1_FLAG			; tONA
	GOTO	CHK_SW2				; ̃L[͂

PUSH_SW1:

	DECFSZ	SW1_CNT,F
	GOTO	CHK_SW2				; 񐔖Ȃ玟̃L[͏

	BSF		SW1_FLAG			; tO𗧂Ă
	MOVLF	KEY_SCAN_CS,SW1_CNT	; JE^

CHK_SW2:

	BTFSS	SW2_PORT			; SW2 Ă邩
	GOTO	PUSH_SW2			; L = ꂽ

	MOVLF	KEY_SCAN_CS,SW2_CNT	; ĂȂ̂ŃJE^
	BCF		SW2_FLAG			; tONA
	GOTO	CHK_SW3				; ̃L[͂

PUSH_SW2:

	DECFSZ	SW2_CNT,F
	GOTO	CHK_SW3				; 񐔖Ȃ玟̃L[͏

	BSF		SW2_FLAG			; tO𗧂Ă
	MOVLF	KEY_SCAN_CS,SW2_CNT	; JE^

CHK_SW3:

	BTFSS	SW3_PORT			; SW3 Ă邩
	GOTO	PUSH_SW3			; L = ꂽ

	MOVLF	KEY_SCAN_CS,SW3_CNT	; ĂȂ̂ŃJE^
	BCF		SW3_FLAG			; tONA
	GOTO	CHK_SW4				; ̃L[͂

PUSH_SW3:

	DECFSZ	SW3_CNT,F
	GOTO	CHK_SW4				; 񐔖Ȃ玟̃L[͏

	BSF		SW3_FLAG			; tO𗧂Ă
	MOVLF	KEY_SCAN_CS,SW3_CNT	; JE^

CHK_SW4:

								; L[ǉ͂

KEY_SCAN_END:

	RETURN

;--------------------------------------------------------------------------------
;	L[̓`FbNpJE^ƃtÕNA
;--------------------------------------------------------------------------------

INIT_KEY_CNT:

	MOVLW	KEY_SCAN_CS			; Wl

	GOTO	INT_KEY2

INIT_KEY_CNT_LONG:

	MOVLW	KEY_SCAN_CL			; 

INT_KEY2:

	MOVWF	SW1_CNT
	MOVWF	SW2_CNT
	MOVWF	SW3_CNT

	CLRF	KEY_FLAG			; L[̓tO

	RETURN

;--------------------------------------------------------------------------------
;	8bit A/D ϊŖ邳o
;	RETURN:		BLIGHTNESS	(0-255)A0 = ÂA255 = 邢
;--------------------------------------------------------------------------------

CHECK_BLIGHTNESS:

	CALL	WAIT_50us_8MHz	; v`[W҂

	SET_BANK 1

	BSF		ADCON0,GO		; Bank 1, GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; Bank 1, A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ A/D ϊ

	MOVF	ADRESH,W		; Bank 1, A/D ϊliʁjǂݏo

	SET_BANK 0

	MOVWF	BLIGHTNESS		; ɃXgA

	RETURN

;--------------------------------------------------------------------------------
;	fB}[ PWM 
;	IN:		BLIGHTNESS (0-255)A0 = ÂA255 = 邢
;--------------------------------------------------------------------------------

DIMMER:

	MOVLW	DUTY0
	SUBWF	BLIGHTNESS,W
	BTFSS	STATUS,C		; if BLIGHTNESS >= DUTY0, C=1, skip next line
	GOTO	MIN_DUTY

	MOVLW	DUTY100
	SUBWF	BLIGHTNESS,W
	BTFSC	STATUS,C		; if BLIGHTNESS < DUTY100, C=0, skip next line
	GOTO	MAX_DUTY

	MOVF	BLIGHTNESS,W	; DUTY_MAX Ȃ A/D ϊl̂܂ DUTY lƂ

SET_DUTY:

	SET_BANK 5

	MOVWF	CCPR2L			; DUTY ύX

	SET_BANK 0

	RETURN

MIN_DUTY:					; DUTY ŏiÊj

	MOVLW	DUTY0			; Œ̋Px

	GOTO	SET_DUTY

MAX_DUTY:					; DUTY őij

	MOVLW	DUTY100

	GOTO	SET_DUTY

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Wait.asm_lib			; ėpԑ҂Tu[`
	INCLUDE		EEPROM_16F193x.asm_lib	; EEPROM ANZXTu[`
	INCLUDE		RS232C_v2.asm_lib		; VAʐMCu

;---------------------------------------------------------------------------
;	EEPROM ̈f[^`i16FV[YƂ̓AhXقȂj
;---------------------------------------------------------------------------

	ORG		H'F000'			; EEPROM JnԒnw

	DE		D'2'			; &H00: \[h

;---------------------------------------------------------------------------
;	vOI
;---------------------------------------------------------------------------

	END

