;--------------------------------------------------------------------------------
;	PIC16F690 LED o[\Xs[h[^[
;	Programmed by GRANADA
;	Since 2010/08/06 - 08/12
;	Ver 1.0		16F88ł, 1st release
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/3color_Speed_Meter.htm
;--------------------------------------------------------------------------------

	LIST		P=16F690
	INCLUDE		P16F690.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_OFF & _INTRC_OSC_NOCLKOUT & _IESO_OFF & _WDT_OFF

;--------------------------------------------------------------------------------
;	t@CAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'		; [U[pt@CWX^iϐ̈j擪AhX

	LED_IN			; LED _
	PREV_DATA		; O̒l

	DISP_LOOP		; _Ci~bN_

	COUNTER1		; ԑ҂p[N
	COUNTER2		; ԑ҂p[N
	COUNTER3		; ԑ҂p[N

	BUNSHI			; 8bit Zp
	BUNBO			; 8bit Zp
	DIV_ANS			; 8bit Zp
	DIV_MOD			; 8bit Zp

ENDC

;--------------------------------------------------------------------------------
;	萔`
;--------------------------------------------------------------------------------

#DEFINE		CYCLE	D'48'					; _Ci~bN_ 1 Zbgɂ邩

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		DATA0		PORTA,0			; LED_iBCDl 0bitځj
#DEFINE		DATA1		PORTA,1			; LED_iBCDl 1bitځj
#DEFINE		DATA2		PORTA,2			; LED_iBCDl 2bitځj
#DEFINE		DATA3		PORTA,3			; LED_iBCDl 3bitځj

#DEFINE		LED2_PORT	PORTA,4
#DEFINE		LED1_PORT	PORTA,5

#DEFINE		LED11_PORT	PORTB,4
#DEFINE		LED10_PORT	PORTB,5
#DEFINE		LED9_PORT	PORTB,6
#DEFINE		LED8_PORT	PORTB,7

#DEFINE		LED14_PORT	PORTC,0
#DEFINE		LED13_PORT	PORTC,1
#DEFINE		LED12_PORT	PORTC,2
#DEFINE		LED5_PORT	PORTC,3
#DEFINE		LED4_PORT	PORTC,4
#DEFINE		LED3_PORT	PORTC,5
#DEFINE		LED6_PORT	PORTC,6
#DEFINE		LED7_PORT	PORTC,7

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏigpj
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX
	RETFIE

;--------------------------------------------------------------------------------
;	
;--------------------------------------------------------------------------------

INITIALIZE:

	BANKSEL	OSCCON				; Bank 1
	MOVLW	B'01111100'			; NbN 8MHz ɐݒ
	MOVWF	OSCCON

	BANKSEL	TRISA
	MOVLW	B'00001111'
	MOVWF	TRISA				; Bank 1APORTA 0,1,2,3 ̓|[gw
	CLRF	TRISB				; Bank 1AS|[go͂Ɏw
	CLRF	TRISC				; Bank 1AS|[go͂Ɏw

	BANK2
	CLRF	ANSEL				; Bank 2AS|[gfW^ɐݒ
	CLRF	ANSELH

	BANK0
	CALL	ALL_LED_OFF			; S LED 

	CLRF	LED_IN
;	MOVLW	D'255'
;	MOVWF	LED_IN				; lƂĕKlƈقȂl^Ă

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

MAIN_LOOP:

;--------------------------------------------------------------------------------
;	LED \̓ǂݏo
;--------------------------------------------------------------------------------

;	MOVF	LED_IN,W
;	MOVWF	PREV_DATA			; O̒lۑ

	MOVF	PORTA,W				; Bit0-3  BCD l
	ANDLW	B'00001111'			; AND -> W,  4bit NA
	MOVWF	LED_IN				; XgA

	SUBLW	D'14'				; 14 - LED_IN(W) -> W
	BTFSC	STATUS,C			; if LED > 14, C=0 Ŏ̍sXLbv
	GOTO	CHK_CNG				; 14 ȉ

	MOVLW	D'14'				; 14 ȏ̏ꍇ 14 ɕ␳
	MOVWF	LED_IN

;--------------------------------------------------------------------------------
;	f[^ωo
;--------------------------------------------------------------------------------

CHK_CNG:

;	MOVF	LED_IN,W
;	SUBWF	PREV_DATA,W			; PREV_DATA - LED_IN(W) -> W, OǂݏolƔr
;	BTFSS	STATUS,Z
;	CALL	CALC_LOOP			; _Ci~bN\񐔍ČvZ

;--------------------------------------------------------------------------------
;	LED \
;--------------------------------------------------------------------------------

EXEC_DISP:

	CALL	DISPLAY_LED			; LED o[_Ci~bN\

;	DECFSZ	DISP_LOOP,F
;	GOTO	EXEC_DISP			; 񐔃[v

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	Tu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	_Ci~bN_̕\񐔂肷i_ɂ鎞ԍɗ͖j
;	IN:			LED_INiĂ_j
;	RETURN:		DISP_LOOP
;--------------------------------------------------------------------------------

CALC_LOOP:

	MOVF	LED_IN,W
	BTFSS	STATUS,Z			; _ 0  ?
	GOTO	CALC2

	MOVLW	CYCLE				; _񐔂␳
	GOTO	SET_VALUE

CALC2:

	MOVWF	BUNBO

	MOVLW	CYCLE
	MOVWF	BUNSHI

	CALL	DIV8				; _񐔌vZ

SET_VALUE:

	MOVF	DIV_ANS,W
	MOVWF	DISP_LOOP			; \񐔂XgA

	RETURN

;--------------------------------------------------------------------------------
;	o[_Ci~bN_
;	̃[`͓̂_ LED ɂĎsԂقȂ_ɒ
;	if[^莞Ԗɕωꍇ͖薳j
;--------------------------------------------------------------------------------

DISPLAY_LED:

	CALL	ALL_LED_OFF			; S LED 

LED1:

	MOVLW	D'1'
	SUBWF	LED_IN,W			; LED_IN - 1 -> W
	BTFSS	STATUS,C			; if LED_IN >= 1, C = 1
	RETURN

	BCF		LED1_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED1_PORT			; 
	CALL	HOLD_LED2

LED2:

	MOVLW	D'2'
	SUBWF	LED_IN,W			; LED_IN - 2 -> W
	BTFSS	STATUS,C			; if LED_IN >= 1, C = 1
	RETURN

	BCF		LED2_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED2_PORT			; 
	CALL	HOLD_LED2

LED3:

	MOVLW	D'3'
	SUBWF	LED_IN,W			; LED_IN - 3 -> W
	BTFSS	STATUS,C			; if LED_IN >= 3, C = 1
	RETURN

	BCF		LED3_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED3_PORT			; 
	CALL	HOLD_LED2

LED4:

	MOVLW	D'4'
	SUBWF	LED_IN,W			; LED_IN - 4 -> W
	BTFSS	STATUS,C			; if LED_IN >= 4, C = 1
	RETURN

	BCF		LED4_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED4_PORT			; 
	CALL	HOLD_LED2

LED5:

	MOVLW	D'5'
	SUBWF	LED_IN,W			; LED_IN - 5 -> W
	BTFSS	STATUS,C			; if LED_IN >= 5, C = 1
	RETURN

	BCF		LED5_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED5_PORT			; 
	CALL	HOLD_LED2

LED6:

	MOVLW	D'6'
	SUBWF	LED_IN,W			; LED_IN - 6 -> W
	BTFSS	STATUS,C			; if LED_IN >= 6, C = 1
	RETURN

	BCF		LED6_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED6_PORT			; 
	CALL	HOLD_LED2

LED7:

	MOVLW	D'7'
	SUBWF	LED_IN,W			; LED_IN - 7 -> W
	BTFSS	STATUS,C			; if LED_IN >= 7, C = 1
	RETURN

	BCF		LED7_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED7_PORT			; 
	CALL	HOLD_LED2

LED8:

	MOVLW	D'8'
	SUBWF	LED_IN,W			; LED_IN - 8 -> W
	BTFSS	STATUS,C			; if LED_IN >= 8, C = 1
	RETURN

	BCF		LED8_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED8_PORT			; 
	CALL	HOLD_LED2

LED9:

	MOVLW	D'9'
	SUBWF	LED_IN,W			; LED_IN - 9 -> W
	BTFSS	STATUS,C			; if LED_IN >= 9, C = 1
	RETURN

	BCF		LED9_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED9_PORT			; 
	CALL	HOLD_LED2

LED10:

	MOVLW	D'10'
	SUBWF	LED_IN,W			; LED_IN - 10 -> W
	BTFSS	STATUS,C			; if LED_IN >= 10, C = 1
	RETURN

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_LED2

LED11:

	MOVLW	D'11'
	SUBWF	LED_IN,W			; LED_IN - 11 -> W
	BTFSS	STATUS,C			; if LED_IN >= 11, C = 1
	RETURN

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_LED2

LED12:

	MOVLW	D'12'
	SUBWF	LED_IN,W			; LED_IN - 12 -> W
	BTFSS	STATUS,C			; if LED_IN >= 12, C = 1
	RETURN

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_LED2

LED13:

	MOVLW	D'13'
	SUBWF	LED_IN,W			; LED_IN - 13 -> W
	BTFSS	STATUS,C			; if LED_IN >= 13, C = 1
	RETURN

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_LED2

LED14:

	MOVLW	D'14'
	SUBWF	LED_IN,W			; LED_IN - 14 -> W
	BTFSS	STATUS,C			; if LED_IN >= 14, C = 1
	RETURN

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED14_PORT			; 

	RETURN

;--------------------------------------------------------------------------------
;	LED Si H = j
;--------------------------------------------------------------------------------

ALL_LED_OFF:

	MOVLW	B'11110000'
	MOVWF	PORTA
	MOVLW	B'11111111'
	MOVWF	PORTB
	MOVWF	PORTC

	CALL	HOLD_LED2

	RETURN

;--------------------------------------------------------------------------------
;	LED \莞ԕێ
;--------------------------------------------------------------------------------

HOLD_LED:

	CALL	WAIT_1ms

HOLD_LED2:

	CALL	WAIT_5us

	RETURN

;--------------------------------------------------------------------------------
;	8bit Z[`Av͕qŉ邩JEg΂悢
;	IN:     BUNSHIi鐔j,	BUNBOi鐔j
;	RETURN: DIV_ANSij, 			DIV_MODi]j
;--------------------------------------------------------------------------------

DIV8:

	CLRF	DIV_ANS			; pNA
	CLRF	DIV_MOD			; ]pNA

DIV_LOOP:

	MOVF	BUNSHI,W		; _̊鐔ǂݏo
	MOVWF	DIV_MOD			; ȏȂꍇ͂̒l̂܂ܗ]ɂȂ

	MOVF	BUNBO,W
	SUBWF	BUNSHI,F		; BUNSHI - W(BUNBO) -> BUNSHI

	BTFSS	STATUS,C		; ܂ȂL[Ȃ̂ C=1 ƂȂ莟̍sXLbv
	RETURN					; Ȃ̂ŏI

	BTFSC	STATUS,Z		; ؂Ȃꍇ Z=0 ƂȂ莟̍sXLbv
	GOTO	CLEAR_MOD		; ؂ꂽꍇ͗]NAKv

	INCF	DIV_ANS,F		; JEgAbv
	GOTO	DIV_LOOP		; Z𑱂

CLEAR_MOD:

	INCF	DIV_ANS,F		; JEgAbv
	CLRF	DIV_MOD			; ]NA

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Time-8MHz.lib	; NbN8MHzpԑ҂[vCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
